from numpy import array

def pglib_opf_case2000_goc():
    """
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%                                                                  %%%%%
    %%%    IEEE PES Power Grid Library - Optimal Power Flow - v23.07     %%%%%
    %%%          (https://github.com/power-grid-lib/pglib-opf)           %%%%%
    %%%               Benchmark Group - Typical Operations               %%%%%
    %%%                         23 - July - 2023                         %%%%%
    %%%                                                                  %%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    This is a synthetic 2,000 bus case, developed for use in ARPA-e's Grid
    Optimization Competition, Challenge 1.

    https://gocompetition.energy.gov/challenges/22/datasets

    When publishing results based on this data, please cite:

    [1] A.B. Birchfield, T. Xu, K.M. Gegner, K.S. Shetye, T.J. Overbye,
    "Grid Structural Characteristics as Validation Criteria for
    Synthetic Networks," IEEE Transactions on Power Systems, 2017.

    February, 2020

    Copyright (c) 2020 by A.B. Birchfield, H. Li, J. Wert, J. Yeo, T. Xu,
    and T.J. Overbye
    Licensed under the Creative Commons Attribution 4.0 International license,
    http://creativecommons.org/licenses/by/4.0/

    """
    ppc = {"version": '2'}

    ## system MVA base
    ppc["baseMVA"] = 100.0

    ## bus data
    # bus_i type Pd Qd Gs Bs area Vm Va baseKV zone Vmax Vmin
    ppc["bus"] = array([
        [1, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [2, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [3, 1, 63.032599, 30.499177, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [4, 1, 39.872692, 2.686688, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [5, 1, 59.86117, 29.465619, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [6, 1, 52.61757, 4.2656153, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [7, 1, 56.669624, 12.18891, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [8, 1, 39.112858, 10.233215, 0.0, 125.081972555, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [9, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [10, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [11, 1, 88.082752, 28.939717, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [12, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [13, 1, 82.616913, 17.693369, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [14, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [15, 1, 124.08794, 60.300901, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [16, 1, 58.164337, 11.289482, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [17, 1, 45.635228, 27.013902, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [18, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [19, 1, 16.253058, 1.8417025, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [20, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [21, 1, 108.94234, 13.34786, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [22, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [23, 1, 47.797985, 7.0533189, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [24, 1, 13.259455, 2.933591, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [25, 1, 16.010345, 1.912179, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [26, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [27, 1, 60.234406, 15.982269, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [28, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [29, 1, 79.633262, 31.091927, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [30, 1, 59.447927, 1.3231653, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [31, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [32, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [33, 1, 51.149767, 11.818091, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [34, 1, 54.772259, 14.831048, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [35, 1, 61.33575, 11.422704, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [36, 1, 46.058696, 5.184763, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [37, 1, 71.28723, 8.0567184, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [38, 1, 20.498477, 5.1283346, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [39, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [40, 1, 56.791513, 31.333153, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [41, 1, 33.346278, 11.155067, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [42, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [43, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [44, 1, 67.732614, 38.37608, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [45, 1, 20.457976, 3.826255, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [46, 1, 21.41017, 4.0268279, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [47, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [48, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [49, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [50, 1, 42.770987, 18.207567, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [51, 1, 26.867091, 13.887133, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [52, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [53, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [54, 1, 65.431926, 21.104749, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [55, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [56, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [57, 1, 39.42829, 2.9001465, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [58, 1, 29.12641, 11.744102, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [59, 1, 21.808205, 7.3975388, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [60, 1, 16.084567, 0.5157274, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [61, 1, 8.1954502, 2.4931054, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [62, 1, 7.7017986, 4.9119172, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [63, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [64, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [65, 1, 16.845318, 8.7799289, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [66, 1, 7.8439512, 2.9993174, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [67, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [68, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [69, 1, 9.5930041, 5.0816634, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [70, 1, 7.3159881, 0.62437414, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [71, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [72, 1, 12.029727, 4.0129322, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [73, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [74, 1, 12.857525, 1.0586832, 0.0, 8.49688906785, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [75, 1, 14.933717, 4.8782627, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [76, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [77, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [78, 1, 26.426587, 4.6764255, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [79, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [80, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [81, 1, 8.8550628, 1.6739562, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [82, 1, 7.7923374, 0.51391182, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [83, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [84, 1, 16.143781, 5.1892803, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [85, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [86, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [87, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [88, 1, 52.386693, 12.736043, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [89, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [90, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [91, 1, 63.939019, 10.266533, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [92, 1, 29.053947, 14.045927, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [93, 1, 18.532061, 4.3305549, 0.0, 13.0031149174, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [94, 1, 19.487602, 3.2734475, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [95, 1, 60.043064, 15.923783, 0.0, 0.00107396248384, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [96, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [97, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [98, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [99, 1, 72.519598, 26.914313, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [100, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [101, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [102, 1, 80.213195, 11.697076, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [103, 1, 42.864125, 2.0052198, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [104, 1, 59.503172, 21.216872, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [105, 1, 0.0, 0.0, 0.0, 0.000699764345338, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [106, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [107, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [108, 1, 78.973787, 26.897779, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [109, 1, 42.500261, 11.215608, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [110, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [111, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [112, 1, 70.32463, 16.641277, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [113, 1, 44.282331, 5.1595078, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [114, 1, 6.6539341, 1.858247, 0.0, -19.5770110823, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [115, 1, 38.288963, 16.397994, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [116, 1, 14.043978, 3.0853286, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [117, 1, 33.648509, 1.2250378, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [118, 1, 14.131552, 3.2964995, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [119, 1, 42.68915, 11.775552, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [120, 1, 63.129219, 43.045801, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [121, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [122, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [123, 1, 77.38747, 23.99223, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [124, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [125, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [126, 1, 50.036685, 18.8862, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [127, 1, 25.701199, 6.4513541, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [128, 1, 31.024184, 7.4663783, 0.0, 0.000271209085663, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [129, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [130, 1, 73.035237, 12.276959, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [131, 1, 41.142072, 21.889228, 0.0, 168.570002396, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [132, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [133, 1, 70.971277, 13.03429, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [134, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [135, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [136, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [137, 1, 135.163, 17.105692, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [138, 1, 43.01499, 5.0493889, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [139, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [140, 1, 97.888643, 58.600837, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [141, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [142, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [143, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [144, 1, 80.88225, 15.434356, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [145, 1, 45.810324, 5.309578, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [146, 1, 39.973054, 8.7672214, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [147, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [148, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [149, 1, 69.114811, 16.155095, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [150, 1, 50.329488, 6.2763458, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [151, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [152, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [153, 1, 54.464316, 6.3389867, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [154, 1, 76.293089, 16.102405, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [155, 1, 48.138363, 2.1361487, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [156, 1, 48.095052, 21.38875, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [157, 1, 45.6242, 11.938822, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [158, 1, 71.854584, 17.031862, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [159, 1, 0.0, 0.0, 0.0, 371.14047516, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [160, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [161, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [162, 1, 71.133321, 10.304815, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [163, 1, 42.982584, 10.440698, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [164, 1, 27.968725, 7.4335923, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [165, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [166, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [167, 1, 136.34574, 82.948765, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [168, 1, 25.153536, 4.7858244, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [169, 1, 48.057962, 12.787909, 0.0, 27.4224213741, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [170, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [171, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [172, 1, 64.99125, 15.347642, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [173, 1, 49.812493, 25.789267, 0.0, 61.4828684306, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [174, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [175, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [176, 1, 67.457252, 7.9139351, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [177, 1, 32.640671, 8.9909054, 0.0, 60.0971715131, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [178, 1, 21.471577, 4.7353379, 0.0, 41.5651119656, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [179, 1, 43.099563, 5.0539475, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [180, 1, 29.859917, 4.3108127, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [181, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [182, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [183, 1, 74.524277, 17.467453, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [184, 1, 38.357391, 2.7000183, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [185, 1, 27.52708, 4.7391381, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [186, 1, 35.411356, 8.3667711, 0.0, -63.3799211635, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [187, 1, 33.45286, 10.163847, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [188, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [189, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [190, 1, 54.302808, 12.182942, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [191, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [192, 1, 50.603533, 21.904329, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [193, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [194, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [195, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [196, 1, 46.960527, 7.8248051, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [197, 1, 39.102226, 8.7138343, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [198, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [199, 1, 28.057407, 3.7781352, 0.0, 0.000175080156541, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [200, 1, 35.117549, 13.890588, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [201, 1, 38.561968, 8.3119722, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [202, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [203, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [204, 1, 70.312943, 33.80852, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [205, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [206, 1, 24.765183, 10.173476, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [207, 1, 0.0, 0.0, 0.0, 847.52041705, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [208, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [209, 1, 34.437989, 10.157234, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [210, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [211, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [212, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [213, 1, 48.261556, 18.852659, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [214, 1, 28.476391, 5.9139731, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [215, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [216, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [217, 1, 89.571068, 26.648451, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [218, 1, 25.963891, 6.5300627, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [219, 1, 21.804968, 13.561906, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [220, 1, 39.913967, 8.7185269, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [221, 1, 26.251232, 10.406422, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [222, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [223, 1, 59.37541, 8.1048634, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [224, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [225, 1, 104.55054, 29.834053, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [226, 1, 40.341216, 18.213994, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [227, 1, 23.256974, 8.8079691, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [228, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [229, 1, 95.196825, 30.378427, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [230, 1, 4.3639334, 1.2627244, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [231, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [232, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [233, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [234, 1, 44.885389, 5.0375267, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [235, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [236, 1, 29.403255, 5.4968207, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [237, 1, 39.037607, 10.145725, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [238, 1, 25.42603, 5.9860443, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [239, 1, 39.625952, 5.987174, 0.0, 4.2328363252e-05, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [240, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [241, 1, 69.418806, 8.6344999, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [242, 1, 32.260563, 3.5089406, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [243, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [244, 1, 49.390959, 4.8116135, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [245, 1, 48.54752, 4.6419743, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [246, 1, 57.718578, 32.391192, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [247, 1, 68.441128, 20.133532, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [248, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [249, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [250, 1, 89.099568, 2.8984139, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [251, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [252, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [253, 1, 89.182953, 16.24558, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [254, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [255, 1, 59.941789, 2.0869679, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [256, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [257, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [258, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [259, 1, 61.721371, 18.203662, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [260, 1, 52.050159, 14.421515, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [261, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [262, 1, 58.148447, 35.111835, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [263, 1, 28.444975, 10.040638, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [264, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [265, 1, 81.182444, 21.992222, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [266, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [267, 1, 49.763204, 16.535205, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [268, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [269, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [270, 1, 64.262518, 16.229304, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [271, 1, 46.893002, 13.144545, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [272, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [273, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [274, 1, 60.833269, 16.399739, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [275, 1, 24.816132, 8.5555295, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [276, 1, 24.535562, 7.8082994, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [277, 1, 13.117069, 1.3683344, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [278, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [279, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [280, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [281, 1, 37.826107, 13.239023, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [282, 1, 11.407892, 3.5135583, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [283, 1, 17.244254, 5.7356516, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [284, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [285, 1, 28.419889, 2.9358938, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [286, 1, 49.72103, 17.324536, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [287, 1, 75.595364, 11.124946, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [288, 1, 37.11725, 6.48009, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [289, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [290, 1, 37.117901, 2.6345163, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [291, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [292, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [293, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [294, 1, 28.910393, 2.2643507, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [295, 1, 55.669211, 19.883257, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [296, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [297, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [298, 1, 62.119325, 16.803784, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [299, 1, 39.300677, 14.011628, 0.0, 0.000279213171645, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [300, 1, 64.258528, 8.6376413, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [301, 1, 29.061871, 9.4173408, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [302, 1, 27.664387, 6.2660941, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [303, 1, 17.474914, 8.9915649, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [304, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [305, 1, 12.006152, 0.44972924, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [306, 1, 20.590495, 1.4049652, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [307, 1, 29.859389, 6.0807273, 0.0, 16.6863635444, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [308, 1, 48.56764, 3.1658846, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [309, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [310, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [311, 1, 61.164318, 18.074699, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [312, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [313, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [314, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [315, 1, 64.284183, 24.079099, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [316, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [317, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [318, 1, 40.922162, 10.714585, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [319, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [320, 1, 49.043709, 16.091821, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [321, 1, 29.793958, 13.198382, 0.0, 27.553393778, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [322, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [323, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [324, 1, 31.616046, 11.958777, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [325, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [326, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [327, 1, 33.102631, 3.6809376, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [328, 1, 8.7338088, 0.84121671, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [329, 1, 8.9003309, 1.3932021, 0.0, 0.167661259419, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [330, 1, 33.4128, 5.7251532, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [331, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [332, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [333, 1, 51.97309, 6.8546219, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [334, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [335, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [336, 1, 77.008871, 8.9262863, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [337, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [338, 1, 63.873713, 7.9465283, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [339, 1, 49.036516, 8.3763469, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [340, 1, 49.997205, 16.495132, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [341, 1, 35.989213, 5.5473178, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [342, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [343, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [344, 1, 44.967296, 16.329116, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [345, 1, 8.8377149, 3.0250972, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [346, 1, 9.7458391, 2.0989856, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [347, 1, 16.938488, 5.5442334, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [348, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [349, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [350, 1, 69.196031, 21.351836, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [351, 1, 45.596505, 7.5178469, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [352, 1, 19.135211, 4.8114431, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [353, 1, 18.924096, 9.6290034, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [354, 1, 31.965656, 10.69408, 0.0, -26.2339498357, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [355, 1, 18.726426, 2.7872062, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [356, 1, 43.011601, 12.853016, 0.0, 51.8360743582, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [357, 1, 52.684058, 44.894966, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [358, 1, 49.877204, 7.5488737, 0.0, -25.3899440786, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [359, 1, 46.562649, 9.1347944, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [360, 1, 28.923744, 8.9289888, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [361, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [362, 1, 36.531816, 8.3800156, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [363, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [364, 1, 72.175628, 5.6681416, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [365, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [366, 1, 27.606056, 10.387597, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [367, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [368, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [369, 1, 129.91106, 49.876691, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [370, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [371, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [372, 1, 56.825715, 27.594831, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [373, 1, 39.892495, 23.807158, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [374, 1, 12.773755, 1.6660769, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [375, 1, 26.984101, 3.3534378, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [376, 1, 14.145566, 3.3523011, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [377, 1, 5.2283842, 1.1254284, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [378, 1, 22.95643, 4.2582073, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [379, 1, 36.639673, 11.090989, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [380, 1, 36.029099, 10.71394, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [381, 1, 5.2956455, 1.3985775, 0.0, 9.28172468228, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [382, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [383, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [384, 1, 47.165278, 15.187817, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [385, 1, 25.989731, 9.1670507, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [386, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [387, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [388, 1, 41.323384, 8.8130178, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [389, 1, 37.178122, 5.6470278, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [390, 1, 18.852149, 3.2906645, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [391, 1, 21.542391, 6.4834532, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [392, 1, 20.665158, 4.3505031, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [393, 1, 19.72778, 5.6201074, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [394, 1, 15.677489, 1.8939805, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [395, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [396, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [397, 1, 46.338404, 16.303822, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [398, 1, 25.214219, 5.3200838, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [399, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [400, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [401, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [402, 1, 48.940398, 12.845885, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [403, 1, 29.514688, 2.6196763, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [404, 1, 15.594994, 2.5211127, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [405, 1, 16.799598, 2.8070748, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [406, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [407, 1, 71.028156, 17.737784, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [408, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [409, 1, 26.824175, 12.349772, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [410, 1, 14.104, 3.0050686, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [411, 1, 22.341591, 4.2917529, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [412, 1, 23.150669, 5.5783409, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [413, 1, 39.694524, 8.6291844, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [414, 1, 46.369021, 21.83882, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [415, 1, 29.444909, 9.9801194, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [416, 1, 8.9321329, 2.5440482, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [417, 1, 9.0236352, 1.1630953, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [418, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [419, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [420, 1, 17.884707, 5.2994505, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [421, 1, 25.532468, 7.8078118, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [422, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [423, 1, 57.68958, 10.019619, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [424, 1, 0.0, 0.0, 0.0, 3.27002106139, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [425, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [426, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [427, 1, 36.28689, 1.9172296, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [428, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [429, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [430, 1, 29.570875, 4.3895201, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [431, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [432, 1, 42.474935, 18.348802, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [433, 1, 14.625004, 4.6658401, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [434, 1, 32.464826, 7.6925395, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [435, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [436, 1, 31.298171, 6.3023573, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [437, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [438, 1, 8.1488851, 1.5220157, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [439, 1, 0.0, 0.0, 0.0, 9.06911297925, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [440, 1, 12.936045, 1.3089599, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [441, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [442, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [443, 1, 34.853261, 11.45709, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [444, 1, 30.247565, 3.9497791, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [445, 1, 11.607393, 1.87475, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [446, 1, 5.1202539, 1.5593293, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [447, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [448, 1, 24.56627, 3.8857313, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [449, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [450, 1, 21.636126, 10.641671, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [451, 1, 20.636403, 1.8728542, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [452, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [453, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [454, 1, 48.468197, 14.957707, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [455, 1, 16.424785, 8.8713764, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [456, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [457, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [458, 1, 27.547855, 16.470258, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [459, 1, 27.297123, 9.7065376, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [460, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [461, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [462, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [463, 1, 66.328998, 11.96703, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [464, 1, 25.463139, 5.0963976, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [465, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [466, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [467, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [468, 1, 38.993867, 3.0226311, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [469, 1, 26.0838, 7.1624303, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [470, 1, 27.77378, 2.2542867, 0.0, 50.9006295476, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [471, 1, 26.623585, 13.166776, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [472, 1, 15.637277, 2.8518181, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [473, 1, 18.370913, 6.4884055, 0.0, 25.7107566727, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [474, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [475, 1, 41.428869, 16.288543, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [476, 1, 27.374971, 7.9761464, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [477, 1, 14.064744, 7.5970628, 0.0, 12.571439704, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [478, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [479, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [480, 1, 41.943082, 1.3795024, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [481, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [482, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [483, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [484, 1, 51.351567, 23.229976, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [485, 1, 21.484064, 6.8173083, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [486, 1, 10.304363, 1.1445885, 0.0, 28.3622772684, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [487, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [488, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [489, 1, 22.411915, 5.4265411, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [490, 1, 18.024912, 5.5343677, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [491, 1, 37.844157, 4.2153687, 0.0, -6.45953940398, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [492, 1, 25.579784, 4.448658, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [493, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [494, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [495, 1, 37.430342, 1.1234783, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [496, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [497, 1, 20.369705, 5.5660242, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [498, 1, 13.259075, 2.2791661, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [499, 1, 0.0, 0.0, 0.0, 0.166350302044, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [500, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [501, 1, 25.025882, 1.0265567, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [502, 1, 11.93512, 2.7941365, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [503, 1, 8.6578196, 4.1366274, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [504, 1, 21.656101, 2.7618799, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [505, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [506, 1, 13.924042, 3.1355421, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [507, 1, 30.802701, 12.756198, 0.0, 5.57154700842, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [508, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [509, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [510, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [511, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [512, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [513, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [514, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [515, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [516, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [517, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [518, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [519, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [520, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [521, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [522, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [523, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [524, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [525, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [526, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [527, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [528, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [529, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [530, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [531, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [532, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [533, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 20.0, 1, 1.10000, 0.90000],
        [534, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [535, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [536, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 24.0, 1, 1.10000, 0.90000],
        [537, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 20.0, 1, 1.10000, 0.90000],
        [538, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [539, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [540, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [541, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [542, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [543, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [544, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [545, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [546, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 22.0, 1, 1.10000, 0.90000],
        [547, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [548, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [549, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [550, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [551, 3, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [552, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 22.0, 1, 1.10000, 0.90000],
        [553, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [554, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [555, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [556, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [557, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [558, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [559, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [560, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [561, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [562, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [563, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.2, 1, 1.10000, 0.90000],
        [564, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [565, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [566, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [567, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [568, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 22.0, 1, 1.10000, 0.90000],
        [569, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 22.0, 1, 1.10000, 0.90000],
        [570, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [571, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [572, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 22.0, 1, 1.10000, 0.90000],
        [573, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [574, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [575, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [576, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [577, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [578, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [579, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [580, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [581, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [582, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [583, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [584, 1, 0.0, 0.0, 0.0, -274.139512688, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [585, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [586, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [587, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 24.0, 1, 1.10000, 0.90000],
        [588, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 20.0, 1, 1.10000, 0.90000],
        [589, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [590, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [591, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [592, 1, 0.0, 0.0, 0.0, 0.000549747986225, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [593, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [594, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [595, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [596, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [597, 2, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [598, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [599, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [600, 1, 0.0, 0.0, 0.0, 0.0, 1, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [601, 1, 33.758457, 12.168944, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [602, 1, 22.539698, 5.7070402, 0.0, 10.2629342532, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [603, 1, 24.899282, 5.4508451, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [604, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [605, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [606, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [607, 1, 55.368016, 6.1943601, 0.0, 0.0, 2, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [608, 1, 71.690553, 18.731326, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [609, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [610, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [611, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [612, 1, 50.748827, 4.6242992, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [613, 1, 19.945314, 4.2164123, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [614, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [615, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [616, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [617, 1, 38.919856, 8.3352979, 0.0, 0.0, 2, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [618, 1, 18.05218, 2.3435479, 0.0, -19.2499288671, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [619, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [620, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [621, 1, 38.725202, 13.431511, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [622, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [623, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [624, 1, 45.33519, 23.583916, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [625, 1, 10.10481, 6.9874349, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [626, 1, 6.7009534, 0.53380828, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [627, 1, 12.52708, 4.2706981, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [628, 1, 32.083651, 8.064071, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [629, 1, 28.61578, 4.8854277, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [630, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [631, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [632, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [633, 1, 39.927865, 4.8704455, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [634, 1, 21.86963, 7.6218639, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [635, 1, 13.608188, 1.5576693, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [636, 1, 6.9900454, 1.9973538, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [637, 1, 47.65195, 18.793376, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [638, 1, 31.941604, 7.171482, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [639, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [640, 1, 28.260838, 9.1820724, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [641, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [642, 1, 25.770775, 1.4039609, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [643, 1, 26.476164, 6.0547257, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [644, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [645, 1, 22.142534, 1.8554077, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [646, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [647, 1, 16.376303, 6.5996894, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [648, 1, 0.0, 0.0, 0.0, 6.43039560242e-05, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [649, 1, 18.338868, 4.7799545, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [650, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [651, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [652, 1, 47.507839, 23.345954, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [653, 1, 25.529935, 9.9676451, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [654, 1, 91.652198, 7.0358237, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [655, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [656, 1, 55.180167, 29.471734, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [657, 1, 23.262553, 5.7603722, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [658, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [659, 1, 96.877092, 66.570582, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [660, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [661, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [662, 1, 61.2195, 18.966881, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [663, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [664, 1, 44.931329, 16.861867, 0.0, 24.4504130873, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [665, 1, 20.447171, 6.5299334, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [666, 1, 39.953358, 15.49874, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [667, 1, 41.16832, 2.4773976, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [668, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [669, 1, 35.136276, 14.6207, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [670, 1, 18.085858, 7.1155778, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [671, 1, 41.342345, 1.4542811, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [672, 1, 85.130214, 38.90443, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [673, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [674, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [675, 1, 72.832214, 15.173138, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [676, 1, 26.099096, 4.4892476, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [677, 1, 75.172144, 27.205943, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [678, 1, 0.0, 0.0, 0.0, 128.665865027, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [679, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [680, 1, 33.952267, 12.475048, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [681, 1, 28.827308, 5.4931607, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [682, 1, 24.373266, 4.0529563, 0.0, 11.0074236784, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [683, 1, 30.758126, 11.466451, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [684, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [685, 1, 34.846057, 2.9110732, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [686, 1, 23.41236, 8.0900333, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [687, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [688, 1, 41.874055, 5.5573187, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [689, 1, 19.753856, 5.3124467, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [690, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [691, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [692, 1, 70.276847, 23.91485, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [693, 1, 6.3370863, 1.5263142, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [694, 1, 42.840889, 6.9056846, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [695, 1, 88.600212, 18.742537, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [696, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [697, 1, 70.429659, 8.8970755, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [698, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [699, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [700, 1, 68.258006, 16.093362, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [701, 1, 20.173645, 5.8749701, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [702, 1, 16.723384, 0.78365582, 0.0, 4.23662705416, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [703, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [704, 1, 58.199131, 7.3918308, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [705, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [706, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [707, 1, 66.969354, 13.202293, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [708, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [709, 1, 33.386202, 13.271113, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [710, 1, 17.495362, 7.1587613, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [711, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [712, 1, 33.562728, 8.2943197, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [713, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [714, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [715, 1, 46.554238, 9.8824433, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [716, 1, 23.089231, 8.0649569, 0.0, 0.000338505472276, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [717, 1, 17.172185, 1.9246176, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [718, 1, 23.831797, 4.8002171, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [719, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [720, 1, 33.433833, 13.721369, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [721, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [722, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [723, 1, 26.80856, 5.6238889, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [724, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [725, 1, 15.605618, 3.429499, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [726, 1, 20.766333, 12.007623, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [727, 1, 12.893137, 3.3983908, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [728, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [729, 1, 32.303818, 13.538482, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [730, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [731, 1, 16.662271, 5.8978202, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [732, 1, 17.051292, 3.5368862, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [733, 1, 29.979416, 6.5008036, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [734, 1, 31.757319, 4.9020962, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [735, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [736, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [737, 1, 36.694326, 7.6001676, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [738, 1, 33.185045, 10.920945, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [739, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [740, 1, 40.724864, 11.837533, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [741, 1, 30.883082, 4.5110796, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [742, 1, 27.24577, 2.8338709, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [743, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [744, 1, 17.635136, 3.8029118, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [745, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [746, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [747, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [748, 1, 23.578201, 4.2406493, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [749, 1, 18.027856, 3.9671714, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [750, 1, 52.065083, 15.525448, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [751, 1, 36.666213, 13.982287, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [752, 1, 15.030375, 3.7828501, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [753, 1, 12.415578, 6.4111856, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [754, 1, 16.785719, 4.8477516, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [755, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [756, 1, 19.211827, 5.4424046, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [757, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [758, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [759, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [760, 1, 49.279242, 9.4429395, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [761, 1, 27.168507, 6.756603, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [762, 1, 27.464102, 1.9155916, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [763, 1, 17.068981, 1.2209609, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [764, 1, 13.244459, 3.9205708, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [765, 1, 14.330021, 5.4201448, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [766, 1, 17.786142, 1.7105333, 0.0, 41.5468017778, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [767, 1, 16.78514, 3.3525824, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [768, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [769, 1, 20.189057, 7.434215, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [770, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [771, 1, 30.253751, 4.2986577, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [772, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [773, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [774, 1, 67.763833, 22.722756, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [775, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [776, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [777, 1, 90.616213, 18.240106, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [778, 1, 17.504073, 1.6757547, 0.0, 0.000130370324012, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [779, 1, 9.6938748, 2.0675052, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [780, 1, 15.161457, 2.3365325, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [781, 1, 24.341274, 7.1053731, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [782, 1, 30.542767, 7.4945859, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [783, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [784, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [785, 1, 45.004637, 15.506934, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [786, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [787, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [788, 1, 31.383606, 5.4062965, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [789, 1, 26.796681, 16.658389, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [790, 1, 24.242244, 8.8477953, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [791, 1, 12.15364, 5.716443, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [792, 1, 8.2213317, 3.3259904, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [793, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [794, 1, 26.878574, 8.6864455, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [795, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [796, 1, 33.671557, 5.2435312, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [797, 1, 31.304691, 5.8448786, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [798, 1, 27.588909, 7.9740885, 0.0, 41.8975468516, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [799, 1, 18.223471, 5.8194092, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [800, 1, 48.053101, 11.161052, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [801, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [802, 1, 34.871987, 7.1371246, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [803, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [804, 1, 25.801132, 8.9858821, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [805, 1, 31.878096, 10.241988, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [806, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [807, 1, 65.183425, 8.7191113, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [808, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [809, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [810, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [811, 1, 46.7907, 13.90101, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [812, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [813, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [814, 1, 40.42027, 23.289298, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [815, 1, 22.685569, 12.170589, 0.0, 1.52240340265, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [816, 1, 26.442299, 8.6049207, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [817, 1, 10.222277, 0.90217822, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [818, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [819, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [820, 1, 93.19402, 20.565999, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [821, 1, 35.87903, 5.9350185, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [822, 1, 55.587219, 17.580379, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [823, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [824, 1, 57.967662, 7.1490883, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [825, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [826, 1, 86.062023, 27.354291, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [827, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [828, 1, 68.302895, 32.74623, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [829, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [830, 1, 34.341403, 10.442079, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [831, 1, 42.974349, 9.0111493, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [832, 1, 44.523138, 27.513218, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [833, 1, 41.743447, 14.39721, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [834, 1, 40.070883, 8.16969, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [835, 1, 94.99114, 35.391777, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [836, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [837, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [838, 1, 81.433697, 21.638713, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [839, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [840, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [841, 1, 55.26549, 10.607143, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [842, 1, 0.0, 0.0, 0.0, 135.217829227, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [843, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [844, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [845, 1, 75.719484, 18.725482, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [846, 1, 50.296181, 18.250893, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [847, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [848, 1, 51.040143, 12.295715, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [849, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [850, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [851, 1, 60.481256, 24.319016, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [852, 1, 25.514315, 4.7064087, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [853, 1, 41.975424, 7.4436336, 0.0, 92.0139900273, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [854, 1, 38.045387, 2.3433174, 0.0, 23.2634677787, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [855, 1, 28.342504, 5.2391154, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [856, 1, 39.088787, 13.648689, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [857, 1, 30.417819, 5.6375315, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [858, 1, 64.265648, 21.857108, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [859, 1, 66.244917, 19.289756, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [860, 1, 24.170256, 3.6901733, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [861, 1, 23.198143, 5.6370625, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [862, 1, 52.781011, 13.269348, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [863, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [864, 1, 34.737812, 10.119477, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [865, 1, 40.115475, 6.4099665, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [866, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [867, 1, 33.815464, 6.6999294, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [868, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [869, 1, 35.386197, 20.162843, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [870, 1, 20.450249, 5.2842223, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [871, 1, 20.400286, 6.8438264, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [872, 1, 98.145783, 22.059747, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [873, 1, 56.828575, 3.3668102, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [874, 1, 52.889097, 10.077944, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [875, 1, 63.492314, 10.038737, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [876, 1, 31.303704, 10.576618, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [877, 1, 37.094448, 11.873199, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [878, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [879, 1, 65.834998, 47.78007, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [880, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [881, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [882, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [883, 1, 77.94987, 14.841892, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [884, 1, 33.484878, 0.92721594, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [885, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [886, 1, 35.403035, 4.5858245, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [887, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [888, 1, 29.956933, 13.016661, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [889, 1, 29.885838, 2.641486, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [890, 1, 50.000601, 9.7360102, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [891, 1, 31.984866, 10.644625, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [892, 1, 44.301931, 4.1052035, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [893, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [894, 1, 21.156659, 1.8986408, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [895, 1, 23.489482, 5.658581, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [896, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [897, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [898, 1, 89.162425, 48.427763, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [899, 1, 32.457406, 7.3194781, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [900, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [901, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [902, 1, 80.608009, 10.290431, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [903, 1, 57.920205, 3.475646, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [904, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [905, 1, 61.720497, 12.178709, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [906, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [907, 1, 40.495367, 15.002231, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [908, 1, 39.974647, 11.609941, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [909, 1, 36.642745, 6.4883216, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [910, 1, 24.186529, 1.6317807, 0.0, 37.7174553634, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [911, 1, 24.371759, 1.9222574, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [912, 1, 43.375146, 4.3638711, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [913, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [914, 1, 34.108153, 4.7205523, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [915, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [916, 1, 37.660816, 6.5322798, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [917, 1, 17.813508, 9.0744792, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [918, 1, 24.266969, 3.2358956, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [919, 1, 10.347298, 1.3882722, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [920, 1, 21.524563, 7.6568343, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [921, 1, 21.254249, 3.8625085, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [922, 1, 13.966924, 2.5022301, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [923, 1, 23.753296, 3.113138, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [924, 1, 12.640224, 3.7835421, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [925, 1, 0.0, 0.0, 0.0, -59.33913768, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [926, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [927, 1, 31.432253, 10.374606, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [928, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [929, 1, 30.337865, 19.398478, 0.0, 43.3169480222, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [930, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [931, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [932, 1, 18.639729, 3.6411337, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [933, 1, 16.079061, 1.5907187, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [934, 1, 28.882511, 6.2087898, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [935, 1, 16.937798, 8.7371784, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [936, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [937, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [938, 1, 34.885977, 22.619954, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [939, 1, 9.7321425, 3.333954, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [940, 1, 15.029713, 3.7623388, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [941, 1, 26.260109, 1.6362582, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [942, 1, 23.023207, 7.4084809, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [943, 1, 29.329409, 16.639267, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [944, 1, 13.573721, 3.7542685, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [945, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [946, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [947, 1, 33.983502, 6.6569447, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [948, 1, 24.830007, 7.5774307, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [949, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [950, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [951, 1, 29.004522, 9.3212628, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [952, 1, 8.4890978, 3.2556557, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [953, 1, 24.312725, 6.6849476, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [954, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [955, 1, 50.991773, 9.8237646, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [956, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [957, 1, 25.225677, 8.9004662, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [958, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [959, 1, 29.879744, 14.358413, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [960, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [961, 1, 14.073098, 3.0089829, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [962, 1, 21.001099, 7.1531372, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [963, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [964, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [965, 1, 32.863845, 0.83558694, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [966, 1, 15.036488, 3.3388924, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [967, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [968, 1, 16.185433, 7.7683687, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [969, 1, 17.228012, 6.9148517, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [970, 1, 27.044139, 3.5668218, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [971, 1, 25.392446, 6.8741779, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [972, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [973, 1, 0.0, 0.0, 0.0, 34.9999656297, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [974, 1, 57.332902, 22.560108, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [975, 1, 33.858228, 6.2553481, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [976, 1, 49.26675, 9.4791166, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [977, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [978, 1, 39.70358, 5.9292752, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [979, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [980, 1, 21.911638, 2.9199578, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [981, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [982, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [983, 1, 57.273646, 20.439033, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [984, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [985, 1, 48.397922, 16.392953, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [986, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [987, 1, 21.428615, 9.000194, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [988, 1, 28.540228, 3.9075125, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [989, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [990, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [991, 1, 33.560671, 11.343825, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [992, 1, 40.375545, 17.73985, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [993, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [994, 1, 14.355406, 3.8363088, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [995, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [996, 1, 20.358863, 8.187586, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [997, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [998, 1, 30.059687, 3.5685354, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [999, 1, 21.359997, 5.4693356, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1000, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1001, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1002, 1, 33.261216, 8.7859047, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1003, 1, 18.640563, 5.4858849, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1004, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1005, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1006, 1, 50.378573, 23.712691, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1007, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1008, 1, 48.166338, 13.746324, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1009, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1010, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1011, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1012, 1, 50.815992, 8.2979495, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1013, 1, 0.0, 0.0, 0.0, 95.8267587681, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1014, 1, 32.211019, 13.566734, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1015, 1, 33.613187, 6.2083569, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1016, 1, 35.858364, 20.640197, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1017, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1018, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1019, 1, 36.372629, 18.065066, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1020, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1021, 1, 11.73821, 3.2320555, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1022, 1, 15.943492, 2.1621351, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1023, 1, 16.429558, 5.0956793, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1024, 1, 17.107891, 9.7624641, 0.0, 27.6732734857, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1025, 1, 14.400398, 2.2979436, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1026, 1, 22.157108, 11.897173, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1027, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1028, 1, 22.300171, 5.3591244, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1029, 1, 17.532514, 2.7778808, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1030, 1, 6.4365602, 1.2398155, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1031, 1, 32.682558, 2.4189517, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1032, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1033, 1, 33.367333, 5.5821396, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1034, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1035, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1036, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1037, 1, 19.914389, 10.741955, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1038, 1, 14.488036, 3.2894122, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1039, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1040, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1041, 1, 20.987424, 4.6338532, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1042, 1, 0.0, 0.0, 0.0, 172.052097673, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1043, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1044, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1045, 1, 47.745802, 11.415124, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1046, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1047, 1, 31.683506, 10.799954, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1048, 1, 27.972414, 1.8273164, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1049, 1, 15.645997, 6.7892796, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1050, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1051, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1052, 1, 28.351857, 3.909283, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1053, 1, 10.147134, 1.8850436, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1054, 1, 25.309172, 4.7021656, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1055, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1056, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1057, 1, 44.725013, 11.28384, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1058, 1, 33.370615, 16.898266, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1059, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1060, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1061, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1062, 1, 72.436244, 35.985312, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1063, 1, 38.100903, 6.2172884, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1064, 1, 16.488276, 5.2107964, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1065, 1, 13.048764, 5.6122727, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1066, 1, 0.0, 0.0, 0.0, 49.9999140485, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1067, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1068, 1, 0.0, 0.0, 0.0, -24.9250780336, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1069, 1, 29.283545, 6.9602629, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1070, 1, 20.502881, 8.1570294, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1071, 1, 27.947152, 8.5794905, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1072, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1073, 1, 32.529683, 10.416739, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1074, 1, 0.0, 0.0, 0.0, 72.0688007392, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1075, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1076, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1077, 1, 44.306214, 7.35935, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1078, 1, 24.130216, 2.2963894, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1079, 1, 33.463675, 8.0437424, 0.0, 40.2220252037, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1080, 1, 40.806186, 2.669891, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1081, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1082, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1083, 1, 62.014655, 14.582864, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1084, 1, 25.14808, 6.4527252, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1085, 1, 24.433555, 5.5785721, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1086, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1087, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1088, 1, 43.735354, 24.940257, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1089, 1, 0.0, 0.0, 0.0, 304.021310109, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1090, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1091, 1, 79.819803, 26.516268, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1092, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1093, 1, 21.901337, 4.6925419, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1094, 1, 26.701392, 5.3308641, 0.0, 53.176552519, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1095, 1, 69.106957, 38.311865, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1096, 1, 31.210573, 11.971446, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1097, 1, 35.132205, 10.04051, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1098, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1099, 1, 11.803371, 5.0405103, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1100, 1, 37.291079, 10.738815, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1101, 1, 18.145966, 4.4932804, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1102, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1103, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1104, 1, 34.65282, 8.8523285, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1105, 1, 19.805827, 7.1172568, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1106, 1, 0.0, 0.0, 0.0, 184.486190643, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1107, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1108, 1, 75.136059, 13.246995, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1109, 1, 34.155279, 10.831411, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1110, 1, 31.251968, 7.5252006, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1111, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1112, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1113, 1, 38.4698, 10.446422, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1114, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1115, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1116, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1117, 1, 13.910126, 6.3049852, 0.0, 0.0, 2, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1118, 1, 12.250871, 1.439596, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1119, 1, 21.975896, 6.565608, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1120, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1121, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1122, 1, 28.693789, 7.687577, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1123, 1, 17.164634, 6.9052449, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1124, 1, 51.619475, 8.2435797, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1125, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1126, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1127, 1, 88.17606, 15.252632, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1128, 1, 0.0, 0.0, 0.0, 489.153827811, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1129, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1130, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1131, 1, 62.666142, 24.734552, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1132, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1133, 1, 34.461251, 2.9418141, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1134, 1, 37.542106, 15.072791, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1135, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1136, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1137, 1, 65.362364, 11.444588, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1138, 1, 25.383967, 5.1851378, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1139, 1, 25.041082, 15.108644, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1140, 1, 47.734952, 10.725829, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1141, 1, 13.131585, 2.2518257, 0.0, 18.8383847654, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1142, 1, 42.99132, 10.422362, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1143, 1, 36.607022, 8.1354117, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1144, 1, 44.569225, 8.3809155, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1145, 1, 0.0, 0.0, 0.0, 0.00374140481256, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1146, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1147, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1148, 1, 46.148954, 12.993604, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1149, 1, 49.374239, 4.4056665, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1150, 1, 22.197059, 3.9259797, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1151, 1, 21.462883, 3.7376077, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1152, 1, 20.694966, 4.1559114, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1153, 1, 16.234304, 1.2029298, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1154, 1, 0.0, 0.0, 0.0, 220.913110367, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1155, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1156, 1, 64.827045, 23.535956, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1157, 1, 23.669728, 6.5991637, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1158, 1, 27.945385, 4.7945098, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1159, 1, 9.06199, 4.3676093, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1160, 1, 27.009282, 7.1020481, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1161, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1162, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1163, 1, 30.695509, 7.5277145, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1164, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1165, 1, 19.655779, 3.0996616, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1166, 1, 14.995102, 3.4812959, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1167, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1168, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1169, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1170, 1, 33.916992, 8.563483, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1171, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1172, 1, 42.462912, 5.2996236, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1173, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1174, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1175, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1176, 1, 52.548059, 26.358651, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1177, 1, 49.652059, 8.6948065, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1178, 1, 22.528472, 4.3940783, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1179, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1180, 1, 46.184191, 21.963829, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1181, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1182, 1, 55.252205, 8.9270454, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1183, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1184, 1, 18.990938, 6.3150273, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1185, 1, 19.827947, 5.262832, 0.0, 24.6325800273, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1186, 1, 20.146871, 4.8603589, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1187, 1, 10.709287, 3.6098646, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1188, 1, 9.6254119, 1.7829996, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1189, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1190, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1191, 1, 9.647578, 5.4463567, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1192, 1, 10.685843, 1.7523883, 0.0, 2.78121337464, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1193, 1, 26.834959, 7.0856539, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1194, 1, 27.550893, 7.7306919, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1195, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1196, 1, 31.08925, 11.928329, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1197, 1, 39.168614, 19.887423, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1198, 1, 17.48348, 2.6317962, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1199, 1, 12.610073, 2.0988455, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1200, 1, 31.923914, 7.6035955, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1201, 1, 16.711174, 3.1697157, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1202, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1203, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1204, 1, 23.051707, 6.4585421, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1205, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1206, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1207, 1, 33.121079, 13.297552, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1208, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1209, 1, 14.107844, 2.601091, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1210, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1211, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1212, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 20.0, 1, 1.10000, 0.90000],
        [1213, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1214, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1215, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1216, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1217, 1, 4.6119268, 2.5300539, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1218, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1219, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1220, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1221, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1222, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1223, 1, 0.0, 0.0, 0.0, -53.0231320374, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1224, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1225, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1226, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1227, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1228, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1229, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1230, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1231, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1232, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1233, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1234, 1, 13.255993, 3.7314061, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1235, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1236, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1237, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1238, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1239, 1, 10.841026, 0.81698808, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1240, 1, 0.0, 0.0, 0.0, -165.639275965, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1241, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1242, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1243, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1244, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1245, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1246, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1247, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1248, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1249, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1250, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1251, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1252, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1253, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 20.0, 1, 1.10000, 0.90000],
        [1254, 1, 48.496768, 9.2105098, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1255, 1, 11.432793, 6.3550392, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1256, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1257, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 22.0, 1, 1.10000, 0.90000],
        [1258, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 20.0, 1, 1.10000, 0.90000],
        [1259, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 22.0, 1, 1.10000, 0.90000],
        [1260, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1261, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1262, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1263, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1264, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1265, 1, 16.316786, 2.6965144, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1266, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 24.0, 1, 1.10000, 0.90000],
        [1267, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1268, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1269, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1270, 1, 0.45660332, 0.11533813, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1271, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 22.0, 1, 1.10000, 0.90000],
        [1272, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 20.0, 1, 1.10000, 0.90000],
        [1273, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1274, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1275, 1, 0.46352069, 0.050966613, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1276, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1277, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1278, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1279, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1280, 1, 41.812959, 9.372608, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1281, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1282, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1283, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1284, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 20.0, 1, 1.10000, 0.90000],
        [1285, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1286, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1287, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1288, 1, 11.899189, 2.5893179, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1289, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 22.0, 1, 1.10000, 0.90000],
        [1290, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.2, 1, 1.10000, 0.90000],
        [1291, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1292, 1, 11.667459, 1.4093778, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1293, 1, 0.0, 0.0, 0.0, -632.819025609, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1294, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1295, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1296, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1297, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1298, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1299, 1, 33.643168, 14.898881, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1300, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1301, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1302, 1, 7.4906887, 1.6942655, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1303, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1304, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1305, 1, 1.519654, 0.42142838, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1306, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1307, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1308, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1309, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1310, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1311, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1312, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1313, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1314, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1315, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1316, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1317, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1318, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1319, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1320, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 20.0, 1, 1.10000, 0.90000],
        [1321, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1322, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1323, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1324, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1325, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1326, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1327, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1328, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1329, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1330, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1331, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1332, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1333, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1334, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1335, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1336, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1337, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1338, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1339, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1340, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1341, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1342, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1343, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1344, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1345, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1346, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1347, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1348, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1349, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1350, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1351, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1352, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1353, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1354, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1355, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1356, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1357, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1358, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1359, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1360, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1361, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1362, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1363, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1364, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1365, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1366, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1367, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1368, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1369, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1370, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1371, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1372, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1373, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1374, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1375, 1, 0.0, 0.0, 0.0, -698.017491315, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1376, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1377, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1378, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1379, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 20.0, 1, 1.10000, 0.90000],
        [1380, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1381, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1382, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1383, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1384, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1385, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1386, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1387, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1388, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1389, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1390, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1391, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1392, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1393, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1394, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1395, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1396, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1397, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1398, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 24.0, 1, 1.10000, 0.90000],
        [1399, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 20.0, 1, 1.10000, 0.90000],
        [1400, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1401, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1402, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1403, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1404, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1405, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1406, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1407, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1408, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1409, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1410, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1411, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1412, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1413, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1414, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1415, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1416, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1417, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1418, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1419, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1420, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1421, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1422, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1423, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1424, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1425, 1, 0.0, 0.0, 0.0, -115.228912897, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1426, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1427, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1428, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1429, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1430, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1431, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1432, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.2, 1, 1.10000, 0.90000],
        [1433, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1434, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1435, 1, 0.0, 0.0, 0.0, -0.000674466335963, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1436, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1437, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1438, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 20.0, 1, 1.10000, 0.90000],
        [1439, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1440, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1441, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1442, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1443, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 22.0, 1, 1.10000, 0.90000],
        [1444, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1445, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1446, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1447, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1448, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1449, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1450, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1451, 1, 0.0, 0.0, 0.0, -0.00082506350761, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1452, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1453, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1454, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1455, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 24.0, 1, 1.10000, 0.90000],
        [1456, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1457, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1458, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1459, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1460, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1461, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1462, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1463, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1464, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1465, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1466, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1467, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1468, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1469, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1470, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1471, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1472, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1473, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1474, 2, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1475, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1476, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1477, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1478, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1479, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1480, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1481, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1482, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1483, 1, 0.0, 0.0, 0.0, 0.0, 2, 1.00000, 0.00000, 138.0, 1, 1.10000, 0.90000],
        [1484, 1, 8.9462649, 5.7063198, 0.0, 32.5002806275, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1485, 1, 20.191033, 8.7284086, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1486, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1487, 1, 41.176178, 5.1409852, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1488, 1, 9.4509725, 2.4141282, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1489, 1, 0.0, 0.0, 0.0, 95.3199029758, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1490, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1491, 1, 34.399907, 2.9478447, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1492, 1, 12.884491, 4.1163372, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1493, 1, 32.701565, 11.834559, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1494, 1, 14.423475, 1.9076373, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1495, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1496, 1, 12.204241, 0.98996159, 0.0, 20.2351637414, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1497, 1, 10.919566, 1.049454, 0.0, 43.748947508, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1498, 1, 20.974949, 2.7376083, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1499, 1, 11.132427, 2.0821424, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1500, 1, 10.866879, 2.5620276, 0.0, 16.7553034558, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1501, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1502, 1, 14.722168, 2.7266725, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1503, 1, 7.4089355, 3.3428862, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1504, 1, 20.952719, 10.497492, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1505, 1, 6.3834891, 2.4236392, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1506, 1, 20.726256, 3.589237, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1507, 1, 19.704282, 2.0119284, 0.0, 31.7806041674, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1508, 1, 26.411777, 6.3144816, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1509, 1, 11.30521, 5.9869747, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1510, 1, 35.696113, 7.2179164, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1511, 1, 26.190553, 4.7575833, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1512, 1, 11.95808, 0.34998636, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1513, 1, 23.629733, 3.0078126, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1514, 1, 59.303068, 23.416757, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1515, 1, 9.381295, 0.87620477, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1516, 1, 57.917106, 33.053558, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1517, 1, 44.406486, 4.7292563, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1518, 1, 39.260131, 9.6565452, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1519, 1, 8.3353832, 0.86339026, 0.0, 56.5606208831, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1520, 1, 25.58192, 15.814653, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1521, 1, 21.733966, 8.5784217, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1522, 1, 22.271419, 6.1401504, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1523, 1, 30.276015, 12.903318, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1524, 1, 40.563222, 2.4344125, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1525, 1, 19.896665, 5.45083, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1526, 1, 8.56147, 4.9602311, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1527, 1, 20.26909, 4.1737963, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1528, 1, 24.702231, 3.4459449, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1529, 1, 21.141002, 10.802685, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1530, 1, 11.403544, 1.7829625, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1531, 1, 29.865197, 7.7948061, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1532, 1, 17.104729, 2.8566299, 0.0, 87.2816692081, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1533, 1, 4.7626258, 2.0416277, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1534, 1, 7.3214356, 2.6912643, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1535, 1, 13.986677, 6.0446755, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1536, 1, 12.308711, 4.3157605, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1537, 1, 14.025555, 2.3512475, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1538, 1, 17.501642, 4.1443094, 0.0, 20.1116013884, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1539, 1, 23.767473, 7.0775195, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1540, 1, 26.927325, 9.6706358, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1541, 1, 42.331685, 12.761207, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1542, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1543, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1544, 1, 42.648743, 5.9471958, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1545, 1, 54.376001, 17.207648, 0.0, 73.8923686139, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1546, 1, 31.643822, 6.49383, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1547, 1, 22.832663, 3.0550275, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1548, 1, 28.180699, 6.9924119, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1549, 1, 45.552791, 9.3324927, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1550, 1, 14.776236, 3.0653436, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1551, 1, 14.567734, 1.0934793, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1552, 1, 56.905226, 36.420125, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1553, 1, 22.221325, 7.0068509, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1554, 1, 21.203831, 3.2866048, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1555, 1, 54.584455, 7.4453275, 0.0, 50.4748507422, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1556, 1, 29.026087, 25.343564, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1557, 1, 24.866414, 10.698928, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1558, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1559, 1, 42.215211, 7.2488637, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1560, 1, 27.316925, 2.2572186, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1561, 1, 31.725462, 10.657121, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1562, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1563, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1564, 1, 49.93007, 10.427409, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1565, 1, 22.944873, 5.3447634, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1566, 1, 20.352847, 4.8998158, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1567, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1568, 1, 31.124087, 4.4163316, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1569, 1, 23.80096, 5.7891646, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1570, 1, 24.557768, 2.9665291, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1571, 1, 49.452745, 11.776936, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1572, 1, 35.153962, 3.2368052, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1573, 1, 0.0, 0.0, 0.0, 125.658535971, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1574, 1, 29.826892, 10.19035, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1575, 1, 13.059287, 0.70632519, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1576, 1, 12.195807, 2.7036079, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1577, 1, 10.817122, 4.3909989, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1578, 1, 44.229621, 12.700312, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1579, 1, 39.021877, 14.340128, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1580, 1, 12.896652, 2.9186475, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1581, 1, 81.241272, 33.288729, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1582, 1, 65.410239, 18.162847, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1583, 1, 82.611835, 6.7686306, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1584, 1, 86.792211, 14.171977, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1585, 1, 38.831785, 3.5385081, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1586, 1, 59.064771, 11.426607, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1587, 1, 50.843562, 12.69251, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1588, 1, 75.803002, 10.525597, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1589, 1, 53.777529, 11.036485, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1590, 1, 47.126879, 13.026194, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1591, 1, 23.041625, 2.0366888, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1592, 1, 38.192336, 16.465017, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1593, 1, 18.181369, 4.6944864, 0.0, 29.237959641, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1594, 1, 20.15879, 9.1372646, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1595, 1, 32.288152, 4.1594277, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1596, 1, 19.76898, 1.1388054, 0.0, 140.105506975, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1597, 1, 18.656508, 10.14262, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1598, 1, 47.821973, 7.3739386, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1599, 1, 94.70077, 19.230245, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1600, 1, 20.505434, 6.2062819, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1601, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1602, 1, 0.0, 0.0, 0.0, 48.5944537606, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1603, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1604, 1, 24.144652, 2.3074813, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1605, 1, 25.446837, 8.0136327, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1606, 1, 60.834998, 19.210139, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1607, 1, 30.897869, 8.1533214, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1608, 1, 43.399074, 12.414288, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1609, 1, 57.536608, 25.835814, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1610, 1, 50.169514, 8.5742135, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1611, 1, 28.733462, 10.275782, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1612, 1, 16.698874, 3.4341965, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1613, 1, 30.794747, 6.3339547, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1614, 1, 31.067439, 5.4023162, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1615, 1, 14.587623, 2.3251698, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1616, 1, 16.015668, 1.3173455, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1617, 1, 28.758612, 5.5927872, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1618, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1619, 1, 33.069658, 6.2392007, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1620, 1, 18.946566, 1.1592714, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1621, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1622, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1623, 1, 15.606628, 5.563879, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1624, 1, 12.098832, 2.2443919, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1625, 1, 45.425034, 1.2114326, 0.0, 28.1997496064, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1626, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1627, 1, 17.596878, 3.625927, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1628, 1, 72.190187, 29.041914, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1629, 1, 41.79146, 17.403721, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1630, 1, 52.820492, 27.166367, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1631, 1, 15.623551, 2.9144729, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1632, 1, 18.600796, 3.0099166, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1633, 1, 15.364536, 1.067279, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1634, 1, 25.74414, 7.3703679, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1635, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1636, 1, 27.213913, 5.6054657, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1637, 1, 30.583336, 1.0294486, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1638, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1639, 1, 22.145361, 3.4029093, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1640, 1, 66.993351, 16.984131, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1641, 1, 23.927672, 7.6217422, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1642, 1, 15.397189, 3.3439784, 0.0, 30.1118806042, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1643, 1, 6.0316895, 1.1783543, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1644, 1, 8.984554, 4.2954068, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1645, 1, 7.656347, 1.1164331, 0.0, 7.1606649672, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1646, 1, 17.540327, 5.823639, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1647, 1, 12.479131, 2.1872544, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1648, 1, 31.711375, 3.868249, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1649, 1, 5.5073612, 2.0374446, 0.0, 3.32131912978, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1650, 1, 7.0852667, 1.0417981, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1651, 1, 16.398981, 7.1215438, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1652, 1, 8.2788635, 0.71878198, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1653, 1, 16.217831, 10.58469, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1654, 1, 23.572113, 9.3002845, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1655, 1, 12.507893, 1.3606622, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1656, 1, 15.121397, 4.4508162, 0.0, 18.0565368732, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1657, 1, 7.6814657, 2.2001609, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1658, 1, 20.060045, 5.9961982, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1659, 1, 19.441345, 1.6356093, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1660, 1, 9.806886, 0.66619139, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1661, 1, 19.053882, 6.440749, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1662, 1, 17.448657, 4.7713823, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1663, 1, 26.328048, 13.107998, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1664, 1, 56.343588, 30.791571, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1665, 1, 18.257068, 4.4242987, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1666, 1, 36.089832, 15.819502, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1667, 1, 17.951916, 1.3157231, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1668, 1, 11.632996, 3.091113, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1669, 1, 17.000142, 6.6484837, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1670, 1, 8.3846281, 2.2752665, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1671, 1, 11.904603, 2.3900445, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1672, 1, 16.913893, 4.8208954, 0.0, 30.5293438432, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1673, 1, 7.8532163, 0.4497465, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1674, 1, 19.97975, 6.9816334, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1675, 1, 11.190537, 3.0401402, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1676, 1, 20.172747, 5.2917298, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1677, 1, 28.793084, 1.7709033, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1678, 1, 21.74443, 8.3760775, 0.0, 25.0805275573, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1679, 1, 4.3505837, 0.30754242, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1680, 1, 11.710314, 4.0908828, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1681, 1, 8.8462717, 3.1030153, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1682, 1, 33.298556, 19.068391, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1683, 1, 36.822468, 7.2418975, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1684, 1, 25.605433, 4.2530015, 0.0, 27.3085010414, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1685, 1, 22.980529, 3.4570161, 0.0, 31.8628465093, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1686, 1, 13.926214, 2.8142417, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1687, 1, 32.288266, 5.0340652, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1688, 1, 7.7877302, 1.041073, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1689, 1, 10.382176, 3.5607613, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1690, 1, 7.2211115, 1.65667, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1691, 1, 6.1667405, 0.89510912, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1692, 1, 9.7962665, 2.6803794, 0.0, 23.7350561921, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1693, 1, 6.1705463, 3.2123363, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1694, 1, 26.068579, 6.6721478, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1695, 1, 24.829059, 7.4937863, 0.0, 100.499361134, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1696, 1, 23.174389, 3.1775966, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1697, 1, 47.651359, 23.08779, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1698, 1, 19.874778, 4.910947, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1699, 1, 63.978535, 22.281783, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1700, 1, 11.636046, 3.5926214, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1701, 1, 29.024782, 11.142982, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1702, 1, 26.646211, 4.2996263, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1703, 1, 80.692581, 39.653381, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1704, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1705, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1706, 1, 74.719405, 25.973291, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1707, 1, 11.671452, 1.4244016, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1708, 1, 15.478427, 3.2994188, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1709, 1, 11.916724, 1.7970997, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1710, 1, 25.894569, 7.6700884, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1711, 1, 13.285248, 7.4847058, 0.0, 23.6825667561, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1712, 1, 27.252516, 5.9987243, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1713, 1, 10.921802, 1.0079265, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1714, 1, 49.68627, 3.5985228, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1715, 1, 26.390913, 13.107127, 0.0, 31.8469685718, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1716, 1, 23.660434, 8.0337825, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1717, 1, 38.523835, 3.9746045, 0.0, 0.000363157118393, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1718, 1, 14.343133, 4.9890352, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1719, 1, 21.839189, 5.7490189, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1720, 1, 21.164561, 2.1647497, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1721, 1, 7.7442515, 1.7547322, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1722, 1, 25.930677, 6.0617007, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1723, 1, 21.13979, 11.688989, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1724, 1, 20.276726, 5.3079217, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1725, 1, 14.284305, 4.84705, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1726, 1, 36.075895, 16.980828, 0.0, 75.6069034355, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1727, 1, 14.159462, 3.5722632, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1728, 1, 22.818069, 5.3800709, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1729, 1, 37.678139, 4.5726589, 0.0, 22.9873404375, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1730, 1, 24.978273, 7.0421338, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1731, 1, 23.402475, 6.8513658, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1732, 1, 8.1008833, 1.2676512, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1733, 1, 37.879991, 17.775901, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1734, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1735, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1736, 1, 34.446983, 3.6433682, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1737, 1, 10.170033, 2.9418163, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1738, 1, 34.552627, 6.5044358, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1739, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1740, 1, 24.237673, 3.9405504, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1741, 1, 26.904651, 6.0686812, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1742, 1, 9.1249013, 2.814617, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1743, 1, 30.489471, 3.5908384, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1744, 1, 16.811645, 1.6146057, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1745, 1, 24.600317, 4.7059927, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1746, 1, 23.785807, 4.6269889, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1747, 1, 26.374303, 12.166746, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1748, 1, 31.451388, 21.842476, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1749, 1, 33.109025, 11.901403, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1750, 1, 40.977512, 11.933121, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1751, 1, 36.276052, 2.4751953, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1752, 1, 10.853642, 4.8950434, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1753, 1, 7.9112342, 0.82782062, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1754, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1755, 1, 23.121602, 2.7474794, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1756, 1, 10.728301, 1.3696126, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1757, 1, 4.0310033, 0.67207873, 0.0, 0.00013648465974, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1758, 1, 15.274052, 3.8048957, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1759, 1, 4.9684518, 1.8162756, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1760, 1, 18.266737, 9.1627861, 0.0, 31.780679626, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1761, 1, 16.784629, 6.0624708, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1762, 1, 19.861331, 6.2719661, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1763, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1764, 1, 31.8616, 15.540908, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1765, 1, 15.826548, 4.1599893, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1766, 1, 22.304413, 9.5761998, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1767, 1, 18.786027, 2.0760161, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1768, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1769, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1770, 1, 23.666442, 5.2678385, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1771, 1, 10.056594, 4.9323477, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1772, 1, 15.087898, 1.8845381, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1773, 1, 13.058935, 2.3661579, 0.0, 37.2693119279, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1774, 1, 10.206326, 1.268621, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1775, 1, 21.517231, 1.7097479, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1776, 1, 23.62723, 14.279551, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1777, 1, 13.312836, 2.8911221, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1778, 1, 27.286342, 5.3129836, 0.0, 16.1102492358, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1779, 1, 26.426618, 7.2909707, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1780, 1, 16.047234, 9.1090766, 0.0, 127.572220981, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1781, 1, 27.259643, 8.4929896, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1782, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1783, 1, 23.063662, 4.3846126, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1784, 1, 61.691883, 21.22679, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1785, 1, 21.620246, 2.5734357, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1786, 1, 60.032688, 15.157642, 0.0, 33.9997322609, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1787, 1, 37.012706, 24.348335, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1788, 1, 20.181906, 4.2046533, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1789, 1, 19.757522, 4.1513176, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1790, 1, 34.921276, 11.123145, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1791, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1792, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1793, 1, 37.697831, 6.5480089, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1794, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1795, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1796, 1, 48.285781, 2.2102355, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1797, 1, 10.481874, 1.1170956, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1798, 1, 39.257276, 18.944395, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1799, 1, 0.0, 0.0, 0.0, 25.6606543737, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1800, 1, 40.177213, 18.852962, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1801, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1802, 1, 28.353163, 4.9301564, 0.0, 0.0, 3, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1803, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1804, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1805, 1, 17.639578, 2.9899823, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1806, 1, 28.214546, 4.3822254, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1807, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1808, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1809, 1, 12.367671, 5.475048, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1810, 1, 10.847045, 4.0451653, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1811, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1812, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1813, 1, 16.362111, 3.8083869, 0.0, 0.0, 3, 1.00000, 0.00000, 69.0, 1, 1.10000, 0.90000],
        [1814, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1815, 1, 18.003657, 6.3183234, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1816, 1, 16.229254, 3.3616639, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1817, 1, 9.529058, 1.1248861, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1818, 1, 14.84826, 6.93097, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1819, 1, 29.207515, 2.034519, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1820, 1, 18.918949, 10.591916, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1821, 1, 0.0, 0.0, 0.0, 0.000836779104306, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1822, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1823, 1, 28.472247, 13.662192, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1824, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1825, 1, 32.185955, 1.2481062, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1826, 1, 18.779585, 6.2366251, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1827, 1, 20.538824, 9.0043565, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1828, 1, 28.470758, 12.305697, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1829, 1, 16.68225, 2.6922262, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1830, 1, 19.199702, 2.3471815, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1831, 1, 18.650787, 4.2203745, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1832, 1, 34.544543, 1.1269822, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1833, 1, 19.721992, 8.7985727, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1834, 1, 20.415035, 0.96516894, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1835, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1836, 1, 54.080303, 19.821528, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1837, 1, 25.799889, 5.1674207, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1838, 1, 22.983573, 9.3162598, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1839, 1, 26.842702, 5.331113, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1840, 1, 9.600329, 3.77739, 0.0, 57.81980184, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1841, 1, 24.307725, 10.561145, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1842, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1843, 1, 31.622441, 15.693971, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1844, 1, 14.17304, 4.5668965, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1845, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1846, 1, 45.639555, 10.114651, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1847, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1848, 1, 19.024947, 4.2809207, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1849, 1, 20.471612, 9.475415, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1850, 1, 18.970772, 8.8619823, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1851, 1, 43.305965, 28.079617, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1852, 1, 16.311981, 4.3631798, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1853, 1, 30.6094, 7.245233, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1854, 1, 15.940952, 3.734022, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1855, 1, 11.286122, 1.2208357, 0.0, 50.1174130129, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1856, 1, 17.962674, 3.6405788, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1857, 1, 12.406002, 3.3577262, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1858, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1859, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1860, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1861, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1862, 1, 7.6225389, 1.6464469, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1863, 1, 0.17712068, 0.047099505, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1864, 1, 0.17937411, 0.092038403, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1865, 1, 0.0, 0.0, 0.0, 69.3783175199, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1866, 1, 13.618402, 4.9500715, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1867, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1868, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1869, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1870, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1871, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1872, 1, 0.0, 0.0, 0.0, -1.1097488202, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1873, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1874, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1875, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1876, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1877, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1878, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1879, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1880, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1881, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1882, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1883, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1884, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1885, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1886, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1887, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1888, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 24.0, 1, 1.10000, 0.90000],
        [1889, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1890, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1891, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1892, 1, 0.0, 0.0, 0.0, 85.0260919933, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1893, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1894, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1895, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1896, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1897, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1898, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1899, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1900, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1901, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1902, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1903, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 20.0, 1, 1.10000, 0.90000],
        [1904, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1905, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 24.0, 1, 1.10000, 0.90000],
        [1906, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1907, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1908, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1909, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1910, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1911, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1912, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1913, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1914, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1915, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1916, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1917, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1918, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1919, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1920, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1921, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1922, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1923, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1924, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1925, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1926, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1927, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1928, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1929, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1930, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1931, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1932, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1933, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1934, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1935, 1, 0.0, 0.0, 0.0, 287.956607127, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1936, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1937, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1938, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1939, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1940, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1941, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1942, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1943, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1944, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1945, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1946, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1947, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1948, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1949, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1950, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 20.0, 1, 1.10000, 0.90000],
        [1951, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1952, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1953, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1954, 1, 0.0, 0.0, 0.0, -20.3584614675, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1955, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1956, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1957, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1958, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 22.0, 1, 1.10000, 0.90000],
        [1959, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1960, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1961, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1962, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1963, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 22.0, 1, 1.10000, 0.90000],
        [1964, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1965, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1966, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1967, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1968, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1969, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1970, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1971, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1972, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1973, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1974, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1975, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1976, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1977, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1978, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1979, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1980, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.2, 1, 1.10000, 0.90000],
        [1981, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1982, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1983, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1984, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1985, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1986, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1987, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1988, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1989, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1990, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1991, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [1992, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 18.0, 1, 1.10000, 0.90000],
        [1993, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 22.0, 1, 1.10000, 0.90000],
        [1994, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1995, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1996, 2, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1997, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 13.8, 1, 1.10000, 0.90000],
        [1998, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 345.0, 1, 1.10000, 0.90000],
        [1999, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000],
        [2000, 1, 0.0, 0.0, 0.0, 0.0, 3, 1.00000, 0.00000, 100.0, 1, 1.10000, 0.90000]    ])

    ## generator data
    # bus Pg Qg Qmax Qmin Vg mBase status Pmax Pmin
    ppc["gen"] = array([
        [511, 199.3925, 57.0965, 146.041, -31.848, 1.0, 286.92, 1, 286.917, 111.868],
        [512, 211.815, 57.0965, 146.041, -31.848, 1.0, 286.92, 1, 286.917, 136.713],
        [513, 202.3985, 57.0965, 146.041, -31.848, 1.0, 286.92, 1, 286.917, 117.88],
        [514, 203.4165, 57.0965, 146.041, -31.848, 1.0, 286.92, 1, 286.917, 119.916],
        [515, 215.024, 57.0965, 146.041, -31.848, 1.0, 286.92, 1, 286.917, 143.131],
        [516, 176.202, 57.0965, 146.041, -31.848, 1.0, 286.92, 1, 286.917, 65.487],
        [518, 17.532, 5.273, 13.488, -2.942, 1.0, 26.5, 1, 26.5, 8.564],
        [522, 605.927, 117.06, 301.245, -67.125, 1.0, 818.6, 1, 818.6, 393.254],
        [523, 455.499, 117.06, 301.245, -67.125, 1.0, 818.6, 1, 818.6, 92.398],
        [525, 0.0, 0.0, 3.02, -0.659, 1.0, 5.93, 0, 5.933, 1.3],
        [525, 0.0, 0.0, 3.02, -0.659, 1.0, 5.93, 0, 5.933, 1.833],
        [525, 0.0, 0.0, 3.02, -0.659, 1.0, 5.93, 0, 5.933, 2.076],
        [525, 0.0, 0.0, 3.02, -0.659, 1.0, 5.93, 0, 5.933, 1.712],
        [525, 0.0, 0.0, 3.02, -0.659, 1.0, 5.93, 0, 5.933, 1.58],
        [525, 0.0, 0.0, 3.02, -0.659, 1.0, 5.93, 0, 5.933, 1.676],
        [529, 0.0, 0.0, 124.603, -27.173, 1.0, 244.8, 0, 244.8, 40.619],
        [530, 147.451, 48.715, 124.603, -27.173, 1.0, 244.8, 1, 244.8, 50.102],
        [531, 174.0605, 48.715, 124.603, -27.173, 1.0, 244.8, 1, 244.8, 103.321],
        [532, 168.6685, 48.715, 124.603, -27.173, 1.0, 244.8, 1, 244.8, 92.537],
        [533, 163.709, 48.715, 124.603, -27.173, 1.0, 244.8, 1, 244.8, 82.618],
        [536, 276.28, 69.144, 187.332, -49.044, 1.0, 402.0, 1, 402.0, 150.56],
        [537, 286.569, 69.144, 187.332, -49.044, 1.0, 402.0, 1, 402.0, 171.138],
        [539, 2.051, 0.631, 1.709, -0.447, 1.0, 3.67, 1, 3.667, 0.435],
        [539, 2.4735, 0.631, 1.709, -0.447, 1.0, 3.67, 1, 3.667, 1.28],
        [539, 2.742, 0.631, 1.709, -0.447, 1.0, 3.67, 1, 3.667, 1.817],
        [539, 2.283, 0.631, 1.709, -0.447, 1.0, 3.67, 1, 3.667, 0.899],
        [539, 0.0, 0.0, 1.709, -0.447, 1.0, 3.67, 0, 3.667, 1.289],
        [539, 0.0, 0.0, 1.709, -0.447, 1.0, 3.67, 0, 3.667, 1.159],
        [542, 0.0, 0.0, 88.43, -19.284, 1.0, 173.73, 0, 173.733, 56.291],
        [543, 111.8905, 34.573, 88.43, -19.284, 1.0, 173.73, 1, 173.733, 50.048],
        [544, 127.1945, 34.573, 88.43, -19.284, 1.0, 173.73, 1, 173.733, 80.656],
        [545, 0.0, 0.0, 88.43, -19.284, 1.0, 173.73, 0, 173.733, 73.088],
        [546, 116.4245, 34.573, 88.43, -19.284, 1.0, 173.73, 1, 173.733, 59.116],
        [547, 111.503, 34.573, 88.43, -19.284, 1.0, 173.73, 1, 173.733, 49.273],
        [551, 624.0895, 154.44, 397.44, -88.56, 1.0, 1080.0, 1, 1080.0, 168.179],
        [552, 626.361, 154.44, 397.44, -88.56, 1.0, 1080.0, 1, 1080.0, 172.722],
        [554, 49.9325, 13.612, 34.816, -7.592, 1.0, 68.4, 1, 68.4, 31.465],
        [554, 43.5455, 13.612, 34.816, -7.592, 1.0, 68.4, 1, 68.4, 18.691],
        [554, 43.997, 13.612, 34.816, -7.592, 1.0, 68.4, 1, 68.4, 19.594],
        [554, 48.079, 13.612, 34.816, -7.592, 1.0, 68.4, 1, 68.4, 27.758],
        [554, 0.0, 0.0, 34.816, -7.592, 1.0, 68.4, 0, 68.4, 26.86],
        [554, 41.136, 13.612, 34.816, -7.592, 1.0, 68.4, 1, 68.4, 13.872],
        [558, 75.428, 27.223, 69.631, -15.185, 1.0, 136.8, 1, 136.8, 14.056],
        [559, 0.0, 0.0, 69.631, -15.185, 1.0, 136.8, 0, 136.8, 64.405],
        [560, 0.0, 0.0, 69.631, -15.185, 1.0, 136.8, 0, 136.8, 41.032],
        [561, 82.724, 27.223, 69.631, -15.185, 1.0, 136.8, 1, 136.8, 28.648],
        [562, 78.8815, 27.223, 69.631, -15.185, 1.0, 136.8, 1, 136.8, 20.963],
        [563, 86.6705, 27.223, 69.631, -15.185, 1.0, 136.8, 1, 136.8, 36.541],
        [567, 461.7685, 141.39, 361.645, -78.865, 1.0, 710.5, 1, 710.5, 213.037],
        [568, 419.9705, 141.39, 361.645, -78.865, 1.0, 710.5, 1, 710.5, 129.441],
        [569, 523.346, 141.39, 361.645, -78.865, 1.0, 710.5, 1, 710.5, 336.192],
        [570, 393.325, 141.39, 361.645, -78.865, 1.0, 710.5, 1, 710.5, 76.15],
        [571, 0.0, 0.0, 361.645, -78.865, 1.0, 710.5, 0, 710.5, 73.471],
        [572, 0.0, 0.0, 361.645, -78.865, 1.0, 710.5, 0, 710.5, 216.649],
        [574, 0.0, 0.0, 57.784, -15.128, 1.0, 124.0, 0, 124.0, 57.005],
        [575, 85.8, 21.328, 57.784, -15.128, 1.0, 124.0, 1, 124.0, 47.6],
        [576, 87.0925, 21.328, 57.784, -15.128, 1.0, 124.0, 1, 124.0, 50.185],
        [577, 68.35, 21.328, 57.784, -15.128, 1.0, 124.0, 1, 124.0, 12.7],
        [578, 70.853, 21.328, 57.784, -15.128, 1.0, 124.0, 1, 124.0, 17.706],
        [579, 0.0, 0.0, 57.784, -15.128, 1.0, 124.0, 0, 124.0, 36.442],
        [581, 13.283, 3.6265, 9.825, -2.572, 1.0, 21.08, 1, 21.083, 5.483],
        [582, 13.656, 3.6265, 9.825, -2.572, 1.0, 21.08, 1, 21.083, 6.229],
        [582, 13.6685, 3.6265, 9.825, -2.572, 1.0, 21.08, 1, 21.083, 6.254],
        [582, 0.0, 0.0, 9.825, -2.572, 1.0, 21.08, 0, 21.083, 7.482],
        [582, 12.7, 3.6265, 9.825, -2.572, 1.0, 21.08, 1, 21.083, 4.317],
        [582, 0.0, 0.0, 9.825, -2.572, 1.0, 21.08, 0, 21.083, 7.684],
        [587, 119.022, 36.019, 92.129, -20.091, 1.0, 181.0, 1, 181.0, 57.044],
        [588, 123.0775, 36.019, 92.129, -20.091, 1.0, 181.0, 1, 181.0, 65.155],
        [590, 8.913, 3.124, 7.991, -1.743, 1.0, 15.7, 1, 15.7, 2.126],
        [590, 10.352, 3.124, 7.991, -1.743, 1.0, 15.7, 1, 15.7, 5.004],
        [594, 233.1585, 64.4265, 164.789, -35.936, 1.0, 323.75, 1, 323.75, 142.567],
        [595, 0.0, 0.0, 164.789, -35.936, 1.0, 323.75, 0, 323.75, 54.778],
        [596, 235.478, 64.4265, 164.789, -35.936, 1.0, 323.75, 1, 323.75, 147.206],
        [597, 185.277, 64.4265, 164.789, -35.936, 1.0, 323.75, 1, 323.75, 46.804],
        [599, 0.0, 0.0, 3.169, -0.83, 1.0, 6.8, 0, 6.8, 3.324],
        [599, 0.0, 0.0, 3.169, -0.83, 1.0, 6.8, 0, 6.8, 0.698],
        [599, 0.0, 0.0, 3.169, -0.83, 1.0, 6.8, 0, 6.8, 0.905],
        [599, 0.0, 0.0, 3.169, -0.83, 1.0, 6.8, 0, 6.8, 1.101],
        [599, 0.0, 0.0, 3.169, -0.83, 1.0, 6.8, 0, 6.8, 3.201],
        [599, 0.0, 0.0, 3.169, -0.83, 1.0, 6.8, 0, 6.8, 2.569],
        [1208, 0.0, 0.0, 5.701, -1.243, 1.0, 11.2, 0, 11.2, 2.558],
        [1208, 0.0, 0.0, 5.701, -1.243, 1.0, 11.2, 0, 11.2, 3.605],
        [1212, 91.7425, 28.357, 72.532, -15.818, 1.0, 142.5, 1, 142.5, 40.985],
        [1213, 0.0, 0.0, 72.532, -15.818, 1.0, 142.5, 0, 142.5, 55.372],
        [1214, 86.6565, 28.357, 72.532, -15.818, 1.0, 142.5, 1, 142.5, 30.813],
        [1216, 57.1245, 17.313, 44.283, -9.657, 1.0, 87.0, 1, 87.0, 27.249],
        [1216, 52.097, 17.313, 44.283, -9.657, 1.0, 87.0, 1, 87.0, 17.194],
        [1219, 56.0685, 14.4825, 39.237, -10.272, 1.0, 84.2, 1, 84.2, 27.937],
        [1219, 46.75, 14.4825, 39.237, -10.272, 1.0, 84.2, 1, 84.2, 9.3],
        [1219, 47.4475, 14.4825, 39.237, -10.272, 1.0, 84.2, 1, 84.2, 10.695],
        [1219, 53.92, 14.4825, 39.237, -10.272, 1.0, 84.2, 1, 84.2, 23.64],
        [1219, 56.779, 14.4825, 39.237, -10.272, 1.0, 84.2, 1, 84.2, 29.358],
        [1219, 55.1095, 14.4825, 39.237, -10.272, 1.0, 84.2, 1, 84.2, 26.019],
        [1226, 0.0, 0.0, 101.23, -22.076, 1.0, 198.88, 0, 198.88, 47.086],
        [1227, 127.5005, 39.577, 101.23, -22.076, 1.0, 198.88, 1, 198.88, 56.121],
        [1228, 130.3675, 39.577, 101.23, -22.076, 1.0, 198.88, 1, 198.88, 61.855],
        [1229, 135.5645, 39.577, 101.23, -22.076, 1.0, 198.88, 1, 198.88, 72.249],
        [1230, 0.0, 0.0, 101.23, -22.076, 1.0, 198.88, 0, 198.88, 76.895],
        [1232, 0.0, 0.0, 2.723, -0.594, 1.0, 5.35, 0, 5.35, 2.222],
        [1233, 0.0, 0.0, 2.723, -0.594, 1.0, 5.35, 0, 5.35, 2.517],
        [1237, 129.6835, 40.934, 104.701, -22.833, 1.0, 205.7, 1, 205.7, 53.667],
        [1238, 0.0, 0.0, 104.701, -22.833, 1.0, 205.7, 0, 205.7, 30.887],
        [1243, 145.9405, 39.681, 101.495, -22.133, 1.0, 199.4, 1, 199.4, 92.481],
        [1244, 123.285, 39.681, 101.495, -22.133, 1.0, 199.4, 1, 199.4, 47.17],
        [1246, 0.0, 0.0, 21.378, -4.662, 1.0, 42.0, 0, 42.0, 17.993],
        [1251, 99.6825, 35.9, 91.824, -20.024, 1.0, 180.4, 1, 180.4, 18.965],
        [1252, 104.498, 35.9, 91.824, -20.024, 1.0, 180.4, 1, 180.4, 28.596],
        [1253, 0.0, 0.0, 91.824, -20.024, 1.0, 180.4, 0, 180.4, 62.389],
        [1256, 210.1575, 66.811, 170.888, -37.266, 1.0, 335.73, 1, 335.733, 84.582],
        [1257, 0.0, 0.0, 170.888, -37.266, 1.0, 335.73, 0, 335.733, 129.272],
        [1258, 195.9485, 66.811, 170.888, -37.266, 1.0, 335.73, 1, 335.733, 56.164],
        [1259, 203.09, 66.811, 170.888, -37.266, 1.0, 335.73, 1, 335.733, 70.447],
        [1260, 0.0, 0.0, 170.888, -37.266, 1.0, 335.73, 0, 335.733, 47.366],
        [1261, 208.251, 66.811, 170.888, -37.266, 1.0, 335.73, 1, 335.733, 80.769],
        [1262, 0.0, 0.0, 0.865, -0.189, 1.0, 1.7, 0, 1.7, 0.215],
        [1266, 0.0, 0.0, 216.457, -56.669, 1.0, 464.5, 0, 464.5, 117.172],
        [1267, 0.0, 0.0, 216.457, -56.669, 1.0, 464.5, 0, 464.5, 81.768],
        [1271, 132.243, 36.218, 92.638, -20.202, 1.0, 182.0, 1, 182.0, 82.486],
        [1272, 130.3275, 36.218, 92.638, -20.202, 1.0, 182.0, 1, 182.0, 78.655],
        [1273, 111.3065, 36.218, 92.638, -20.202, 1.0, 182.0, 1, 182.0, 40.613],
        [1274, 124.9885, 36.218, 92.638, -20.202, 1.0, 182.0, 1, 182.0, 67.977],
        [1277, 0.0, 0.0, 23.176, -5.054, 1.0, 45.53, 0, 45.533, 22.712],
        [1277, 0.0, 0.0, 23.176, -5.054, 1.0, 45.53, 0, 45.533, 4.714],
        [1277, 0.0, 0.0, 23.176, -5.054, 1.0, 45.53, 0, 45.533, 8.36],
        [1281, 144.997, 49.869, 127.555, -27.817, 1.0, 250.6, 1, 250.6, 39.394],
        [1282, 170.8875, 49.869, 127.555, -27.817, 1.0, 250.6, 1, 250.6, 91.175],
        [1283, 0.0, 0.0, 127.555, -27.817, 1.0, 250.6, 0, 250.6, 104.51],
        [1284, 186.507, 49.869, 127.555, -27.817, 1.0, 250.6, 1, 250.6, 122.414],
        [1285, 155.499, 49.869, 127.555, -27.817, 1.0, 250.6, 1, 250.6, 60.398],
        [1289, 0.0, 0.0, 109.299, -23.835, 1.0, 214.73, 0, 214.733, 106.491],
        [1290, 0.0, 0.0, 109.299, -23.835, 1.0, 214.73, 0, 214.733, 100.357],
        [1291, 142.397, 42.732, 109.299, -23.835, 1.0, 214.73, 1, 214.733, 70.061],
        [1295, 224.2795, 64.4265, 164.789, -35.936, 1.0, 323.75, 1, 323.75, 124.809],
        [1296, 241.37, 64.4265, 164.789, -35.936, 1.0, 323.75, 1, 323.75, 158.99],
        [1297, 222.095, 64.4265, 164.789, -35.936, 1.0, 323.75, 1, 323.75, 120.44],
        [1298, 230.6285, 64.4265, 164.789, -35.936, 1.0, 323.75, 1, 323.75, 137.507],
        [1300, 0.0, 0.0, 1.476, -0.322, 1.0, 2.9, 0, 2.9, 1.047],
        [1300, 50.0395, 13.91, 35.579, -7.759, 1.0, 69.9, 1, 69.9, 30.179],
        [1300, 48.9705, 13.91, 35.579, -7.759, 1.0, 69.9, 1, 69.9, 28.041],
        [1300, 40.167, 13.91, 35.579, -7.759, 1.0, 69.9, 1, 69.9, 10.434],
        [1300, 46.6465, 13.91, 35.579, -7.759, 1.0, 69.9, 1, 69.9, 23.393],
        [1301, 0.0, 0.0, 1.476, -0.322, 1.0, 2.9, 0, 2.9, 0.497],
        [1303, 137.322, 45.6575, 116.782, -25.467, 1.0, 229.43, 1, 229.433, 45.211],
        [1303, 0.0, 0.0, 116.782, -25.467, 1.0, 229.43, 0, 229.433, 51.807],
        [1303, 158.8135, 45.6575, 116.782, -25.467, 1.0, 229.43, 1, 229.433, 88.194],
        [1308, 0.0, 0.0, 89.482, -19.514, 1.0, 175.8, 0, 175.8, 61.666],
        [1309, 111.237, 34.984, 89.482, -19.514, 1.0, 175.8, 1, 175.8, 46.674],
        [1310, 125.8785, 34.984, 89.482, -19.514, 1.0, 175.8, 1, 175.8, 75.957],
        [1311, 0.0, 0.0, 89.482, -19.514, 1.0, 175.8, 0, 175.8, 23.848],
        [1313, 0.79, 0.2065, 0.559, -0.146, 1.0, 1.2, 1, 1.2, 0.38],
        [1313, 0.0, 0.0, 3.883, -1.017, 1.0, 8.33, 0, 8.333, 1.146],
        [1313, 0.809, 0.2065, 0.559, -0.146, 1.0, 1.2, 1, 1.2, 0.418],
        [1313, 1.4495, 0.43, 1.165, -0.305, 1.0, 2.5, 1, 2.5, 0.399],
        [1313, 1.5575, 0.43, 1.165, -0.305, 1.0, 2.5, 1, 2.5, 0.615],
        [1313, 0.0, 0.0, 3.883, -1.017, 1.0, 8.33, 0, 8.333, 2.53],
        [1313, 0.0, 0.0, 3.883, -1.017, 1.0, 8.33, 0, 8.333, 2.739],
        [1313, 5.963, 1.433, 3.883, -1.017, 1.0, 8.33, 1, 8.333, 3.593],
        [1313, 5.5175, 1.433, 3.883, -1.017, 1.0, 8.33, 1, 8.333, 2.702],
        [1313, 0.0, 0.0, 3.883, -1.017, 1.0, 8.33, 0, 8.333, 3.708],
        [1318, 122.399, 39.8, 101.8, -22.2, 1.0, 200.0, 1, 200.0, 44.798],
        [1319, 140.125, 39.8, 101.8, -22.2, 1.0, 200.0, 1, 200.0, 80.25],
        [1320, 131.923, 39.8, 101.8, -22.2, 1.0, 200.0, 1, 200.0, 63.846],
        [1325, 564.028, 160.734, 435.477, -114.009, 1.0, 934.5, 1, 934.5, 193.556],
        [1326, 658.5845, 160.734, 435.477, -114.009, 1.0, 934.5, 1, 934.5, 382.669],
        [1328, 31.719, 9.7525, 26.422, -6.917, 1.0, 56.7, 1, 56.7, 6.738],
        [1328, 33.4295, 9.7525, 26.422, -6.917, 1.0, 56.7, 1, 56.7, 10.159],
        [1328, 37.3085, 9.7525, 26.422, -6.917, 1.0, 56.7, 1, 56.7, 17.917],
        [1328, 36.575, 9.7525, 26.422, -6.917, 1.0, 56.7, 1, 56.7, 16.45],
        [1330, 48.1835, 17.114, 43.774, -9.546, 1.0, 86.0, 1, 86.0, 10.367],
        [1330, 53.2595, 17.114, 43.774, -9.546, 1.0, 86.0, 1, 86.0, 20.519],
        [1330, 58.9985, 17.114, 43.774, -9.546, 1.0, 86.0, 1, 86.0, 31.997],
        [1332, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0, 1.0, 0.404],
        [1332, 2.013, 0.0, 0.0, 0.0, 1.0, 2.7, 1, 2.7, 1.326],
        [1332, 2.1075, 0.0, 0.0, 0.0, 1.0, 3.5, 1, 3.5, 0.715],
        [1332, 17.664, 0.0, 0.0, 0.0, 1.0, 25.0, 1, 25.0, 10.328],
        [1336, 88.498, 27.6705, 70.776, -15.435, 1.0, 139.05, 1, 139.05, 37.946],
        [1337, 101.1105, 27.6705, 70.776, -15.435, 1.0, 139.05, 1, 139.05, 63.171],
        [1341, 0.0, 0.0, 169.531, -44.384, 1.0, 363.8, 0, 363.8, 134.77],
        [1343, 31.949, 9.313, 23.821, -5.195, 1.0, 46.8, 1, 46.8, 17.098],
        [1345, 0.0, 0.0, 19.495, -4.251, 1.0, 38.3, 0, 38.3, 4.815],
        [1346, 0.0, 0.0, 19.495, -4.251, 1.0, 38.3, 0, 38.3, 17.942],
        [1346, 0.0, 0.0, 19.495, -4.251, 1.0, 38.3, 0, 38.3, 17.183],
        [1346, 0.0, 0.0, 19.495, -4.251, 1.0, 38.3, 0, 38.3, 12.737],
        [1348, 0.0, 0.0, 2.087, -0.455, 1.0, 4.1, 0, 4.1, 1.28],
        [1348, 0.0, 0.0, 2.087, -0.455, 1.0, 4.1, 0, 4.1, 0.484],
        [1350, 3.192, 0.0, 0.0, 0.0, 1.0, 5.1, 1, 5.1, 1.284],
        [1350, 5.955, 0.0, 0.0, 0.0, 1.0, 10.0, 1, 10.0, 1.91],
        [1352, 0.0, 0.0, 8.947, -2.342, 1.0, 19.2, 0, 19.2, 3.432],
        [1354, 0.0, 0.0, 13.539, -2.953, 1.0, 26.6, 0, 26.6, 8.702],
        [1356, 0.0, 0.0, 17.153, -3.741, 1.0, 33.7, 0, 33.7, 11.2],
        [1360, 287.578, 81.2085, 207.714, -45.297, 1.0, 408.08, 1, 408.083, 167.073],
        [1361, 0.0, 0.0, 207.714, -45.297, 1.0, 408.08, 0, 408.083, 44.635],
        [1362, 275.2035, 81.2085, 207.714, -45.297, 1.0, 408.08, 1, 408.083, 142.324],
        [1363, 0.0, 0.0, 207.714, -45.297, 1.0, 408.08, 0, 408.083, 195.064],
        [1364, 279.582, 81.2085, 207.714, -45.297, 1.0, 408.08, 1, 408.083, 151.081],
        [1365, 245.173, 81.2085, 207.714, -45.297, 1.0, 408.08, 1, 408.083, 82.263],
        [1370, 0.0, 0.0, 212.321, -55.586, 1.0, 455.63, 0, 455.625, 138.412],
        [1371, 0.0, 0.0, 212.321, -55.586, 1.0, 455.63, 0, 455.625, 88.104],
        [1372, 0.0, 0.0, 212.321, -55.586, 1.0, 455.63, 0, 455.625, 105.861],
        [1373, 0.0, 0.0, 212.321, -55.586, 1.0, 455.63, 0, 455.625, 111.3],
        [1377, 222.0385, 75.0395, 191.935, -41.856, 1.0, 377.08, 1, 377.083, 66.994],
        [1378, 242.1685, 75.0395, 191.935, -41.856, 1.0, 377.08, 1, 377.083, 107.254],
        [1379, 266.0535, 75.0395, 191.935, -41.856, 1.0, 377.08, 1, 377.083, 155.024],
        [1380, 237.232, 75.0395, 191.935, -41.856, 1.0, 377.08, 1, 377.083, 97.381],
        [1381, 0.0, 0.0, 191.935, -41.856, 1.0, 377.08, 0, 377.083, 130.646],
        [1382, 217.287, 75.0395, 191.935, -41.856, 1.0, 377.08, 1, 377.083, 57.491],
        [1384, 0.0, 0.0, 17.179, -3.746, 1.0, 33.75, 0, 33.75, 12.154],
        [1384, 0.0, 0.0, 17.179, -3.746, 1.0, 33.75, 0, 33.75, 15.261],
        [1386, 0.0, 0.0, 8.947, -2.342, 1.0, 19.2, 0, 19.2, 9.464],
        [1386, 0.0, 0.0, 8.947, -2.342, 1.0, 19.2, 0, 19.2, 2.957],
        [1390, 182.747, 48.739, 124.664, -27.186, 1.0, 244.92, 1, 244.92, 120.574],
        [1391, 180.706, 48.739, 124.664, -27.186, 1.0, 244.92, 1, 244.92, 116.492],
        [1392, 152.2195, 48.739, 124.664, -27.186, 1.0, 244.92, 1, 244.92, 59.519],
        [1393, 147.2585, 48.739, 124.664, -27.186, 1.0, 244.92, 1, 244.92, 49.597],
        [1394, 154.943, 48.739, 124.664, -27.186, 1.0, 244.92, 1, 244.92, 64.966],
        [1398, 115.1155, 38.9375, 99.594, -21.719, 1.0, 195.67, 1, 195.667, 34.564],
        [1399, 0.0, 0.0, 99.594, -21.719, 1.0, 195.67, 0, 195.667, 60.419],
        [1400, 116.332, 38.9375, 99.594, -21.719, 1.0, 195.67, 1, 195.667, 36.997],
        [1404, 583.8815, 148.4875, 402.298, -105.323, 1.0, 863.3, 1, 863.3, 304.463],
        [1405, 549.8575, 148.4875, 402.298, -105.323, 1.0, 863.3, 1, 863.3, 236.415],
        [1407, 0.0, 0.0, 25.956, -6.795, 1.0, 55.7, 0, 55.7, 22.723],
        [1407, 31.706, 9.5805, 25.956, -6.795, 1.0, 55.7, 1, 55.7, 7.712],
        [1410, 34.979, 12.338, 31.558, -6.882, 1.0, 62.0, 1, 62.0, 7.958],
        [1412, 0.0, 0.0, 14.736, -3.213, 1.0, 28.95, 0, 28.95, 4.899],
        [1412, 0.0, 0.0, 14.736, -3.213, 1.0, 28.95, 0, 28.95, 4.249],
        [1414, 61.5115, 17.154, 43.876, -9.568, 1.0, 86.2, 1, 86.2, 36.823],
        [1417, 91.8925, 28.062, 76.028, -19.904, 1.0, 163.15, 1, 163.15, 20.635],
        [1418, 97.9985, 28.062, 76.028, -19.904, 1.0, 163.15, 1, 163.15, 32.847],
        [1421, 0.0, 0.0, 62.302, -13.586, 1.0, 122.4, 0, 122.4, 12.748],
        [1423, 0.0, 0.0, 283.106, -61.738, 1.0, 556.2, 0, 556.2, 157.584],
        [1423, 331.527, 110.684, 283.106, -61.738, 1.0, 556.2, 1, 556.2, 106.854],
        [1426, 45.6795, 12.4675, 31.889, -6.954, 1.0, 62.65, 1, 62.65, 28.709],
        [1426, 45.225, 12.4675, 31.889, -6.954, 1.0, 62.65, 1, 62.65, 27.8],
        [1429, 31.376, 11.084, 28.351, -6.183, 1.0, 55.7, 1, 55.7, 7.052],
        [1429, 41.325, 11.084, 28.351, -6.183, 1.0, 55.7, 1, 55.7, 26.95],
        [1432, 121.2235, 33.1335, 84.749, -18.482, 1.0, 166.5, 1, 166.5, 75.947],
        [1433, 113.4765, 33.1335, 84.749, -18.482, 1.0, 166.5, 1, 166.5, 60.453],
        [1438, 0.0, 0.0, 68.291, -14.893, 1.0, 134.17, 0, 134.167, 34.999],
        [1439, 92.842, 26.699, 68.291, -14.893, 1.0, 134.17, 1, 134.167, 51.517],
        [1440, 0.0, 0.0, 68.291, -14.893, 1.0, 134.17, 0, 134.167, 57.668],
        [1441, 84.17, 26.699, 68.291, -14.893, 1.0, 134.17, 1, 134.167, 34.173],
        [1442, 88.2115, 26.699, 68.291, -14.893, 1.0, 134.17, 1, 134.167, 42.256],
        [1443, 74.7535, 26.699, 68.291, -14.893, 1.0, 134.17, 1, 134.167, 15.34],
        [1445, 49.683, 17.054, 43.621, -9.513, 1.0, 85.7, 1, 85.7, 13.666],
        [1445, 47.2615, 17.054, 43.621, -9.513, 1.0, 85.7, 1, 85.7, 8.823],
        [1445, 63.4085, 17.054, 43.621, -9.513, 1.0, 85.7, 1, 85.7, 41.117],
        [1445, 0.0, 0.0, 43.621, -9.513, 1.0, 85.7, 0, 85.7, 41.344],
        [1449, 0.0, 0.0, 66.221, -14.441, 1.0, 130.1, 0, 130.1, 23.75],
        [1453, 0.0, 0.0, 103.327, -22.533, 1.0, 203.0, 0, 203.0, 87.132],
        [1454, 137.1065, 40.397, 103.327, -22.533, 1.0, 203.0, 1, 203.0, 71.213],
        [1455, 118.7315, 40.397, 103.327, -22.533, 1.0, 203.0, 1, 203.0, 34.463],
        [1457, 28.3285, 9.373, 23.974, -5.228, 1.0, 47.1, 1, 47.1, 9.557],
        [1458, 33.3055, 9.373, 23.974, -5.228, 1.0, 47.1, 1, 47.1, 19.511],
        [1458, 27.1215, 9.373, 23.974, -5.228, 1.0, 47.1, 1, 47.1, 7.143],
        [1461, 39.605, 12.338, 31.558, -6.882, 1.0, 62.0, 1, 62.0, 17.21],
        [1461, 40.7135, 12.338, 31.558, -6.882, 1.0, 62.0, 1, 62.0, 19.427],
        [1461, 38.3265, 12.338, 31.558, -6.882, 1.0, 62.0, 1, 62.0, 14.653],
        [1461, 0.0, 0.0, 31.558, -6.882, 1.0, 62.0, 0, 62.0, 27.611],
        [1461, 41.41, 12.338, 31.558, -6.882, 1.0, 62.0, 1, 62.0, 20.82],
        [1465, 0.0, 0.0, 58.408, -12.737, 1.0, 114.75, 0, 114.75, 45.066],
        [1466, 84.1435, 22.8355, 58.408, -12.737, 1.0, 114.75, 1, 114.75, 53.537],
        [1468, 0.0, 0.0, 17.815, -3.885, 1.0, 35.0, 0, 35.0, 14.316],
        [1468, 0.0, 0.0, 17.815, -3.885, 1.0, 35.0, 0, 35.0, 7.951],
        [1473, 0.0, 0.0, 93.91, -20.48, 1.0, 184.5, 0, 184.5, 82.454],
        [1474, 105.2305, 36.715, 93.91, -20.48, 1.0, 184.5, 1, 184.5, 25.961],
        [1479, 0.0, 0.0, 184.256, -48.239, 1.0, 395.4, 0, 395.4, 194.055],
        [1482, 0.0, 0.0, 15.704, -4.111, 1.0, 33.7, 0, 33.7, 12.402],
        [1858, 2.4615, 0.816, 2.087, -0.455, 1.0, 4.1, 1, 4.1, 0.823],
        [1858, 25.7735, 8.557, 21.887, -4.773, 1.0, 43.0, 1, 43.0, 8.547],
        [1861, 162.2015, 50.1555, 135.886, -35.575, 1.0, 291.6, 1, 291.6, 32.803],
        [1863, 0.0, 0.0, 7.635, -1.665, 1.0, 15.0, 0, 15.0, 6.868],
        [1863, 0.0, 0.0, 7.635, -1.665, 1.0, 15.0, 0, 15.0, 5.584],
        [1867, 0.0, 0.0, 284.575, -74.502, 1.0, 610.67, 0, 610.675, 116.957],
        [1868, 446.8485, 105.0365, 284.575, -74.502, 1.0, 610.67, 1, 610.675, 283.022],
        [1869, 0.0, 0.0, 284.575, -74.502, 1.0, 610.67, 0, 610.675, 208.275],
        [1870, 341.249, 105.0365, 284.575, -74.502, 1.0, 610.67, 1, 610.675, 71.823],
        [1873, 30.394, 8.428, 22.834, -5.978, 1.0, 49.0, 1, 49.0, 11.788],
        [1873, 31.968, 8.428, 22.834, -5.978, 1.0, 49.0, 1, 49.0, 14.936],
        [1875, 44.543, 10.6815, 28.939, -7.576, 1.0, 62.1, 1, 62.1, 26.986],
        [1875, 41.088, 10.6815, 28.939, -7.576, 1.0, 62.1, 1, 62.1, 20.076],
        [1875, 38.827, 10.6815, 28.939, -7.576, 1.0, 62.1, 1, 62.1, 15.554],
        [1875, 34.7175, 10.6815, 28.939, -7.576, 1.0, 62.1, 1, 62.1, 7.335],
        [1877, 58.7845, 14.786, 40.06, -10.488, 1.0, 85.97, 1, 85.967, 31.602],
        [1877, 0.0, 0.0, 40.06, -10.488, 1.0, 85.97, 0, 85.967, 25.521],
        [1877, 60.4905, 14.786, 40.06, -10.488, 1.0, 85.97, 1, 85.967, 35.014],
        [1877, 50.9175, 14.786, 40.06, -10.488, 1.0, 85.97, 1, 85.967, 15.868],
        [1877, 0.0, 0.0, 40.06, -10.488, 1.0, 85.97, 0, 85.967, 25.47],
        [1877, 0.0, 0.0, 40.06, -10.488, 1.0, 85.97, 0, 85.967, 15.792],
        [1880, 0.0, 0.0, 27.587, -7.222, 1.0, 59.2, 0, 59.2, 18.201],
        [1880, 36.5695, 10.1825, 27.587, -7.222, 1.0, 59.2, 1, 59.2, 13.939],
        [1883, 116.476, 29.24, 79.22, -20.74, 1.0, 170.0, 1, 170.0, 62.952],
        [1884, 125.0495, 29.24, 79.22, -20.74, 1.0, 170.0, 1, 170.0, 80.099],
        [1887, 0.0, 0.0, 94.165, -20.535, 1.0, 185.0, 0, 185.0, 90.356],
        [1888, 106.4425, 36.815, 94.165, -20.535, 1.0, 185.0, 1, 185.0, 27.885],
        [1889, 0.0, 0.0, 1.527, -0.333, 1.0, 3.0, 0, 3.0, 0.701],
        [1890, 0.0, 0.0, 1.527, -0.333, 1.0, 3.0, 0, 3.0, 0.438],
        [1890, 0.0, 0.0, 1.527, -0.333, 1.0, 3.0, 0, 3.0, 0.905],
        [1893, 0.0, 0.0, 11.184, -2.928, 1.0, 24.0, 0, 24.0, 11.225],
        [1893, 16.93, 4.128, 11.184, -2.928, 1.0, 24.0, 1, 24.0, 9.86],
        [1897, 127.883, 37.89, 96.914, -21.134, 1.0, 190.4, 1, 190.4, 65.366],
        [1898, 0.0, 0.0, 96.914, -21.134, 1.0, 190.4, 0, 190.4, 23.704],
        [1899, 0.0, 0.0, 4.937, -1.077, 1.0, 9.7, 0, 9.7, 1.231],
        [1903, 211.7325, 48.809, 132.239, -34.621, 1.0, 283.77, 1, 283.775, 139.69],
        [1904, 164.758, 48.809, 132.239, -34.621, 1.0, 283.77, 1, 283.775, 45.741],
        [1905, 184.677, 48.809, 132.239, -34.621, 1.0, 283.77, 1, 283.775, 85.579],
        [1906, 0.0, 0.0, 132.239, -34.621, 1.0, 283.77, 0, 283.775, 98.476],
        [1908, 0.0, 0.0, 1.162, -0.253, 1.0, 2.28, 0, 2.283, 0.506],
        [1908, 55.278, 17.114, 43.774, -9.546, 1.0, 86.0, 1, 86.0, 24.556],
        [1908, 0.0, 0.0, 1.162, -0.253, 1.0, 2.28, 0, 2.283, 0.888],
        [1908, 0.0, 0.0, 1.162, -0.253, 1.0, 2.28, 0, 2.283, 1.026],
        [1908, 0.0, 0.0, 1.162, -0.253, 1.0, 2.28, 0, 2.283, 0.521],
        [1908, 0.0, 0.0, 1.162, -0.253, 1.0, 2.28, 0, 2.283, 0.325],
        [1908, 0.0, 0.0, 1.162, -0.253, 1.0, 2.28, 0, 2.283, 0.251],
        [1908, 0.0, 0.0, 2.715, -0.592, 1.0, 5.33, 0, 5.333, 1.226],
        [1908, 0.0, 0.0, 2.715, -0.592, 1.0, 5.33, 0, 5.333, 1.237],
        [1908, 0.0, 0.0, 2.715, -0.592, 1.0, 5.33, 0, 5.333, 1.455],
        [1912, 93.8145, 27.3125, 69.86, -15.235, 1.0, 137.25, 1, 137.25, 50.379],
        [1913, 82.839, 27.3125, 69.86, -15.235, 1.0, 137.25, 1, 137.25, 28.428],
        [1914, 3.104, 0.935, 2.392, -0.522, 1.0, 4.7, 1, 4.7, 1.508],
        [1914, 0.0, 0.0, 2.392, -0.522, 1.0, 4.7, 0, 4.7, 0.49],
        [1915, 0.0, 0.0, 2.392, -0.522, 1.0, 4.7, 0, 4.7, 0.898],
        [1917, 0.0, 0.0, 0.0, 0.0, 1.0, 1.2, 0, 1.2, 0.282],
        [1917, 0.0, 0.0, 0.0, 0.0, 1.0, 1.6, 0, 1.6, 0.26],
        [1917, 5.507, 0.0, 0.0, 0.0, 1.0, 10.0, 1, 10.0, 1.014],
        [1917, 8.36, 0.0, 0.0, 0.0, 1.0, 15.0, 1, 15.0, 1.72],
        [1919, 0.0, 0.0, 4.377, -0.955, 1.0, 8.6, 0, 8.6, 1.384],
        [1919, 19.812, 5.97, 15.27, -3.33, 1.0, 30.0, 1, 30.0, 9.624],
        [1921, 31.1145, 7.1895, 19.479, -5.1, 1.0, 41.8, 1, 41.8, 20.429],
        [1923, 2.9045, 0.6815, 1.562, -0.199, 1.0, 4.07, 1, 4.067, 1.742],
        [1923, 0.0, 0.0, 1.562, -0.199, 1.0, 4.07, 0, 4.067, 1.966],
        [1923, 2.76, 0.6815, 1.562, -0.199, 1.0, 4.07, 1, 4.067, 1.453],
        [1923, 0.0, 0.0, 5.568, -0.71, 1.0, 14.5, 0, 14.5, 2.197],
        [1923, 9.1905, 2.429, 5.568, -0.71, 1.0, 14.5, 1, 14.5, 3.881],
        [1923, 0.0, 0.0, 5.568, -0.71, 1.0, 14.5, 0, 14.5, 2.16],
        [1925, 42.352, 10.5265, 28.519, -7.466, 1.0, 61.2, 1, 61.2, 23.504],
        [1927, 34.197, 9.6385, 24.653, -5.376, 1.0, 48.43, 1, 48.433, 19.961],
        [1927, 34.394, 9.6385, 24.653, -5.376, 1.0, 48.43, 1, 48.433, 20.355],
        [1927, 34.7315, 9.6385, 24.653, -5.376, 1.0, 48.43, 1, 48.433, 21.03],
        [1929, 49.707, 14.925, 38.175, -8.325, 1.0, 75.0, 1, 75.0, 24.414],
        [1931, 0.0, 0.0, 20.78, -4.532, 1.0, 40.83, 0, 40.825, 11.848],
        [1931, 25.873, 8.124, 20.78, -4.532, 1.0, 40.83, 1, 40.825, 10.921],
        [1931, 0.0, 0.0, 20.78, -4.532, 1.0, 40.83, 0, 40.825, 16.89],
        [1931, 22.837, 8.124, 20.78, -4.532, 1.0, 40.83, 1, 40.825, 4.849],
        [1933, 0.0, 0.0, 2.087, -0.455, 1.0, 4.1, 0, 4.1, 0.733],
        [1933, 28.456, 8.902, 22.769, -4.965, 1.0, 44.73, 1, 44.733, 12.179],
        [1934, 0.0, 0.0, 22.769, -4.965, 1.0, 44.73, 0, 44.733, 21.889],
        [1934, 24.665, 8.902, 22.769, -4.965, 1.0, 44.73, 1, 44.733, 4.597],
        [1936, 33.661, 12.179, 31.151, -6.793, 1.0, 61.2, 1, 61.2, 6.122],
        [1936, 44.695, 12.179, 31.151, -6.793, 1.0, 61.2, 1, 61.2, 28.19],
        [1939, 33.1615, 9.751, 24.941, -5.439, 1.0, 49.0, 1, 49.0, 17.323],
        [1939, 33.0325, 9.751, 24.941, -5.439, 1.0, 49.0, 1, 49.0, 17.065],
        [1939, 28.357, 9.751, 24.941, -5.439, 1.0, 49.0, 1, 49.0, 7.714],
        [1942, 180.708, 51.17, 138.635, -36.295, 1.0, 297.5, 1, 297.5, 63.916],
        [1943, 0.0, 0.0, 138.635, -36.295, 1.0, 297.5, 0, 297.5, 121.949],
        [1946, 111.378, 36.815, 94.165, -20.535, 1.0, 185.0, 1, 185.0, 37.756],
        [1950, 148.8165, 39.581, 101.24, -22.078, 1.0, 198.9, 1, 198.9, 98.733],
        [1952, 31.5615, 7.7745, 21.063, -5.514, 1.0, 45.2, 1, 45.2, 17.923],
        [1952, 31.0925, 7.7745, 21.063, -5.514, 1.0, 45.2, 1, 45.2, 16.985],
        [1952, 0.0, 0.0, 21.063, -5.514, 1.0, 45.2, 0, 45.2, 6.243],
        [1952, 33.2885, 7.7745, 21.063, -5.514, 1.0, 45.2, 1, 45.2, 21.377],
        [1956, 111.7735, 39.674, 101.478, -22.13, 1.0, 199.37, 1, 199.367, 24.18],
        [1957, 139.0445, 39.674, 101.478, -22.13, 1.0, 199.37, 1, 199.367, 78.722],
        [1958, 110.6735, 39.674, 101.478, -22.13, 1.0, 199.37, 1, 199.367, 21.98],
        [1962, 116.245, 41.1065, 105.142, -22.929, 1.0, 206.57, 1, 206.567, 25.923],
        [1963, 145.303, 41.1065, 105.142, -22.929, 1.0, 206.57, 1, 206.567, 84.039],
        [1964, 146.3115, 41.1065, 105.142, -22.929, 1.0, 206.57, 1, 206.567, 86.056],
        [1968, 71.853, 24.5765, 62.862, -13.709, 1.0, 123.5, 1, 123.5, 20.206],
        [1969, 0.0, 0.0, 62.862, -13.709, 1.0, 123.5, 0, 123.5, 28.1],
        [1973, 0.0, 0.0, 116.826, -30.585, 1.0, 250.7, 0, 250.7, 110.634],
        [1976, 324.667, 112.176, 286.923, -62.571, 1.0, 563.7, 1, 563.7, 85.634],
        [1979, 86.1155, 22.885, 58.535, -12.765, 1.0, 115.0, 1, 115.0, 57.231],
        [1980, 0.0, 0.0, 58.535, -12.765, 1.0, 115.0, 0, 115.0, 42.224],
        [1981, 84.1415, 22.885, 58.535, -12.765, 1.0, 115.0, 1, 115.0, 53.283],
        [1983, 48.27, 14.5365, 37.182, -8.109, 1.0, 73.05, 1, 73.05, 23.49],
        [1983, 40.9185, 14.5365, 37.182, -8.109, 1.0, 73.05, 1, 73.05, 8.787],
        [1987, 0.0, 0.0, 316.414, -82.838, 1.0, 679.0, 0, 679.0, 333.531],
        [1988, 0.0, 0.0, 316.414, -82.838, 1.0, 679.0, 0, 679.0, 336.397],
        [1992, 0.0, 0.0, 201.717, -43.989, 1.0, 396.3, 0, 396.3, 174.289],
        [1993, 280.214, 78.864, 201.717, -43.989, 1.0, 396.3, 1, 396.3, 164.128],
        [1994, 0.0, 0.0, 201.717, -43.989, 1.0, 396.3, 0, 396.3, 138.575],
        [1995, 0.0, 0.0, 201.717, -43.989, 1.0, 396.3, 0, 396.3, 73.366],
        [1996, 287.4955, 78.864, 201.717, -43.989, 1.0, 396.3, 1, 396.3, 178.691],
        [1997, 0.0, 0.0, 201.717, -43.989, 1.0, 396.3, 0, 396.3, 76.742],
        [1999, 0.0, 0.0, 38.175, -8.325, 1.0, 75.0, 0, 75.0, 9.36]    ])

    ## branch data
    # fbus tbus r x b rateA rateB rateC ratio angle status
    ppc["branch"] = array([
        [1, 3, 0.00023182, 0.00102493, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1, 28, 0.00413857, 0.0270728, 0.00746341, 219.62, 219.62, 219.62, 0.0, 0.0, 1, -30.0, 30.0],
        [1, 174, 0.00529188, 0.0209981, 0.0166533, 241.75, 241.75, 241.75, 0.0, 0.0, 1, -30.0, 30.0],
        [1, 174, 0.00529188, 0.0209981, 0.0166533, 241.75, 241.75, 241.75, 0.0, 0.0, 1, -30.0, 30.0],
        [1, 247, 0.00712647, 0.0357571, 0.00985329, 265.68, 265.68, 265.68, 0.0, 0.0, 1, -30.0, 30.0],
        [1, 248, 0.00369663, 0.021138, 0.0100986, 243.83, 243.83, 243.83, 0.0, 0.0, 1, -30.0, 30.0],
        [2, 23, 0.0104592, 0.0332497, 0.00196885, 79.04, 79.04, 79.04, 0.0, 0.0, 1, -30.0, 30.0],
        [2, 23, 0.0104592, 0.0332497, 0.00196885, 79.04, 79.04, 79.04, 0.0, 0.0, 1, -30.0, 30.0],
        [2, 23, 0.0104592, 0.0332497, 0.00196885, 79.04, 79.04, 79.04, 0.0, 0.0, 0, -30.0, 30.0],
        [4, 128, 0.0132902, 0.0268195, 0.00578327, 64.44, 64.44, 64.44, 0.0, 0.0, 1, -30.0, 30.0],
        [4, 164, 0.0219322, 0.0591199, 0.0121884, 52.0, 52.0, 52.0, 0.0, 0.0, 1, -30.0, 30.0],
        [5, 4, 0.0108814, 0.0309317, 0.0010461, 80.95, 80.95, 80.95, 0.0, 0.0, 1, -30.0, 30.0],
        [5, 10, 0.00934009, 0.0255526, 0.00609131, 108.59, 108.59, 108.59, 0.0, 0.0, 1, -30.0, 30.0],
        [6, 13, 0.0134592, 0.0297145, 0.0015211, 65.19, 65.19, 65.19, 0.0, 0.0, 1, -30.0, 30.0],
        [6, 13, 0.0134592, 0.0297145, 0.0015211, 65.19, 65.19, 65.19, 0.0, 0.0, 1, -30.0, 30.0],
        [6, 43, 0.0177663, 0.0495402, 0.00459009, 81.61, 81.61, 81.61, 0.0, 0.0, 1, -30.0, 30.0],
        [6, 43, 0.0177663, 0.0495402, 0.00459009, 81.61, 81.61, 81.61, 0.0, 0.0, 1, -30.0, 30.0],
        [6, 43, 0.0177663, 0.0495402, 0.00459009, 81.61, 81.61, 81.61, 0.0, 0.0, 1, -30.0, 30.0],
        [7, 86, 0.00434889, 0.0146316, 0.0344193, 256.34, 256.34, 256.34, 0.0, 0.0, 1, -30.0, 30.0],
        [7, 86, 0.00434889, 0.0146316, 0.0344193, 256.34, 256.34, 256.34, 0.0, 0.0, 1, -30.0, 30.0],
        [7, 86, 0.00434889, 0.0146316, 0.0344193, 256.34, 256.34, 256.34, 0.0, 0.0, 1, -30.0, 30.0],
        [8, 214, 0.0177395, 0.0479832, 0.00111804, 105.16, 105.16, 105.16, 0.0, 0.0, 1, -30.0, 30.0],
        [9, 7, 0.00214021, 0.0150334, 0.0121318, 319.17, 319.17, 319.17, 0.0, 0.0, 1, -30.0, 30.0],
        [9, 11, 0.000211449, 0.00119004, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [9, 208, 0.00444784, 0.0271527, 0.0302679, 318.16, 318.16, 318.16, 0.0, 0.0, 0, -30.0, 30.0],
        [10, 6, 0.0170262, 0.0421583, 0.00119287, 86.29, 86.29, 86.29, 0.0, 0.0, 1, -30.0, 30.0],
        [12, 14, 0.000238768, 0.00116074, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [13, 8, 0.0165507, 0.0426667, 0.00366785, 133.11, 133.11, 133.11, 0.0, 0.0, 1, -30.0, 30.0],
        [13, 17, 0.0320514, 0.0754904, 0.00235805, 82.53, 82.53, 82.53, 0.0, 0.0, 1, -30.0, 30.0],
        [13, 187, 0.0069238, 0.0171061, 0.00801142, 79.4, 79.4, 79.4, 0.0, 0.0, 1, -30.0, 30.0],
        [14, 9, 0.00364564, 0.0218068, 0.0060302, 172.04, 172.04, 172.04, 0.0, 0.0, 1, -30.0, 30.0],
        [15, 151, 0.00171507, 0.0115251, 0.0086048, 286.2, 286.2, 286.2, 0.0, 0.0, 1, -30.0, 30.0],
        [15, 211, 0.00192474, 0.0105067, 0.00425216, 280.32, 280.32, 280.32, 0.0, 0.0, 1, -30.0, 30.0],
        [15, 232, 0.0046, 0.029799, 0.0212613, 280.54, 280.54, 280.54, 0.0, 0.0, 1, -30.0, 30.0],
        [15, 232, 0.0046, 0.029799, 0.0212613, 321.13, 321.13, 321.13, 0.0, 0.0, 1, -30.0, 30.0],
        [16, 21, 0.011558, 0.0357297, 0.00234347, 105.45, 105.45, 105.45, 0.0, 0.0, 1, -30.0, 30.0],
        [16, 35, 0.00813416, 0.0195601, 0.00218755, 92.42, 92.42, 92.42, 0.0, 0.0, 1, -30.0, 30.0],
        [16, 37, 0.0129734, 0.0401236, 0.000641011, 73.63, 73.63, 73.63, 0.0, 0.0, 1, -30.0, 30.0],
        [17, 43, 0.0167472, 0.042412, 0.00168994, 99.4, 99.4, 99.4, 0.0, 0.0, 1, -30.0, 30.0],
        [18, 19, 0.000249168, 0.00107953, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [18, 187, 0.018127, 0.0528191, 0.00213896, 73.01, 73.01, 73.01, 0.0, 0.0, 1, -30.0, 30.0],
        [18, 187, 0.018127, 0.0528191, 0.00213896, 82.62, 82.62, 82.62, 0.0, 0.0, 1, -30.0, 30.0],
        [20, 22, 0.000219564, 0.00118149, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [21, 38, 0.0228097, 0.052298, 0.00200842, 68.0, 68.0, 68.0, 0.0, 0.0, 1, -30.0, 30.0],
        [21, 38, 0.0228097, 0.052298, 0.00200842, 68.0, 68.0, 68.0, 0.0, 0.0, 1, -30.0, 30.0],
        [22, 34, 0.00459707, 0.0237513, 0.0317594, 215.75, 215.75, 215.75, 0.0, 0.0, 1, -30.0, 30.0],
        [22, 86, 0.0024419, 0.0144345, 0.00822082, 267.98, 267.98, 267.98, 0.0, 0.0, 1, -30.0, 30.0],
        [22, 215, 0.00318566, 0.01486, 0.0134473, 258.04, 258.04, 258.04, 0.0, 0.0, 1, -30.0, 30.0],
        [22, 215, 0.00318566, 0.01486, 0.0134473, 258.04, 258.04, 258.04, 0.0, 0.0, 1, -30.0, 30.0],
        [22, 215, 0.00318566, 0.01486, 0.0134473, 258.04, 258.04, 258.04, 0.0, 0.0, 1, -30.0, 30.0],
        [22, 548, 0.00620426, 0.0329366, 0.0176561, 258.61, 258.61, 258.61, 0.0, 0.0, 1, -30.0, 30.0],
        [22, 548, 0.00620426, 0.0329366, 0.0176561, 258.61, 258.61, 258.61, 0.0, 0.0, 1, -30.0, 30.0],
        [22, 548, 0.00620426, 0.0329366, 0.0176561, 258.61, 258.61, 258.61, 0.0, 0.0, 1, -30.0, 30.0],
        [23, 177, 0.0167668, 0.0454559, 0.00130041, 75.07, 75.07, 75.07, 0.0, 0.0, 1, -30.0, 30.0],
        [24, 16, 0.0118471, 0.0318563, 0.00208615, 99.33, 99.33, 99.33, 0.0, 0.0, 1, -30.0, 30.0],
        [24, 25, 0.000264528, 0.00110156, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [24, 41, 0.015854, 0.041633, 0.00114618, 67.07, 67.07, 67.07, 0.0, 0.0, 1, -30.0, 30.0],
        [24, 41, 0.015854, 0.041633, 0.00114618, 67.07, 67.07, 67.07, 0.0, 0.0, 1, -30.0, 30.0],
        [26, 28, 0.000288654, 0.00112215, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [27, 23, 0.0127749, 0.0299585, 0.00159547, 59.21, 59.21, 59.21, 0.0, 0.0, 1, -30.0, 30.0],
        [27, 177, 0.0148095, 0.0384174, 0.00194579, 76.41, 76.41, 76.41, 0.0, 0.0, 1, -30.0, 30.0],
        [27, 219, 0.0146725, 0.0356523, 0.000881023, 55.36, 55.36, 55.36, 0.0, 0.0, 1, -30.0, 30.0],
        [28, 165, 0.00356549, 0.0232361, 0.00589297, 350.0, 350.0, 350.0, 0.0, 0.0, 1, -30.0, 30.0],
        [28, 174, 0.00146485, 0.0101278, 0.00457715, 241.31, 241.31, 241.31, 0.0, 0.0, 1, -30.0, 30.0],
        [28, 555, 0.00683845, 0.0343749, 0.0208829, 322.49, 322.49, 322.49, 0.0, 0.0, 0, -30.0, 30.0],
        [29, 252, 0.0190813, 0.056663, 0.00108459, 60.63, 60.63, 60.63, 0.0, 0.0, 1, -30.0, 30.0],
        [29, 267, 0.0244295, 0.0641456, 0.00258533, 81.86, 81.86, 81.86, 0.0, 0.0, 1, -30.0, 30.0],
        [29, 557, 0.00231061, 0.00635728, 0.000323514, 96.22, 96.22, 96.22, 0.0, 0.0, 1, -30.0, 30.0],
        [29, 557, 0.00231061, 0.00635728, 0.000323514, 109.17, 109.17, 109.17, 0.0, 0.0, 1, -30.0, 30.0],
        [30, 31, 0.0017784, 0.0116988, 0.00650237, 191.0, 191.0, 191.0, 0.0, 0.0, 1, -30.0, 30.0],
        [31, 33, 0.000274453, 0.00119906, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [31, 42, 0.00623491, 0.0279952, 0.00721758, 229.38, 229.38, 229.38, 0.0, 0.0, 1, -30.0, 30.0],
        [32, 17, 0.0264094, 0.065065, 0.0020865, 68.42, 68.42, 68.42, 0.0, 0.0, 1, -30.0, 30.0],
        [32, 17, 0.0264094, 0.065065, 0.0020865, 68.42, 68.42, 68.42, 0.0, 0.0, 1, -30.0, 30.0],
        [32, 283, 0.0142241, 0.0432463, 0.00220303, 67.66, 67.66, 67.66, 0.0, 0.0, 1, -30.0, 30.0],
        [32, 283, 0.0142241, 0.0432463, 0.00220303, 67.66, 67.66, 67.66, 0.0, 0.0, 1, -30.0, 30.0],
        [34, 31, 0.003786, 0.0214023, 0.00785309, 232.2, 232.2, 232.2, 0.0, 0.0, 1, -30.0, 30.0],
        [34, 31, 0.003786, 0.0214023, 0.00785309, 232.2, 232.2, 232.2, 0.0, 0.0, 1, -30.0, 30.0],
        [34, 39, 0.00416941, 0.0265708, 0.00900656, 241.19, 241.19, 241.19, 0.0, 0.0, 1, -30.0, 30.0],
        [34, 39, 0.00416941, 0.0265708, 0.00900656, 241.19, 241.19, 241.19, 0.0, 0.0, 1, -30.0, 30.0],
        [34, 564, 0.00581665, 0.0316411, 0.00756963, 215.42, 215.42, 215.42, 0.0, 0.0, 1, -30.0, 30.0],
        [35, 238, 0.0300367, 0.0904545, 0.00848998, 62.8, 62.8, 62.8, 0.0, 0.0, 1, -30.0, 30.0],
        [35, 557, 0.0312946, 0.0706114, 0.00282773, 76.09, 76.09, 76.09, 0.0, 0.0, 1, -30.0, 30.0],
        [35, 557, 0.0312946, 0.0706114, 0.00282773, 76.09, 76.09, 76.09, 0.0, 0.0, 1, -30.0, 30.0],
        [35, 557, 0.0312946, 0.0706114, 0.00282773, 76.09, 76.09, 76.09, 0.0, 0.0, 1, -30.0, 30.0],
        [36, 35, 0.0265135, 0.047453, 0.00141328, 68.8, 68.8, 68.8, 0.0, 0.0, 1, -30.0, 30.0],
        [36, 35, 0.0265135, 0.047453, 0.00141328, 68.8, 68.8, 68.8, 0.0, 0.0, 1, -30.0, 30.0],
        [36, 245, 0.0293616, 0.0673862, 0.0011626, 49.63, 49.63, 49.63, 0.0, 0.0, 1, -30.0, 30.0],
        [36, 249, 0.00801014, 0.0261499, 0.00092202, 75.41, 75.41, 75.41, 0.0, 0.0, 1, -30.0, 30.0],
        [36, 249, 0.00801014, 0.0261499, 0.00092202, 75.41, 75.41, 75.41, 0.0, 0.0, 1, -30.0, 30.0],
        [36, 249, 0.00801014, 0.0261499, 0.00092202, 75.41, 75.41, 75.41, 0.0, 0.0, 1, -30.0, 30.0],
        [36, 557, 0.0164183, 0.0420729, 0.0024045, 101.25, 101.25, 101.25, 0.0, 0.0, 1, -30.0, 30.0],
        [37, 21, 0.0161314, 0.0299526, 0.00131014, 73.06, 73.06, 73.06, 0.0, 0.0, 1, -30.0, 30.0],
        [37, 35, 0.0126768, 0.0268139, 0.00271526, 77.95, 77.95, 77.95, 0.0, 0.0, 1, -30.0, 30.0],
        [37, 35, 0.0126768, 0.0268139, 0.00271526, 77.95, 77.95, 77.95, 0.0, 0.0, 1, -30.0, 30.0],
        [37, 35, 0.0126768, 0.0268139, 0.00271526, 77.95, 77.95, 77.95, 0.0, 0.0, 1, -30.0, 30.0],
        [37, 38, 0.0187055, 0.0608938, 0.00196692, 68.2, 68.2, 68.2, 0.0, 0.0, 1, -30.0, 30.0],
        [37, 38, 0.0187055, 0.0608938, 0.00196692, 68.2, 68.2, 68.2, 0.0, 0.0, 1, -30.0, 30.0],
        [37, 87, 0.0221178, 0.0564016, 0.00139673, 86.12, 86.12, 86.12, 0.0, 0.0, 1, -30.0, 30.0],
        [38, 173, 0.0177711, 0.0570116, 0.00116236, 92.96, 92.96, 92.96, 0.0, 0.0, 1, -30.0, 30.0],
        [40, 263, 0.0271487, 0.0714019, 0.00446768, 55.15, 55.15, 55.15, 0.0, 0.0, 1, -30.0, 30.0],
        [40, 276, 0.0226872, 0.0486309, 0.000835191, 72.1, 72.1, 72.1, 0.0, 0.0, 1, -30.0, 30.0],
        [40, 276, 0.0226872, 0.0486309, 0.000835191, 72.1, 72.1, 72.1, 0.0, 0.0, 1, -30.0, 30.0],
        [42, 14, 0.00495081, 0.0249773, 0.0106939, 198.72, 198.72, 198.72, 0.0, 0.0, 1, -30.0, 30.0],
        [42, 44, 0.000209978, 0.00108899, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [43, 46, 0.0241647, 0.0448606, 0.00129086, 89.95, 89.95, 89.95, 0.0, 0.0, 1, -30.0, 30.0],
        [45, 46, 0.0251788, 0.0603475, 0.00162961, 107.1, 107.1, 107.1, 0.0, 0.0, 1, -30.0, 30.0],
        [45, 275, 0.0163836, 0.035907, 0.00183584, 66.64, 66.64, 66.64, 0.0, 0.0, 1, -30.0, 30.0],
        [46, 209, 0.0238416, 0.0619123, 0.0025303, 76.82, 76.82, 76.82, 0.0, 0.0, 1, -30.0, 30.0],
        [47, 50, 0.000237887, 0.00109477, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [47, 524, 0.000539494, 0.00584139, 0.118909, 1062.02, 1062.02, 1062.02, 0.0, 0.0, 1, -30.0, 30.0],
        [48, 73, 0.0147435, 0.0749894, 0.0160216, 226.94, 226.94, 226.94, 0.0, 0.0, 1, -30.0, 30.0],
        [48, 534, 0.00216759, 0.0137543, 0.0523514, 269.8, 269.8, 269.8, 0.0, 0.0, 1, -30.0, 30.0],
        [48, 534, 0.00216759, 0.0137543, 0.0523514, 269.8, 269.8, 269.8, 0.0, 0.0, 1, -30.0, 30.0],
        [48, 534, 0.00216759, 0.0137543, 0.0523514, 269.8, 269.8, 269.8, 0.0, 0.0, 1, -30.0, 30.0],
        [49, 60, 0.0218319, 0.051633, 0.00357013, 71.51, 71.51, 71.51, 0.0, 0.0, 1, -30.0, 30.0],
        [51, 61, 0.0394089, 0.115713, 0.0202389, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [51, 200, 0.0312098, 0.0713229, 0.00237936, 112.35, 112.35, 112.35, 0.0, 0.0, 1, -30.0, 30.0],
        [52, 54, 0.000204513, 0.00101533, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [52, 159, 0.000268521, 0.00355215, 0.0808721, 1160.4, 1160.4, 1160.4, 0.0, 0.0, 1, -30.0, 30.0],
        [53, 158, 0.00438862, 0.024717, 0.00913984, 247.5, 247.5, 247.5, 0.0, 0.0, 1, -30.0, 30.0],
        [53, 193, 0.00421062, 0.0273134, 0.0266542, 259.13, 259.13, 259.13, 0.0, 0.0, 1, -30.0, 30.0],
        [53, 193, 0.00421062, 0.0273134, 0.0266542, 259.13, 259.13, 259.13, 0.0, 0.0, 1, -30.0, 30.0],
        [53, 193, 0.00421062, 0.0273134, 0.0266542, 259.13, 259.13, 259.13, 0.0, 0.0, 1, -30.0, 30.0],
        [53, 521, 0.00640328, 0.0509321, 0.00899089, 295.34, 295.34, 295.34, 0.0, 0.0, 1, -30.0, 30.0],
        [53, 521, 0.00640328, 0.0509321, 0.00899089, 295.34, 295.34, 295.34, 0.0, 0.0, 1, -30.0, 30.0],
        [55, 48, 0.0054273, 0.0328757, 0.0133538, 200.97, 200.97, 200.97, 0.0, 0.0, 1, -30.0, 30.0],
        [55, 53, 0.00501826, 0.0245394, 0.0149817, 287.21, 287.21, 287.21, 0.0, 0.0, 1, -30.0, 30.0],
        [55, 53, 0.00501826, 0.0245394, 0.0149817, 287.21, 287.21, 287.21, 0.0, 0.0, 1, -30.0, 30.0],
        [55, 53, 0.00501826, 0.0245394, 0.0149817, 287.21, 287.21, 287.21, 0.0, 0.0, 1, -30.0, 30.0],
        [55, 57, 0.000297933, 0.00100615, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [55, 521, 0.0060725, 0.0302758, 0.0132185, 226.91, 226.91, 226.91, 0.0, 0.0, 1, -30.0, 30.0],
        [55, 534, 0.00415165, 0.0209214, 0.0199132, 278.07, 278.07, 278.07, 0.0, 0.0, 1, -30.0, 30.0],
        [55, 534, 0.00415165, 0.0209214, 0.0199132, 278.07, 278.07, 278.07, 0.0, 0.0, 1, -30.0, 30.0],
        [55, 534, 0.00415165, 0.0209214, 0.0199132, 278.07, 278.07, 278.07, 0.0, 0.0, 1, -30.0, 30.0],
        [55, 538, 0.0124503, 0.0306121, 0.0100872, 241.11, 241.11, 241.11, 0.0, 0.0, 1, -30.0, 30.0],
        [55, 538, 0.0124503, 0.0306121, 0.0100872, 241.11, 241.11, 241.11, 0.0, 0.0, 1, -30.0, 30.0],
        [58, 56, 0.0232941, 0.04945, 0.00381086, 81.24, 81.24, 81.24, 0.0, 0.0, 1, -30.0, 30.0],
        [58, 56, 0.0232941, 0.04945, 0.00381086, 81.24, 81.24, 81.24, 0.0, 0.0, 1, -30.0, 30.0],
        [58, 56, 0.0232941, 0.04945, 0.00381086, 81.24, 81.24, 81.24, 0.0, 0.0, 1, -30.0, 30.0],
        [59, 528, 0.0218772, 0.0556881, 0.00172262, 73.29, 73.29, 73.29, 0.0, 0.0, 1, -30.0, 30.0],
        [59, 528, 0.0218772, 0.0556881, 0.00172262, 80.37, 80.37, 80.37, 0.0, 0.0, 1, -30.0, 30.0],
        [60, 59, 0.0260598, 0.0575497, 0.00437377, 65.99, 65.99, 65.99, 0.0, 0.0, 1, -30.0, 30.0],
        [60, 59, 0.0260598, 0.0575497, 0.00437377, 65.99, 65.99, 65.99, 0.0, 0.0, 1, -30.0, 30.0],
        [60, 66, 0.0716723, 0.182181, 0.0051759, 70.21, 70.21, 70.21, 0.0, 0.0, 1, -30.0, 30.0],
        [63, 65, 0.000239799, 0.0010442, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [63, 73, 0.00899317, 0.0441317, 0.021161, 204.65, 204.65, 204.65, 0.0, 0.0, 1, -30.0, 30.0],
        [64, 61, 0.0247274, 0.0504625, 0.00389364, 69.75, 69.75, 69.75, 0.0, 0.0, 1, -30.0, 30.0],
        [64, 62, 0.0185909, 0.0516831, 0.00336356, 49.99, 49.99, 49.99, 0.0, 0.0, 1, -30.0, 30.0],
        [66, 70, 0.0775854, 0.186854, 0.00374987, 55.84, 55.84, 55.84, 0.0, 0.0, 1, -30.0, 30.0],
        [67, 69, 0.000247637, 0.00109325, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [67, 71, 0.01, 0.07, 0.0, 220.0, 220.0, 220.0, 0.0, 0.0, 1, -30.0, 30.0],
        [67, 84, 0.0174435, 0.0973726, 0.062295, 193.76, 193.76, 193.76, 0.0, 0.0, 1, -30.0, 30.0],
        [68, 114, 0.0576338, 0.0976108, 0.00478169, 50.8, 50.8, 50.8, 0.0, 0.0, 1, -30.0, 30.0],
        [68, 540, 0.140015, 0.345219, 0.0176072, 49.46, 49.46, 49.46, 0.0, 0.0, 1, -30.0, 30.0],
        [70, 68, 0.295903, 0.4766, 0.0102401, 66.17, 66.17, 66.17, 0.0, 0.0, 1, -30.0, 30.0],
        [70, 68, 0.295903, 0.4766, 0.0102401, 66.17, 66.17, 66.17, 0.0, 0.0, 1, -30.0, 30.0],
        [71, 73, 0.000258197, 0.00116176, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [72, 62, 0.0615458, 0.136756, 0.00335725, 68.81, 68.81, 68.81, 0.0, 0.0, 1, -30.0, 30.0],
        [72, 70, 0.0432172, 0.104951, 0.00449017, 65.12, 65.12, 65.12, 0.0, 0.0, 1, -30.0, 30.0],
        [74, 75, 0.0157799, 0.0362398, 0.00373355, 44.56, 44.56, 44.56, 0.0, 0.0, 1, -30.0, 30.0],
        [75, 77, 0.0160396, 0.051732, 0.00218375, 47.39, 47.39, 47.39, 0.0, 0.0, 1, -30.0, 30.0],
        [76, 78, 0.000244189, 0.00106703, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [77, 80, 0.106385, 0.288295, 0.0321868, 43.17, 43.17, 43.17, 0.0, 0.0, 1, -30.0, 30.0],
        [79, 81, 0.000291143, 0.00109582, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [79, 583, 0.0107739, 0.0577945, 0.0467452, 203.21, 203.21, 203.21, 0.0, 0.0, 1, -30.0, 30.0],
        [80, 582, 0.136555, 0.418502, 0.00591819, 52.91, 52.91, 52.91, 0.0, 0.0, 1, -30.0, 30.0],
        [82, 80, 0.0670566, 0.179301, 0.00424244, 51.02, 51.02, 51.02, 0.0, 0.0, 1, -30.0, 30.0],
        [83, 85, 0.000215668, 0.00115619, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [84, 79, 0.0174229, 0.104359, 0.0364631, 178.64, 178.64, 178.64, 0.0, 0.0, 1, -30.0, 30.0],
        [84, 83, 7.7e-05, 0.005637, 0.0, 249.81, 249.81, 249.81, 0.0, 0.0, 1, -30.0, 30.0],
        [86, 30, 0.00215456, 0.0116695, 0.0201028, 223.69, 223.69, 223.69, 0.0, 0.0, 1, -30.0, 30.0],
        [86, 88, 0.000272636, 0.0010805, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [86, 548, 0.00655185, 0.0267685, 0.00992387, 261.71, 261.71, 261.71, 0.0, 0.0, 1, -30.0, 30.0],
        [86, 548, 0.00655185, 0.0267685, 0.00992387, 261.71, 261.71, 261.71, 0.0, 0.0, 1, -30.0, 30.0],
        [87, 16, 0.00903103, 0.0200972, 0.000811898, 75.33, 75.33, 75.33, 0.0, 0.0, 1, -30.0, 30.0],
        [87, 16, 0.00903103, 0.0200972, 0.000811898, 75.33, 75.33, 75.33, 0.0, 0.0, 1, -30.0, 30.0],
        [87, 16, 0.00903103, 0.0200972, 0.000811898, 75.33, 75.33, 75.33, 0.0, 0.0, 1, -30.0, 30.0],
        [87, 245, 0.0215529, 0.0452311, 0.00579575, 57.45, 57.45, 57.45, 0.0, 0.0, 1, -30.0, 30.0],
        [89, 91, 0.000262292, 0.00112916, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [89, 106, 0.0049332, 0.027038, 0.0145293, 339.82, 339.82, 339.82, 0.0, 0.0, 1, -30.0, 30.0],
        [89, 106, 0.0049332, 0.027038, 0.0145293, 339.82, 339.82, 339.82, 0.0, 0.0, 1, -30.0, 30.0],
        [89, 106, 0.0049332, 0.027038, 0.0145293, 339.82, 339.82, 339.82, 0.0, 0.0, 1, -30.0, 30.0],
        [89, 256, 0.00321876, 0.0194069, 0.0071382, 400.54, 400.54, 400.54, 0.0, 0.0, 1, -30.0, 30.0],
        [89, 382, 0.00247514, 0.0157938, 0.0257527, 340.14, 340.14, 340.14, 0.0, 0.0, 1, -30.0, 30.0],
        [90, 101, 0.0135841, 0.0402193, 0.000924601, 61.72, 61.72, 61.72, 0.0, 0.0, 1, -30.0, 30.0],
        [90, 241, 0.0103536, 0.0265833, 0.00234702, 66.61, 66.61, 66.61, 0.0, 0.0, 1, -30.0, 30.0],
        [90, 241, 0.0103536, 0.0265833, 0.00234702, 66.61, 66.61, 66.61, 0.0, 0.0, 1, -30.0, 30.0],
        [90, 255, 0.0163281, 0.0386576, 0.00633577, 79.03, 79.03, 79.03, 0.0, 0.0, 1, -30.0, 30.0],
        [90, 255, 0.0163281, 0.0386576, 0.00633577, 79.03, 79.03, 79.03, 0.0, 0.0, 1, -30.0, 30.0],
        [90, 255, 0.0163281, 0.0386576, 0.00633577, 79.03, 79.03, 79.03, 0.0, 0.0, 1, -30.0, 30.0],
        [92, 98, 0.00878045, 0.0230698, 0.00110421, 100.76, 100.76, 100.76, 0.0, 0.0, 1, -30.0, 30.0],
        [92, 330, 0.00678989, 0.0170465, 0.00477099, 74.17, 74.17, 74.17, 0.0, 0.0, 1, -30.0, 30.0],
        [94, 262, 0.0142721, 0.029344, 0.0017331, 79.5, 79.5, 79.5, 0.0, 0.0, 1, -30.0, 30.0],
        [94, 262, 0.0142721, 0.029344, 0.0017331, 79.5, 79.5, 79.5, 0.0, 0.0, 1, -30.0, 30.0],
        [94, 262, 0.0142721, 0.029344, 0.0017331, 79.5, 79.5, 79.5, 0.0, 0.0, 1, -30.0, 30.0],
        [95, 107, 0.0232242, 0.0598063, 0.000771374, 83.77, 83.77, 83.77, 0.0, 0.0, 1, -30.0, 30.0],
        [95, 323, 0.0212776, 0.0554299, 0.00227383, 69.02, 69.02, 69.02, 0.0, 0.0, 1, -30.0, 30.0],
        [96, 105, 0.000408666, 0.00511537, 0.138302, 1367.07, 1367.07, 1367.07, 0.0, 0.0, 1, -30.0, 30.0],
        [96, 337, 0.0011469, 0.0134575, 0.247207, 1220.57, 1220.57, 1220.57, 0.0, 0.0, 1, -30.0, 30.0],
        [97, 99, 0.000240917, 0.00106504, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [98, 104, 0.0153055, 0.0407224, 0.00263142, 84.93, 84.93, 84.93, 0.0, 0.0, 1, -30.0, 30.0],
        [98, 104, 0.0153055, 0.0407224, 0.00263142, 84.93, 84.93, 84.93, 0.0, 0.0, 1, -30.0, 30.0],
        [98, 104, 0.0153055, 0.0407224, 0.00263142, 84.93, 84.93, 84.93, 0.0, 0.0, 1, -30.0, 30.0],
        [99, 89, 0.00475721, 0.0187764, 0.0123966, 271.72, 271.72, 271.72, 0.0, 0.0, 1, -30.0, 30.0],
        [99, 89, 0.00475721, 0.0187764, 0.0123966, 271.72, 271.72, 271.72, 0.0, 0.0, 1, -30.0, 30.0],
        [99, 89, 0.00475721, 0.0187764, 0.0123966, 271.72, 271.72, 271.72, 0.0, 0.0, 1, -30.0, 30.0],
        [100, 89, 0.00188894, 0.0111185, 0.00304078, 331.74, 331.74, 331.74, 0.0, 0.0, 1, -30.0, 30.0],
        [100, 89, 0.00188894, 0.0111185, 0.00304078, 331.74, 331.74, 331.74, 0.0, 0.0, 1, -30.0, 30.0],
        [100, 102, 0.000297511, 0.00100671, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [100, 266, 0.00206771, 0.00896756, 0.00757472, 233.74, 233.74, 233.74, 0.0, 0.0, 1, -30.0, 30.0],
        [100, 272, 0.00340005, 0.0151321, 0.0123492, 336.33, 336.33, 336.33, 0.0, 0.0, 1, -30.0, 30.0],
        [101, 239, 0.00735116, 0.0202893, 0.00118867, 79.32, 79.32, 79.32, 0.0, 0.0, 1, -30.0, 30.0],
        [101, 239, 0.00735116, 0.0202893, 0.00118867, 79.32, 79.32, 79.32, 0.0, 0.0, 1, -30.0, 30.0],
        [101, 255, 0.0198734, 0.0446362, 0.00807479, 55.3, 55.3, 55.3, 0.0, 0.0, 1, -30.0, 30.0],
        [103, 98, 0.0121132, 0.0280759, 0.00194239, 90.47, 90.47, 90.47, 0.0, 0.0, 1, -30.0, 30.0],
        [103, 98, 0.0121132, 0.0280759, 0.00194239, 90.47, 90.47, 90.47, 0.0, 0.0, 1, -30.0, 30.0],
        [103, 104, 0.0211389, 0.0515966, 0.00134639, 83.96, 83.96, 83.96, 0.0, 0.0, 1, -30.0, 30.0],
        [103, 116, 0.0161076, 0.0460532, 0.00164375, 64.26, 64.26, 64.26, 0.0, 0.0, 1, -30.0, 30.0],
        [103, 383, 0.0219526, 0.0620973, 0.00211351, 62.49, 62.49, 62.49, 0.0, 0.0, 1, -30.0, 30.0],
        [104, 90, 0.0139255, 0.0364425, 0.00135108, 60.39, 60.39, 60.39, 0.0, 0.0, 1, -30.0, 30.0],
        [105, 108, 0.000217559, 0.00104663, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [105, 257, 0.000403776, 0.00504771, 0.194269, 1393.7, 1393.7, 1393.7, 0.0, 0.0, 1, -30.0, 30.0],
        [105, 257, 0.000403776, 0.00504771, 0.194269, 1642.77, 1642.77, 1642.77, 0.0, 0.0, 1, -30.0, 30.0],
        [105, 278, 0.000904309, 0.00982195, 0.178443, 1661.48, 1661.48, 1661.48, 0.0, 0.0, 1, -30.0, 30.0],
        [105, 312, 0.00106025, 0.0128823, 0.40761, 1601.13, 1601.13, 1601.13, 0.0, 0.0, 1, -30.0, 30.0],
        [105, 337, 0.000996085, 0.0111383, 0.212829, 1190.94, 1190.94, 1190.94, 0.0, 0.0, 1, -30.0, 30.0],
        [107, 323, 0.00746138, 0.0230318, 0.00426172, 89.19, 89.19, 89.19, 0.0, 0.0, 1, -30.0, 30.0],
        [107, 323, 0.00746138, 0.0230318, 0.00426172, 89.19, 89.19, 89.19, 0.0, 0.0, 1, -30.0, 30.0],
        [109, 271, 0.0311446, 0.0715399, 0.00229317, 72.24, 72.24, 72.24, 0.0, 0.0, 1, -30.0, 30.0],
        [110, 100, 0.000992258, 0.00600635, 0.00862559, 207.96, 207.96, 207.96, 0.0, 0.0, 1, -30.0, 30.0],
        [110, 112, 0.000219746, 0.00112367, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [110, 258, 0.00448319, 0.0235773, 0.00744099, 267.67, 267.67, 267.67, 0.0, 0.0, 1, -30.0, 30.0],
        [110, 258, 0.00448319, 0.0235773, 0.00744099, 267.67, 267.67, 267.67, 0.0, 0.0, 1, -30.0, 30.0],
        [110, 266, 0.00306132, 0.0172473, 0.00395665, 193.06, 193.06, 193.06, 0.0, 0.0, 1, -30.0, 30.0],
        [111, 95, 0.0233638, 0.0602519, 0.00164413, 51.19, 51.19, 51.19, 0.0, 0.0, 1, -30.0, 30.0],
        [113, 246, 0.0208441, 0.0526995, 0.00140041, 59.03, 59.03, 59.03, 0.0, 0.0, 1, -30.0, 30.0],
        [113, 263, 0.0237193, 0.0585573, 0.00287452, 73.7, 73.7, 73.7, 0.0, 0.0, 1, -30.0, 30.0],
        [115, 93, 0.0103536, 0.0245352, 0.00242157, 58.52, 58.52, 58.52, 0.0, 0.0, 1, -30.0, 30.0],
        [115, 323, 0.0215259, 0.0572476, 0.00205438, 70.23, 70.23, 70.23, 0.0, 0.0, 1, -30.0, 30.0],
        [115, 323, 0.0215259, 0.0572476, 0.00205438, 85.16, 85.16, 85.16, 0.0, 0.0, 1, -30.0, 30.0],
        [116, 101, 0.0103578, 0.0254021, 0.00366305, 56.92, 56.92, 56.92, 0.0, 0.0, 1, -30.0, 30.0],
        [117, 335, 0.0140214, 0.0392128, 0.00219977, 57.27, 57.27, 57.27, 0.0, 0.0, 1, -30.0, 30.0],
        [117, 351, 0.0167616, 0.0437303, 0.00330131, 53.17, 53.17, 53.17, 0.0, 0.0, 1, -30.0, 30.0],
        [118, 94, 0.0262951, 0.0640164, 0.00178833, 50.28, 50.28, 50.28, 0.0, 0.0, 1, -30.0, 30.0],
        [118, 335, 0.0323626, 0.0736332, 0.00362906, 74.81, 74.81, 74.81, 0.0, 0.0, 1, -30.0, 30.0],
        [119, 150, 0.0107148, 0.0244462, 0.00059213, 120.14, 120.14, 120.14, 0.0, 0.0, 1, -30.0, 30.0],
        [119, 152, 0.0174862, 0.0398716, 0.00528466, 117.87, 117.87, 117.87, 0.0, 0.0, 1, -30.0, 30.0],
        [120, 5, 0.0281416, 0.0623207, 0.00132153, 54.03, 54.03, 54.03, 0.0, 0.0, 1, -30.0, 30.0],
        [120, 136, 0.0194422, 0.0453793, 0.00331294, 56.66, 56.66, 56.66, 0.0, 0.0, 1, -30.0, 30.0],
        [120, 182, 0.00917599, 0.0196278, 0.000579437, 66.42, 66.42, 66.42, 0.0, 0.0, 1, -30.0, 30.0],
        [120, 182, 0.00917599, 0.0196278, 0.000579437, 66.42, 66.42, 66.42, 0.0, 0.0, 1, -30.0, 30.0],
        [121, 123, 0.000231367, 0.0011215, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [122, 129, 0.0158644, 0.0331483, 0.00304268, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [122, 169, 0.0470025, 0.0997468, 0.00439981, 85.27, 85.27, 85.27, 0.0, 0.0, 1, -30.0, 30.0],
        [124, 126, 0.000257772, 0.00100347, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [124, 134, 0.00201515, 0.0120129, 0.00791521, 188.99, 188.99, 188.99, 0.0, 0.0, 1, -30.0, 30.0],
        [124, 181, 0.0086982, 0.0437715, 0.0221044, 225.39, 225.39, 225.39, 0.0, 0.0, 1, -30.0, 30.0],
        [125, 133, 0.0342664, 0.0703215, 0.00192097, 84.04, 84.04, 84.04, 0.0, 0.0, 1, -30.0, 30.0],
        [128, 206, 0.0500026, 0.136891, 0.00662817, 59.75, 59.75, 59.75, 0.0, 0.0, 1, -30.0, 30.0],
        [128, 212, 0.00846591, 0.0226591, 0.00180537, 45.98, 45.98, 45.98, 0.0, 0.0, 1, -30.0, 30.0],
        [129, 130, 0.000250518, 0.00118342, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [129, 145, 0.00693554, 0.0187185, 0.00178033, 71.74, 71.74, 71.74, 0.0, 0.0, 1, -30.0, 30.0],
        [129, 148, 0.0100724, 0.0223945, 0.00074482, 60.15, 60.15, 60.15, 0.0, 0.0, 1, -30.0, 30.0],
        [132, 134, 0.0002517, 0.00105477, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [133, 131, 0.012054, 0.0380042, 0.00123801, 175.0, 175.0, 175.0, 0.0, 0.0, 1, -30.0, 30.0],
        [134, 142, 0.00624869, 0.0291668, 0.0147264, 220.21, 220.21, 220.21, 0.0, 0.0, 1, -30.0, 30.0],
        [135, 137, 0.000258659, 0.00100961, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [135, 142, 0.00148943, 0.00817814, 0.00402973, 268.43, 268.43, 268.43, 0.0, 0.0, 1, -30.0, 30.0],
        [135, 147, 0.00337827, 0.0155843, 0.0104208, 211.74, 211.74, 211.74, 0.0, 0.0, 1, -30.0, 30.0],
        [135, 211, 0.00219446, 0.0136816, 0.0342655, 251.71, 251.71, 251.71, 0.0, 0.0, 1, -30.0, 30.0],
        [135, 211, 0.00219446, 0.0136816, 0.0342655, 251.71, 251.71, 251.71, 0.0, 0.0, 1, -30.0, 30.0],
        [135, 211, 0.00219446, 0.0136816, 0.0342655, 251.71, 251.71, 251.71, 0.0, 0.0, 1, -30.0, 30.0],
        [136, 119, 0.00536476, 0.0127679, 0.000807633, 85.77, 85.77, 85.77, 0.0, 0.0, 1, -30.0, 30.0],
        [136, 119, 0.00536476, 0.0127679, 0.000807633, 85.77, 85.77, 85.77, 0.0, 0.0, 1, -30.0, 30.0],
        [136, 143, 0.0124299, 0.0349686, 0.00146269, 56.64, 56.64, 56.64, 0.0, 0.0, 1, -30.0, 30.0],
        [136, 150, 0.0101332, 0.0266133, 0.0021264, 78.83, 78.83, 78.83, 0.0, 0.0, 1, -30.0, 30.0],
        [136, 150, 0.0101332, 0.0266133, 0.0021264, 78.83, 78.83, 78.83, 0.0, 0.0, 1, -30.0, 30.0],
        [136, 150, 0.0101332, 0.0266133, 0.0021264, 78.83, 78.83, 78.83, 0.0, 0.0, 1, -30.0, 30.0],
        [138, 156, 0.0122921, 0.0343963, 0.000727317, 71.9, 71.9, 71.9, 0.0, 0.0, 1, -30.0, 30.0],
        [138, 156, 0.0122921, 0.0343963, 0.000727317, 76.43, 76.43, 76.43, 0.0, 0.0, 1, -30.0, 30.0],
        [139, 141, 0.000283866, 0.00115379, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [140, 131, 0.0206677, 0.0578969, 0.00246221, 120.03, 120.03, 120.03, 0.0, 0.0, 1, -30.0, 30.0],
        [141, 121, 0.00298751, 0.0169096, 0.010762, 203.61, 203.61, 203.61, 0.0, 0.0, 1, -30.0, 30.0],
        [141, 170, 0.0044403, 0.0252526, 0.00774537, 218.02, 218.02, 218.02, 0.0, 0.0, 1, -30.0, 30.0],
        [142, 121, 0.00462374, 0.0185567, 0.00777404, 217.9, 217.9, 217.9, 0.0, 0.0, 1, -30.0, 30.0],
        [142, 144, 0.00021375, 0.00116679, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [142, 147, 0.00168383, 0.0117549, 0.005166, 239.83, 239.83, 239.83, 0.0, 0.0, 1, -30.0, 30.0],
        [142, 147, 0.00168383, 0.0117549, 0.005166, 239.83, 239.83, 239.83, 0.0, 0.0, 1, -30.0, 30.0],
        [143, 150, 0.0300321, 0.0558917, 0.00175097, 58.3, 58.3, 58.3, 0.0, 0.0, 1, -30.0, 30.0],
        [145, 192, 0.0164822, 0.0402533, 0.00833636, 70.62, 70.62, 70.62, 0.0, 0.0, 1, -30.0, 30.0],
        [145, 192, 0.0164822, 0.0402533, 0.00833636, 70.62, 70.62, 70.62, 0.0, 0.0, 1, -30.0, 30.0],
        [146, 38, 0.0175551, 0.0385382, 0.001254, 70.65, 70.65, 70.65, 0.0, 0.0, 1, -30.0, 30.0],
        [146, 38, 0.0175551, 0.0385382, 0.001254, 70.65, 70.65, 70.65, 0.0, 0.0, 1, -30.0, 30.0],
        [146, 154, 0.0264926, 0.0613898, 0.00150132, 106.32, 106.32, 106.32, 0.0, 0.0, 1, -30.0, 30.0],
        [147, 149, 0.000233401, 0.00115107, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [147, 194, 0.00255462, 0.0137489, 0.0143692, 258.72, 258.72, 258.72, 0.0, 0.0, 1, -30.0, 30.0],
        [147, 194, 0.00255462, 0.0137489, 0.0143692, 258.72, 258.72, 258.72, 0.0, 0.0, 1, -30.0, 30.0],
        [147, 194, 0.00255462, 0.0137489, 0.0143692, 258.72, 258.72, 258.72, 0.0, 0.0, 1, -30.0, 30.0],
        [148, 156, 0.0181624, 0.0443439, 0.00160887, 42.39, 42.39, 42.39, 0.0, 0.0, 1, -30.0, 30.0],
        [150, 120, 0.0297795, 0.0563028, 0.00158465, 46.42, 46.42, 46.42, 0.0, 0.0, 1, -30.0, 30.0],
        [150, 140, 0.0298952, 0.0660431, 0.00149036, 75.76, 75.76, 75.76, 0.0, 0.0, 1, -30.0, 30.0],
        [150, 140, 0.0298952, 0.0660431, 0.00149036, 75.76, 75.76, 75.76, 0.0, 0.0, 1, -30.0, 30.0],
        [150, 140, 0.0298952, 0.0660431, 0.00149036, 75.76, 75.76, 75.76, 0.0, 0.0, 1, -30.0, 30.0],
        [151, 7, 0.00326958, 0.01729, 0.00868229, 245.15, 245.15, 245.15, 0.0, 0.0, 1, -30.0, 30.0],
        [151, 153, 0.000235403, 0.00110097, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [151, 215, 0.00263144, 0.0113403, 0.0437624, 218.85, 218.85, 218.85, 0.0, 0.0, 1, -30.0, 30.0],
        [152, 4, 0.0147656, 0.0290754, 0.00087911, 85.6, 85.6, 85.6, 0.0, 0.0, 1, -30.0, 30.0],
        [152, 4, 0.0147656, 0.0290754, 0.00087911, 85.6, 85.6, 85.6, 0.0, 0.0, 1, -30.0, 30.0],
        [152, 5, 0.00545811, 0.0144163, 0.00473266, 78.0, 78.0, 78.0, 0.0, 0.0, 1, -30.0, 30.0],
        [152, 5, 0.00545811, 0.0144163, 0.00473266, 78.0, 78.0, 78.0, 0.0, 0.0, 1, -30.0, 30.0],
        [152, 5, 0.00545811, 0.0144163, 0.00473266, 78.0, 78.0, 78.0, 0.0, 0.0, 1, -30.0, 30.0],
        [154, 10, 0.0107485, 0.0206414, 0.000973874, 71.18, 71.18, 71.18, 0.0, 0.0, 1, -30.0, 30.0],
        [154, 10, 0.0107485, 0.0206414, 0.000973874, 80.56, 80.56, 80.56, 0.0, 0.0, 1, -30.0, 30.0],
        [155, 163, 0.0196274, 0.0471833, 0.00197792, 74.8, 74.8, 74.8, 0.0, 0.0, 1, -30.0, 30.0],
        [155, 180, 0.010351, 0.0283498, 0.00294648, 58.31, 58.31, 58.31, 0.0, 0.0, 1, -30.0, 30.0],
        [155, 223, 0.0272432, 0.0805527, 0.00229527, 78.09, 78.09, 78.09, 0.0, 0.0, 1, -30.0, 30.0],
        [156, 192, 0.0205836, 0.0468515, 0.00655589, 67.49, 67.49, 67.49, 0.0, 0.0, 1, -30.0, 30.0],
        [156, 192, 0.0205836, 0.0468515, 0.00655589, 67.49, 67.49, 67.49, 0.0, 0.0, 1, -30.0, 30.0],
        [156, 195, 0.0155055, 0.0375019, 0.00446355, 72.47, 72.47, 72.47, 0.0, 0.0, 1, -30.0, 30.0],
        [156, 195, 0.0155055, 0.0375019, 0.00446355, 72.47, 72.47, 72.47, 0.0, 0.0, 1, -30.0, 30.0],
        [157, 193, 0.00381339, 0.0208875, 0.00475713, 189.05, 189.05, 189.05, 0.0, 0.0, 1, -30.0, 30.0],
        [157, 228, 0.00245352, 0.0150944, 0.0225053, 214.24, 214.24, 214.24, 0.0, 0.0, 1, -30.0, 30.0],
        [159, 205, 0.000278906, 0.0035979, 0.0518977, 1102.04, 1102.04, 1102.04, 0.0, 0.0, 1, -30.0, 30.0],
        [160, 162, 0.000293304, 0.0010983, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [161, 200, 0.0151843, 0.0358731, 0.00333635, 69.38, 69.38, 69.38, 0.0, 0.0, 1, -30.0, 30.0],
        [161, 200, 0.0151843, 0.0358731, 0.00333635, 69.38, 69.38, 69.38, 0.0, 0.0, 1, -30.0, 30.0],
        [161, 204, 0.0148346, 0.0447823, 0.00556805, 75.86, 75.86, 75.86, 0.0, 0.0, 1, -30.0, 30.0],
        [161, 204, 0.0148346, 0.0447823, 0.00556805, 75.86, 75.86, 75.86, 0.0, 0.0, 1, -30.0, 30.0],
        [161, 204, 0.0148346, 0.0447823, 0.00556805, 75.86, 75.86, 75.86, 0.0, 0.0, 1, -30.0, 30.0],
        [162, 55, 0.00558741, 0.030459, 0.0194915, 234.02, 234.02, 234.02, 0.0, 0.0, 1, -30.0, 30.0],
        [162, 55, 0.00558741, 0.030459, 0.0194915, 234.02, 234.02, 234.02, 0.0, 0.0, 1, -30.0, 30.0],
        [162, 220, 0.00268522, 0.0139605, 0.00596498, 387.61, 387.61, 387.61, 0.0, 0.0, 1, -30.0, 30.0],
        [162, 224, 0.00351279, 0.018422, 0.00806909, 258.69, 258.69, 258.69, 0.0, 0.0, 1, -30.0, 30.0],
        [162, 224, 0.00351279, 0.018422, 0.00806909, 258.69, 258.69, 258.69, 0.0, 0.0, 1, -30.0, 30.0],
        [162, 224, 0.00351279, 0.018422, 0.00806909, 258.69, 258.69, 258.69, 0.0, 0.0, 1, -30.0, 30.0],
        [163, 223, 0.00808175, 0.0230899, 0.00107231, 76.48, 76.48, 76.48, 0.0, 0.0, 1, -30.0, 30.0],
        [163, 223, 0.00808175, 0.0230899, 0.00107231, 76.48, 76.48, 76.48, 0.0, 0.0, 1, -30.0, 30.0],
        [163, 223, 0.00808175, 0.0230899, 0.00107231, 76.48, 76.48, 76.48, 0.0, 0.0, 1, -30.0, 30.0],
        [163, 229, 0.0204084, 0.0621093, 0.00176807, 52.45, 52.45, 52.45, 0.0, 0.0, 1, -30.0, 30.0],
        [164, 168, 0.016071, 0.0391314, 0.00143223, 58.01, 58.01, 58.01, 0.0, 0.0, 1, -30.0, 30.0],
        [165, 167, 0.000251608, 0.00103394, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [168, 166, 0.0150379, 0.0434832, 0.000881361, 59.41, 59.41, 59.41, 0.0, 0.0, 1, -30.0, 30.0],
        [168, 218, 0.0307907, 0.0691482, 0.00291256, 62.92, 62.92, 62.92, 0.0, 0.0, 1, -30.0, 30.0],
        [169, 171, 0.00890843, 0.0193735, 0.00231454, 65.93, 65.93, 65.93, 0.0, 0.0, 1, -30.0, 30.0],
        [169, 171, 0.00890843, 0.0193735, 0.00231454, 65.93, 65.93, 65.93, 0.0, 0.0, 1, -30.0, 30.0],
        [170, 172, 0.000273637, 0.00109044, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [170, 215, 0.00262571, 0.0157018, 0.0157498, 232.83, 232.83, 232.83, 0.0, 0.0, 1, -30.0, 30.0],
        [170, 215, 0.00262571, 0.0157018, 0.0157498, 232.83, 232.83, 232.83, 0.0, 0.0, 1, -30.0, 30.0],
        [171, 219, 0.0328035, 0.0877929, 0.00914503, 74.18, 74.18, 74.18, 0.0, 0.0, 1, -30.0, 30.0],
        [173, 146, 0.009555, 0.023129, 0.00106, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [174, 165, 0.0025341, 0.0161874, 0.00380501, 350.0, 350.0, 350.0, 0.0, 0.0, 1, -30.0, 30.0],
        [174, 176, 0.000274191, 0.00107177, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [175, 27, 0.0136528, 0.0387942, 0.00114814, 99.55, 99.55, 99.55, 0.0, 0.0, 1, -30.0, 30.0],
        [177, 218, 0.0140703, 0.0397389, 0.00149568, 76.84, 76.84, 76.84, 0.0, 0.0, 1, -30.0, 30.0],
        [178, 221, 0.00647355, 0.0094515, 0.0108546, 87.47, 87.47, 87.47, 0.0, 0.0, 1, -30.0, 30.0],
        [179, 127, 0.0181795, 0.0380883, 0.000744678, 39.06, 39.06, 39.06, 0.0, 0.0, 1, -30.0, 30.0],
        [179, 145, 0.0189744, 0.0520399, 0.00163095, 56.63, 56.63, 56.63, 0.0, 0.0, 1, -30.0, 30.0],
        [180, 129, 0.0185349, 0.0425666, 0.00144921, 62.88, 62.88, 62.88, 0.0, 0.0, 1, -30.0, 30.0],
        [180, 195, 0.0141662, 0.0282517, 0.000658897, 67.5, 67.5, 67.5, 0.0, 0.0, 1, -30.0, 30.0],
        [180, 195, 0.0141662, 0.0282517, 0.000658897, 67.5, 67.5, 67.5, 0.0, 0.0, 1, -30.0, 30.0],
        [181, 7, 0.00312107, 0.0163926, 0.00586532, 234.06, 234.06, 234.06, 0.0, 0.0, 1, -30.0, 30.0],
        [181, 7, 0.00312107, 0.0163926, 0.00586532, 234.06, 234.06, 234.06, 0.0, 0.0, 1, -30.0, 30.0],
        [181, 183, 0.000258671, 0.00105971, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [182, 216, 0.0117745, 0.0327963, 0.00203928, 55.48, 55.48, 55.48, 0.0, 0.0, 1, -30.0, 30.0],
        [185, 138, 0.00839062, 0.020628, 0.00162726, 104.72, 104.72, 104.72, 0.0, 0.0, 1, -30.0, 30.0],
        [185, 184, 0.0167247, 0.0366035, 0.00147383, 70.93, 70.93, 70.93, 0.0, 0.0, 1, -30.0, 30.0],
        [186, 184, 0.022805, 0.0572779, 0.00165113, 72.5, 72.5, 72.5, 0.0, 0.0, 1, -30.0, 30.0],
        [186, 184, 0.022805, 0.0572779, 0.00165113, 80.96, 80.96, 80.96, 0.0, 0.0, 1, -30.0, 30.0],
        [186, 189, 0.0113752, 0.0297572, 0.00248138, 66.24, 66.24, 66.24, 0.0, 0.0, 1, -30.0, 30.0],
        [186, 189, 0.0113752, 0.0297572, 0.00248138, 66.24, 66.24, 66.24, 0.0, 0.0, 1, -30.0, 30.0],
        [186, 230, 0.0581273, 0.157118, 0.00669773, 54.84, 54.84, 54.84, 0.0, 0.0, 1, -30.0, 30.0],
        [187, 8, 0.0298845, 0.0653661, 0.00177523, 83.28, 83.28, 83.28, 0.0, 0.0, 1, -30.0, 30.0],
        [188, 190, 0.000224839, 0.00112493, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [188, 232, 0.00752042, 0.0337115, 0.00783354, 231.85, 231.85, 231.85, 0.0, 0.0, 1, -30.0, 30.0],
        [188, 232, 0.00752042, 0.0337115, 0.00783354, 231.85, 231.85, 231.85, 0.0, 0.0, 1, -30.0, 30.0],
        [189, 206, 0.0159815, 0.0410208, 0.00166865, 67.51, 67.51, 67.51, 0.0, 0.0, 1, -30.0, 30.0],
        [189, 206, 0.0159815, 0.0410208, 0.00166865, 67.51, 67.51, 67.51, 0.0, 0.0, 1, -30.0, 30.0],
        [191, 193, 0.000231723, 0.00119342, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [192, 127, 0.0168769, 0.0410262, 0.00105163, 56.04, 56.04, 56.04, 0.0, 0.0, 1, -30.0, 30.0],
        [192, 179, 0.0104674, 0.0230029, 0.00156838, 68.12, 68.12, 68.12, 0.0, 0.0, 1, -30.0, 30.0],
        [192, 179, 0.0104674, 0.0230029, 0.00156838, 68.12, 68.12, 68.12, 0.0, 0.0, 1, -30.0, 30.0],
        [192, 195, 0.0179909, 0.0437068, 0.00182021, 92.11, 92.11, 92.11, 0.0, 0.0, 1, -30.0, 30.0],
        [193, 158, 0.00316113, 0.0244446, 0.0132982, 198.06, 198.06, 198.06, 0.0, 0.0, 1, -30.0, 30.0],
        [193, 194, 0.0025736, 0.0102262, 0.00620697, 281.31, 281.31, 281.31, 0.0, 0.0, 1, -30.0, 30.0],
        [193, 194, 0.0025736, 0.0102262, 0.00620697, 281.31, 281.31, 281.31, 0.0, 0.0, 1, -30.0, 30.0],
        [194, 196, 0.00024043, 0.00113302, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [194, 228, 0.00287857, 0.0159396, 0.0219001, 260.84, 260.84, 260.84, 0.0, 0.0, 1, -30.0, 30.0],
        [194, 228, 0.00287857, 0.0159396, 0.0219001, 260.84, 260.84, 260.84, 0.0, 0.0, 1, -30.0, 30.0],
        [194, 228, 0.00287857, 0.0159396, 0.0219001, 260.84, 260.84, 260.84, 0.0, 0.0, 1, -30.0, 30.0],
        [195, 155, 0.0223752, 0.0441843, 0.000689068, 74.0, 74.0, 74.0, 0.0, 0.0, 1, -30.0, 30.0],
        [197, 198, 0.000246371, 0.00105231, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [198, 127, 0.0204338, 0.0481634, 0.00302687, 77.18, 77.18, 77.18, 0.0, 0.0, 1, -30.0, 30.0],
        [198, 199, 0.0131317, 0.0331819, 0.00274932, 73.03, 73.03, 73.03, 0.0, 0.0, 1, -30.0, 30.0],
        [198, 229, 0.0150684, 0.0336281, 0.00116685, 69.02, 69.02, 69.02, 0.0, 0.0, 1, -30.0, 30.0],
        [199, 227, 0.0161123, 0.0358027, 0.00487595, 108.44, 108.44, 108.44, 0.0, 0.0, 1, -30.0, 30.0],
        [199, 227, 0.0161123, 0.0358027, 0.00487595, 120.28, 120.28, 120.28, 0.0, 0.0, 1, -30.0, 30.0],
        [200, 227, 0.01385, 0.0276341, 0.000981022, 87.51, 87.51, 87.51, 0.0, 0.0, 1, -30.0, 30.0],
        [201, 226, 0.0150041, 0.0392713, 0.0059648, 73.27, 73.27, 73.27, 0.0, 0.0, 1, -30.0, 30.0],
        [202, 205, 0.000205339, 0.00116498, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [204, 201, 0.0134857, 0.030966, 0.000608419, 67.24, 67.24, 67.24, 0.0, 0.0, 1, -30.0, 30.0],
        [204, 201, 0.0134857, 0.030966, 0.000608419, 67.24, 67.24, 67.24, 0.0, 0.0, 1, -30.0, 30.0],
        [204, 233, 0.017523, 0.0435312, 0.00464601, 99.33, 99.33, 99.33, 0.0, 0.0, 1, -30.0, 30.0],
        [205, 231, 0.000215139, 0.00277088, 0.0771537, 1158.05, 1158.05, 1158.05, 0.0, 0.0, 1, -30.0, 30.0],
        [205, 278, 0.00105332, 0.0119442, 0.525216, 1145.14, 1145.14, 1145.14, 0.0, 0.0, 1, -30.0, 30.0],
        [205, 524, 0.000633563, 0.00765519, 0.336932, 1198.91, 1198.91, 1198.91, 0.0, 0.0, 1, -30.0, 30.0],
        [207, 210, 0.000203077, 0.00103235, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [208, 42, 0.00386321, 0.0212459, 0.0116812, 245.12, 245.12, 245.12, 0.0, 0.0, 1, -30.0, 30.0],
        [208, 42, 0.00386321, 0.0212459, 0.0116812, 285.62, 285.62, 285.62, 0.0, 0.0, 1, -30.0, 30.0],
        [209, 18, 0.0141481, 0.036677, 0.00257837, 75.36, 75.36, 75.36, 0.0, 0.0, 1, -30.0, 30.0],
        [209, 18, 0.0141481, 0.036677, 0.00257837, 75.36, 75.36, 75.36, 0.0, 0.0, 1, -30.0, 30.0],
        [209, 18, 0.0141481, 0.036677, 0.00257837, 75.36, 75.36, 75.36, 0.0, 0.0, 1, -30.0, 30.0],
        [210, 231, 0.000786165, 0.00848843, 0.154832, 1115.12, 1115.12, 1115.12, 0.0, 0.0, 1, -30.0, 30.0],
        [211, 213, 0.00023881, 0.00108615, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [211, 220, 0.0084638, 0.0458131, 0.0300363, 258.6, 258.6, 258.6, 0.0, 0.0, 1, -30.0, 30.0],
        [211, 220, 0.0084638, 0.0458131, 0.0300363, 258.6, 258.6, 258.6, 0.0, 0.0, 1, -30.0, 30.0],
        [211, 220, 0.0084638, 0.0458131, 0.0300363, 258.6, 258.6, 258.6, 0.0, 0.0, 1, -30.0, 30.0],
        [212, 138, 0.0128544, 0.021912, 0.00101185, 102.26, 102.26, 102.26, 0.0, 0.0, 1, -30.0, 30.0],
        [214, 212, 0.0143758, 0.0257748, 0.00190122, 71.52, 71.52, 71.52, 0.0, 0.0, 1, -30.0, 30.0],
        [214, 212, 0.0143758, 0.0257748, 0.00190122, 71.52, 71.52, 71.52, 0.0, 0.0, 1, -30.0, 30.0],
        [215, 174, 0.00442733, 0.0216691, 0.0122677, 210.3, 210.3, 210.3, 0.0, 0.0, 1, -30.0, 30.0],
        [215, 181, 0.0029237, 0.0161116, 0.00255529, 229.07, 229.07, 229.07, 0.0, 0.0, 1, -30.0, 30.0],
        [215, 217, 0.000203962, 0.00108148, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [216, 173, 0.0196128, 0.0551717, 0.00117719, 62.84, 62.84, 62.84, 0.0, 0.0, 1, -30.0, 30.0],
        [218, 175, 0.00812846, 0.0176939, 0.00270339, 72.19, 72.19, 72.19, 0.0, 0.0, 1, -30.0, 30.0],
        [218, 175, 0.00812846, 0.0176939, 0.00270339, 85.09, 85.09, 85.09, 0.0, 0.0, 1, -30.0, 30.0],
        [219, 2, 0.0242094, 0.0435085, 0.0013409, 91.65, 91.65, 91.65, 0.0, 0.0, 1, -30.0, 30.0],
        [219, 2, 0.0242094, 0.0435085, 0.0013409, 91.65, 91.65, 91.65, 0.0, 0.0, 1, -30.0, 30.0],
        [219, 23, 0.0131534, 0.0254694, 0.00153205, 77.86, 77.86, 77.86, 0.0, 0.0, 1, -30.0, 30.0],
        [220, 48, 0.00732722, 0.0381605, 0.0190141, 254.92, 254.92, 254.92, 0.0, 0.0, 1, -30.0, 30.0],
        [220, 48, 0.00732722, 0.0381605, 0.0190141, 254.92, 254.92, 254.92, 0.0, 0.0, 1, -30.0, 30.0],
        [220, 48, 0.00732722, 0.0381605, 0.0190141, 254.92, 254.92, 254.92, 0.0, 0.0, 1, -30.0, 30.0],
        [221, 204, 0.0175829, 0.041989, 0.00218895, 67.31, 67.31, 67.31, 0.0, 0.0, 1, -30.0, 30.0],
        [221, 204, 0.0175829, 0.041989, 0.00218895, 85.53, 85.53, 85.53, 0.0, 0.0, 1, -30.0, 30.0],
        [222, 224, 0.000242767, 0.00111003, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [223, 229, 0.0174924, 0.0503299, 0.000887144, 85.11, 85.11, 85.11, 0.0, 0.0, 1, -30.0, 30.0],
        [224, 228, 0.0022212, 0.0104378, 0.00567601, 327.28, 327.28, 327.28, 0.0, 0.0, 1, -30.0, 30.0],
        [225, 203, 0.00222796, 0.0139973, 0.0133388, 247.99, 247.99, 247.99, 0.0, 0.0, 1, -30.0, 30.0],
        [225, 224, 0.00212109, 0.0120557, 0.00523631, 225.98, 225.98, 225.98, 0.0, 0.0, 1, -30.0, 30.0],
        [226, 227, 0.0227207, 0.0580639, 0.00241506, 78.07, 78.07, 78.07, 0.0, 0.0, 1, -30.0, 30.0],
        [227, 58, 0.00992046, 0.0195323, 0.00980818, 83.11, 83.11, 83.11, 0.0, 0.0, 0, -30.0, 30.0],
        [227, 58, 0.00992046, 0.0195323, 0.00980818, 95.9, 95.9, 95.9, 0.0, 0.0, 1, -30.0, 30.0],
        [227, 161, 0.0147658, 0.0294545, 0.00119876, 76.49, 76.49, 76.49, 0.0, 0.0, 1, -30.0, 30.0],
        [227, 161, 0.0147658, 0.0294545, 0.00119876, 76.49, 76.49, 76.49, 0.0, 0.0, 1, -30.0, 30.0],
        [228, 53, 0.00382559, 0.0165362, 0.022197, 292.96, 292.96, 292.96, 0.0, 0.0, 1, -30.0, 30.0],
        [228, 53, 0.00382559, 0.0165362, 0.022197, 292.96, 292.96, 292.96, 0.0, 0.0, 1, -30.0, 30.0],
        [228, 53, 0.00382559, 0.0165362, 0.022197, 292.96, 292.96, 292.96, 0.0, 0.0, 1, -30.0, 30.0],
        [229, 199, 0.0180675, 0.0414104, 0.00262177, 62.51, 62.51, 62.51, 0.0, 0.0, 1, -30.0, 30.0],
        [230, 236, 0.0449154, 0.0969611, 0.00491852, 52.84, 52.84, 52.84, 0.0, 0.0, 1, -30.0, 30.0],
        [231, 234, 0.000297527, 0.00115454, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [233, 186, 0.0171062, 0.0355652, 0.00143411, 104.83, 104.83, 104.83, 0.0, 0.0, 1, -30.0, 30.0],
        [233, 186, 0.0171062, 0.0355652, 0.00143411, 104.83, 104.83, 104.83, 0.0, 0.0, 1, -30.0, 30.0],
        [233, 201, 0.021404, 0.0484185, 0.00310989, 72.54, 72.54, 72.54, 0.0, 0.0, 1, -30.0, 30.0],
        [235, 232, 0.00270916, 0.0178324, 0.0129997, 207.9, 207.9, 207.9, 0.0, 0.0, 1, -30.0, 30.0],
        [237, 244, 0.00610288, 0.0194043, 0.0010148, 62.33, 62.33, 62.33, 0.0, 0.0, 1, -30.0, 30.0],
        [237, 255, 0.0174779, 0.0354033, 0.00266394, 65.07, 65.07, 65.07, 0.0, 0.0, 1, -30.0, 30.0],
        [239, 265, 0.018114, 0.0480106, 0.000838238, 89.56, 89.56, 89.56, 0.0, 0.0, 1, -30.0, 30.0],
        [240, 89, 0.00157057, 0.00962461, 0.00453312, 310.0, 310.0, 310.0, 0.0, 0.0, 1, -30.0, 30.0],
        [240, 89, 0.00157057, 0.00962461, 0.00453312, 310.0, 310.0, 310.0, 0.0, 0.0, 1, -30.0, 30.0],
        [240, 89, 0.00157057, 0.00962461, 0.00453312, 261.92, 261.92, 261.92, 0.0, 0.0, 1, -30.0, 30.0],
        [240, 247, 0.0029793, 0.019774, 0.0166579, 240.22, 240.22, 240.22, 0.0, 0.0, 1, -30.0, 30.0],
        [240, 247, 0.0029793, 0.019774, 0.0166579, 240.22, 240.22, 240.22, 0.0, 0.0, 1, -30.0, 30.0],
        [240, 256, 0.00195956, 0.0113483, 0.00769648, 251.41, 251.41, 251.41, 0.0, 0.0, 0, -30.0, 30.0],
        [241, 104, 0.0161927, 0.0398667, 0.00266059, 68.35, 68.35, 68.35, 0.0, 0.0, 1, -30.0, 30.0],
        [241, 104, 0.0161927, 0.0398667, 0.00266059, 68.35, 68.35, 68.35, 0.0, 0.0, 1, -30.0, 30.0],
        [241, 244, 0.00924478, 0.0292172, 0.00269516, 90.05, 90.05, 90.05, 0.0, 0.0, 1, -30.0, 30.0],
        [242, 238, 0.0207745, 0.0499956, 0.00338267, 68.04, 68.04, 68.04, 0.0, 0.0, 1, -30.0, 30.0],
        [242, 238, 0.0207745, 0.0499956, 0.00338267, 68.04, 68.04, 68.04, 0.0, 0.0, 1, -30.0, 30.0],
        [242, 244, 0.0265792, 0.0613294, 0.00227154, 68.8, 68.8, 68.8, 0.0, 0.0, 1, -30.0, 30.0],
        [242, 255, 0.0186242, 0.043782, 0.000629708, 72.32, 72.32, 72.32, 0.0, 0.0, 1, -30.0, 30.0],
        [242, 255, 0.0186242, 0.043782, 0.000629708, 72.32, 72.32, 72.32, 0.0, 0.0, 1, -30.0, 30.0],
        [243, 240, 0.00282367, 0.0159616, 0.00597651, 219.93, 219.93, 219.93, 0.0, 0.0, 1, -30.0, 30.0],
        [245, 249, 0.0127162, 0.0269046, 0.000676628, 84.43, 84.43, 84.43, 0.0, 0.0, 1, -30.0, 30.0],
        [245, 249, 0.0127162, 0.0269046, 0.000676628, 84.43, 84.43, 84.43, 0.0, 0.0, 1, -30.0, 30.0],
        [246, 29, 0.0114014, 0.0256159, 0.00143978, 83.46, 83.46, 83.46, 0.0, 0.0, 1, -30.0, 30.0],
        [247, 555, 0.0019849, 0.0126378, 0.00467362, 238.81, 238.81, 238.81, 0.0, 0.0, 1, -30.0, 30.0],
        [247, 555, 0.0019849, 0.0126378, 0.00467362, 238.81, 238.81, 238.81, 0.0, 0.0, 1, -30.0, 30.0],
        [248, 250, 0.000273011, 0.0010022, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [248, 548, 0.00119699, 0.00650868, 0.00241705, 308.36, 308.36, 308.36, 0.0, 0.0, 1, -30.0, 30.0],
        [248, 548, 0.00119699, 0.00650868, 0.00241705, 311.43, 311.43, 311.43, 0.0, 0.0, 1, -30.0, 30.0],
        [248, 564, 0.00366752, 0.0184431, 0.00807276, 191.9, 191.9, 191.9, 0.0, 0.0, 1, -30.0, 30.0],
        [251, 248, 0.00149495, 0.0112232, 0.0139702, 208.59, 208.59, 208.59, 0.0, 0.0, 1, -30.0, 30.0],
        [251, 253, 0.00023888, 0.00104132, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [251, 564, 0.00143282, 0.00821499, 0.00649029, 196.26, 196.26, 196.26, 0.0, 0.0, 1, -30.0, 30.0],
        [254, 256, 0.000274063, 0.00111039, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [255, 241, 0.0155016, 0.0446079, 0.0015347, 68.2, 68.2, 68.2, 0.0, 0.0, 1, -30.0, 30.0],
        [256, 247, 0.00200632, 0.0136637, 0.00814842, 233.97, 233.97, 233.97, 0.0, 0.0, 1, -30.0, 30.0],
        [256, 247, 0.00200632, 0.0136637, 0.00814842, 233.97, 233.97, 233.97, 0.0, 0.0, 1, -30.0, 30.0],
        [257, 96, 0.000598834, 0.00715367, 0.104794, 1213.35, 1213.35, 1213.35, 0.0, 0.0, 1, -30.0, 30.0],
        [257, 210, 0.0011251, 0.011754, 0.284958, 1209.81, 1209.81, 1209.81, 0.0, 0.0, 1, -30.0, 30.0],
        [257, 259, 0.000227435, 0.00102602, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [258, 266, 0.00255972, 0.0149715, 0.00795317, 284.14, 284.14, 284.14, 0.0, 0.0, 1, -30.0, 30.0],
        [258, 266, 0.00255972, 0.0149715, 0.00795317, 284.14, 284.14, 284.14, 0.0, 0.0, 1, -30.0, 30.0],
        [258, 266, 0.00255972, 0.0149715, 0.00795317, 284.14, 284.14, 284.14, 0.0, 0.0, 1, -30.0, 30.0],
        [258, 268, 0.00504439, 0.0299556, 0.010531, 424.46, 424.46, 424.46, 0.0, 0.0, 1, -30.0, 30.0],
        [260, 273, 0.0062996, 0.0162751, 0.00609084, 71.76, 71.76, 71.76, 0.0, 0.0, 1, -30.0, 30.0],
        [260, 273, 0.0062996, 0.0162751, 0.00609084, 76.24, 76.24, 76.24, 0.0, 0.0, 1, -30.0, 30.0],
        [261, 258, 0.00385342, 0.0201756, 0.0144687, 194.78, 194.78, 194.78, 0.0, 0.0, 1, -30.0, 30.0],
        [261, 322, 0.00534084, 0.0243743, 0.0101562, 213.71, 213.71, 213.71, 0.0, 0.0, 1, -30.0, 30.0],
        [262, 109, 0.0110242, 0.0364559, 0.0015607, 71.19, 71.19, 71.19, 0.0, 0.0, 1, -30.0, 30.0],
        [262, 109, 0.0110242, 0.0364559, 0.0015607, 71.19, 71.19, 71.19, 0.0, 0.0, 1, -30.0, 30.0],
        [263, 269, 0.0115005, 0.028237, 0.00153276, 52.95, 52.95, 52.95, 0.0, 0.0, 1, -30.0, 30.0],
        [263, 280, 0.0148282, 0.0428866, 0.00080893, 69.24, 69.24, 69.24, 0.0, 0.0, 1, -30.0, 30.0],
        [263, 280, 0.0148282, 0.0428866, 0.00080893, 69.24, 69.24, 69.24, 0.0, 0.0, 1, -30.0, 30.0],
        [264, 266, 0.000295755, 0.00115773, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [265, 260, 0.0188234, 0.0390689, 0.00136615, 80.67, 80.67, 80.67, 0.0, 0.0, 1, -30.0, 30.0],
        [265, 260, 0.0188234, 0.0390689, 0.00136615, 80.67, 80.67, 80.67, 0.0, 0.0, 1, -30.0, 30.0],
        [265, 260, 0.0188234, 0.0390689, 0.00136615, 80.67, 80.67, 80.67, 0.0, 0.0, 1, -30.0, 30.0],
        [265, 271, 0.0207914, 0.0418415, 0.00677852, 69.92, 69.92, 69.92, 0.0, 0.0, 1, -30.0, 30.0],
        [265, 271, 0.0207914, 0.0418415, 0.00677852, 69.92, 69.92, 69.92, 0.0, 0.0, 1, -30.0, 30.0],
        [266, 272, 0.0034261, 0.0167744, 0.00702026, 240.48, 240.48, 240.48, 0.0, 0.0, 1, -30.0, 30.0],
        [266, 272, 0.0034261, 0.0167744, 0.00702026, 240.48, 240.48, 240.48, 0.0, 0.0, 1, -30.0, 30.0],
        [267, 273, 0.0160189, 0.0362244, 0.00115009, 71.35, 71.35, 71.35, 0.0, 0.0, 1, -30.0, 30.0],
        [267, 273, 0.0160189, 0.0362244, 0.00115009, 77.65, 77.65, 77.65, 0.0, 0.0, 1, -30.0, 30.0],
        [268, 39, 0.00416594, 0.0254577, 0.00935775, 241.74, 241.74, 241.74, 0.0, 0.0, 1, -30.0, 30.0],
        [268, 270, 0.000235627, 0.00111924, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [268, 281, 0.00337442, 0.0178337, 0.00605589, 310.85, 310.85, 310.85, 0.0, 0.0, 1, -30.0, 30.0],
        [269, 113, 0.0106788, 0.0295836, 0.00221903, 69.2, 69.2, 69.2, 0.0, 0.0, 1, -30.0, 30.0],
        [269, 113, 0.0106788, 0.0295836, 0.00221903, 69.2, 69.2, 69.2, 0.0, 0.0, 1, -30.0, 30.0],
        [269, 276, 0.0160855, 0.0460924, 0.00242577, 66.41, 66.41, 66.41, 0.0, 0.0, 1, -30.0, 30.0],
        [269, 276, 0.0160855, 0.0460924, 0.00242577, 66.41, 66.41, 66.41, 0.0, 0.0, 1, -30.0, 30.0],
        [272, 251, 0.00228951, 0.0136952, 0.00366725, 236.81, 236.81, 236.81, 0.0, 0.0, 1, -30.0, 30.0],
        [272, 251, 0.00228951, 0.0136952, 0.00366725, 236.81, 236.81, 236.81, 0.0, 0.0, 1, -30.0, 30.0],
        [272, 274, 0.000267023, 0.00101293, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [273, 242, 0.0143761, 0.0361022, 0.00193949, 60.49, 60.49, 60.49, 0.0, 0.0, 1, -30.0, 30.0],
        [273, 557, 0.017136, 0.0482097, 0.00390908, 71.75, 71.75, 71.75, 0.0, 0.0, 1, -30.0, 30.0],
        [273, 557, 0.017136, 0.0482097, 0.00390908, 71.75, 71.75, 71.75, 0.0, 0.0, 1, -30.0, 30.0],
        [275, 283, 0.0230872, 0.0505329, 0.00257514, 75.34, 75.34, 75.34, 0.0, 0.0, 1, -30.0, 30.0],
        [276, 41, 0.0143025, 0.0440679, 0.00413152, 75.11, 75.11, 75.11, 0.0, 0.0, 1, -30.0, 30.0],
        [276, 41, 0.0143025, 0.0440679, 0.00413152, 92.35, 92.35, 92.35, 0.0, 0.0, 1, -30.0, 30.0],
        [277, 109, 0.0431985, 0.0719534, 0.00654047, 55.77, 55.77, 55.77, 0.0, 0.0, 1, -30.0, 30.0],
        [277, 282, 0.0137762, 0.035728, 0.00253148, 58.62, 58.62, 58.62, 0.0, 0.0, 1, -30.0, 30.0],
        [278, 210, 0.000649137, 0.007959, 0.17925, 1152.75, 1152.75, 1152.75, 0.0, 0.0, 1, -30.0, 30.0],
        [278, 257, 0.000389733, 0.00500821, 0.121635, 1338.25, 1338.25, 1338.25, 0.0, 0.0, 1, -30.0, 30.0],
        [279, 281, 0.000207007, 0.00118167, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [280, 282, 0.00419738, 0.0108666, 0.00834402, 77.94, 77.94, 77.94, 0.0, 0.0, 1, -30.0, 30.0],
        [281, 39, 0.00336136, 0.0267922, 0.0139285, 248.9, 248.9, 248.9, 0.0, 0.0, 1, -30.0, 30.0],
        [281, 39, 0.00336136, 0.0267922, 0.0139285, 248.9, 248.9, 248.9, 0.0, 0.0, 1, -30.0, 30.0],
        [281, 39, 0.00336136, 0.0267922, 0.0139285, 248.9, 248.9, 248.9, 0.0, 0.0, 1, -30.0, 30.0],
        [284, 285, 0.00022402, 0.00100338, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [286, 284, 0.0274693, 0.0754281, 0.00250741, 63.54, 63.54, 63.54, 0.0, 0.0, 1, -30.0, 30.0],
        [286, 301, 0.0750357, 0.213335, 0.00361709, 50.41, 50.41, 50.41, 0.0, 0.0, 1, -30.0, 30.0],
        [287, 300, 0.00209536, 0.0136011, 0.0216782, 247.81, 247.81, 247.81, 0.0, 0.0, 1, -30.0, 30.0],
        [288, 318, 0.0171298, 0.0347877, 0.0148853, 89.72, 89.72, 89.72, 0.0, 0.0, 1, -30.0, 30.0],
        [288, 355, 0.0257954, 0.0633871, 0.0021817, 90.33, 90.33, 90.33, 0.0, 0.0, 1, -30.0, 30.0],
        [289, 291, 0.00026215, 0.00115036, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [290, 288, 0.0194431, 0.0536157, 0.00167939, 61.3, 61.3, 61.3, 0.0, 0.0, 1, -30.0, 30.0],
        [290, 301, 0.0489703, 0.123077, 0.00765854, 67.82, 67.82, 67.82, 0.0, 0.0, 1, -30.0, 30.0],
        [290, 301, 0.0489703, 0.123077, 0.00765854, 67.82, 67.82, 67.82, 0.0, 0.0, 1, -30.0, 30.0],
        [290, 354, 0.0356352, 0.0767378, 0.0018933, 53.4, 53.4, 53.4, 0.0, 0.0, 1, -30.0, 30.0],
        [291, 319, 0.00438098, 0.029131, 0.0151494, 219.1, 219.1, 219.1, 0.0, 0.0, 1, -30.0, 30.0],
        [292, 294, 0.00028553, 0.00105743, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [292, 1202, 0.0107918, 0.0527453, 0.0128012, 191.5, 191.5, 191.5, 0.0, 0.0, 1, -30.0, 30.0],
        [292, 1205, 0.0097667, 0.054125, 0.0160784, 206.58, 206.58, 206.58, 0.0, 0.0, 1, -30.0, 30.0],
        [295, 300, 0.00147198, 0.00805837, 0.00737939, 181.52, 181.52, 181.52, 0.0, 0.0, 1, -30.0, 30.0],
        [295, 319, 0.00617092, 0.0429942, 0.0179008, 261.59, 261.59, 261.59, 0.0, 0.0, 1, -30.0, 30.0],
        [296, 298, 0.000223811, 0.00106479, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [296, 304, 0.00225211, 0.0168586, 0.00915137, 200.03, 200.03, 200.03, 0.0, 0.0, 1, -30.0, 30.0],
        [296, 593, 0.00283154, 0.0223177, 0.0490341, 234.73, 234.73, 234.73, 0.0, 0.0, 1, -30.0, 30.0],
        [296, 593, 0.00283154, 0.0223177, 0.0490341, 234.73, 234.73, 234.73, 0.0, 0.0, 1, -30.0, 30.0],
        [297, 299, 0.0149112, 0.0386725, 0.00448012, 101.99, 101.99, 101.99, 0.0, 0.0, 1, -30.0, 30.0],
        [297, 305, 0.0213953, 0.0491083, 0.00214111, 74.74, 74.74, 74.74, 0.0, 0.0, 1, -30.0, 30.0],
        [299, 301, 0.0160858, 0.0302484, 0.00483072, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [302, 1205, 0.00389961, 0.019182, 0.0187003, 300.79, 300.79, 300.79, 0.0, 0.0, 1, -30.0, 30.0],
        [304, 306, 0.000206959, 0.00115203, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [304, 566, 0.00665794, 0.0325476, 0.00629414, 306.81, 306.81, 306.81, 0.0, 0.0, 1, -30.0, 30.0],
        [305, 303, 0.0105811, 0.0226671, 0.00189319, 67.8, 67.8, 67.8, 0.0, 0.0, 1, -30.0, 30.0],
        [305, 303, 0.0105811, 0.0226671, 0.00189319, 73.74, 73.74, 73.74, 0.0, 0.0, 1, -30.0, 30.0],
        [305, 375, 0.0361675, 0.0731479, 0.00229816, 54.67, 54.67, 54.67, 0.0, 0.0, 1, -30.0, 30.0],
        [307, 303, 0.0349958, 0.0807535, 0.00356522, 105.21, 105.21, 105.21, 0.0, 0.0, 1, -30.0, 30.0],
        [308, 370, 0.00305985, 0.015432, 0.00930427, 249.6, 249.6, 249.6, 0.0, 0.0, 1, -30.0, 30.0],
        [308, 370, 0.00305985, 0.015432, 0.00930427, 249.6, 249.6, 249.6, 0.0, 0.0, 1, -30.0, 30.0],
        [308, 370, 0.00305985, 0.015432, 0.00930427, 249.6, 249.6, 249.6, 0.0, 0.0, 1, -30.0, 30.0],
        [309, 311, 0.000245932, 0.00112744, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [309, 315, 0.00156776, 0.00751842, 0.0123771, 309.87, 309.87, 309.87, 0.0, 0.0, 1, -30.0, 30.0],
        [309, 315, 0.00156776, 0.00751842, 0.0123771, 309.87, 309.87, 309.87, 0.0, 0.0, 1, -30.0, 30.0],
        [309, 315, 0.00156776, 0.00751842, 0.0123771, 309.87, 309.87, 309.87, 0.0, 0.0, 1, -30.0, 30.0],
        [309, 315, 0.00156776, 0.00751842, 0.0123771, 309.87, 309.87, 309.87, 0.0, 0.0, 1, -30.0, 30.0],
        [309, 359, 0.00357311, 0.0157835, 0.00658763, 247.91, 247.91, 247.91, 0.0, 0.0, 1, -30.0, 30.0],
        [309, 359, 0.00357311, 0.0157835, 0.00658763, 247.91, 247.91, 247.91, 0.0, 0.0, 1, -30.0, 30.0],
        [309, 359, 0.00357311, 0.0157835, 0.00658763, 247.91, 247.91, 247.91, 0.0, 0.0, 1, -30.0, 30.0],
        [309, 365, 0.00344402, 0.0198963, 0.0055028, 186.16, 186.16, 186.16, 0.0, 0.0, 1, -30.0, 30.0],
        [310, 284, 0.0126056, 0.0354382, 0.00360802, 112.62, 112.62, 112.62, 0.0, 0.0, 1, -30.0, 30.0],
        [312, 316, 0.000591123, 0.00757427, 0.113717, 1487.5, 1487.5, 1487.5, 0.0, 0.0, 1, -30.0, 30.0],
        [312, 316, 0.000591123, 0.00757427, 0.113717, 1492.29, 1492.29, 1492.29, 0.0, 0.0, 1, -30.0, 30.0],
        [312, 565, 0.000882509, 0.00998051, 0.194933, 1412.85, 1412.85, 1412.85, 0.0, 0.0, 1, -30.0, 30.0],
        [312, 598, 0.000189782, 0.00212014, 0.0609098, 1259.27, 1259.27, 1259.27, 0.0, 0.0, 1, -30.0, 30.0],
        [313, 315, 0.000212907, 0.00107278, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [314, 286, 0.0222781, 0.0502544, 0.00378533, 70.58, 70.58, 70.58, 0.0, 0.0, 1, -30.0, 30.0],
        [314, 286, 0.0222781, 0.0502544, 0.00378533, 70.58, 70.58, 70.58, 0.0, 0.0, 1, -30.0, 30.0],
        [315, 287, 0.00268005, 0.0151261, 0.00606538, 509.17, 509.17, 509.17, 0.0, 0.0, 1, -30.0, 30.0],
        [316, 1327, 0.0012437, 0.0138706, 0.270196, 1616.18, 1616.18, 1616.18, 0.0, 0.0, 1, -30.0, 30.0],
        [316, 1327, 0.0012437, 0.0138706, 0.270196, 1616.18, 1616.18, 1616.18, 0.0, 0.0, 1, -30.0, 30.0],
        [317, 319, 0.000288323, 0.00111081, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [318, 374, 0.0642131, 0.128681, 0.00412392, 61.55, 61.55, 61.55, 0.0, 0.0, 1, -30.0, 30.0],
        [319, 302, 0.00349091, 0.024543, 0.0113948, 267.15, 267.15, 267.15, 0.0, 0.0, 1, -30.0, 30.0],
        [320, 332, 0.0152593, 0.0426074, 0.00322039, 63.22, 63.22, 63.22, 0.0, 0.0, 1, -30.0, 30.0],
        [320, 383, 0.012416, 0.0236714, 0.00115229, 62.35, 62.35, 62.35, 0.0, 0.0, 1, -30.0, 30.0],
        [321, 352, 0.0188044, 0.0519585, 0.00236034, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [322, 106, 0.00280324, 0.0207091, 0.00682083, 235.95, 235.95, 235.95, 0.0, 0.0, 1, -30.0, 30.0],
        [322, 106, 0.00280324, 0.0207091, 0.00682083, 235.95, 235.95, 235.95, 0.0, 0.0, 1, -30.0, 30.0],
        [322, 324, 0.000205824, 0.00110916, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [322, 334, 0.00326301, 0.0179748, 0.0109428, 210.58, 210.58, 210.58, 0.0, 0.0, 1, -30.0, 30.0],
        [323, 94, 0.0210914, 0.054994, 0.00127251, 82.68, 82.68, 82.68, 0.0, 0.0, 1, -30.0, 30.0],
        [323, 94, 0.0210914, 0.054994, 0.00127251, 82.68, 82.68, 82.68, 0.0, 0.0, 1, -30.0, 30.0],
        [323, 94, 0.0210914, 0.054994, 0.00127251, 82.68, 82.68, 82.68, 0.0, 0.0, 1, -30.0, 30.0],
        [325, 327, 0.000280948, 0.0010884, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [325, 566, 0.017891, 0.0749676, 0.0220623, 258.61, 258.61, 258.61, 0.0, 0.0, 1, -30.0, 30.0],
        [325, 566, 0.017891, 0.0749676, 0.0220623, 258.61, 258.61, 258.61, 0.0, 0.0, 1, -30.0, 30.0],
        [325, 566, 0.017891, 0.0749676, 0.0220623, 258.61, 258.61, 258.61, 0.0, 0.0, 1, -30.0, 30.0],
        [328, 326, 0.0385122, 0.104673, 0.00500988, 86.3, 86.3, 86.3, 0.0, 0.0, 1, -30.0, 30.0],
        [328, 329, 0.0541117, 0.0979473, 0.00705246, 52.79, 52.79, 52.79, 0.0, 0.0, 1, -30.0, 30.0],
        [328, 377, 0.0589813, 0.151027, 0.00395743, 55.59, 55.59, 55.59, 0.0, 0.0, 1, -30.0, 30.0],
        [330, 320, 0.0214254, 0.041138, 0.00112614, 44.84, 44.84, 44.84, 0.0, 0.0, 1, -30.0, 30.0],
        [330, 332, 0.021426, 0.0526701, 0.00548689, 61.09, 61.09, 61.09, 0.0, 0.0, 1, -30.0, 30.0],
        [330, 360, 0.0961537, 0.25104, 0.00758041, 60.55, 60.55, 60.55, 0.0, 0.0, 1, -30.0, 30.0],
        [331, 333, 0.000235225, 0.00106474, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [331, 380, 0.00296783, 0.0153324, 0.0137058, 218.04, 218.04, 218.04, 0.0, 0.0, 1, -30.0, 30.0],
        [331, 382, 0.00211995, 0.0132781, 0.00531391, 227.83, 227.83, 227.83, 0.0, 0.0, 1, -30.0, 30.0],
        [332, 117, 0.0114498, 0.0279019, 0.00198693, 75.41, 75.41, 75.41, 0.0, 0.0, 1, -30.0, 30.0],
        [334, 106, 0.00238432, 0.0101735, 0.0155224, 239.53, 239.53, 239.53, 0.0, 0.0, 1, -30.0, 30.0],
        [334, 106, 0.00238432, 0.0101735, 0.0155224, 239.53, 239.53, 239.53, 0.0, 0.0, 1, -30.0, 30.0],
        [334, 331, 0.00335668, 0.0212297, 0.00852997, 288.24, 288.24, 288.24, 0.0, 0.0, 1, -30.0, 30.0],
        [334, 336, 0.000281597, 0.00106268, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [337, 312, 0.000461814, 0.00618416, 0.118333, 1234.07, 1234.07, 1234.07, 0.0, 0.0, 1, -30.0, 30.0],
        [338, 342, 0.00398948, 0.0224714, 0.00803469, 242.73, 242.73, 242.73, 0.0, 0.0, 1, -30.0, 30.0],
        [338, 359, 0.00219618, 0.0123905, 0.00457766, 242.68, 242.68, 242.68, 0.0, 0.0, 1, -30.0, 30.0],
        [338, 359, 0.00219618, 0.0123905, 0.00457766, 285.54, 285.54, 285.54, 0.0, 0.0, 1, -30.0, 30.0],
        [339, 331, 0.000869447, 0.00434723, 0.0336222, 254.24, 254.24, 254.24, 0.0, 0.0, 1, -30.0, 30.0],
        [339, 331, 0.000869447, 0.00434723, 0.0336222, 254.24, 254.24, 254.24, 0.0, 0.0, 1, -30.0, 30.0],
        [339, 331, 0.000869447, 0.00434723, 0.0336222, 254.24, 254.24, 254.24, 0.0, 0.0, 1, -30.0, 30.0],
        [339, 370, 0.00238231, 0.0125257, 0.0901667, 329.72, 329.72, 329.72, 0.0, 0.0, 1, -30.0, 30.0],
        [339, 370, 0.00238231, 0.0125257, 0.0901667, 329.72, 329.72, 329.72, 0.0, 0.0, 1, -30.0, 30.0],
        [339, 370, 0.00238231, 0.0125257, 0.0901667, 329.72, 329.72, 329.72, 0.0, 0.0, 1, -30.0, 30.0],
        [339, 382, 0.00577075, 0.0288747, 0.0148258, 296.43, 296.43, 296.43, 0.0, 0.0, 1, -30.0, 30.0],
        [340, 338, 0.00386549, 0.0184822, 0.00504685, 223.51, 223.51, 223.51, 0.0, 0.0, 1, -30.0, 30.0],
        [340, 370, 0.00296575, 0.0135246, 0.00637364, 183.46, 183.46, 183.46, 0.0, 0.0, 1, -30.0, 30.0],
        [341, 343, 0.0147213, 0.041109, 0.00163104, 74.05, 74.05, 74.05, 0.0, 0.0, 1, -30.0, 30.0],
        [341, 343, 0.0147213, 0.041109, 0.00163104, 83.24, 83.24, 83.24, 0.0, 0.0, 1, -30.0, 30.0],
        [341, 349, 0.0282512, 0.0646541, 0.00173717, 101.69, 101.69, 101.69, 0.0, 0.0, 1, -30.0, 30.0],
        [341, 379, 0.0174629, 0.0408243, 0.00185553, 70.55, 70.55, 70.55, 0.0, 0.0, 1, -30.0, 30.0],
        [341, 379, 0.0174629, 0.0408243, 0.00185553, 74.33, 74.33, 74.33, 0.0, 0.0, 1, -30.0, 30.0],
        [342, 340, 0.00433219, 0.0183784, 0.00434387, 193.67, 193.67, 193.67, 0.0, 0.0, 1, -30.0, 30.0],
        [342, 344, 0.000250033, 0.00105938, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [343, 349, 0.0149467, 0.0363656, 0.00195416, 70.52, 70.52, 70.52, 0.0, 0.0, 1, -30.0, 30.0],
        [343, 366, 0.0155351, 0.038179, 0.00226189, 52.54, 52.54, 52.54, 0.0, 0.0, 1, -30.0, 30.0],
        [345, 346, 0.0435687, 0.110744, 0.00360061, 56.03, 56.03, 56.03, 0.0, 0.0, 1, -30.0, 30.0],
        [345, 502, 0.094023, 0.222529, 0.014457, 61.63, 61.63, 61.63, 0.0, 0.0, 1, -30.0, 30.0],
        [346, 381, 0.0871775, 0.230583, 0.00544508, 50.57, 50.57, 50.57, 0.0, 0.0, 1, -30.0, 30.0],
        [347, 325, 0.0209426, 0.112866, 0.0433862, 262.24, 262.24, 262.24, 0.0, 0.0, 1, -30.0, 30.0],
        [347, 325, 0.0209426, 0.112866, 0.0433862, 262.24, 262.24, 262.24, 0.0, 0.0, 1, -30.0, 30.0],
        [347, 325, 0.0209426, 0.112866, 0.0433862, 262.24, 262.24, 262.24, 0.0, 0.0, 1, -30.0, 30.0],
        [347, 376, 0.0149671, 0.0924615, 0.0324004, 314.36, 314.36, 314.36, 0.0, 0.0, 1, -30.0, 30.0],
        [348, 342, 0.00217198, 0.0120132, 0.0053261, 251.09, 251.09, 251.09, 0.0, 0.0, 1, -30.0, 30.0],
        [348, 350, 0.000262692, 0.0011521, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [351, 332, 0.0261114, 0.0333541, 0.000962627, 99.07, 99.07, 99.07, 0.0, 0.0, 1, -30.0, 30.0],
        [352, 366, 0.0303231, 0.0842459, 0.00660881, 80.99, 80.99, 80.99, 0.0, 0.0, 1, -30.0, 30.0],
        [352, 371, 0.0154052, 0.041136, 0.0105235, 66.58, 66.58, 66.58, 0.0, 0.0, 1, -30.0, 30.0],
        [352, 371, 0.0154052, 0.041136, 0.0105235, 66.58, 66.58, 66.58, 0.0, 0.0, 1, -30.0, 30.0],
        [353, 767, 0.0508954, 0.0969524, 0.00603201, 67.92, 67.92, 67.92, 0.0, 0.0, 1, -30.0, 30.0],
        [353, 767, 0.0508954, 0.0969524, 0.00603201, 67.92, 67.92, 67.92, 0.0, 0.0, 1, -30.0, 30.0],
        [354, 318, 0.0179016, 0.0485455, 0.00179153, 66.67, 66.67, 66.67, 0.0, 0.0, 1, -30.0, 30.0],
        [354, 318, 0.0179016, 0.0485455, 0.00179153, 66.67, 66.67, 66.67, 0.0, 0.0, 1, -30.0, 30.0],
        [355, 293, 0.00636287, 0.0202092, 0.0024714, 61.76, 61.76, 61.76, 0.0, 0.0, 1, -30.0, 30.0],
        [356, 353, 0.0105033, 0.0307915, 0.00489109, 106.42, 106.42, 106.42, 0.0, 0.0, 1, -30.0, 30.0],
        [356, 378, 0.014009, 0.0340754, 0.00658993, 107.31, 107.31, 107.31, 0.0, 0.0, 1, -30.0, 30.0],
        [357, 309, 0.00419277, 0.0180514, 0.00745632, 235.35, 235.35, 235.35, 0.0, 0.0, 1, -30.0, 30.0],
        [357, 309, 0.00419277, 0.0180514, 0.00745632, 235.35, 235.35, 235.35, 0.0, 0.0, 1, -30.0, 30.0],
        [357, 348, 0.00521398, 0.0287698, 0.0106617, 253.67, 253.67, 253.67, 0.0, 0.0, 1, -30.0, 30.0],
        [358, 310, 0.0199119, 0.0460854, 0.00156488, 100.73, 100.73, 100.73, 0.0, 0.0, 1, -30.0, 30.0],
        [358, 314, 0.0194716, 0.0438792, 0.00272678, 68.46, 68.46, 68.46, 0.0, 0.0, 1, -30.0, 30.0],
        [358, 314, 0.0194716, 0.0438792, 0.00272678, 68.46, 68.46, 68.46, 0.0, 0.0, 1, -30.0, 30.0],
        [360, 600, 0.00796346, 0.0205306, 0.000670865, 53.74, 53.74, 53.74, 0.0, 0.0, 1, -30.0, 30.0],
        [361, 308, 0.00301942, 0.0191898, 0.0126535, 261.29, 261.29, 261.29, 0.0, 0.0, 1, -30.0, 30.0],
        [361, 308, 0.00301942, 0.0191898, 0.0126535, 261.29, 261.29, 261.29, 0.0, 0.0, 1, -30.0, 30.0],
        [361, 308, 0.00301942, 0.0191898, 0.0126535, 261.29, 261.29, 261.29, 0.0, 0.0, 1, -30.0, 30.0],
        [362, 307, 0.0281224, 0.0760376, 0.00192977, 81.33, 81.33, 81.33, 0.0, 0.0, 1, -30.0, 30.0],
        [363, 365, 0.000212772, 0.00113184, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [365, 368, 0.00287663, 0.020689, 0.00896525, 269.75, 269.75, 269.75, 0.0, 0.0, 1, -30.0, 30.0],
        [366, 371, 0.0182246, 0.0520078, 0.00243645, 54.4, 54.4, 54.4, 0.0, 0.0, 1, -30.0, 30.0],
        [366, 519, 0.0110974, 0.0273225, 0.00240673, 64.63, 64.63, 64.63, 0.0, 0.0, 1, -30.0, 30.0],
        [367, 105, 0.00117453, 0.0126939, 0.314935, 1670.54, 1670.54, 1670.54, 0.0, 0.0, 1, -30.0, 30.0],
        [367, 369, 0.000257977, 0.00112781, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [367, 565, 0.000579967, 0.00648643, 0.12273, 2071.54, 2071.54, 2071.54, 0.0, 0.0, 1, -30.0, 30.0],
        [370, 338, 0.00239717, 0.0139735, 0.0123336, 266.16, 266.16, 266.16, 0.0, 0.0, 1, -30.0, 30.0],
        [370, 338, 0.00239717, 0.0139735, 0.0123336, 266.16, 266.16, 266.16, 0.0, 0.0, 1, -30.0, 30.0],
        [370, 372, 0.000288612, 0.00111613, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [371, 373, 0.0201814, 0.0484854, 0.0045982, 75.68, 75.68, 75.68, 0.0, 0.0, 1, -30.0, 30.0],
        [373, 297, 0.0493119, 0.116738, 0.00238978, 73.02, 73.02, 73.02, 0.0, 0.0, 1, -30.0, 30.0],
        [373, 297, 0.0493119, 0.116738, 0.00238978, 73.02, 73.02, 73.02, 0.0, 0.0, 1, -30.0, 30.0],
        [373, 364, 0.0325241, 0.067827, 0.00377785, 114.91, 114.91, 114.91, 0.0, 0.0, 1, -30.0, 30.0],
        [375, 374, 0.0311353, 0.0859491, 0.00418356, 54.04, 54.04, 54.04, 0.0, 0.0, 1, -30.0, 30.0],
        [376, 418, 0.005616, 0.0353161, 0.0630282, 336.64, 336.64, 336.64, 0.0, 0.0, 1, -30.0, 30.0],
        [377, 1324, 0.0776143, 0.214713, 0.0116046, 63.11, 63.11, 63.11, 0.0, 0.0, 1, -30.0, 30.0],
        [378, 293, 0.0175258, 0.0419682, 0.000860319, 49.32, 49.32, 49.32, 0.0, 0.0, 1, -30.0, 30.0],
        [378, 355, 0.0148108, 0.0373677, 0.0013365, 58.19, 58.19, 58.19, 0.0, 0.0, 1, -30.0, 30.0],
        [378, 767, 0.0427946, 0.101626, 0.00645454, 71.72, 71.72, 71.72, 0.0, 0.0, 1, -30.0, 30.0],
        [378, 767, 0.0427946, 0.101626, 0.00645454, 71.72, 71.72, 71.72, 0.0, 0.0, 1, -30.0, 30.0],
        [379, 351, 0.0293197, 0.0790878, 0.00304817, 77.61, 77.61, 77.61, 0.0, 0.0, 1, -30.0, 30.0],
        [382, 380, 0.00231669, 0.0113545, 0.0259543, 196.51, 196.51, 196.51, 0.0, 0.0, 1, -30.0, 30.0],
        [382, 384, 0.000258228, 0.00104364, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [383, 332, 0.00950631, 0.0219822, 0.00418232, 70.68, 70.68, 70.68, 0.0, 0.0, 1, -30.0, 30.0],
        [385, 442, 0.0297823, 0.0520536, 0.00222878, 47.04, 47.04, 47.04, 0.0, 0.0, 1, -30.0, 30.0],
        [385, 444, 0.0177231, 0.0435273, 0.00281456, 59.47, 59.47, 59.47, 0.0, 0.0, 1, -30.0, 30.0],
        [386, 388, 0.000244136, 0.00118642, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [386, 402, 0.00427, 0.027073, 0.009136, 300.0, 300.0, 300.0, 0.0, 0.0, 1, -30.0, 30.0],
        [386, 452, 0.00146413, 0.00966915, 0.0242681, 272.88, 272.88, 272.88, 0.0, 0.0, 1, -30.0, 30.0],
        [386, 452, 0.00146413, 0.00966915, 0.0242681, 300.36, 300.36, 300.36, 0.0, 0.0, 1, -30.0, 30.0],
        [386, 456, 0.0016233, 0.00868473, 0.0222886, 243.27, 243.27, 243.27, 0.0, 0.0, 1, -30.0, 30.0],
        [386, 580, 0.00478209, 0.02449, 0.0390124, 290.43, 290.43, 290.43, 0.0, 0.0, 1, -30.0, 30.0],
        [386, 580, 0.00478209, 0.02449, 0.0390124, 290.43, 290.43, 290.43, 0.0, 0.0, 1, -30.0, 30.0],
        [386, 580, 0.00478209, 0.02449, 0.0390124, 290.43, 290.43, 290.43, 0.0, 0.0, 1, -30.0, 30.0],
        [389, 385, 0.0604683, 0.117095, 0.00208839, 64.55, 64.55, 64.55, 0.0, 0.0, 1, -30.0, 30.0],
        [389, 442, 0.0432462, 0.118757, 0.00183811, 64.94, 64.94, 64.94, 0.0, 0.0, 1, -30.0, 30.0],
        [390, 412, 0.0161109, 0.0459195, 0.002328, 51.85, 51.85, 51.85, 0.0, 0.0, 1, -30.0, 30.0],
        [390, 510, 0.0225583, 0.0637642, 0.00124958, 59.89, 59.89, 59.89, 0.0, 0.0, 1, -30.0, 30.0],
        [390, 586, 0.0158029, 0.0351765, 0.00161802, 70.88, 70.88, 70.88, 0.0, 0.0, 1, -30.0, 30.0],
        [391, 390, 0.0336393, 0.0875983, 0.00248688, 61.77, 61.77, 61.77, 0.0, 0.0, 1, -30.0, 30.0],
        [391, 413, 0.0106799, 0.0306683, 0.0172391, 76.63, 76.63, 76.63, 0.0, 0.0, 1, -30.0, 30.0],
        [391, 413, 0.0106799, 0.0306683, 0.0172391, 76.63, 76.63, 76.63, 0.0, 0.0, 1, -30.0, 30.0],
        [391, 445, 0.0154834, 0.0452914, 0.00800259, 52.17, 52.17, 52.17, 0.0, 0.0, 1, -30.0, 30.0],
        [391, 510, 0.026748, 0.0619051, 0.00481447, 89.09, 89.09, 89.09, 0.0, 0.0, 1, -30.0, 30.0],
        [391, 510, 0.026748, 0.0619051, 0.00481447, 89.09, 89.09, 89.09, 0.0, 0.0, 1, -30.0, 30.0],
        [392, 412, 0.0296456, 0.064913, 0.00337362, 57.89, 57.89, 57.89, 0.0, 0.0, 1, -30.0, 30.0],
        [393, 417, 0.0585051, 0.141084, 0.00817711, 55.23, 55.23, 55.23, 0.0, 0.0, 1, -30.0, 30.0],
        [393, 510, 0.0728571, 0.139097, 0.00514625, 62.75, 62.75, 62.75, 0.0, 0.0, 1, -30.0, 30.0],
        [394, 389, 0.0318131, 0.0857575, 0.00248271, 50.07, 50.07, 50.07, 0.0, 0.0, 1, -30.0, 30.0],
        [395, 397, 0.000277085, 0.00105959, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [395, 437, 0.00179496, 0.019137, 0.294723, 1128.12, 1128.12, 1128.12, 0.0, 0.0, 1, -30.0, 30.0],
        [395, 460, 0.00104578, 0.0131307, 0.239975, 1076.88, 1076.88, 1076.88, 0.0, 0.0, 1, -30.0, 30.0],
        [396, 408, 0.00215271, 0.013271, 0.00507087, 258.4, 258.4, 258.4, 0.0, 0.0, 1, -30.0, 30.0],
        [396, 466, 0.00695835, 0.0428867, 0.0316844, 245.14, 245.14, 245.14, 0.0, 0.0, 1, -30.0, 30.0],
        [396, 491, 0.00714193, 0.0390073, 0.0659368, 220.66, 220.66, 220.66, 0.0, 0.0, 1, -30.0, 30.0],
        [398, 396, 0.00292931, 0.0160831, 0.0197493, 208.19, 208.19, 208.19, 0.0, 0.0, 1, -30.0, 30.0],
        [399, 589, 0.000581322, 0.00700932, 0.121409, 1088.44, 1088.44, 1088.44, 0.0, 0.0, 1, -30.0, 30.0],
        [400, 402, 0.000202042, 0.00114628, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [401, 433, 0.105643, 0.203936, 0.00414125, 58.64, 58.64, 58.64, 0.0, 0.0, 1, -30.0, 30.0],
        [401, 455, 0.0342677, 0.0698818, 0.00674977, 94.89, 94.89, 94.89, 0.0, 0.0, 1, -30.0, 30.0],
        [402, 411, 0.00749457, 0.0327197, 0.0193924, 250.0, 250.0, 250.0, 0.0, 0.0, 1, -30.0, 30.0],
        [402, 436, 0.00861, 0.043883, 0.027116, 300.0, 300.0, 300.0, 0.0, 0.0, 1, -30.0, 30.0],
        [403, 387, 0.00787192, 0.0220761, 0.00278301, 48.17, 48.17, 48.17, 0.0, 0.0, 1, -30.0, 30.0],
        [403, 412, 0.0250134, 0.0592279, 0.00167919, 57.07, 57.07, 57.07, 0.0, 0.0, 1, -30.0, 30.0],
        [403, 586, 0.0258492, 0.0819625, 0.00329823, 65.07, 65.07, 65.07, 0.0, 0.0, 1, -30.0, 30.0],
        [404, 415, 0.0288787, 0.0748193, 0.00237248, 56.67, 56.67, 56.67, 0.0, 0.0, 1, -30.0, 30.0],
        [404, 442, 0.0537734, 0.129782, 0.00457646, 69.09, 69.09, 69.09, 0.0, 0.0, 1, -30.0, 30.0],
        [404, 497, 0.0241792, 0.0516142, 0.00359434, 42.22, 42.22, 42.22, 0.0, 0.0, 1, -30.0, 30.0],
        [405, 394, 0.0175903, 0.0383734, 0.00207393, 73.5, 73.5, 73.5, 0.0, 0.0, 1, -30.0, 30.0],
        [406, 408, 0.000243949, 0.00107676, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [407, 405, 0.0286997, 0.0696851, 0.0027308, 77.68, 77.68, 77.68, 0.0, 0.0, 1, -30.0, 30.0],
        [407, 453, 0.034111, 0.0862441, 0.00202472, 73.97, 73.97, 73.97, 0.0, 0.0, 1, -30.0, 30.0],
        [408, 414, 0.00211638, 0.0156873, 0.0086825, 228.03, 228.03, 228.03, 0.0, 0.0, 1, -30.0, 30.0],
        [409, 451, 0.0315738, 0.0854312, 0.00260873, 83.27, 83.27, 83.27, 0.0, 0.0, 1, -30.0, 30.0],
        [410, 391, 0.034233, 0.0731398, 0.00146497, 124.45, 124.45, 124.45, 0.0, 0.0, 1, -30.0, 30.0],
        [410, 423, 0.0249609, 0.0714427, 0.00187938, 94.04, 94.04, 94.04, 0.0, 0.0, 1, -30.0, 30.0],
        [411, 449, 0.008453, 0.059812, 0.017865, 260.0, 260.0, 260.0, 0.0, 0.0, 1, -30.0, 30.0],
        [412, 413, 0.0435537, 0.0895344, 0.00444916, 69.39, 69.39, 69.39, 0.0, 0.0, 1, -30.0, 30.0],
        [413, 385, 0.0432435, 0.0783139, 0.00251483, 90.95, 90.95, 90.95, 0.0, 0.0, 1, -30.0, 30.0],
        [413, 385, 0.0432435, 0.0783139, 0.00251483, 90.95, 90.95, 90.95, 0.0, 0.0, 1, -30.0, 30.0],
        [413, 387, 0.0422043, 0.0946154, 0.00438343, 64.3, 64.3, 64.3, 0.0, 0.0, 1, -30.0, 30.0],
        [414, 441, 0.00259802, 0.0179968, 0.0224203, 248.06, 248.06, 248.06, 0.0, 0.0, 1, -30.0, 30.0],
        [414, 585, 0.00923266, 0.0385886, 0.0204909, 260.12, 260.12, 260.12, 0.0, 0.0, 1, -30.0, 30.0],
        [414, 585, 0.00923266, 0.0385886, 0.0204909, 260.12, 260.12, 260.12, 0.0, 0.0, 1, -30.0, 30.0],
        [415, 421, 0.0759055, 0.20292, 0.0049787, 78.47, 78.47, 78.47, 0.0, 0.0, 1, -30.0, 30.0],
        [417, 416, 0.0379531, 0.0878657, 0.00361774, 52.16, 52.16, 52.16, 0.0, 0.0, 1, -30.0, 30.0],
        [418, 420, 0.000264767, 0.00108648, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [418, 425, 0.00880593, 0.0375741, 0.0221572, 223.14, 223.14, 223.14, 0.0, 0.0, 1, -30.0, 30.0],
        [419, 416, 0.0874754, 0.176002, 0.00458207, 60.12, 60.12, 60.12, 0.0, 0.0, 1, -30.0, 30.0],
        [421, 426, 0.0377491, 0.0982433, 0.00405683, 73.82, 73.82, 73.82, 0.0, 0.0, 1, -30.0, 30.0],
        [421, 426, 0.0377491, 0.0982433, 0.00405683, 73.82, 73.82, 73.82, 0.0, 0.0, 1, -30.0, 30.0],
        [422, 439, 0.0203025, 0.117194, 0.0458186, 193.2, 193.2, 193.2, 0.0, 0.0, 1, -30.0, 30.0],
        [422, 517, 0.00907183, 0.045431, 0.0087331, 225.91, 225.91, 225.91, 0.0, 0.0, 1, -30.0, 30.0],
        [424, 427, 0.000251118, 0.00114715, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [424, 493, 0.000673159, 0.0079741, 0.148368, 1210.14, 1210.14, 1210.14, 0.0, 0.0, 1, -30.0, 30.0],
        [424, 508, 0.000686559, 0.00954996, 0.162328, 1460.96, 1460.96, 1460.96, 0.0, 0.0, 1, -30.0, 30.0],
        [424, 589, 0.00115973, 0.0126146, 0.185507, 1165.1, 1165.1, 1165.1, 0.0, 0.0, 1, -30.0, 30.0],
        [428, 430, 0.000209184, 0.00111768, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [428, 436, 0.00386565, 0.0279591, 0.013579, 242.88, 242.88, 242.88, 0.0, 0.0, 1, -30.0, 30.0],
        [432, 1039, 0.00864131, 0.0301675, 0.0433844, 221.58, 221.58, 221.58, 0.0, 0.0, 1, -30.0, 30.0],
        [433, 450, 0.0347978, 0.10953, 0.0040882, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [434, 429, 0.0253428, 0.068197, 0.00138519, 49.76, 49.76, 49.76, 0.0, 0.0, 1, -30.0, 30.0],
        [434, 1031, 0.054973, 0.115017, 0.00522475, 65.25, 65.25, 65.25, 0.0, 0.0, 1, -30.0, 30.0],
        [434, 1036, 0.0341747, 0.107152, 0.0105116, 73.61, 73.61, 73.61, 0.0, 0.0, 1, -30.0, 30.0],
        [434, 1036, 0.0341747, 0.107152, 0.0105116, 73.61, 73.61, 73.61, 0.0, 0.0, 1, -30.0, 30.0],
        [435, 437, 0.000281677, 0.00106079, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [438, 1030, 0.0452408, 0.102192, 0.00388413, 60.68, 60.68, 60.68, 0.0, 0.0, 1, -30.0, 30.0],
        [438, 1031, 0.0299069, 0.0823226, 0.00261149, 57.9, 57.9, 57.9, 0.0, 0.0, 1, -30.0, 30.0],
        [440, 451, 0.0429224, 0.110053, 0.00834297, 55.85, 55.85, 55.85, 0.0, 0.0, 1, -30.0, 30.0],
        [441, 443, 0.000285687, 0.00108041, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [442, 444, 0.0100829, 0.0305775, 0.00530311, 64.4, 64.4, 64.4, 0.0, 0.0, 1, -30.0, 30.0],
        [445, 393, 0.0187618, 0.0505159, 0.00213582, 56.74, 56.74, 56.74, 0.0, 0.0, 1, -30.0, 30.0],
        [445, 421, 0.03, 0.09, 0.0, 95.0, 95.0, 95.0, 0.0, 0.0, 1, -30.0, 30.0],
        [445, 510, 0.0448384, 0.0908994, 0.00242404, 68.52, 68.52, 68.52, 0.0, 0.0, 1, -30.0, 30.0],
        [446, 392, 0.0390815, 0.0926408, 0.00854504, 56.9, 56.9, 56.9, 0.0, 0.0, 1, -30.0, 30.0],
        [446, 393, 0.0499776, 0.120889, 0.00604835, 43.58, 43.58, 43.58, 0.0, 0.0, 1, -30.0, 30.0],
        [447, 449, 0.000284878, 0.00114452, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [448, 1036, 0.0207054, 0.0599342, 0.00159965, 67.87, 67.87, 67.87, 0.0, 0.0, 1, -30.0, 30.0],
        [449, 505, 0.00666894, 0.0395423, 0.0959218, 204.3, 204.3, 204.3, 0.0, 0.0, 1, -30.0, 30.0],
        [449, 1035, 0.00301597, 0.018425, 0.00471112, 300.0, 300.0, 300.0, 0.0, 0.0, 1, -30.0, 30.0],
        [450, 448, 0.0107543, 0.0325665, 0.00266332, 59.88, 59.88, 59.88, 0.0, 0.0, 1, -30.0, 30.0],
        [450, 1036, 0.0411956, 0.104205, 0.00335971, 61.46, 61.46, 61.46, 0.0, 0.0, 1, -30.0, 30.0],
        [451, 405, 0.0298137, 0.0660426, 0.00207833, 81.23, 81.23, 81.23, 0.0, 0.0, 1, -30.0, 30.0],
        [452, 398, 0.00236686, 0.0199324, 0.00597405, 231.26, 231.26, 231.26, 0.0, 0.0, 1, -30.0, 30.0],
        [452, 408, 0.00392017, 0.0183317, 0.00795507, 237.43, 237.43, 237.43, 0.0, 0.0, 1, -30.0, 30.0],
        [452, 454, 0.000270392, 0.00106477, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [455, 409, 0.0297164, 0.0859446, 0.00531282, 61.54, 61.54, 61.54, 0.0, 0.0, 1, -30.0, 30.0],
        [455, 457, 0.0404006, 0.0845445, 0.00322629, 59.36, 59.36, 59.36, 0.0, 0.0, 1, -30.0, 30.0],
        [456, 458, 0.000294859, 0.00101228, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [457, 409, 0.0209773, 0.0583183, 0.0013764, 73.78, 73.78, 73.78, 0.0, 0.0, 1, -30.0, 30.0],
        [457, 409, 0.0209773, 0.0583183, 0.0013764, 73.78, 73.78, 73.78, 0.0, 0.0, 1, -30.0, 30.0],
        [461, 463, 0.000246305, 0.00119604, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [462, 459, 0.0252774, 0.0734003, 0.00744006, 68.44, 68.44, 68.44, 0.0, 0.0, 1, -30.0, 30.0],
        [462, 476, 0.0359618, 0.0921016, 0.00302888, 62.32, 62.32, 62.32, 0.0, 0.0, 1, -30.0, 30.0],
        [464, 465, 0.000222454, 0.00108643, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [465, 462, 0.00741313, 0.020925, 0.00172467, 91.92, 91.92, 91.92, 0.0, 0.0, 1, -30.0, 30.0],
        [465, 467, 0.0474882, 0.093519, 0.00341147, 60.21, 60.21, 60.21, 0.0, 0.0, 1, -30.0, 30.0],
        [465, 469, 0.0101793, 0.0332979, 0.00514143, 82.36, 82.36, 82.36, 0.0, 0.0, 1, -30.0, 30.0],
        [466, 468, 0.000277237, 0.00108451, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [467, 462, 0.013358, 0.0305045, 0.00766566, 68.58, 68.58, 68.58, 0.0, 0.0, 1, -30.0, 30.0],
        [467, 492, 0.0329171, 0.0704787, 0.00287169, 69.6, 69.6, 69.6, 0.0, 0.0, 1, -30.0, 30.0],
        [469, 459, 0.0196391, 0.043138, 0.00275772, 54.24, 54.24, 54.24, 0.0, 0.0, 1, -30.0, 30.0],
        [469, 471, 0.0289019, 0.0707348, 0.00306849, 58.64, 58.64, 58.64, 0.0, 0.0, 1, -30.0, 30.0],
        [469, 476, 0.0072701, 0.026056, 0.00145959, 52.62, 52.62, 52.62, 0.0, 0.0, 1, -30.0, 30.0],
        [469, 479, 0.01058, 0.0261333, 0.00169246, 71.63, 71.63, 71.63, 0.0, 0.0, 1, -30.0, 30.0],
        [470, 475, 0.0079998, 0.0433286, 0.0138769, 208.02, 208.02, 208.02, 0.0, 0.0, 1, -30.0, 30.0],
        [471, 472, 0.044425, 0.0803654, 0.00469518, 59.67, 59.67, 59.67, 0.0, 0.0, 1, -30.0, 30.0],
        [471, 479, 0.0158062, 0.0454819, 0.00127368, 72.29, 72.29, 72.29, 0.0, 0.0, 1, -30.0, 30.0],
        [472, 473, 0.0442321, 0.0945649, 0.0129027, 64.42, 64.42, 64.42, 0.0, 0.0, 1, -30.0, 30.0],
        [472, 483, 0.0650464, 0.1489, 0.0041117, 70.8, 70.8, 70.8, 0.0, 0.0, 1, -30.0, 30.0],
        [474, 481, 0.000710867, 0.00773603, 0.236903, 1040.2, 1040.2, 1040.2, 0.0, 0.0, 1, -30.0, 30.0],
        [476, 477, 0.0271127, 0.0679739, 0.00116003, 60.41, 60.41, 60.41, 0.0, 0.0, 1, -30.0, 30.0],
        [478, 470, 0.0036415, 0.0208313, 0.0101581, 191.24, 191.24, 191.24, 0.0, 0.0, 1, -30.0, 30.0],
        [478, 480, 0.000298201, 0.00107643, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [478, 482, 0.0052881, 0.0355904, 0.00979982, 223.22, 223.22, 223.22, 0.0, 0.0, 1, -30.0, 30.0],
        [478, 494, 0.0156312, 0.0923045, 0.0231802, 204.95, 204.95, 204.95, 0.0, 0.0, 1, -30.0, 30.0],
        [479, 476, 0.0245802, 0.0474335, 0.0017234, 62.84, 62.84, 62.84, 0.0, 0.0, 1, -30.0, 30.0],
        [481, 460, 0.000475113, 0.0051749, 0.138541, 963.3, 963.3, 963.3, 0.0, 0.0, 1, -30.0, 30.0],
        [481, 484, 0.000201883, 0.00100337, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [481, 493, 0.000809159, 0.00912012, 0.19516, 1129.11, 1129.11, 1129.11, 0.0, 0.0, 1, -30.0, 30.0],
        [485, 488, 0.057847, 0.150789, 0.00277297, 57.88, 57.88, 57.88, 0.0, 0.0, 1, -30.0, 30.0],
        [486, 415, 0.0382998, 0.110103, 0.00637809, 65.51, 65.51, 65.51, 0.0, 0.0, 1, -30.0, 30.0],
        [486, 502, 0.1119, 0.241525, 0.0056541, 59.82, 59.82, 59.82, 0.0, 0.0, 1, -30.0, 30.0],
        [487, 489, 0.000236173, 0.00104634, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [487, 494, 0.00575006, 0.0362927, 0.0148317, 280.27, 280.27, 280.27, 0.0, 0.0, 1, -30.0, 30.0],
        [488, 486, 0.0162547, 0.0435781, 0.00241054, 74.06, 74.06, 74.06, 0.0, 0.0, 1, -30.0, 30.0],
        [488, 502, 0.0585716, 0.151717, 0.0144133, 69.65, 69.65, 69.65, 0.0, 0.0, 1, -30.0, 30.0],
        [490, 486, 0.0506362, 0.161036, 0.00225104, 46.75, 46.75, 46.75, 0.0, 0.0, 1, -30.0, 30.0],
        [490, 488, 0.0307783, 0.0708472, 0.00194737, 64.35, 64.35, 64.35, 0.0, 0.0, 1, -30.0, 30.0],
        [491, 463, 0.00423815, 0.0278445, 0.00972451, 191.34, 191.34, 191.34, 0.0, 0.0, 1, -30.0, 30.0],
        [492, 462, 0.0257456, 0.0745021, 0.00366604, 61.94, 61.94, 61.94, 0.0, 0.0, 1, -30.0, 30.0],
        [492, 485, 0.034543, 0.076582, 0.00324468, 84.22, 84.22, 84.22, 0.0, 0.0, 1, -30.0, 30.0],
        [493, 495, 0.0002233, 0.00109985, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [496, 494, 0.00681298, 0.0265828, 0.023494, 197.52, 197.52, 197.52, 0.0, 0.0, 1, -30.0, 30.0],
        [498, 487, 0.021974, 0.0811351, 0.024, 192.31, 192.31, 192.31, 0.0, 0.0, 1, -30.0, 30.0],
        [498, 500, 0.0100924, 0.0636365, 0.0178899, 201.52, 201.52, 201.52, 0.0, 0.0, 1, -30.0, 30.0],
        [499, 424, 0.000670279, 0.00727137, 0.184284, 1200.56, 1200.56, 1200.56, 0.0, 0.0, 1, -30.0, 30.0],
        [499, 501, 0.000224141, 0.00106808, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [500, 347, 0.00555165, 0.028056, 0.062152, 259.53, 259.53, 259.53, 0.0, 0.0, 1, -30.0, 30.0],
        [500, 347, 0.00555165, 0.028056, 0.062152, 259.53, 259.53, 259.53, 0.0, 0.0, 1, -30.0, 30.0],
        [500, 347, 0.00555165, 0.028056, 0.062152, 259.53, 259.53, 259.53, 0.0, 0.0, 1, -30.0, 30.0],
        [503, 471, 0.0993019, 0.289024, 0.00611307, 53.32, 53.32, 53.32, 0.0, 0.0, 1, -30.0, 30.0],
        [503, 472, 0.0418333, 0.125781, 0.00630877, 50.96, 50.96, 50.96, 0.0, 0.0, 1, -30.0, 30.0],
        [504, 505, 0.000257035, 0.00112928, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [506, 1029, 0.0485512, 0.119387, 0.00594082, 56.62, 56.62, 56.62, 0.0, 0.0, 1, -30.0, 30.0],
        [506, 1038, 0.00935266, 0.0177848, 0.00154938, 74.26, 74.26, 74.26, 0.0, 0.0, 1, -30.0, 30.0],
        [506, 1040, 0.0240701, 0.0599962, 0.00181884, 70.24, 70.24, 70.24, 0.0, 0.0, 1, -30.0, 30.0],
        [507, 1047, 0.0233893, 0.0509651, 0.00834795, 71.82, 71.82, 71.82, 0.0, 0.0, 1, -30.0, 30.0],
        [508, 589, 0.000301302, 0.0032465, 0.0573886, 1482.04, 1482.04, 1482.04, 0.0, 0.0, 1, -30.0, 30.0],
        [509, 517, 0.000291849, 0.00102047, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [510, 586, 0.0191262, 0.0489876, 0.0038594, 67.2, 67.2, 67.2, 0.0, 0.0, 1, -30.0, 30.0],
        [517, 580, 0.00118382, 0.00665146, 0.00135904, 437.23, 437.23, 437.23, 0.0, 0.0, 1, -30.0, 30.0],
        [517, 585, 0.00367489, 0.020074, 0.00918435, 205.59, 205.59, 205.59, 0.0, 0.0, 1, -30.0, 30.0],
        [518, 519, 0.000299553, 0.00106906, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [520, 524, 0.000203605, 0.00108109, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [521, 71, 0.008, 0.05, 0.0, 200.0, 200.0, 200.0, 0.0, 0.0, 1, -30.0, 30.0],
        [521, 534, 0.00043939, 0.00196345, 0.0020824, 380.93, 380.93, 380.93, 0.0, 0.0, 1, -30.0, 30.0],
        [521, 538, 0.000503702, 0.00320583, 0.00173554, 273.45, 273.45, 273.45, 0.0, 0.0, 1, -30.0, 30.0],
        [521, 538, 0.000503702, 0.00320583, 0.00173554, 273.45, 273.45, 273.45, 0.0, 0.0, 1, -30.0, 30.0],
        [524, 52, 0.00035603, 0.00431534, 0.105758, 1272.01, 1272.01, 1272.01, 0.0, 0.0, 1, -30.0, 30.0],
        [525, 526, 0.000276778, 0.00101188, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [526, 49, 0.0201832, 0.0535213, 0.00305879, 60.94, 60.94, 60.94, 0.0, 0.0, 1, -30.0, 30.0],
        [526, 56, 0.0150892, 0.041224, 0.00329562, 60.97, 60.97, 60.97, 0.0, 0.0, 1, -30.0, 30.0],
        [527, 534, 0.000201707, 0.0011085, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [535, 538, 0.000215984, 0.00110514, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [538, 534, 0.000721221, 0.00415843, 0.00147252, 269.89, 269.89, 269.89, 0.0, 0.0, 1, -30.0, 30.0],
        [538, 534, 0.000721221, 0.00415843, 0.00147252, 269.89, 269.89, 269.89, 0.0, 0.0, 1, -30.0, 30.0],
        [539, 540, 0.000273748, 0.00101978, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [540, 82, 0.0963456, 0.190976, 0.00681037, 55.88, 55.88, 55.88, 0.0, 0.0, 1, -30.0, 30.0],
        [541, 548, 0.000265133, 0.0010262, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [548, 247, 0.00303929, 0.0148098, 0.00535043, 208.67, 208.67, 208.67, 0.0, 0.0, 1, -30.0, 30.0],
        [549, 553, 0.000278953, 0.00107311, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [550, 1174, 0.00437215, 0.0280295, 0.0108636, 339.68, 339.68, 339.68, 0.0, 0.0, 1, -30.0, 30.0],
        [553, 1164, 0.000495779, 0.0061559, 0.107324, 1108.88, 1108.88, 1108.88, 0.0, 0.0, 1, -30.0, 30.0],
        [553, 1327, 0.00121103, 0.0153621, 0.390008, 1157.64, 1157.64, 1157.64, 0.0, 0.0, 1, -30.0, 30.0],
        [554, 555, 0.000221241, 0.00115387, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [555, 1, 0.00269583, 0.0123455, 0.00884861, 266.49, 266.49, 266.49, 0.0, 0.0, 1, -30.0, 30.0],
        [555, 1, 0.00269583, 0.0123455, 0.00884861, 266.49, 266.49, 266.49, 0.0, 0.0, 1, -30.0, 30.0],
        [555, 1, 0.00269583, 0.0123455, 0.00884861, 266.49, 266.49, 266.49, 0.0, 0.0, 1, -30.0, 30.0],
        [556, 564, 0.00023886, 0.00118333, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [557, 246, 0.00835992, 0.0201846, 0.00103921, 129.27, 129.27, 129.27, 0.0, 0.0, 1, -30.0, 30.0],
        [564, 86, 0.00276173, 0.0169112, 0.0130245, 284.64, 284.64, 284.64, 0.0, 0.0, 1, -30.0, 30.0],
        [564, 86, 0.00276173, 0.0169112, 0.0130245, 284.64, 284.64, 284.64, 0.0, 0.0, 1, -30.0, 30.0],
        [564, 86, 0.00276173, 0.0169112, 0.0130245, 284.64, 284.64, 284.64, 0.0, 0.0, 1, -30.0, 30.0],
        [565, 105, 0.000927072, 0.0119612, 0.301387, 1429.69, 1429.69, 1429.69, 0.0, 0.0, 1, -30.0, 30.0],
        [565, 105, 0.000927072, 0.0119612, 0.301387, 1429.69, 1429.69, 1429.69, 0.0, 0.0, 1, -30.0, 30.0],
        [565, 105, 0.000927072, 0.0119612, 0.301387, 1429.69, 1429.69, 1429.69, 0.0, 0.0, 1, -30.0, 30.0],
        [565, 1476, 0.00127449, 0.0144722, 0.439266, 1561.24, 1561.24, 1561.24, 0.0, 0.0, 1, -30.0, 30.0],
        [565, 1476, 0.00127449, 0.0144722, 0.439266, 1561.24, 1561.24, 1561.24, 0.0, 0.0, 1, -30.0, 30.0],
        [566, 361, 0.00749039, 0.0387631, 0.0230975, 267.2, 267.2, 267.2, 0.0, 0.0, 1, -30.0, 30.0],
        [566, 361, 0.00749039, 0.0387631, 0.0230975, 267.2, 267.2, 267.2, 0.0, 0.0, 1, -30.0, 30.0],
        [566, 361, 0.00749039, 0.0387631, 0.0230975, 267.2, 267.2, 267.2, 0.0, 0.0, 1, -30.0, 30.0],
        [573, 580, 0.0002281, 0.00107203, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [580, 418, 0.0209399, 0.0789756, 0.0197633, 216.6, 216.6, 216.6, 0.0, 0.0, 1, -30.0, 30.0],
        [580, 585, 0.00489002, 0.0304278, 0.00617626, 210.43, 210.43, 210.43, 0.0, 0.0, 1, -30.0, 30.0],
        [581, 583, 0.000248157, 0.00105837, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [582, 75, 0.0837778, 0.187267, 0.00360086, 76.05, 76.05, 76.05, 0.0, 0.0, 1, -30.0, 30.0],
        [583, 76, 0.0114181, 0.0684986, 0.016999, 154.31, 154.31, 154.31, 0.0, 0.0, 1, -30.0, 30.0],
        [584, 589, 0.000297423, 0.00108592, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [586, 392, 0.027532, 0.069418, 0.00165736, 69.8, 69.8, 69.8, 0.0, 0.0, 1, -30.0, 30.0],
        [586, 412, 0.0173138, 0.0384023, 0.00207949, 77.48, 77.48, 77.48, 0.0, 0.0, 1, -30.0, 30.0],
        [586, 412, 0.0173138, 0.0384023, 0.00207949, 77.48, 77.48, 77.48, 0.0, 0.0, 1, -30.0, 30.0],
        [590, 591, 0.000209049, 0.00115246, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [591, 310, 0.0199104, 0.0551306, 0.00221859, 65.71, 65.71, 65.71, 0.0, 0.0, 1, -30.0, 30.0],
        [591, 310, 0.0199104, 0.0551306, 0.00221859, 65.71, 65.71, 65.71, 0.0, 0.0, 1, -30.0, 30.0],
        [591, 360, 0.020504, 0.0386094, 0.00145339, 72.17, 72.17, 72.17, 0.0, 0.0, 1, -30.0, 30.0],
        [591, 360, 0.020504, 0.0386094, 0.00145339, 83.1, 83.1, 83.1, 0.0, 0.0, 1, -30.0, 30.0],
        [592, 598, 0.000290024, 0.00109186, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [593, 287, 0.00199447, 0.0107065, 0.00552222, 339.88, 339.88, 339.88, 0.0, 0.0, 1, -30.0, 30.0],
        [593, 287, 0.00199447, 0.0107065, 0.00552222, 339.88, 339.88, 339.88, 0.0, 0.0, 1, -30.0, 30.0],
        [598, 337, 0.000480088, 0.00629871, 0.187159, 1266.92, 1266.92, 1266.92, 0.0, 0.0, 1, -30.0, 30.0],
        [598, 1366, 0.0019562, 0.0217613, 0.419969, 1665.08, 1665.08, 1665.08, 0.0, 0.0, 1, -30.0, 30.0],
        [599, 600, 0.000209344, 0.00112736, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [600, 519, 0.0105157, 0.0251478, 0.00180325, 53.8, 53.8, 53.8, 0.0, 0.0, 1, -30.0, 30.0],
        [601, 602, 0.0455539, 0.10164, 0.00276018, 70.97, 70.97, 70.97, 0.0, 0.0, 1, -30.0, 30.0],
        [601, 616, 0.0252845, 0.0598286, 0.00138346, 102.97, 102.97, 102.97, 0.0, 0.0, 1, -30.0, 30.0],
        [602, 1118, 0.0382385, 0.0936161, 0.00593235, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [603, 616, 0.0208807, 0.0514828, 0.00145363, 93.14, 93.14, 93.14, 0.0, 0.0, 1, -30.0, 30.0],
        [603, 665, 0.0156538, 0.034826, 0.00390441, 44.76, 44.76, 44.76, 0.0, 0.0, 1, -30.0, 30.0],
        [603, 1144, 0.0225162, 0.0680801, 0.0058515, 54.23, 54.23, 54.23, 0.0, 0.0, 1, -30.0, 30.0],
        [603, 1147, 0.039941, 0.0707324, 0.00635831, 67.22, 67.22, 67.22, 0.0, 0.0, 1, -30.0, 30.0],
        [603, 1147, 0.039941, 0.0707324, 0.00635831, 67.22, 67.22, 67.22, 0.0, 0.0, 1, -30.0, 30.0],
        [604, 619, 0.00333519, 0.0244102, 0.033561, 202.52, 202.52, 202.52, 0.0, 0.0, 1, -30.0, 30.0],
        [604, 630, 0.00264824, 0.0132312, 0.0159338, 248.07, 248.07, 248.07, 0.0, 0.0, 1, -30.0, 30.0],
        [605, 607, 0.00022901, 0.0010451, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [606, 629, 0.0289642, 0.0754662, 0.00360247, 58.13, 58.13, 58.13, 0.0, 0.0, 1, -30.0, 30.0],
        [607, 1807, 0.00901977, 0.0349668, 0.00281924, 119.95, 119.95, 119.95, 0.0, 0.0, 1, -30.0, 30.0],
        [608, 634, 0.0167604, 0.0479626, 0.00449652, 66.97, 66.97, 66.97, 0.0, 0.0, 1, -30.0, 30.0],
        [608, 634, 0.0167604, 0.0479626, 0.00449652, 66.97, 66.97, 66.97, 0.0, 0.0, 1, -30.0, 30.0],
        [608, 674, 0.0168862, 0.0388489, 0.000755531, 57.78, 57.78, 57.78, 0.0, 0.0, 1, -30.0, 30.0],
        [609, 612, 0.000248257, 0.00106075, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [609, 1128, 0.00118283, 0.011943, 0.363774, 1213.1, 1213.1, 1213.1, 0.0, 0.0, 1, -30.0, 30.0],
        [609, 1998, 0.000624398, 0.00766225, 0.147014, 1230.3, 1230.3, 1230.3, 0.0, 0.0, 1, -30.0, 30.0],
        [610, 604, 0.00261782, 0.01613, 0.00579452, 255.4, 255.4, 255.4, 0.0, 0.0, 1, -30.0, 30.0],
        [610, 604, 0.00261782, 0.01613, 0.00579452, 255.4, 255.4, 255.4, 0.0, 0.0, 1, -30.0, 30.0],
        [610, 623, 0.00547359, 0.0306937, 0.028542, 258.18, 258.18, 258.18, 0.0, 0.0, 1, -30.0, 30.0],
        [610, 623, 0.00547359, 0.0306937, 0.028542, 258.18, 258.18, 258.18, 0.0, 0.0, 1, -30.0, 30.0],
        [611, 606, 0.0127515, 0.0296475, 0.00252512, 70.46, 70.46, 70.46, 0.0, 0.0, 1, -30.0, 30.0],
        [611, 606, 0.0127515, 0.0296475, 0.00252512, 70.46, 70.46, 70.46, 0.0, 0.0, 1, -30.0, 30.0],
        [611, 628, 0.0230039, 0.0563837, 0.00177659, 70.91, 70.91, 70.91, 0.0, 0.0, 1, -30.0, 30.0],
        [611, 628, 0.0230039, 0.0563837, 0.00177659, 70.91, 70.91, 70.91, 0.0, 0.0, 1, -30.0, 30.0],
        [611, 659, 0.0268642, 0.0525058, 0.00284657, 90.43, 90.43, 90.43, 0.0, 0.0, 1, -30.0, 30.0],
        [611, 664, 0.0192571, 0.047837, 0.000974305, 68.53, 68.53, 68.53, 0.0, 0.0, 1, -30.0, 30.0],
        [611, 664, 0.0192571, 0.047837, 0.000974305, 68.53, 68.53, 68.53, 0.0, 0.0, 1, -30.0, 30.0],
        [613, 624, 0.0153157, 0.0343128, 0.00165211, 67.46, 67.46, 67.46, 0.0, 0.0, 1, -30.0, 30.0],
        [614, 1146, 0.00415961, 0.0242993, 0.00988136, 203.61, 203.61, 203.61, 0.0, 0.0, 1, -30.0, 30.0],
        [615, 617, 0.00021665, 0.00113098, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [617, 1797, 0.00815072, 0.033422, 0.00403181, 133.5, 133.5, 133.5, 0.0, 0.0, 1, -30.0, 30.0],
        [618, 601, 0.0132332, 0.0359223, 0.00144367, 68.25, 68.25, 68.25, 0.0, 0.0, 1, -30.0, 30.0],
        [618, 601, 0.0132332, 0.0359223, 0.00144367, 68.25, 68.25, 68.25, 0.0, 0.0, 1, -30.0, 30.0],
        [620, 622, 0.000247529, 0.00115365, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [621, 613, 0.0282131, 0.0775253, 0.00294983, 59.39, 59.39, 59.39, 0.0, 0.0, 1, -30.0, 30.0],
        [622, 1811, 0.0238733, 0.0891712, 0.0129275, 126.42, 126.42, 126.42, 0.0, 0.0, 1, -30.0, 30.0],
        [623, 614, 0.00724767, 0.0390628, 0.0121625, 204.33, 204.33, 204.33, 0.0, 0.0, 1, -30.0, 30.0],
        [624, 618, 0.0162984, 0.0487863, 0.00170192, 73.63, 73.63, 73.63, 0.0, 0.0, 1, -30.0, 30.0],
        [624, 618, 0.0162984, 0.0487863, 0.00170192, 86.62, 86.62, 86.62, 0.0, 0.0, 1, -30.0, 30.0],
        [624, 657, 0.0307961, 0.0845802, 0.00409009, 66.1, 66.1, 66.1, 0.0, 0.0, 1, -30.0, 30.0],
        [625, 632, 0.0191459, 0.0588057, 0.00262151, 50.07, 50.07, 50.07, 0.0, 0.0, 1, -30.0, 30.0],
        [626, 648, 0.0524643, 0.142037, 0.00813611, 63.14, 63.14, 63.14, 0.0, 0.0, 1, -30.0, 30.0],
        [627, 690, 0.0101591, 0.047841, 0.0343353, 223.85, 223.85, 223.85, 0.0, 0.0, 1, -30.0, 30.0],
        [628, 606, 0.0175857, 0.0352162, 0.00133254, 71.85, 71.85, 71.85, 0.0, 0.0, 1, -30.0, 30.0],
        [628, 638, 0.0144741, 0.0319262, 0.0029036, 64.41, 64.41, 64.41, 0.0, 0.0, 1, -30.0, 30.0],
        [629, 632, 0.0116266, 0.0383602, 0.00117482, 48.37, 48.37, 48.37, 0.0, 0.0, 1, -30.0, 30.0],
        [630, 633, 0.000212428, 0.00116451, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [631, 1791, 0.00601784, 0.0267931, 0.00295831, 131.17, 131.17, 131.17, 0.0, 0.0, 1, -30.0, 30.0],
        [631, 1807, 0.0149384, 0.0674603, 0.00609337, 106.51, 106.51, 106.51, 0.0, 0.0, 1, -30.0, 30.0],
        [632, 1792, 0.0115648, 0.0299919, 0.00181599, 49.49, 49.49, 49.49, 0.0, 0.0, 1, -30.0, 30.0],
        [634, 644, 0.0292303, 0.072831, 0.00146895, 61.27, 61.27, 61.27, 0.0, 0.0, 1, -30.0, 30.0],
        [634, 691, 0.0229108, 0.0593961, 0.00155861, 75.48, 75.48, 75.48, 0.0, 0.0, 1, -30.0, 30.0],
        [634, 691, 0.0229108, 0.0593961, 0.00155861, 88.9, 88.9, 88.9, 0.0, 0.0, 1, -30.0, 30.0],
        [635, 626, 0.0924319, 0.280079, 0.00513052, 58.66, 58.66, 58.66, 0.0, 0.0, 1, -30.0, 30.0],
        [635, 689, 0.0625344, 0.128086, 0.00501518, 45.48, 45.48, 45.48, 0.0, 0.0, 1, -30.0, 30.0],
        [635, 1808, 0.0390315, 0.0880232, 0.00589063, 53.84, 53.84, 53.84, 0.0, 0.0, 1, -30.0, 30.0],
        [636, 635, 0.0530784, 0.135524, 0.00338162, 48.79, 48.79, 48.79, 0.0, 0.0, 1, -30.0, 30.0],
        [637, 610, 0.00430347, 0.0253321, 0.00727546, 233.77, 233.77, 233.77, 0.0, 0.0, 1, -30.0, 30.0],
        [639, 640, 0.000232634, 0.00103046, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [639, 642, 0.0236557, 0.0596034, 0.00241568, 101.91, 101.91, 101.91, 0.0, 0.0, 1, -30.0, 30.0],
        [639, 643, 0.0199841, 0.0410373, 0.0116674, 59.23, 59.23, 59.23, 0.0, 0.0, 1, -30.0, 30.0],
        [639, 745, 0.0155288, 0.0385999, 0.011341, 109.23, 109.23, 109.23, 0.0, 0.0, 1, -30.0, 30.0],
        [641, 627, 0.00999977, 0.0483874, 0.0117947, 231.99, 231.99, 231.99, 0.0, 0.0, 1, -30.0, 30.0],
        [641, 1446, 0.006488, 0.0394316, 0.0103659, 246.53, 246.53, 246.53, 0.0, 0.0, 1, -30.0, 30.0],
        [643, 642, 0.017703, 0.0510591, 0.00434371, 83.32, 83.32, 83.32, 0.0, 0.0, 1, -30.0, 30.0],
        [644, 645, 0.000281571, 0.00116283, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [644, 1808, 0.015848, 0.0431067, 0.000879128, 40.91, 40.91, 40.91, 0.0, 0.0, 1, -30.0, 30.0],
        [646, 647, 0.000283355, 0.00116546, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [646, 688, 0.0473218, 0.119875, 0.00620503, 67.36, 67.36, 67.36, 0.0, 0.0, 1, -30.0, 30.0],
        [646, 688, 0.0473218, 0.119875, 0.00620503, 67.36, 67.36, 67.36, 0.0, 0.0, 1, -30.0, 30.0],
        [648, 642, 0.0172289, 0.0476638, 0.00283302, 67.59, 67.59, 67.59, 0.0, 0.0, 1, -30.0, 30.0],
        [648, 642, 0.0172289, 0.0476638, 0.00283302, 67.59, 67.59, 67.59, 0.0, 0.0, 1, -30.0, 30.0],
        [648, 649, 0.000230419, 0.00113639, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [650, 652, 0.000259806, 0.00115688, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [650, 1304, 0.0064262, 0.033085, 0.0238257, 273.86, 273.86, 273.86, 0.0, 0.0, 1, -30.0, 30.0],
        [650, 1304, 0.0064262, 0.033085, 0.0238257, 273.86, 273.86, 273.86, 0.0, 0.0, 1, -30.0, 30.0],
        [653, 651, 0.00620356, 0.0170441, 0.00242647, 78.84, 78.84, 78.84, 0.0, 0.0, 1, -30.0, 30.0],
        [653, 651, 0.00620356, 0.0170441, 0.00242647, 78.84, 78.84, 78.84, 0.0, 0.0, 1, -30.0, 30.0],
        [653, 651, 0.00620356, 0.0170441, 0.00242647, 78.84, 78.84, 78.84, 0.0, 0.0, 1, -30.0, 30.0],
        [653, 666, 0.0213244, 0.0515147, 0.00224652, 72.73, 72.73, 72.73, 0.0, 0.0, 1, -30.0, 30.0],
        [653, 666, 0.0213244, 0.0515147, 0.00224652, 72.73, 72.73, 72.73, 0.0, 0.0, 1, -30.0, 30.0],
        [654, 650, 0.00190006, 0.0141848, 0.00573083, 211.83, 211.83, 211.83, 0.0, 0.0, 1, -30.0, 30.0],
        [654, 673, 0.0024807, 0.0152767, 0.00775809, 230.27, 230.27, 230.27, 0.0, 0.0, 1, -30.0, 30.0],
        [654, 1268, 0.00887427, 0.0495665, 0.0184845, 253.25, 253.25, 253.25, 0.0, 0.0, 1, -30.0, 30.0],
        [655, 1422, 0.00350282, 0.0224734, 0.0189753, 186.81, 186.81, 186.81, 0.0, 0.0, 1, -30.0, 30.0],
        [656, 699, 0.0308025, 0.0729591, 0.00173524, 69.24, 69.24, 69.24, 0.0, 0.0, 1, -30.0, 30.0],
        [656, 699, 0.0308025, 0.0729591, 0.00173524, 69.24, 69.24, 69.24, 0.0, 0.0, 1, -30.0, 30.0],
        [656, 1153, 0.03269, 0.0813869, 0.00456483, 66.83, 66.83, 66.83, 0.0, 0.0, 1, -30.0, 30.0],
        [657, 1147, 0.0173338, 0.043371, 0.00173625, 105.81, 105.81, 105.81, 0.0, 0.0, 1, -30.0, 30.0],
        [658, 660, 0.000260686, 0.00114891, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [659, 608, 0.0119276, 0.0255981, 0.00417406, 88.15, 88.15, 88.15, 0.0, 0.0, 1, -30.0, 30.0],
        [659, 1353, 0.0179053, 0.0434677, 0.0145087, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [659, 1353, 0.0179053, 0.0434677, 0.0145087, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [660, 610, 0.00215342, 0.0190024, 0.00800481, 395.23, 395.23, 395.23, 0.0, 0.0, 1, -30.0, 30.0],
        [660, 673, 0.00291784, 0.0163853, 0.0119173, 245.54, 245.54, 245.54, 0.0, 0.0, 1, -30.0, 30.0],
        [661, 663, 0.000260289, 0.00117892, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [662, 666, 0.0126536, 0.0296745, 0.000792605, 84.37, 84.37, 84.37, 0.0, 0.0, 1, -30.0, 30.0],
        [662, 668, 0.0281889, 0.0768284, 0.00143102, 51.3, 51.3, 51.3, 0.0, 0.0, 1, -30.0, 30.0],
        [663, 637, 0.002987, 0.0182175, 0.00907401, 187.3, 187.3, 187.3, 0.0, 0.0, 1, -30.0, 30.0],
        [664, 1808, 0.04663, 0.110152, 0.00618656, 81.69, 81.69, 81.69, 0.0, 0.0, 1, -30.0, 30.0],
        [665, 1144, 0.0186888, 0.048373, 0.00165928, 58.99, 58.99, 58.99, 0.0, 0.0, 1, -30.0, 30.0],
        [666, 668, 0.00804715, 0.02013, 0.00247589, 73.49, 73.49, 73.49, 0.0, 0.0, 1, -30.0, 30.0],
        [667, 668, 0.000224572, 0.00103791, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [668, 1143, 0.0220687, 0.0504825, 0.00121542, 76.92, 76.92, 76.92, 0.0, 0.0, 1, -30.0, 30.0],
        [669, 651, 0.0175898, 0.0469284, 0.00275307, 123.96, 123.96, 123.96, 0.0, 0.0, 1, -30.0, 30.0],
        [669, 653, 0.0154637, 0.0295173, 0.001706, 70.53, 70.53, 70.53, 0.0, 0.0, 1, -30.0, 30.0],
        [669, 704, 0.0124503, 0.0313695, 0.00253688, 104.53, 104.53, 104.53, 0.0, 0.0, 1, -30.0, 30.0],
        [670, 697, 0.033002, 0.0800743, 0.00595662, 117.32, 117.32, 117.32, 0.0, 0.0, 1, -30.0, 30.0],
        [670, 1110, 0.0413434, 0.111828, 0.0052168, 75.28, 75.28, 75.28, 0.0, 0.0, 1, -30.0, 30.0],
        [670, 1138, 0.012739, 0.0406079, 0.0041686, 72.72, 72.72, 72.72, 0.0, 0.0, 1, -30.0, 30.0],
        [670, 1138, 0.012739, 0.0406079, 0.0041686, 72.72, 72.72, 72.72, 0.0, 0.0, 1, -30.0, 30.0],
        [670, 1158, 0.0445628, 0.104877, 0.00369872, 69.22, 69.22, 69.22, 0.0, 0.0, 1, -30.0, 30.0],
        [670, 1158, 0.0445628, 0.104877, 0.00369872, 69.22, 69.22, 69.22, 0.0, 0.0, 1, -30.0, 30.0],
        [671, 685, 0.039719, 0.113328, 0.00458021, 68.34, 68.34, 68.34, 0.0, 0.0, 1, -30.0, 30.0],
        [671, 1265, 0.013185, 0.031615, 0.002685, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [672, 677, 0.00227844, 0.013934, 0.00262847, 162.46, 162.46, 162.46, 0.0, 0.0, 1, -30.0, 30.0],
        [672, 678, 0.00291183, 0.017044, 0.0087691, 194.28, 194.28, 194.28, 0.0, 0.0, 1, -30.0, 30.0],
        [673, 675, 0.000239975, 0.00116515, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [673, 690, 0.00558691, 0.0343872, 0.0128565, 220.52, 220.52, 220.52, 0.0, 0.0, 1, -30.0, 30.0],
        [676, 702, 0.0332397, 0.0841367, 0.00529002, 53.6, 53.6, 53.6, 0.0, 0.0, 1, -30.0, 30.0],
        [676, 1434, 0.0140643, 0.0342121, 0.00250153, 88.96, 88.96, 88.96, 0.0, 0.0, 1, -30.0, 30.0],
        [677, 703, 0.00291457, 0.0201388, 0.0139011, 250.74, 250.74, 250.74, 0.0, 0.0, 1, -30.0, 30.0],
        [678, 680, 0.000279525, 0.00111737, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [679, 681, 0.0291949, 0.0789025, 0.00431615, 54.05, 54.05, 54.05, 0.0, 0.0, 1, -30.0, 30.0],
        [682, 676, 0.0099684, 0.0238349, 0.00283784, 55.08, 55.08, 55.08, 0.0, 0.0, 1, -30.0, 30.0],
        [682, 683, 0.0241937, 0.0550627, 0.00167109, 75.78, 75.78, 75.78, 0.0, 0.0, 0, -30.0, 30.0],
        [683, 686, 0.0169713, 0.0423502, 0.00148777, 79.28, 79.28, 79.28, 0.0, 0.0, 1, -30.0, 30.0],
        [683, 686, 0.0169713, 0.0423502, 0.00148777, 79.28, 79.28, 79.28, 0.0, 0.0, 1, -30.0, 30.0],
        [684, 1304, 0.00306921, 0.0212897, 0.00750665, 199.38, 199.38, 199.38, 0.0, 0.0, 1, -30.0, 30.0],
        [685, 689, 0.00646412, 0.0192895, 0.00541993, 63.35, 63.35, 63.35, 0.0, 0.0, 1, -30.0, 30.0],
        [686, 671, 0.0149537, 0.0461248, 0.00253534, 87.81, 87.81, 87.81, 0.0, 0.0, 1, -30.0, 30.0],
        [686, 1353, 0.0281172, 0.0681477, 0.00189654, 71.4, 71.4, 71.4, 0.0, 0.0, 1, -30.0, 30.0],
        [686, 1353, 0.0281172, 0.0681477, 0.00189654, 71.4, 71.4, 71.4, 0.0, 0.0, 1, -30.0, 30.0],
        [690, 687, 0.00137206, 0.00890413, 0.0216856, 255.22, 255.22, 255.22, 0.0, 0.0, 1, -30.0, 30.0],
        [690, 687, 0.00137206, 0.00890413, 0.0216856, 255.22, 255.22, 255.22, 0.0, 0.0, 1, -30.0, 30.0],
        [690, 692, 0.000299015, 0.00118887, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [693, 636, 0.0766093, 0.13377, 0.0056259, 54.91, 54.91, 54.91, 0.0, 0.0, 1, -30.0, 30.0],
        [693, 727, 0.0443643, 0.102643, 0.00436691, 59.92, 59.92, 59.92, 0.0, 0.0, 1, -30.0, 30.0],
        [694, 656, 0.0297958, 0.0586736, 0.00194872, 59.47, 59.47, 59.47, 0.0, 0.0, 1, -30.0, 30.0],
        [694, 1143, 0.0120966, 0.0336867, 0.00199342, 59.06, 59.06, 59.06, 0.0, 0.0, 1, -30.0, 30.0],
        [695, 703, 0.0024537, 0.0158766, 0.0407758, 262.12, 262.12, 262.12, 0.0, 0.0, 1, -30.0, 30.0],
        [695, 703, 0.0024537, 0.0158766, 0.0407758, 262.12, 262.12, 262.12, 0.0, 0.0, 1, -30.0, 30.0],
        [696, 695, 0.00306516, 0.0174873, 0.00644348, 314.99, 314.99, 314.99, 0.0, 0.0, 1, -30.0, 30.0],
        [696, 695, 0.00306516, 0.0174873, 0.00644348, 314.99, 314.99, 314.99, 0.0, 0.0, 1, -30.0, 30.0],
        [696, 1125, 0.000599286, 0.00423763, 0.0299773, 279.58, 279.58, 279.58, 0.0, 0.0, 1, -30.0, 30.0],
        [696, 1125, 0.000599286, 0.00423763, 0.0299773, 350.23, 350.23, 350.23, 0.0, 0.0, 1, -30.0, 30.0],
        [698, 655, 0.00278608, 0.0185511, 0.00573274, 235.34, 235.34, 235.34, 0.0, 0.0, 1, -30.0, 30.0],
        [698, 695, 0.0059417, 0.0329699, 0.00504594, 186.83, 186.83, 186.83, 0.0, 0.0, 1, -30.0, 30.0],
        [698, 700, 0.000236497, 0.00104229, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [698, 1220, 0.00441666, 0.0264788, 0.0434845, 294.95, 294.95, 294.95, 0.0, 0.0, 1, -30.0, 30.0],
        [698, 1220, 0.00441666, 0.0264788, 0.0434845, 294.95, 294.95, 294.95, 0.0, 0.0, 1, -30.0, 30.0],
        [698, 1220, 0.00441666, 0.0264788, 0.0434845, 294.95, 294.95, 294.95, 0.0, 0.0, 1, -30.0, 30.0],
        [699, 694, 0.0212242, 0.0649283, 0.00116722, 91.14, 91.14, 91.14, 0.0, 0.0, 1, -30.0, 30.0],
        [699, 704, 0.00878844, 0.0271126, 0.0125655, 101.01, 101.01, 101.01, 0.0, 0.0, 1, -30.0, 30.0],
        [699, 1143, 0.0156707, 0.0330314, 0.00480481, 81.14, 81.14, 81.14, 0.0, 0.0, 1, -30.0, 30.0],
        [699, 1143, 0.0156707, 0.0330314, 0.00480481, 81.14, 81.14, 81.14, 0.0, 0.0, 1, -30.0, 30.0],
        [699, 1143, 0.0156707, 0.0330314, 0.00480481, 81.14, 81.14, 81.14, 0.0, 0.0, 1, -30.0, 30.0],
        [701, 699, 0.032238, 0.073738, 0.002609, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [701, 1434, 0.0911385, 0.237256, 0.00605358, 59.7, 59.7, 59.7, 0.0, 0.0, 1, -30.0, 30.0],
        [703, 663, 0.00343701, 0.0231228, 0.0214183, 217.69, 217.69, 217.69, 0.0, 0.0, 1, -30.0, 30.0],
        [703, 672, 0.00211817, 0.0127384, 0.0252995, 272.72, 272.72, 272.72, 0.0, 0.0, 1, -30.0, 30.0],
        [703, 1422, 0.00215412, 0.0136641, 0.005089, 232.5, 232.5, 232.5, 0.0, 0.0, 1, -30.0, 30.0],
        [705, 708, 0.00020348, 0.00109814, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [706, 713, 0.00567904, 0.0357368, 0.0148785, 179.89, 179.89, 179.89, 0.0, 0.0, 1, -30.0, 30.0],
        [706, 721, 0.00657839, 0.0380713, 0.0168178, 239.84, 239.84, 239.84, 0.0, 0.0, 1, -30.0, 30.0],
        [707, 717, 0.0141588, 0.0342785, 0.00378699, 69.02, 69.02, 69.02, 0.0, 0.0, 1, -30.0, 30.0],
        [707, 717, 0.0141588, 0.0342785, 0.00378699, 69.02, 69.02, 69.02, 0.0, 0.0, 1, -30.0, 30.0],
        [707, 738, 0.0120058, 0.0393746, 0.00443448, 54.37, 54.37, 54.37, 0.0, 0.0, 1, -30.0, 30.0],
        [708, 1231, 0.00096663, 0.0112062, 0.328585, 1217.96, 1217.96, 1217.96, 0.0, 0.0, 1, -30.0, 30.0],
        [709, 717, 0.0257207, 0.0673327, 0.0022203, 55.22, 55.22, 55.22, 0.0, 0.0, 1, -30.0, 30.0],
        [710, 711, 0.000259697, 0.00114275, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [711, 714, 0.022699, 0.0450699, 0.0172425, 67.23, 67.23, 67.23, 0.0, 0.0, 1, -30.0, 30.0],
        [711, 738, 0.0236781, 0.0558632, 0.00473035, 45.83, 45.83, 45.83, 0.0, 0.0, 1, -30.0, 30.0],
        [712, 707, 0.0107379, 0.0281534, 0.00184699, 55.4, 55.4, 55.4, 0.0, 0.0, 1, -30.0, 30.0],
        [713, 715, 0.00021605, 0.00114424, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [714, 709, 0.0466187, 0.10548, 0.00200237, 63.62, 63.62, 63.62, 0.0, 0.0, 1, -30.0, 30.0],
        [714, 734, 0.00625145, 0.0197327, 0.00173027, 68.4, 68.4, 68.4, 0.0, 0.0, 1, -30.0, 30.0],
        [714, 734, 0.00625145, 0.0197327, 0.00173027, 68.4, 68.4, 68.4, 0.0, 0.0, 1, -30.0, 30.0],
        [716, 720, 0.0385453, 0.100286, 0.00369637, 66.9, 66.9, 66.9, 0.0, 0.0, 1, -30.0, 30.0],
        [717, 716, 0.0512647, 0.115454, 0.00250588, 99.64, 99.64, 99.64, 0.0, 0.0, 1, -30.0, 30.0],
        [718, 720, 0.015782, 0.0331277, 0.00115131, 67.44, 67.44, 67.44, 0.0, 0.0, 1, -30.0, 30.0],
        [718, 720, 0.015782, 0.0331277, 0.00115131, 67.44, 67.44, 67.44, 0.0, 0.0, 1, -30.0, 30.0],
        [719, 721, 0.000258457, 0.00112691, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [721, 765, 0.0113236, 0.0627085, 0.0245229, 167.42, 167.42, 167.42, 0.0, 0.0, 1, -30.0, 30.0],
        [722, 724, 0.000271347, 0.00118105, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [723, 752, 0.0195676, 0.0529531, 0.00480647, 72.02, 72.02, 72.02, 0.0, 0.0, 1, -30.0, 30.0],
        [723, 752, 0.0195676, 0.0529531, 0.00480647, 72.02, 72.02, 72.02, 0.0, 0.0, 1, -30.0, 30.0],
        [724, 706, 0.00755435, 0.04567, 0.0108024, 228.29, 228.29, 228.29, 0.0, 0.0, 1, -30.0, 30.0],
        [724, 735, 0.00679339, 0.0364124, 0.0375024, 205.79, 205.79, 205.79, 0.0, 0.0, 1, -30.0, 30.0],
        [724, 757, 0.00960434, 0.0465698, 0.0166906, 250.0, 250.0, 250.0, 0.0, 0.0, 1, -30.0, 30.0],
        [726, 639, 0.0331712, 0.0726349, 0.00393949, 50.08, 50.08, 50.08, 0.0, 0.0, 1, -30.0, 30.0],
        [726, 741, 0.0370365, 0.0908796, 0.00320872, 47.01, 47.01, 47.01, 0.0, 0.0, 1, -30.0, 30.0],
        [726, 1225, 0.0535962, 0.124344, 0.00305197, 57.26, 57.26, 57.26, 0.0, 0.0, 1, -30.0, 30.0],
        [727, 745, 0.031743, 0.102119, 0.00339531, 66.12, 66.12, 66.12, 0.0, 0.0, 1, -30.0, 30.0],
        [728, 729, 0.000236119, 0.0011587, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [728, 739, 0.00607912, 0.0347631, 0.0210146, 235.38, 235.38, 235.38, 0.0, 0.0, 1, -30.0, 30.0],
        [728, 1224, 0.00318864, 0.0206159, 0.00547395, 281.81, 281.81, 281.81, 0.0, 0.0, 1, -30.0, 30.0],
        [730, 731, 0.000285794, 0.00118818, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [730, 733, 0.0250102, 0.0572674, 0.00547769, 77.03, 77.03, 77.03, 0.0, 0.0, 1, -30.0, 30.0],
        [730, 733, 0.0250102, 0.0572674, 0.00547769, 77.03, 77.03, 77.03, 0.0, 0.0, 1, -30.0, 30.0],
        [730, 743, 0.0180046, 0.0426831, 0.00724871, 82.61, 82.61, 82.61, 0.0, 0.0, 1, -30.0, 30.0],
        [730, 743, 0.0180046, 0.0426831, 0.00724871, 98.85, 98.85, 98.85, 0.0, 0.0, 1, -30.0, 30.0],
        [732, 713, 0.00308498, 0.0213107, 0.0266089, 305.76, 305.76, 305.76, 0.0, 0.0, 1, -30.0, 30.0],
        [732, 750, 0.00978066, 0.0497498, 0.00954899, 221.8, 221.8, 221.8, 0.0, 0.0, 1, -30.0, 30.0],
        [732, 751, 0.00591267, 0.0333803, 0.0313573, 226.14, 226.14, 226.14, 0.0, 0.0, 1, -30.0, 30.0],
        [733, 714, 0.0397449, 0.125455, 0.00220495, 50.67, 50.67, 50.67, 0.0, 0.0, 1, -30.0, 30.0],
        [734, 709, 0.0360463, 0.0948109, 0.00124411, 56.93, 56.93, 56.93, 0.0, 0.0, 1, -30.0, 30.0],
        [735, 706, 0.00349417, 0.0220542, 0.0135676, 226.77, 226.77, 226.77, 0.0, 0.0, 1, -30.0, 30.0],
        [735, 713, 0.00406877, 0.0200777, 0.0151237, 213.91, 213.91, 213.91, 0.0, 0.0, 1, -30.0, 30.0],
        [735, 737, 0.000209531, 0.00114103, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [736, 712, 0.0120164, 0.0330956, 0.00434116, 92.16, 92.16, 92.16, 0.0, 0.0, 1, -30.0, 30.0],
        [736, 733, 0.0217717, 0.0618056, 0.00157267, 76.41, 76.41, 76.41, 0.0, 0.0, 1, -30.0, 30.0],
        [736, 738, 0.0276494, 0.0423896, 0.00102261, 60.33, 60.33, 60.33, 0.0, 0.0, 1, -30.0, 30.0],
        [739, 713, 0.00432333, 0.0309945, 0.0206286, 226.06, 226.06, 226.06, 0.0, 0.0, 1, -30.0, 30.0],
        [740, 730, 0.0103258, 0.0274783, 0.0102986, 71.15, 71.15, 71.15, 0.0, 0.0, 1, -30.0, 30.0],
        [741, 1351, 0.0449736, 0.118862, 0.00224926, 56.47, 56.47, 56.47, 0.0, 0.0, 1, -30.0, 30.0],
        [742, 743, 0.000297694, 0.00101352, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [743, 747, 0.0418213, 0.114189, 0.00619562, 77.46, 77.46, 77.46, 0.0, 0.0, 1, -30.0, 30.0],
        [743, 747, 0.0418213, 0.114189, 0.00619562, 77.46, 77.46, 77.46, 0.0, 0.0, 1, -30.0, 30.0],
        [743, 747, 0.0418213, 0.114189, 0.00619562, 77.46, 77.46, 77.46, 0.0, 0.0, 1, -30.0, 30.0],
        [744, 745, 0.000273195, 0.00102476, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [745, 741, 0.0279111, 0.0697424, 0.00168454, 47.07, 47.07, 47.07, 0.0, 0.0, 1, -30.0, 30.0],
        [745, 1225, 0.0280246, 0.0740571, 0.001457, 73.56, 73.56, 73.56, 0.0, 0.0, 1, -30.0, 30.0],
        [745, 1225, 0.0280246, 0.0740571, 0.001457, 73.56, 73.56, 73.56, 0.0, 0.0, 1, -30.0, 30.0],
        [746, 748, 0.000246778, 0.00101087, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [746, 1446, 0.00734994, 0.0381184, 0.0192566, 264.12, 264.12, 264.12, 0.0, 0.0, 1, -30.0, 30.0],
        [746, 1446, 0.00734994, 0.0381184, 0.0192566, 264.12, 264.12, 264.12, 0.0, 0.0, 1, -30.0, 30.0],
        [747, 725, 0.0296543, 0.0617213, 0.00277619, 55.39, 55.39, 55.39, 0.0, 0.0, 1, -30.0, 30.0],
        [749, 740, 0.0434928, 0.106918, 0.00292269, 82.56, 82.56, 82.56, 0.0, 0.0, 1, -30.0, 30.0],
        [750, 746, 0.00415907, 0.0171685, 0.0148585, 250.54, 250.54, 250.54, 0.0, 0.0, 1, -30.0, 30.0],
        [750, 1224, 0.00997991, 0.0364096, 0.0177388, 223.79, 223.79, 223.79, 0.0, 0.0, 1, -30.0, 30.0],
        [752, 753, 0.0548537, 0.134376, 0.0039606, 57.37, 57.37, 57.37, 0.0, 0.0, 1, -30.0, 30.0],
        [753, 718, 0.0182084, 0.0509132, 0.017097, 69.65, 69.65, 69.65, 0.0, 0.0, 1, -30.0, 30.0],
        [754, 752, 0.0268277, 0.0681183, 0.00100596, 103.37, 103.37, 103.37, 0.0, 0.0, 1, -30.0, 30.0],
        [754, 756, 0.0196583, 0.0412184, 0.00197465, 80.37, 80.37, 80.37, 0.0, 0.0, 1, -30.0, 30.0],
        [755, 757, 0.000289861, 0.00103578, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [756, 762, 0.0401271, 0.110182, 0.00640868, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [756, 762, 0.0401271, 0.110182, 0.00640868, 67.01, 67.01, 67.01, 0.0, 0.0, 1, -30.0, 30.0],
        [757, 761, 0.010971, 0.0634626, 0.023568, 181.54, 181.54, 181.54, 0.0, 0.0, 1, -30.0, 30.0],
        [758, 708, 0.00156929, 0.0191222, 0.332168, 1113.47, 1113.47, 1113.47, 0.0, 0.0, 1, -30.0, 30.0],
        [758, 760, 0.000267244, 0.00110848, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [758, 1164, 0.000649, 0.008684, 0.140067, 1200.0, 1200.0, 1200.0, 0.0, 0.0, 1, -30.0, 30.0],
        [759, 1189, 0.0196054, 0.127867, 0.0942536, 187.08, 187.08, 187.08, 0.0, 0.0, 1, -30.0, 30.0],
        [761, 759, 0.00537571, 0.0363951, 0.00784317, 210.8, 210.8, 210.8, 0.0, 0.0, 1, -30.0, 30.0],
        [762, 764, 0.125056, 0.255655, 0.00650492, 45.42, 45.42, 45.42, 0.0, 0.0, 1, -30.0, 30.0],
        [762, 766, 0.0430187, 0.123069, 0.00226026, 49.15, 49.15, 49.15, 0.0, 0.0, 1, -30.0, 30.0],
        [762, 1166, 0.0301256, 0.0734533, 0.00165003, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [763, 756, 0.0292606, 0.0730098, 0.00408734, 74.19, 74.19, 74.19, 0.0, 0.0, 1, -30.0, 30.0],
        [763, 766, 0.0298118, 0.0737139, 0.0118129, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [764, 753, 0.0848101, 0.212392, 0.00700939, 55.33, 55.33, 55.33, 0.0, 0.0, 1, -30.0, 30.0],
        [764, 1185, 0.107068, 0.250415, 0.00640377, 47.49, 47.49, 47.49, 0.0, 0.0, 1, -30.0, 30.0],
        [765, 1179, 0.0361755, 0.224805, 0.0540552, 172.43, 172.43, 172.43, 0.0, 0.0, 1, -30.0, 30.0],
        [765, 1385, 0.0125277, 0.0829849, 0.0290367, 187.45, 187.45, 187.45, 0.0, 0.0, 1, -30.0, 30.0],
        [766, 1165, 0.0697077, 0.145835, 0.00612952, 47.1, 47.1, 47.1, 0.0, 0.0, 1, -30.0, 30.0],
        [767, 1203, 0.0229888, 0.0582403, 0.00179601, 85.44, 85.44, 85.44, 0.0, 0.0, 1, -30.0, 30.0],
        [768, 770, 0.00023325, 0.0010018, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [769, 767, 0.0451853, 0.128321, 0.0039516, 92.87, 92.87, 92.87, 0.0, 0.0, 1, -30.0, 30.0],
        [769, 767, 0.0451853, 0.128321, 0.0039516, 92.87, 92.87, 92.87, 0.0, 0.0, 1, -30.0, 30.0],
        [769, 767, 0.0451853, 0.128321, 0.0039516, 92.87, 92.87, 92.87, 0.0, 0.0, 1, -30.0, 30.0],
        [769, 1200, 0.0522081, 0.109553, 0.00213545, 76.37, 76.37, 76.37, 0.0, 0.0, 1, -30.0, 30.0],
        [769, 1200, 0.0522081, 0.109553, 0.00213545, 76.37, 76.37, 76.37, 0.0, 0.0, 1, -30.0, 30.0],
        [770, 1173, 0.0116963, 0.0557865, 0.0157288, 201.22, 201.22, 201.22, 0.0, 0.0, 1, -30.0, 30.0],
        [771, 810, 0.0246092, 0.0488022, 0.00179747, 85.72, 85.72, 85.72, 0.0, 0.0, 1, -30.0, 30.0],
        [772, 774, 0.000261468, 0.00116519, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [772, 806, 0.00254542, 0.0191982, 0.00837887, 275.48, 275.48, 275.48, 0.0, 0.0, 1, -30.0, 30.0],
        [772, 806, 0.00254542, 0.0191982, 0.00837887, 275.48, 275.48, 275.48, 0.0, 0.0, 1, -30.0, 30.0],
        [773, 776, 0.0477915, 0.1215, 0.00268081, 58.02, 58.02, 58.02, 0.0, 0.0, 1, -30.0, 30.0],
        [773, 805, 0.0212617, 0.0547238, 0.00218667, 62.43, 62.43, 62.43, 0.0, 0.0, 1, -30.0, 30.0],
        [773, 807, 0.0351298, 0.0732948, 0.00204405, 59.97, 59.97, 59.97, 0.0, 0.0, 1, -30.0, 30.0],
        [775, 772, 0.00421329, 0.0252029, 0.00898322, 274.98, 274.98, 274.98, 0.0, 0.0, 1, -30.0, 30.0],
        [775, 772, 0.00421329, 0.0252029, 0.00898322, 274.98, 274.98, 274.98, 0.0, 0.0, 1, -30.0, 30.0],
        [775, 777, 0.000232018, 0.00111077, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [775, 811, 0.00246499, 0.0153016, 0.0129739, 249.02, 249.02, 249.02, 0.0, 0.0, 1, -30.0, 30.0],
        [776, 805, 0.0149399, 0.0349942, 0.0060912, 75.61, 75.61, 75.61, 0.0, 0.0, 1, -30.0, 30.0],
        [776, 816, 0.0487514, 0.13772, 0.00528137, 64.68, 64.68, 64.68, 0.0, 0.0, 1, -30.0, 30.0],
        [780, 784, 0.0115045, 0.0253216, 0.00796936, 49.76, 49.76, 49.76, 0.0, 0.0, 1, -30.0, 30.0],
        [780, 1076, 0.0426133, 0.106767, 0.00758234, 54.22, 54.22, 54.22, 0.0, 0.0, 1, -30.0, 30.0],
        [781, 817, 0.0393211, 0.121676, 0.00727359, 83.33, 83.33, 83.33, 0.0, 0.0, 1, -30.0, 30.0],
        [781, 1459, 0.0223887, 0.0537148, 0.00210059, 71.72, 71.72, 71.72, 0.0, 0.0, 1, -30.0, 30.0],
        [781, 1459, 0.0223887, 0.0537148, 0.00210059, 71.72, 71.72, 71.72, 0.0, 0.0, 1, -30.0, 30.0],
        [782, 791, 0.0386251, 0.0885969, 0.00434073, 53.66, 53.66, 53.66, 0.0, 0.0, 1, -30.0, 30.0],
        [783, 785, 0.000242303, 0.00108501, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [783, 786, 0.00680162, 0.0397286, 0.00787004, 189.29, 189.29, 189.29, 0.0, 0.0, 1, -30.0, 30.0],
        [786, 788, 0.000292922, 0.0011756, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [786, 861, 0.00406964, 0.02337, 0.0216395, 221.53, 221.53, 221.53, 0.0, 0.0, 1, -30.0, 30.0],
        [786, 915, 0.00912693, 0.0560723, 0.0122011, 196.14, 196.14, 196.14, 0.0, 0.0, 1, -30.0, 30.0],
        [789, 787, 0.0150532, 0.0475956, 0.0023362, 67.48, 67.48, 67.48, 0.0, 0.0, 1, -30.0, 30.0],
        [789, 1459, 0.0417626, 0.11275, 0.00614682, 56.49, 56.49, 56.49, 0.0, 0.0, 1, -30.0, 30.0],
        [790, 787, 0.058196, 0.118439, 0.00473632, 54.82, 54.82, 54.82, 0.0, 0.0, 1, -30.0, 30.0],
        [790, 853, 0.0230004, 0.0536403, 0.00358439, 59.72, 59.72, 59.72, 0.0, 0.0, 1, -30.0, 30.0],
        [791, 784, 0.0293445, 0.053774, 0.00460567, 72.42, 72.42, 72.42, 0.0, 0.0, 1, -30.0, 30.0],
        [792, 793, 0.000295455, 0.00111316, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [793, 816, 0.044622, 0.119035, 0.00781618, 72.14, 72.14, 72.14, 0.0, 0.0, 1, -30.0, 30.0],
        [793, 816, 0.044622, 0.119035, 0.00781618, 72.14, 72.14, 72.14, 0.0, 0.0, 1, -30.0, 30.0],
        [793, 941, 0.0149606, 0.0327207, 0.0095816, 75.98, 75.98, 75.98, 0.0, 0.0, 1, -30.0, 30.0],
        [793, 941, 0.0149606, 0.0327207, 0.0095816, 75.98, 75.98, 75.98, 0.0, 0.0, 1, -30.0, 30.0],
        [793, 941, 0.0149606, 0.0327207, 0.0095816, 75.98, 75.98, 75.98, 0.0, 0.0, 1, -30.0, 30.0],
        [793, 942, 0.0443409, 0.120469, 0.00310284, 68.54, 68.54, 68.54, 0.0, 0.0, 1, -30.0, 30.0],
        [793, 942, 0.0443409, 0.120469, 0.00310284, 68.54, 68.54, 68.54, 0.0, 0.0, 1, -30.0, 30.0],
        [793, 1331, 0.0668295, 0.185868, 0.00543285, 102.45, 102.45, 102.45, 0.0, 0.0, 1, -30.0, 30.0],
        [794, 772, 0.00655411, 0.0324524, 0.0106704, 239.34, 239.34, 239.34, 0.0, 0.0, 1, -30.0, 30.0],
        [794, 1419, 0.00959114, 0.0543401, 0.0155979, 251.05, 251.05, 251.05, 0.0, 0.0, 1, -30.0, 30.0],
        [795, 812, 0.00672778, 0.0375608, 0.0162642, 194.82, 194.82, 194.82, 0.0, 0.0, 1, -30.0, 30.0],
        [795, 918, 0.0111696, 0.045562, 0.0251937, 241.02, 241.02, 241.02, 0.0, 0.0, 1, -30.0, 30.0],
        [796, 797, 0.0158986, 0.0322097, 0.0020707, 68.13, 68.13, 68.13, 0.0, 0.0, 1, -30.0, 30.0],
        [796, 797, 0.0158986, 0.0322097, 0.0020707, 68.13, 68.13, 68.13, 0.0, 0.0, 1, -30.0, 30.0],
        [796, 916, 0.0350615, 0.0861103, 0.00815909, 65.22, 65.22, 65.22, 0.0, 0.0, 1, -30.0, 30.0],
        [797, 771, 0.0236821, 0.048774, 0.00383912, 48.57, 48.57, 48.57, 0.0, 0.0, 1, -30.0, 30.0],
        [798, 797, 0.0356653, 0.0735303, 0.00252286, 53.3, 53.3, 53.3, 0.0, 0.0, 1, -30.0, 30.0],
        [798, 916, 0.0571675, 0.138514, 0.00351431, 59.54, 59.54, 59.54, 0.0, 0.0, 1, -30.0, 30.0],
        [798, 917, 0.0290577, 0.0681567, 0.00253819, 78.7, 78.7, 78.7, 0.0, 0.0, 1, -30.0, 30.0],
        [799, 815, 0.0214645, 0.0610672, 0.00263357, 96.78, 96.78, 96.78, 0.0, 0.0, 1, -30.0, 30.0],
        [801, 803, 0.000299059, 0.00115904, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [802, 804, 0.0116984, 0.0353557, 0.0017734, 72.26, 72.26, 72.26, 0.0, 0.0, 1, -30.0, 30.0],
        [802, 804, 0.0116984, 0.0353557, 0.0017734, 72.26, 72.26, 72.26, 0.0, 0.0, 1, -30.0, 30.0],
        [802, 969, 0.0633007, 0.152267, 0.0116004, 71.04, 71.04, 71.04, 0.0, 0.0, 1, -30.0, 30.0],
        [803, 1389, 0.00431867, 0.0216558, 0.00526411, 279.07, 279.07, 279.07, 0.0, 0.0, 1, -30.0, 30.0],
        [803, 1403, 0.00291769, 0.0144732, 0.00768421, 429.33, 429.33, 429.33, 0.0, 0.0, 1, -30.0, 30.0],
        [804, 815, 0.079929, 0.153043, 0.00381405, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [804, 871, 0.0575817, 0.137055, 0.00430612, 57.93, 57.93, 57.93, 0.0, 0.0, 1, -30.0, 30.0],
        [805, 778, 0.0217417, 0.0561983, 0.00181281, 60.16, 60.16, 60.16, 0.0, 0.0, 1, -30.0, 30.0],
        [805, 807, 0.0346316, 0.0956168, 0.00234489, 72.45, 72.45, 72.45, 0.0, 0.0, 1, -30.0, 30.0],
        [805, 807, 0.0346316, 0.0956168, 0.00234489, 72.45, 72.45, 72.45, 0.0, 0.0, 1, -30.0, 30.0],
        [806, 864, 0.0111849, 0.0615986, 0.0215723, 208.44, 208.44, 208.44, 0.0, 0.0, 1, -30.0, 30.0],
        [806, 1374, 0.00408262, 0.0204135, 0.0145343, 201.31, 201.31, 201.31, 0.0, 0.0, 1, -30.0, 30.0],
        [806, 1403, 0.00442287, 0.0343395, 0.0319444, 285.33, 285.33, 285.33, 0.0, 0.0, 1, -30.0, 30.0],
        [806, 1403, 0.00442287, 0.0343395, 0.0319444, 285.33, 285.33, 285.33, 0.0, 0.0, 1, -30.0, 30.0],
        [806, 1403, 0.00442287, 0.0343395, 0.0319444, 285.33, 285.33, 285.33, 0.0, 0.0, 1, -30.0, 30.0],
        [807, 799, 0.0124305, 0.0364808, 0.00127793, 122.31, 122.31, 122.31, 0.0, 0.0, 1, -30.0, 30.0],
        [807, 800, 0.0212885, 0.0478871, 0.00355304, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [808, 842, 0.00142045, 0.0157898, 0.282854, 1182.07, 1182.07, 1182.07, 0.0, 0.0, 1, -30.0, 30.0],
        [808, 1254, 0.00117353, 0.0143531, 0.556189, 1305.13, 1305.13, 1305.13, 0.0, 0.0, 1, -30.0, 30.0],
        [808, 1383, 0.00145215, 0.0154375, 0.290601, 1381.88, 1381.88, 1381.88, 0.0, 0.0, 1, -30.0, 30.0],
        [809, 811, 0.000250849, 0.00112677, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [810, 776, 0.0111387, 0.0311905, 0.00407199, 71.4, 71.4, 71.4, 0.0, 0.0, 1, -30.0, 30.0],
        [810, 776, 0.0111387, 0.0311905, 0.00407199, 71.4, 71.4, 71.4, 0.0, 0.0, 1, -30.0, 30.0],
        [810, 796, 0.0181765, 0.0472114, 0.00403662, 114.92, 114.92, 114.92, 0.0, 0.0, 1, -30.0, 30.0],
        [811, 795, 0.0061845, 0.0330197, 0.00730518, 200.27, 200.27, 200.27, 0.0, 0.0, 1, -30.0, 30.0],
        [811, 812, 0.00344162, 0.0226463, 0.0192601, 258.84, 258.84, 258.84, 0.0, 0.0, 1, -30.0, 30.0],
        [811, 812, 0.00344162, 0.0226463, 0.0192601, 258.84, 258.84, 258.84, 0.0, 0.0, 1, -30.0, 30.0],
        [812, 814, 0.000293127, 0.00103843, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [813, 852, 0.0310923, 0.0858033, 0.00303104, 75.12, 75.12, 75.12, 0.0, 0.0, 1, -30.0, 30.0],
        [813, 852, 0.0310923, 0.0858033, 0.00303104, 82.13, 82.13, 82.13, 0.0, 0.0, 1, -30.0, 30.0],
        [817, 779, 0.0476863, 0.104219, 0.0105567, 62.87, 62.87, 62.87, 0.0, 0.0, 1, -30.0, 30.0],
        [818, 820, 0.000218518, 0.00109511, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [818, 823, 0.00379179, 0.0216897, 0.00995852, 232.42, 232.42, 232.42, 0.0, 0.0, 1, -30.0, 30.0],
        [818, 859, 0.00388236, 0.0242721, 0.00558331, 177.59, 177.59, 177.59, 0.0, 0.0, 1, -30.0, 30.0],
        [819, 821, 0.0219468, 0.0620993, 0.00242959, 56.54, 56.54, 56.54, 0.0, 0.0, 1, -30.0, 30.0],
        [819, 829, 0.0176091, 0.0418731, 0.00482447, 81.37, 81.37, 81.37, 0.0, 0.0, 1, -30.0, 30.0],
        [819, 829, 0.0176091, 0.0418731, 0.00482447, 81.37, 81.37, 81.37, 0.0, 0.0, 1, -30.0, 30.0],
        [819, 829, 0.0176091, 0.0418731, 0.00482447, 81.37, 81.37, 81.37, 0.0, 0.0, 1, -30.0, 30.0],
        [821, 865, 0.0126039, 0.0302144, 0.0229644, 81.25, 81.25, 81.25, 0.0, 0.0, 1, -30.0, 30.0],
        [822, 855, 0.0229749, 0.0418912, 0.00321397, 80.83, 80.83, 80.83, 0.0, 0.0, 1, -30.0, 30.0],
        [822, 1301, 0.00563389, 0.0127621, 0.00234364, 73.18, 73.18, 73.18, 0.0, 0.0, 1, -30.0, 30.0],
        [822, 1301, 0.00563389, 0.0127621, 0.00234364, 100.39, 100.39, 100.39, 0.0, 0.0, 1, -30.0, 30.0],
        [823, 775, 0.00322617, 0.0190636, 0.0124316, 266.68, 266.68, 266.68, 0.0, 0.0, 1, -30.0, 30.0],
        [823, 775, 0.00322617, 0.0190636, 0.0124316, 266.68, 266.68, 266.68, 0.0, 0.0, 1, -30.0, 30.0],
        [823, 858, 0.00757868, 0.0327386, 0.0475527, 236.77, 236.77, 236.77, 0.0, 0.0, 1, -30.0, 30.0],
        [823, 1263, 0.00679532, 0.0365862, 0.0147046, 345.55, 345.55, 345.55, 0.0, 0.0, 1, -30.0, 30.0],
        [824, 776, 0.0331549, 0.0699101, 0.00322445, 83.24, 83.24, 83.24, 0.0, 0.0, 1, -30.0, 30.0],
        [824, 776, 0.0331549, 0.0699101, 0.00322445, 83.24, 83.24, 83.24, 0.0, 0.0, 1, -30.0, 30.0],
        [824, 776, 0.0331549, 0.0699101, 0.00322445, 83.24, 83.24, 83.24, 0.0, 0.0, 1, -30.0, 30.0],
        [824, 819, 0.0194152, 0.0489612, 0.00250331, 77.96, 77.96, 77.96, 0.0, 0.0, 1, -30.0, 30.0],
        [824, 819, 0.0194152, 0.0489612, 0.00250331, 77.96, 77.96, 77.96, 0.0, 0.0, 1, -30.0, 30.0],
        [824, 819, 0.0194152, 0.0489612, 0.00250331, 77.96, 77.96, 77.96, 0.0, 0.0, 1, -30.0, 30.0],
        [825, 827, 0.000207584, 0.00112661, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [826, 821, 0.0312451, 0.0757018, 0.00458117, 153.55, 153.55, 153.55, 0.0, 0.0, 1, -30.0, 30.0],
        [827, 835, 0.0083775, 0.032842, 0.0150866, 198.51, 198.51, 198.51, 0.0, 0.0, 1, -30.0, 30.0],
        [828, 840, 0.0439168, 0.126294, 0.00839162, 77.12, 77.12, 77.12, 0.0, 0.0, 1, -30.0, 30.0],
        [828, 840, 0.0439168, 0.126294, 0.00839162, 77.12, 77.12, 77.12, 0.0, 0.0, 1, -30.0, 30.0],
        [828, 840, 0.0439168, 0.126294, 0.00839162, 77.12, 77.12, 77.12, 0.0, 0.0, 1, -30.0, 30.0],
        [828, 846, 0.0164762, 0.0480241, 0.00344396, 75.82, 75.82, 75.82, 0.0, 0.0, 1, -30.0, 30.0],
        [828, 846, 0.0164762, 0.0480241, 0.00344396, 75.82, 75.82, 75.82, 0.0, 0.0, 1, -30.0, 30.0],
        [828, 1072, 0.0398257, 0.0779606, 0.00973381, 47.09, 47.09, 47.09, 0.0, 0.0, 1, -30.0, 30.0],
        [828, 1084, 0.0458194, 0.101754, 0.00271837, 46.93, 46.93, 46.93, 0.0, 0.0, 1, -30.0, 30.0],
        [829, 830, 0.000236109, 0.00111517, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [829, 831, 0.00990748, 0.025441, 0.0165811, 90.43, 90.43, 90.43, 0.0, 0.0, 1, -30.0, 30.0],
        [829, 831, 0.00990748, 0.025441, 0.0165811, 95.93, 95.93, 95.93, 0.0, 0.0, 1, -30.0, 30.0],
        [829, 831, 0.00990748, 0.025441, 0.0165811, 95.93, 95.93, 95.93, 0.0, 0.0, 1, -30.0, 30.0],
        [829, 832, 0.0342816, 0.0818059, 0.00272986, 78.66, 78.66, 78.66, 0.0, 0.0, 1, -30.0, 30.0],
        [829, 850, 0.0287, 0.0691843, 0.00414683, 77.13, 77.13, 77.13, 0.0, 0.0, 1, -30.0, 30.0],
        [829, 850, 0.0287, 0.0691843, 0.00414683, 77.13, 77.13, 77.13, 0.0, 0.0, 1, -30.0, 30.0],
        [829, 850, 0.0287, 0.0691843, 0.00414683, 77.13, 77.13, 77.13, 0.0, 0.0, 1, -30.0, 30.0],
        [829, 852, 0.0302298, 0.0677275, 0.00846515, 69.66, 69.66, 69.66, 0.0, 0.0, 1, -30.0, 30.0],
        [829, 852, 0.0302298, 0.0677275, 0.00846515, 69.66, 69.66, 69.66, 0.0, 0.0, 1, -30.0, 30.0],
        [831, 828, 0.0154063, 0.0421167, 0.00137218, 70.05, 70.05, 70.05, 0.0, 0.0, 1, -30.0, 30.0],
        [831, 833, 0.0306222, 0.0803456, 0.00287959, 55.88, 55.88, 55.88, 0.0, 0.0, 1, -30.0, 30.0],
        [831, 848, 0.0232971, 0.0471613, 0.00252821, 63.9, 63.9, 63.9, 0.0, 0.0, 1, -30.0, 30.0],
        [831, 860, 0.0365663, 0.0956145, 0.00637404, 60.25, 60.25, 60.25, 0.0, 0.0, 1, -30.0, 30.0],
        [832, 831, 0.0188065, 0.0338134, 0.00108383, 60.85, 60.85, 60.85, 0.0, 0.0, 1, -30.0, 30.0],
        [833, 829, 0.0314703, 0.0820471, 0.00365157, 78.08, 78.08, 78.08, 0.0, 0.0, 1, -30.0, 30.0],
        [833, 829, 0.0314703, 0.0820471, 0.00365157, 78.08, 78.08, 78.08, 0.0, 0.0, 1, -30.0, 30.0],
        [833, 832, 0.0248247, 0.066138, 0.00167722, 49.47, 49.47, 49.47, 0.0, 0.0, 1, -30.0, 30.0],
        [834, 847, 0.0046278, 0.0258692, 0.00616339, 181.18, 181.18, 181.18, 0.0, 0.0, 1, -30.0, 30.0],
        [834, 862, 0.00500071, 0.0303134, 0.0107695, 198.75, 198.75, 198.75, 0.0, 0.0, 1, -30.0, 30.0],
        [835, 839, 0.00220603, 0.0155599, 0.00844475, 272.79, 272.79, 272.79, 0.0, 0.0, 1, -30.0, 30.0],
        [835, 845, 0.00791063, 0.0296858, 0.0198371, 246.81, 246.81, 246.81, 0.0, 0.0, 1, -30.0, 30.0],
        [835, 847, 0.00479085, 0.0312283, 0.0180939, 235.29, 235.29, 235.29, 0.0, 0.0, 1, -30.0, 30.0],
        [835, 858, 0.0056663, 0.0280124, 0.010056, 218.44, 218.44, 218.44, 0.0, 0.0, 1, -30.0, 30.0],
        [835, 1095, 0.0158872, 0.0770772, 0.0161198, 208.5, 208.5, 208.5, 0.0, 0.0, 1, -30.0, 30.0],
        [835, 1263, 0.00761152, 0.0446938, 0.0172138, 346.83, 346.83, 346.83, 0.0, 0.0, 1, -30.0, 30.0],
        [835, 1263, 0.00761152, 0.0446938, 0.0172138, 346.83, 346.83, 346.83, 0.0, 0.0, 1, -30.0, 30.0],
        [835, 1302, 0.00584738, 0.0311925, 0.0355367, 289.22, 289.22, 289.22, 0.0, 0.0, 1, -30.0, 30.0],
        [835, 1302, 0.00584738, 0.0311925, 0.0355367, 289.22, 289.22, 289.22, 0.0, 0.0, 1, -30.0, 30.0],
        [835, 1302, 0.00584738, 0.0311925, 0.0355367, 289.22, 289.22, 289.22, 0.0, 0.0, 1, -30.0, 30.0],
        [836, 827, 0.00300607, 0.016604, 0.0147514, 220.07, 220.07, 220.07, 0.0, 0.0, 1, -30.0, 30.0],
        [836, 838, 0.000293632, 0.00105537, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [836, 839, 0.00390262, 0.0212586, 0.00987104, 235.36, 235.36, 235.36, 0.0, 0.0, 1, -30.0, 30.0],
        [836, 1263, 0.00697266, 0.0372567, 0.00978284, 425.24, 425.24, 425.24, 0.0, 0.0, 1, -30.0, 30.0],
        [836, 1302, 0.00516175, 0.0353126, 0.0116323, 263.67, 263.67, 263.67, 0.0, 0.0, 1, -30.0, 30.0],
        [836, 1302, 0.00516175, 0.0353126, 0.0116323, 263.67, 263.67, 263.67, 0.0, 0.0, 1, -30.0, 30.0],
        [837, 821, 0.0151134, 0.0447701, 0.00114037, 68.34, 68.34, 68.34, 0.0, 0.0, 1, -30.0, 30.0],
        [837, 821, 0.0151134, 0.0447701, 0.00114037, 68.34, 68.34, 68.34, 0.0, 0.0, 1, -30.0, 30.0],
        [837, 854, 0.0323529, 0.0956415, 0.00762536, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [837, 865, 0.0153966, 0.0483435, 0.00669422, 72.68, 72.68, 72.68, 0.0, 0.0, 1, -30.0, 30.0],
        [837, 865, 0.0153966, 0.0483435, 0.00669422, 72.68, 72.68, 72.68, 0.0, 0.0, 1, -30.0, 30.0],
        [837, 1301, 0.0331722, 0.0726528, 0.00352213, 68.12, 68.12, 68.12, 0.0, 0.0, 1, -30.0, 30.0],
        [837, 1301, 0.0331722, 0.0726528, 0.00352213, 68.12, 68.12, 68.12, 0.0, 0.0, 1, -30.0, 30.0],
        [839, 841, 0.00024051, 0.00108032, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [842, 887, 0.000331887, 0.00410061, 0.239922, 1088.37, 1088.37, 1088.37, 0.0, 0.0, 1, -30.0, 30.0],
        [842, 1425, 0.000652928, 0.0086589, 0.151779, 1020.0, 1020.0, 1020.0, 0.0, 0.0, 1, -30.0, 30.0],
        [843, 845, 0.000295175, 0.00106078, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [844, 846, 0.0275821, 0.0738511, 0.003491, 56.95, 56.95, 56.95, 0.0, 0.0, 1, -30.0, 30.0],
        [844, 857, 0.0188294, 0.0531652, 0.00160609, 71.37, 71.37, 71.37, 0.0, 0.0, 1, -30.0, 30.0],
        [844, 857, 0.0188294, 0.0531652, 0.00160609, 71.37, 71.37, 71.37, 0.0, 0.0, 1, -30.0, 30.0],
        [845, 839, 0.00497183, 0.0243456, 0.0133302, 210.65, 210.65, 210.65, 0.0, 0.0, 1, -30.0, 30.0],
        [845, 1102, 0.00830782, 0.0411312, 0.0159184, 219.78, 219.78, 219.78, 0.0, 0.0, 1, -30.0, 30.0],
        [845, 1106, 0.004369, 0.025156, 0.019077, 300.0, 300.0, 300.0, 0.0, 0.0, 1, -30.0, 30.0],
        [847, 858, 0.00232022, 0.0139375, 0.00494528, 228.93, 228.93, 228.93, 0.0, 0.0, 1, -30.0, 30.0],
        [847, 859, 0.00869784, 0.0422364, 0.017532, 206.75, 206.75, 206.75, 0.0, 0.0, 1, -30.0, 30.0],
        [848, 828, 0.0160515, 0.0406449, 0.00104782, 54.29, 54.29, 54.29, 0.0, 0.0, 1, -30.0, 30.0],
        [848, 1084, 0.00980892, 0.0242317, 0.00470625, 64.56, 64.56, 64.56, 0.0, 0.0, 1, -30.0, 30.0],
        [849, 818, 0.00409956, 0.0188656, 0.0145182, 209.03, 209.03, 209.03, 0.0, 0.0, 1, -30.0, 30.0],
        [849, 823, 0.00282601, 0.0163694, 0.00822121, 207.29, 207.29, 207.29, 0.0, 0.0, 1, -30.0, 30.0],
        [849, 851, 0.00025783, 0.00113714, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [849, 862, 0.0037801, 0.0237197, 0.0212244, 246.63, 246.63, 246.63, 0.0, 0.0, 1, -30.0, 30.0],
        [849, 1263, 0.00997078, 0.0579154, 0.0162879, 261.32, 261.32, 261.32, 0.0, 0.0, 1, -30.0, 30.0],
        [849, 1302, 0.00543505, 0.0236862, 0.029782, 277.41, 277.41, 277.41, 0.0, 0.0, 1, -30.0, 30.0],
        [849, 1302, 0.00543505, 0.0236862, 0.029782, 277.41, 277.41, 277.41, 0.0, 0.0, 1, -30.0, 30.0],
        [850, 855, 0.0312522, 0.0700944, 0.00427488, 48.7, 48.7, 48.7, 0.0, 0.0, 1, -30.0, 30.0],
        [853, 833, 0.0206427, 0.051293, 0.00291542, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [853, 860, 0.00921547, 0.0288024, 0.00268076, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [855, 819, 0.0163929, 0.0456407, 0.00135977, 81.71, 81.71, 81.71, 0.0, 0.0, 1, -30.0, 30.0],
        [855, 824, 0.0123463, 0.0410783, 0.000840856, 67.55, 67.55, 67.55, 0.0, 0.0, 1, -30.0, 30.0],
        [855, 824, 0.0123463, 0.0410783, 0.000840856, 67.55, 67.55, 67.55, 0.0, 0.0, 1, -30.0, 30.0],
        [856, 831, 0.0287447, 0.0609652, 0.00296309, 65.58, 65.58, 65.58, 0.0, 0.0, 1, -30.0, 30.0],
        [856, 848, 0.013173, 0.0363622, 0.00105167, 64.67, 64.67, 64.67, 0.0, 0.0, 1, -30.0, 30.0],
        [857, 846, 0.0116889, 0.0312915, 0.00154574, 66.91, 66.91, 66.91, 0.0, 0.0, 1, -30.0, 30.0],
        [859, 1263, 0.00795774, 0.0447862, 0.0227307, 298.02, 298.02, 298.02, 0.0, 0.0, 1, -30.0, 30.0],
        [860, 833, 0.0198967, 0.0567364, 0.00159243, 56.52, 56.52, 56.52, 0.0, 0.0, 1, -30.0, 30.0],
        [861, 783, 0.00635748, 0.0376093, 0.0261276, 221.06, 221.06, 221.06, 0.0, 0.0, 1, -30.0, 30.0],
        [861, 812, 0.00670174, 0.0447301, 0.0146314, 237.81, 237.81, 237.81, 0.0, 0.0, 1, -30.0, 30.0],
        [861, 849, 0.00616619, 0.0338556, 0.0240714, 223.92, 223.92, 223.92, 0.0, 0.0, 1, -30.0, 30.0],
        [862, 1075, 0.00744938, 0.0392079, 0.0138364, 172.94, 172.94, 172.94, 0.0, 0.0, 1, -30.0, 30.0],
        [863, 1406, 0.000742357, 0.00886093, 0.130025, 1034.36, 1034.36, 1034.36, 0.0, 0.0, 1, -30.0, 30.0],
        [865, 854, 0.0144462, 0.0345593, 0.00316672, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [866, 867, 0.000276341, 0.00109427, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [866, 1430, 0.0149641, 0.0398307, 0.00143931, 68.79, 68.79, 68.79, 0.0, 0.0, 1, -30.0, 30.0],
        [866, 1430, 0.0149641, 0.0398307, 0.00143931, 68.79, 68.79, 68.79, 0.0, 0.0, 1, -30.0, 30.0],
        [868, 869, 0.000223148, 0.00101107, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [868, 884, 0.0257323, 0.0518335, 0.00954313, 76.27, 76.27, 76.27, 0.0, 0.0, 1, -30.0, 30.0],
        [868, 884, 0.0257323, 0.0518335, 0.00954313, 76.27, 76.27, 76.27, 0.0, 0.0, 1, -30.0, 30.0],
        [868, 884, 0.0257323, 0.0518335, 0.00954313, 76.27, 76.27, 76.27, 0.0, 0.0, 1, -30.0, 30.0],
        [868, 1408, 0.0160935, 0.0352051, 0.000561057, 78.52, 78.52, 78.52, 0.0, 0.0, 1, -30.0, 30.0],
        [868, 1408, 0.0160935, 0.0352051, 0.000561057, 78.52, 78.52, 78.52, 0.0, 0.0, 1, -30.0, 30.0],
        [868, 1408, 0.0160935, 0.0352051, 0.000561057, 78.52, 78.52, 78.52, 0.0, 0.0, 1, -30.0, 30.0],
        [870, 1430, 0.0650136, 0.167707, 0.00591362, 57.62, 57.62, 57.62, 0.0, 0.0, 1, -30.0, 30.0],
        [872, 1409, 0.00713069, 0.0447113, 0.0223776, 251.52, 251.52, 251.52, 0.0, 0.0, 1, -30.0, 30.0],
        [873, 872, 0.00331653, 0.0214213, 0.00843231, 204.21, 204.21, 204.21, 0.0, 0.0, 1, -30.0, 30.0],
        [873, 1286, 0.00692452, 0.0279289, 0.0169179, 248.45, 248.45, 248.45, 0.0, 0.0, 1, -30.0, 30.0],
        [874, 875, 0.0234442, 0.0433118, 0.00128198, 62.5, 62.5, 62.5, 0.0, 0.0, 1, -30.0, 30.0],
        [874, 1280, 0.0239702, 0.0646327, 0.00278759, 71.76, 71.76, 71.76, 0.0, 0.0, 1, -30.0, 30.0],
        [875, 866, 0.0205218, 0.051568, 0.00203657, 55.41, 55.41, 55.41, 0.0, 0.0, 1, -30.0, 30.0],
        [875, 876, 0.013589, 0.0322821, 0.00258304, 108.63, 108.63, 108.63, 0.0, 0.0, 1, -30.0, 30.0],
        [875, 1430, 0.0213043, 0.0470697, 0.00302565, 74.22, 74.22, 74.22, 0.0, 0.0, 1, -30.0, 30.0],
        [875, 1430, 0.0213043, 0.0470697, 0.00302565, 74.22, 74.22, 74.22, 0.0, 0.0, 1, -30.0, 30.0],
        [876, 870, 0.0130195, 0.0317378, 0.00276845, 51.9, 51.9, 51.9, 0.0, 0.0, 1, -30.0, 30.0],
        [876, 877, 0.0363281, 0.0818851, 0.00352788, 64.86, 64.86, 64.86, 0.0, 0.0, 1, -30.0, 30.0],
        [876, 879, 0.00851556, 0.0200381, 0.0235247, 118.15, 118.15, 118.15, 0.0, 0.0, 1, -30.0, 30.0],
        [878, 880, 0.000264349, 0.00119166, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [879, 891, 0.016346, 0.041839, 0.003042, 68.22, 68.22, 68.22, 0.0, 0.0, 1, -30.0, 30.0],
        [879, 897, 0.0168704, 0.034681, 0.00162615, 43.5, 43.5, 43.5, 0.0, 0.0, 1, -30.0, 30.0],
        [880, 1329, 0.00574032, 0.0454716, 0.0184203, 244.58, 244.58, 244.58, 0.0, 0.0, 1, -30.0, 30.0],
        [881, 883, 0.000233237, 0.00113654, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [881, 886, 0.00406248, 0.0269318, 0.0080785, 236.19, 236.19, 236.19, 0.0, 0.0, 1, -30.0, 30.0],
        [881, 1102, 0.00813538, 0.0508602, 0.0154714, 209.82, 209.82, 209.82, 0.0, 0.0, 1, -30.0, 30.0],
        [882, 891, 0.01315, 0.043098, 0.001468, 120.0, 120.0, 120.0, 0.0, 0.0, 1, -30.0, 30.0],
        [882, 895, 0.0162207, 0.0412893, 0.00415737, 66.4, 66.4, 66.4, 0.0, 0.0, 1, -30.0, 30.0],
        [882, 899, 0.0248779, 0.0475163, 0.00255782, 69.48, 69.48, 69.48, 0.0, 0.0, 1, -30.0, 30.0],
        [882, 899, 0.0248779, 0.0475163, 0.00255782, 69.48, 69.48, 69.48, 0.0, 0.0, 1, -30.0, 30.0],
        [882, 901, 0.0354958, 0.0892573, 0.00273117, 62.19, 62.19, 62.19, 0.0, 0.0, 1, -30.0, 30.0],
        [884, 890, 0.0184526, 0.0504054, 0.0023841, 49.38, 49.38, 49.38, 0.0, 0.0, 1, -30.0, 30.0],
        [884, 893, 0.048909, 0.111161, 0.00415771, 77.18, 77.18, 77.18, 0.0, 0.0, 1, -30.0, 30.0],
        [884, 1098, 0.0884745, 0.211853, 0.00616446, 80.47, 80.47, 80.47, 0.0, 0.0, 1, -30.0, 30.0],
        [884, 1098, 0.0884745, 0.211853, 0.00616446, 80.47, 80.47, 80.47, 0.0, 0.0, 1, -30.0, 30.0],
        [885, 887, 0.000287341, 0.00118496, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [888, 1107, 0.0152849, 0.0417149, 0.00288019, 66.96, 66.96, 66.96, 0.0, 0.0, 1, -30.0, 30.0],
        [888, 1346, 0.0182058, 0.0382904, 0.00194619, 73.22, 73.22, 73.22, 0.0, 0.0, 1, -30.0, 30.0],
        [889, 899, 0.0324359, 0.0921834, 0.00806293, 54.64, 54.64, 54.64, 0.0, 0.0, 1, -30.0, 30.0],
        [889, 1100, 0.0755974, 0.180334, 0.00619858, 51.05, 51.05, 51.05, 0.0, 0.0, 1, -30.0, 30.0],
        [890, 891, 0.009621, 0.023244, 0.001062, 77.96, 77.96, 77.96, 0.0, 0.0, 1, -30.0, 30.0],
        [890, 901, 0.0185513, 0.0545375, 0.00151043, 72.77, 72.77, 72.77, 0.0, 0.0, 1, -30.0, 30.0],
        [890, 901, 0.0185513, 0.0545375, 0.00151043, 72.77, 72.77, 72.77, 0.0, 0.0, 1, -30.0, 30.0],
        [892, 884, 0.0121481, 0.0335744, 0.00162421, 69.08, 69.08, 69.08, 0.0, 0.0, 1, -30.0, 30.0],
        [892, 901, 0.0363382, 0.078617, 0.00205382, 70.35, 70.35, 70.35, 0.0, 0.0, 1, -30.0, 30.0],
        [893, 894, 0.000207915, 0.00117142, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [895, 1105, 0.0895543, 0.179898, 0.00759527, 51.81, 51.81, 51.81, 0.0, 0.0, 1, -30.0, 30.0],
        [896, 880, 0.00220113, 0.0122884, 0.00493934, 199.18, 199.18, 199.18, 0.0, 0.0, 1, -30.0, 30.0],
        [896, 898, 0.000285712, 0.00111172, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [896, 1286, 0.00749865, 0.0375115, 0.0191417, 267.28, 267.28, 267.28, 0.0, 0.0, 1, -30.0, 30.0],
        [896, 1286, 0.00749865, 0.0375115, 0.0191417, 267.28, 267.28, 267.28, 0.0, 0.0, 1, -30.0, 30.0],
        [897, 877, 0.0310009, 0.0877229, 0.00315856, 63.01, 63.01, 63.01, 0.0, 0.0, 1, -30.0, 30.0],
        [900, 881, 0.00775112, 0.0313461, 0.007673, 253.17, 253.17, 253.17, 0.0, 0.0, 1, -30.0, 30.0],
        [900, 896, 0.00124437, 0.00879118, 0.0203382, 246.31, 246.31, 246.31, 0.0, 0.0, 1, -30.0, 30.0],
        [900, 902, 0.000213643, 0.00118333, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [900, 1106, 0.00456359, 0.024189, 0.0119209, 246.86, 246.86, 246.86, 0.0, 0.0, 1, -30.0, 30.0],
        [900, 1286, 0.00618198, 0.0336243, 0.0169232, 276.6, 276.6, 276.6, 0.0, 0.0, 1, -30.0, 30.0],
        [900, 1286, 0.00618198, 0.0336243, 0.0169232, 276.6, 276.6, 276.6, 0.0, 0.0, 1, -30.0, 30.0],
        [903, 1355, 0.0215532, 0.0501785, 0.00383496, 96.28, 96.28, 96.28, 0.0, 0.0, 1, -30.0, 30.0],
        [904, 906, 0.000284052, 0.00104099, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [905, 903, 0.0202099, 0.0452365, 0.00127449, 68.8, 68.8, 68.8, 0.0, 0.0, 1, -30.0, 30.0],
        [905, 903, 0.0202099, 0.0452365, 0.00127449, 68.8, 68.8, 68.8, 0.0, 0.0, 1, -30.0, 30.0],
        [905, 908, 0.0175574, 0.0430054, 0.00142481, 96.67, 96.67, 96.67, 0.0, 0.0, 1, -30.0, 30.0],
        [905, 1464, 0.0162675, 0.0476633, 0.00395311, 115.2, 115.2, 115.2, 0.0, 0.0, 1, -30.0, 30.0],
        [906, 956, 0.00544146, 0.0322106, 0.00627746, 197.56, 197.56, 197.56, 0.0, 0.0, 1, -30.0, 30.0],
        [906, 1428, 0.00398516, 0.0277768, 0.0368543, 273.54, 273.54, 273.54, 0.0, 0.0, 1, -30.0, 30.0],
        [906, 1428, 0.00398516, 0.0277768, 0.0368543, 273.54, 273.54, 273.54, 0.0, 0.0, 1, -30.0, 30.0],
        [906, 1467, 0.00307403, 0.0166808, 0.0114274, 313.26, 313.26, 313.26, 0.0, 0.0, 1, -30.0, 30.0],
        [907, 909, 0.0129662, 0.0350265, 0.00154191, 60.53, 60.53, 60.53, 0.0, 0.0, 1, -30.0, 30.0],
        [907, 910, 0.0461419, 0.095697, 0.00708217, 77.38, 77.38, 77.38, 0.0, 0.0, 1, -30.0, 30.0],
        [907, 910, 0.0461419, 0.095697, 0.00708217, 77.38, 77.38, 77.38, 0.0, 0.0, 1, -30.0, 30.0],
        [907, 910, 0.0461419, 0.095697, 0.00708217, 77.38, 77.38, 77.38, 0.0, 0.0, 1, -30.0, 30.0],
        [907, 1355, 0.0155987, 0.0420016, 0.00101385, 56.26, 56.26, 56.26, 0.0, 0.0, 1, -30.0, 30.0],
        [907, 1472, 0.0148331, 0.0300098, 0.00117289, 71.92, 71.92, 71.92, 0.0, 0.0, 1, -30.0, 30.0],
        [907, 1472, 0.0148331, 0.0300098, 0.00117289, 71.92, 71.92, 71.92, 0.0, 0.0, 1, -30.0, 30.0],
        [909, 1355, 0.00806644, 0.0206432, 0.000580483, 50.68, 50.68, 50.68, 0.0, 0.0, 1, -30.0, 30.0],
        [911, 910, 0.045129, 0.08748, 0.0029765, 74.7, 74.7, 74.7, 0.0, 0.0, 1, -30.0, 30.0],
        [911, 910, 0.045129, 0.08748, 0.0029765, 85.09, 85.09, 85.09, 0.0, 0.0, 1, -30.0, 30.0],
        [911, 1110, 0.125287, 0.219752, 0.0102101, 68.62, 68.62, 68.62, 0.0, 0.0, 1, -30.0, 30.0],
        [911, 1110, 0.125287, 0.219752, 0.0102101, 68.62, 68.62, 68.62, 0.0, 0.0, 1, -30.0, 30.0],
        [912, 1314, 0.00407732, 0.0251471, 0.00848059, 227.84, 227.84, 227.84, 0.0, 0.0, 1, -30.0, 30.0],
        [912, 1342, 0.00739072, 0.0399005, 0.0195604, 214.34, 214.34, 214.34, 0.0, 0.0, 1, -30.0, 30.0],
        [913, 915, 0.000293722, 0.00116715, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [914, 789, 0.0422731, 0.122758, 0.00318974, 64.51, 64.51, 64.51, 0.0, 0.0, 1, -30.0, 30.0],
        [915, 912, 0.0072293, 0.049528, 0.0118029, 231.41, 231.41, 231.41, 0.0, 0.0, 1, -30.0, 30.0],
        [917, 908, 0.0422276, 0.0994981, 0.00276473, 86.75, 86.75, 86.75, 0.0, 0.0, 1, -30.0, 30.0],
        [918, 1376, 0.00784507, 0.0405413, 0.0248877, 252.37, 252.37, 252.37, 0.0, 0.0, 1, -30.0, 30.0],
        [919, 920, 0.066865, 0.113669, 0.00164769, 67.82, 67.82, 67.82, 0.0, 0.0, 1, -30.0, 30.0],
        [919, 920, 0.066865, 0.113669, 0.00164769, 67.82, 67.82, 67.82, 0.0, 0.0, 1, -30.0, 30.0],
        [920, 927, 0.0121093, 0.0315235, 0.00865251, 74.2, 74.2, 74.2, 0.0, 0.0, 1, -30.0, 30.0],
        [920, 927, 0.0121093, 0.0315235, 0.00865251, 92.46, 92.46, 92.46, 0.0, 0.0, 1, -30.0, 30.0],
        [922, 923, 0.034876, 0.0979201, 0.00384052, 51.45, 51.45, 51.45, 0.0, 0.0, 1, -30.0, 30.0],
        [922, 942, 0.0512683, 0.0842536, 0.0083853, 67.01, 67.01, 67.01, 0.0, 0.0, 1, -30.0, 30.0],
        [922, 942, 0.0512683, 0.0842536, 0.0083853, 67.01, 67.01, 67.01, 0.0, 0.0, 1, -30.0, 30.0],
        [922, 1427, 0.0119152, 0.0296773, 0.000920763, 60.9, 60.9, 60.9, 0.0, 0.0, 1, -30.0, 30.0],
        [923, 921, 0.0191943, 0.0508227, 0.00384041, 55.01, 55.01, 55.01, 0.0, 0.0, 1, -30.0, 30.0],
        [923, 1331, 0.0700765, 0.205178, 0.00547387, 70.71, 70.71, 70.71, 0.0, 0.0, 1, -30.0, 30.0],
        [923, 1331, 0.0700765, 0.205178, 0.00547387, 70.71, 70.71, 70.71, 0.0, 0.0, 1, -30.0, 30.0],
        [924, 953, 0.0443624, 0.116599, 0.00528133, 46.41, 46.41, 46.41, 0.0, 0.0, 1, -30.0, 30.0],
        [925, 928, 0.000206185, 0.00105186, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [927, 940, 0.0255391, 0.0687652, 0.00989511, 67.84, 67.84, 67.84, 0.0, 0.0, 1, -30.0, 30.0],
        [928, 1401, 0.001059, 0.0133355, 0.397747, 1104.28, 1104.28, 1104.28, 0.0, 0.0, 1, -30.0, 30.0],
        [929, 924, 0.0288096, 0.0792624, 0.00149471, 60.99, 60.99, 60.99, 0.0, 0.0, 1, -30.0, 30.0],
        [930, 932, 0.000243422, 0.00100264, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [930, 960, 0.0068593, 0.0459985, 0.0278908, 217.5, 217.5, 217.5, 0.0, 0.0, 1, -30.0, 30.0],
        [930, 1142, 0.00697575, 0.0512134, 0.0187711, 224.24, 224.24, 224.24, 0.0, 0.0, 1, -30.0, 30.0],
        [931, 1140, 0.0275652, 0.0736848, 0.00422429, 68.93, 68.93, 68.93, 0.0, 0.0, 1, -30.0, 30.0],
        [931, 1140, 0.0275652, 0.0736848, 0.00422429, 68.93, 68.93, 68.93, 0.0, 0.0, 1, -30.0, 30.0],
        [933, 931, 0.0159626, 0.0402539, 0.00221776, 60.72, 60.72, 60.72, 0.0, 0.0, 1, -30.0, 30.0],
        [935, 937, 0.0705267, 0.173395, 0.0031257, 64.57, 64.57, 64.57, 0.0, 0.0, 1, -30.0, 30.0],
        [935, 1187, 0.0783732, 0.217089, 0.0136176, 68.01, 68.01, 68.01, 0.0, 0.0, 1, -30.0, 30.0],
        [935, 1387, 0.0719878, 0.19919, 0.00466302, 63.89, 63.89, 63.89, 0.0, 0.0, 1, -30.0, 30.0],
        [936, 938, 0.000207856, 0.00106055, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [936, 945, 0.00763405, 0.0433074, 0.0214102, 219.88, 219.88, 219.88, 0.0, 0.0, 1, -30.0, 30.0],
        [939, 937, 0.00746472, 0.0225206, 0.00798065, 35.54, 35.54, 35.54, 0.0, 0.0, 1, -30.0, 30.0],
        [940, 1233, 0.0210176, 0.0582314, 0.00494707, 85.34, 85.34, 85.34, 0.0, 0.0, 1, -30.0, 30.0],
        [942, 917, 0.0449971, 0.115449, 0.00262017, 73.7, 73.7, 73.7, 0.0, 0.0, 1, -30.0, 30.0],
        [942, 917, 0.0449971, 0.115449, 0.00262017, 73.7, 73.7, 73.7, 0.0, 0.0, 1, -30.0, 30.0],
        [943, 915, 0.00941759, 0.0508943, 0.0293292, 178.81, 178.81, 178.81, 0.0, 0.0, 1, -30.0, 30.0],
        [944, 1357, 0.0406607, 0.0885434, 0.00677368, 52.97, 52.97, 52.97, 0.0, 0.0, 1, -30.0, 30.0],
        [945, 947, 0.000210737, 0.00117214, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [945, 1483, 0.00484463, 0.0284133, 0.0307273, 248.9, 248.9, 248.9, 0.0, 0.0, 1, -30.0, 30.0],
        [946, 944, 0.0134868, 0.0343276, 0.00666352, 46.47, 46.47, 46.47, 0.0, 0.0, 1, -30.0, 30.0],
        [948, 936, 0.0212055, 0.0991524, 0.0255366, 234.15, 234.15, 234.15, 0.0, 0.0, 1, -30.0, 30.0],
        [948, 949, 0.00739877, 0.0437266, 0.0196894, 256.61, 256.61, 256.61, 0.0, 0.0, 1, -30.0, 30.0],
        [948, 949, 0.00739877, 0.0437266, 0.0196894, 256.61, 256.61, 256.61, 0.0, 0.0, 1, -30.0, 30.0],
        [948, 1483, 0.00595641, 0.0338552, 0.0174753, 224.49, 224.49, 224.49, 0.0, 0.0, 1, -30.0, 30.0],
        [949, 951, 0.000274099, 0.00101236, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [950, 1023, 0.0742636, 0.22645, 0.0119263, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [950, 1217, 0.0842428, 0.189037, 0.00420808, 66.86, 66.86, 66.86, 0.0, 0.0, 1, -30.0, 30.0],
        [952, 939, 0.0537747, 0.121439, 0.00541008, 58.25, 58.25, 58.25, 0.0, 0.0, 1, -30.0, 30.0],
        [953, 933, 0.023828, 0.0552619, 0.00290229, 46.75, 46.75, 46.75, 0.0, 0.0, 1, -30.0, 30.0],
        [954, 956, 0.000225968, 0.00104181, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [955, 1464, 0.0124338, 0.0300711, 0.0121508, 65.02, 65.02, 65.02, 0.0, 0.0, 1, -30.0, 30.0],
        [957, 955, 0.0424093, 0.0938728, 0.00257287, 45.53, 45.53, 45.53, 0.0, 0.0, 1, -30.0, 30.0],
        [958, 960, 0.000215412, 0.00119673, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [959, 929, 0.0293233, 0.0561411, 0.00330354, 70.9, 70.9, 70.9, 0.0, 0.0, 1, -30.0, 30.0],
        [959, 929, 0.0293233, 0.0561411, 0.00330354, 70.9, 70.9, 70.9, 0.0, 0.0, 1, -30.0, 30.0],
        [959, 953, 0.0339305, 0.0836565, 0.00191068, 73.12, 73.12, 73.12, 0.0, 0.0, 1, -30.0, 30.0],
        [959, 1349, 0.0151187, 0.0432886, 0.00457843, 115.36, 115.36, 115.36, 0.0, 0.0, 1, -30.0, 30.0],
        [959, 1448, 0.0241244, 0.0468359, 0.00565896, 74.31, 74.31, 74.31, 0.0, 0.0, 1, -30.0, 30.0],
        [959, 1448, 0.0241244, 0.0468359, 0.00565896, 74.31, 74.31, 74.31, 0.0, 0.0, 1, -30.0, 30.0],
        [960, 1444, 0.008204, 0.0498472, 0.0220349, 186.23, 186.23, 186.23, 0.0, 0.0, 1, -30.0, 30.0],
        [961, 934, 0.0305664, 0.0736339, 0.00292959, 65.96, 65.96, 65.96, 0.0, 0.0, 1, -30.0, 30.0],
        [961, 1209, 0.0298572, 0.0835608, 0.0107818, 63.95, 63.95, 63.95, 0.0, 0.0, 1, -30.0, 30.0],
        [962, 931, 0.029944, 0.0703077, 0.00360386, 70.45, 70.45, 70.45, 0.0, 0.0, 1, -30.0, 30.0],
        [962, 931, 0.029944, 0.0703077, 0.00360386, 70.45, 70.45, 70.45, 0.0, 0.0, 1, -30.0, 30.0],
        [963, 965, 0.000213236, 0.00112803, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [963, 1428, 0.0064191, 0.0424086, 0.0211165, 258.09, 258.09, 258.09, 0.0, 0.0, 1, -30.0, 30.0],
        [963, 1428, 0.0064191, 0.0424086, 0.0211165, 258.09, 258.09, 258.09, 0.0, 0.0, 1, -30.0, 30.0],
        [964, 934, 0.0445385, 0.101866, 0.00149597, 71.19, 71.19, 71.19, 0.0, 0.0, 1, -30.0, 30.0],
        [964, 934, 0.0445385, 0.101866, 0.00149597, 71.19, 71.19, 71.19, 0.0, 0.0, 1, -30.0, 30.0],
        [964, 957, 0.0348891, 0.0977872, 0.00199036, 62.75, 62.75, 62.75, 0.0, 0.0, 1, -30.0, 30.0],
        [966, 1141, 0.214148, 0.353051, 0.00429869, 51.49, 51.49, 51.49, 0.0, 0.0, 1, -30.0, 30.0],
        [967, 1142, 0.0102518, 0.0558398, 0.0312431, 169.9, 169.9, 169.9, 0.0, 0.0, 1, -30.0, 30.0],
        [968, 919, 0.0420904, 0.112203, 0.00648621, 76.16, 76.16, 76.16, 0.0, 0.0, 1, -30.0, 30.0],
        [968, 966, 0.0188666, 0.0640804, 0.00320425, 61.71, 61.71, 61.71, 0.0, 0.0, 1, -30.0, 30.0],
        [969, 971, 0.0208948, 0.0653657, 0.00257339, 99.28, 99.28, 99.28, 0.0, 0.0, 1, -30.0, 30.0],
        [969, 996, 0.0408003, 0.108168, 0.00363294, 77.48, 77.48, 77.48, 0.0, 0.0, 1, -30.0, 30.0],
        [970, 986, 0.00623294, 0.0315385, 0.0191051, 202.98, 202.98, 202.98, 0.0, 0.0, 1, -30.0, 30.0],
        [971, 975, 0.027749, 0.079326, 0.0035213, 58.13, 58.13, 58.13, 0.0, 0.0, 1, -30.0, 30.0],
        [972, 974, 0.000201065, 0.0011743, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [972, 1010, 0.000713133, 0.0090398, 0.10195, 1112.82, 1112.82, 1112.82, 0.0, 0.0, 1, -30.0, 30.0],
        [972, 1395, 0.000775385, 0.00935555, 0.188072, 1229.54, 1229.54, 1229.54, 0.0, 0.0, 1, -30.0, 30.0],
        [972, 1406, 0.000714401, 0.00881318, 0.184815, 1239.53, 1239.53, 1239.53, 0.0, 0.0, 1, -30.0, 30.0],
        [973, 979, 0.0064534, 0.0289398, 0.00841589, 373.03, 373.03, 373.03, 0.0, 0.0, 1, -30.0, 30.0],
        [973, 981, 0.00182705, 0.0131156, 0.0112044, 281.3, 281.3, 281.3, 0.0, 0.0, 1, -30.0, 30.0],
        [973, 981, 0.00182705, 0.0131156, 0.0112044, 281.3, 281.3, 281.3, 0.0, 0.0, 1, -30.0, 30.0],
        [973, 981, 0.00182705, 0.0131156, 0.0112044, 281.3, 281.3, 281.3, 0.0, 0.0, 1, -30.0, 30.0],
        [973, 986, 0.0073514, 0.0333571, 0.00623472, 198.68, 198.68, 198.68, 0.0, 0.0, 1, -30.0, 30.0],
        [975, 985, 0.0262347, 0.0652516, 0.00355458, 72.95, 72.95, 72.95, 0.0, 0.0, 1, -30.0, 30.0],
        [975, 1016, 0.0505178, 0.10311, 0.00208371, 34.55, 34.55, 34.55, 0.0, 0.0, 1, -30.0, 30.0],
        [976, 975, 0.0370758, 0.0916024, 0.00189265, 55.63, 55.63, 55.63, 0.0, 0.0, 1, -30.0, 30.0],
        [976, 978, 0.0292803, 0.080414, 0.00357112, 58.77, 58.77, 58.77, 0.0, 0.0, 1, -30.0, 30.0],
        [976, 982, 0.0103464, 0.0304904, 0.000962201, 84.87, 84.87, 84.87, 0.0, 0.0, 1, -30.0, 30.0],
        [976, 982, 0.0103464, 0.0304904, 0.000962201, 91.88, 91.88, 91.88, 0.0, 0.0, 1, -30.0, 30.0],
        [976, 988, 0.0367428, 0.102469, 0.00705061, 56.34, 56.34, 56.34, 0.0, 0.0, 1, -30.0, 30.0],
        [976, 1016, 0.0264548, 0.0658582, 0.00254071, 56.93, 56.93, 56.93, 0.0, 0.0, 1, -30.0, 30.0],
        [977, 979, 0.000218609, 0.00103332, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [978, 987, 0.0187595, 0.0446628, 0.00691324, 48.53, 48.53, 48.53, 0.0, 0.0, 1, -30.0, 30.0],
        [978, 988, 0.0449064, 0.115233, 0.00494904, 57.76, 57.76, 57.76, 0.0, 0.0, 1, -30.0, 30.0],
        [978, 1003, 0.0168581, 0.0416982, 0.00903127, 43.32, 43.32, 43.32, 0.0, 0.0, 1, -30.0, 30.0],
        [978, 1344, 0.00659543, 0.016892, 0.000540483, 61.04, 61.04, 61.04, 0.0, 0.0, 1, -30.0, 30.0],
        [979, 989, 0.00486856, 0.0317356, 0.0172198, 220.49, 220.49, 220.49, 0.0, 0.0, 1, -30.0, 30.0],
        [980, 978, 0.034077, 0.0694006, 0.00315631, 64.1, 64.1, 64.1, 0.0, 0.0, 1, -30.0, 30.0],
        [980, 1015, 0.0623322, 0.137775, 0.00942632, 45.51, 45.51, 45.51, 0.0, 0.0, 1, -30.0, 30.0],
        [981, 979, 0.00497629, 0.030811, 0.0128889, 204.03, 204.03, 204.03, 0.0, 0.0, 1, -30.0, 30.0],
        [981, 983, 0.000230636, 0.00104656, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [982, 1008, 0.0211138, 0.050196, 0.00447641, 93.89, 93.89, 93.89, 0.0, 0.0, 1, -30.0, 30.0],
        [982, 1016, 0.0272523, 0.0526361, 0.00273195, 75.74, 75.74, 75.74, 0.0, 0.0, 1, -30.0, 30.0],
        [982, 1016, 0.0272523, 0.0526361, 0.00273195, 75.74, 75.74, 75.74, 0.0, 0.0, 1, -30.0, 30.0],
        [984, 986, 0.000256991, 0.00116117, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [986, 1000, 0.00542912, 0.0321139, 0.0110935, 305.54, 305.54, 305.54, 0.0, 0.0, 1, -30.0, 30.0],
        [987, 985, 0.0201657, 0.0523468, 0.00258862, 57.79, 57.79, 57.79, 0.0, 0.0, 1, -30.0, 30.0],
        [989, 991, 0.000296, 0.00105065, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [990, 988, 0.0312531, 0.077845, 0.00306213, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [992, 981, 0.00486478, 0.0311878, 0.0116324, 221.74, 221.74, 221.74, 0.0, 0.0, 1, -30.0, 30.0],
        [992, 1009, 0.00469754, 0.0304403, 0.0287072, 204.41, 204.41, 204.41, 0.0, 0.0, 1, -30.0, 30.0],
        [993, 994, 0.000225311, 0.00108674, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [993, 1021, 0.122111, 0.346876, 0.00635424, 38.38, 38.38, 38.38, 0.0, 0.0, 1, -30.0, 30.0],
        [995, 997, 0.000224861, 0.00115707, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [996, 993, 0.0343715, 0.0949745, 0.00455418, 59.58, 59.58, 59.58, 0.0, 0.0, 1, -30.0, 30.0],
        [997, 1020, 0.0116863, 0.05886, 0.0232405, 221.99, 221.99, 221.99, 0.0, 0.0, 1, -30.0, 30.0],
        [998, 978, 0.0270174, 0.051444, 0.00121209, 62.95, 62.95, 62.95, 0.0, 0.0, 1, -30.0, 30.0],
        [998, 980, 0.0426137, 0.0888564, 0.00126541, 52.66, 52.66, 52.66, 0.0, 0.0, 1, -30.0, 30.0],
        [998, 1344, 0.0225199, 0.0658634, 0.0019573, 62.97, 62.97, 62.97, 0.0, 0.0, 1, -30.0, 30.0],
        [999, 987, 0.0209964, 0.0601883, 0.0014991, 64.1, 64.1, 64.1, 0.0, 0.0, 1, -30.0, 30.0],
        [999, 1003, 0.0218914, 0.0608859, 0.00238584, 65.71, 65.71, 65.71, 0.0, 0.0, 1, -30.0, 30.0],
        [1000, 1002, 0.000276912, 0.00113612, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1001, 871, 0.0806068, 0.178478, 0.00470894, 54.82, 54.82, 54.82, 0.0, 0.0, 1, -30.0, 30.0],
        [1001, 999, 0.0382799, 0.0822717, 0.00296755, 83.11, 83.11, 83.11, 0.0, 0.0, 1, -30.0, 30.0],
        [1001, 999, 0.0382799, 0.0822717, 0.00296755, 83.11, 83.11, 83.11, 0.0, 0.0, 1, -30.0, 30.0],
        [1004, 1006, 0.000206026, 0.00107192, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1007, 1009, 0.000236862, 0.00112116, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1008, 1005, 0.01, 0.026, 0.005, 107.5, 107.5, 107.5, 0.0, 0.0, 1, -30.0, 30.0],
        [1008, 1016, 0.0156236, 0.0452217, 0.00188109, 56.29, 56.29, 56.29, 0.0, 0.0, 1, -30.0, 30.0],
        [1009, 1017, 0.00547216, 0.0280527, 0.0181451, 300.0, 300.0, 300.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1010, 1012, 0.00026945, 0.00111897, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1011, 1004, 0.00265706, 0.0130797, 0.00784967, 232.29, 232.29, 232.29, 0.0, 0.0, 1, -30.0, 30.0],
        [1011, 1009, 0.00566929, 0.0245107, 0.0102829, 224.13, 224.13, 224.13, 0.0, 0.0, 1, -30.0, 30.0],
        [1013, 970, 0.00940443, 0.0467474, 0.0164635, 177.9, 177.9, 177.9, 0.0, 0.0, 1, -30.0, 30.0],
        [1013, 1020, 0.00773172, 0.0505351, 0.0153318, 204.39, 204.39, 204.39, 0.0, 0.0, 1, -30.0, 30.0],
        [1013, 1027, 0.00737906, 0.0393677, 0.0177329, 196.11, 196.11, 196.11, 0.0, 0.0, 1, -30.0, 30.0],
        [1014, 1015, 0.0288642, 0.0801733, 0.0013983, 51.22, 51.22, 51.22, 0.0, 0.0, 1, -30.0, 30.0],
        [1016, 1015, 0.00951493, 0.0237437, 0.00924968, 86.4, 86.4, 86.4, 0.0, 0.0, 1, -30.0, 30.0],
        [1017, 1019, 0.000242594, 0.00103374, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1017, 1045, 0.00654229, 0.0322797, 0.0277235, 191.7, 191.7, 191.7, 0.0, 0.0, 1, -30.0, 30.0],
        [1018, 1028, 0.0270953, 0.0862081, 0.00196126, 38.38, 38.38, 38.38, 0.0, 0.0, 1, -30.0, 30.0],
        [1018, 1029, 0.0416269, 0.0887182, 0.00741366, 68.47, 68.47, 68.47, 0.0, 0.0, 1, -30.0, 30.0],
        [1022, 1023, 0.0331787, 0.0758216, 0.00692905, 70.69, 70.69, 70.69, 0.0, 0.0, 1, -30.0, 30.0],
        [1022, 1036, 0.0948658, 0.260107, 0.00325972, 47.34, 47.34, 47.34, 0.0, 0.0, 1, -30.0, 30.0],
        [1024, 1022, 0.0228441, 0.0589345, 0.00502709, 60.62, 60.62, 60.62, 0.0, 0.0, 1, -30.0, 30.0],
        [1025, 1023, 0.0230371, 0.0652709, 0.00277184, 65.1, 65.1, 65.1, 0.0, 0.0, 1, -30.0, 30.0],
        [1025, 1242, 0.0425587, 0.0967259, 0.00240023, 72.6, 72.6, 72.6, 0.0, 0.0, 1, -30.0, 30.0],
        [1026, 1018, 0.045832, 0.105161, 0.00278057, 54.77, 54.77, 54.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1026, 1044, 0.0566785, 0.125939, 0.00262572, 63.07, 63.07, 63.07, 0.0, 0.0, 1, -30.0, 30.0],
        [1030, 1044, 0.027611, 0.0640822, 0.00422583, 68.88, 68.88, 68.88, 0.0, 0.0, 1, -30.0, 30.0],
        [1031, 1047, 0.0159276, 0.0330225, 0.00142913, 68.67, 68.67, 68.67, 0.0, 0.0, 1, -30.0, 30.0],
        [1032, 1034, 0.000225065, 0.00112909, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1033, 429, 0.0362837, 0.0904263, 0.00238877, 62.71, 62.71, 62.71, 0.0, 0.0, 1, -30.0, 30.0],
        [1033, 438, 0.0249513, 0.0473152, 0.00192132, 52.18, 52.18, 52.18, 0.0, 0.0, 1, -30.0, 30.0],
        [1034, 428, 0.0059242, 0.027248, 0.00870318, 250.0, 250.0, 250.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1034, 1046, 0.003909, 0.02655, 0.009623, 260.0, 260.0, 260.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1035, 1037, 0.000278118, 0.00102447, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1038, 507, 0.0473699, 0.108574, 0.00380162, 55.47, 55.47, 55.47, 0.0, 0.0, 1, -30.0, 30.0],
        [1039, 505, 0.00178921, 0.00915491, 0.0503661, 184.61, 184.61, 184.61, 0.0, 0.0, 1, -30.0, 30.0],
        [1039, 1027, 0.00556536, 0.0267626, 0.0348181, 166.27, 166.27, 166.27, 0.0, 0.0, 1, -30.0, 30.0],
        [1039, 1041, 0.000288891, 0.00103333, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1042, 431, 0.000852568, 0.0111274, 0.272981, 1042.49, 1042.49, 1042.49, 0.0, 0.0, 1, -30.0, 30.0],
        [1042, 972, 0.0011204, 0.0141073, 0.224594, 1135.4, 1135.4, 1135.4, 0.0, 0.0, 1, -30.0, 30.0],
        [1043, 1045, 0.000239348, 0.00102426, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1045, 1046, 0.00516779, 0.0330801, 0.0183432, 196.64, 196.64, 196.64, 0.0, 0.0, 1, -30.0, 30.0],
        [1046, 1039, 0.00809109, 0.043671, 0.00803332, 197.39, 197.39, 197.39, 0.0, 0.0, 1, -30.0, 30.0],
        [1048, 1050, 0.00915073, 0.0454795, 0.0244045, 206.14, 206.14, 206.14, 0.0, 0.0, 1, -30.0, 30.0],
        [1049, 1068, 0.0448845, 0.134177, 0.00497314, 43.65, 43.65, 43.65, 0.0, 0.0, 1, -30.0, 30.0],
        [1050, 1052, 0.000210853, 0.00102124, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1050, 1066, 0.00635115, 0.0380204, 0.0412386, 332.07, 332.07, 332.07, 0.0, 0.0, 1, -30.0, 30.0],
        [1051, 817, 1e-07, 0.015, 0.0, 140.0, 140.0, 140.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1051, 1058, 0.0342996, 0.0914182, 0.00259319, 79.41, 79.41, 79.41, 0.0, 0.0, 1, -30.0, 30.0],
        [1053, 1049, 0.0378543, 0.11217, 0.00271202, 57.06, 57.06, 57.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1053, 1051, 0.0704215, 0.148837, 0.0068763, 75.62, 75.62, 75.62, 0.0, 0.0, 1, -30.0, 30.0],
        [1054, 1056, 0.0102216, 0.0158521, 0.00614521, 127.46, 127.46, 127.46, 0.0, 0.0, 1, -30.0, 30.0],
        [1054, 1063, 0.0421498, 0.100411, 0.00449733, 63.57, 63.57, 63.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1054, 1064, 0.0540528, 0.130602, 0.00535848, 47.53, 47.53, 47.53, 0.0, 0.0, 1, -30.0, 30.0],
        [1054, 1091, 0.0905503, 0.266023, 0.00621363, 43.66, 43.66, 43.66, 0.0, 0.0, 1, -30.0, 30.0],
        [1055, 1057, 0.000286759, 0.0010938, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1056, 1065, 0.0488843, 0.121634, 0.00362914, 87.45, 87.45, 87.45, 0.0, 0.0, 1, -30.0, 30.0],
        [1056, 1065, 0.0488843, 0.121634, 0.00362914, 87.45, 87.45, 87.45, 0.0, 0.0, 1, -30.0, 30.0],
        [1058, 1061, 0.018373, 0.0443552, 0.00927176, 66.67, 66.67, 66.67, 0.0, 0.0, 1, -30.0, 30.0],
        [1058, 1061, 0.018373, 0.0443552, 0.00927176, 66.67, 66.67, 66.67, 0.0, 0.0, 1, -30.0, 30.0],
        [1059, 1254, 0.000761331, 0.00707976, 0.0994884, 986.97, 986.97, 986.97, 0.0, 0.0, 1, -30.0, 30.0],
        [1059, 1457, 0.00083176, 0.0112863, 0.18962, 1101.75, 1101.75, 1101.75, 0.0, 0.0, 1, -30.0, 30.0],
        [1060, 1062, 0.000221125, 0.00111712, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1062, 1073, 0.00749862, 0.0345144, 0.0335206, 188.8, 188.8, 188.8, 0.0, 0.0, 1, -30.0, 30.0],
        [1063, 1061, 0.00916458, 0.0256303, 0.00160012, 67.86, 67.86, 67.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1063, 1061, 0.00916458, 0.0256303, 0.00160012, 67.86, 67.86, 67.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1064, 1061, 0.0485679, 0.108646, 0.00629951, 54.96, 54.96, 54.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1066, 1069, 0.000266901, 0.00113746, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1067, 1816, 0.0145696, 0.0521735, 0.0081114, 278.91, 278.91, 278.91, 0.0, 0.0, 1, -30.0, 30.0],
        [1067, 1817, 0.030858, 0.134419, 0.013522, 129.95, 129.95, 129.95, 0.0, 0.0, 1, -30.0, 30.0],
        [1068, 1070, 0.024539, 0.0731183, 0.00286752, 122.67, 122.67, 122.67, 0.0, 0.0, 1, -30.0, 30.0],
        [1070, 1065, 0.0363766, 0.0876826, 0.00388092, 149.98, 149.98, 149.98, 0.0, 0.0, 1, -30.0, 30.0],
        [1071, 1072, 0.000290339, 0.00107502, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1074, 808, 0.000760527, 0.0107653, 0.310428, 1246.73, 1246.73, 1246.73, 0.0, 0.0, 1, -30.0, 30.0],
        [1074, 1077, 0.00027768, 0.00119731, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1075, 783, 0.00548524, 0.0377883, 0.0111728, 204.05, 204.05, 204.05, 0.0, 0.0, 1, -30.0, 30.0],
        [1075, 1073, 0.00803261, 0.0492543, 0.00959905, 222.85, 222.85, 222.85, 0.0, 0.0, 1, -30.0, 30.0],
        [1076, 790, 0.0166253, 0.0448466, 0.00268588, 65.24, 65.24, 65.24, 0.0, 0.0, 1, -30.0, 30.0],
        [1076, 1072, 0.0249728, 0.0689083, 0.00331326, 61.96, 61.96, 61.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1078, 1082, 0.0423447, 0.116644, 0.00377576, 91.94, 91.94, 91.94, 0.0, 0.0, 1, -30.0, 30.0],
        [1078, 1097, 0.0341319, 0.0713982, 0.00430506, 76.89, 76.89, 76.89, 0.0, 0.0, 1, -30.0, 30.0],
        [1078, 1097, 0.0341319, 0.0713982, 0.00430506, 76.89, 76.89, 76.89, 0.0, 0.0, 1, -30.0, 30.0],
        [1080, 1055, 0.0113185, 0.0669195, 0.0117948, 205.95, 205.95, 205.95, 0.0, 0.0, 1, -30.0, 30.0],
        [1080, 1249, 0.0041256, 0.0259375, 0.00805293, 199.7, 199.7, 199.7, 0.0, 0.0, 1, -30.0, 30.0],
        [1080, 1424, 0.0112602, 0.0649121, 0.0202986, 218.52, 218.52, 218.52, 0.0, 0.0, 1, -30.0, 30.0],
        [1081, 847, 0.00417007, 0.0222499, 0.026196, 238.97, 238.97, 238.97, 0.0, 0.0, 1, -30.0, 30.0],
        [1081, 1083, 0.000260688, 0.00113354, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1081, 1086, 0.00586549, 0.0326104, 0.0242963, 227.57, 227.57, 227.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1081, 1424, 0.019955, 0.0746233, 0.0138645, 210.63, 210.63, 210.63, 0.0, 0.0, 1, -30.0, 30.0],
        [1082, 1079, 0.0151314, 0.0398006, 0.0018003, 88.19, 88.19, 88.19, 0.0, 0.0, 1, -30.0, 30.0],
        [1082, 1091, 0.0161433, 0.0438849, 0.00371602, 70.52, 70.52, 70.52, 0.0, 0.0, 1, -30.0, 30.0],
        [1085, 1087, 0.0289545, 0.0873142, 0.00584346, 51.52, 51.52, 51.52, 0.0, 0.0, 1, -30.0, 30.0],
        [1085, 1250, 0.0517453, 0.12662, 0.00311154, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1086, 1088, 0.000295484, 0.00100307, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1089, 1425, 0.000346397, 0.00480523, 0.0780366, 1168.1, 1168.1, 1168.1, 0.0, 0.0, 1, -30.0, 30.0],
        [1090, 1092, 0.000237415, 0.00102493, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1091, 1078, 0.0116473, 0.035181, 0.00254508, 80.82, 80.82, 80.82, 0.0, 0.0, 1, -30.0, 30.0],
        [1091, 1078, 0.0116473, 0.035181, 0.00254508, 85.92, 85.92, 85.92, 0.0, 0.0, 1, -30.0, 30.0],
        [1091, 1087, 0.0296571, 0.0733595, 0.00194088, 73.48, 73.48, 73.48, 0.0, 0.0, 1, -30.0, 30.0],
        [1092, 1081, 0.00323818, 0.0131499, 0.0137771, 184.7, 184.7, 184.7, 0.0, 0.0, 1, -30.0, 30.0],
        [1093, 844, 0.0286855, 0.084588, 0.00257065, 62.88, 62.88, 62.88, 0.0, 0.0, 1, -30.0, 30.0],
        [1093, 888, 0.0181079, 0.048501, 0.00270286, 61.42, 61.42, 61.42, 0.0, 0.0, 1, -30.0, 30.0],
        [1094, 1097, 0.0286079, 0.0730849, 0.0014278, 117.55, 117.55, 117.55, 0.0, 0.0, 1, -30.0, 30.0],
        [1094, 1101, 0.0326031, 0.0858916, 0.00396932, 125.03, 125.03, 125.03, 0.0, 0.0, 1, -30.0, 30.0],
        [1095, 845, 0.00405912, 0.0250049, 0.0109671, 193.76, 193.76, 193.76, 0.0, 0.0, 1, -30.0, 30.0],
        [1096, 845, 0.00422124, 0.0206313, 0.0263285, 218.63, 218.63, 218.63, 0.0, 0.0, 1, -30.0, 30.0],
        [1096, 1081, 0.00360005, 0.0181251, 0.00968752, 187.41, 187.41, 187.41, 0.0, 0.0, 1, -30.0, 30.0],
        [1098, 1099, 0.000297011, 0.00108329, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1100, 857, 0.0267051, 0.0573351, 0.00539015, 62.24, 62.24, 62.24, 0.0, 0.0, 1, -30.0, 30.0],
        [1100, 1093, 0.0358644, 0.079428, 0.00104239, 51.85, 51.85, 51.85, 0.0, 0.0, 1, -30.0, 30.0],
        [1101, 1098, 0.0224486, 0.0535138, 0.00255244, 142.16, 142.16, 142.16, 0.0, 0.0, 1, -30.0, 30.0],
        [1102, 1104, 0.000219214, 0.00116358, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1105, 1093, 0.0144544, 0.0393812, 0.00588137, 43.84, 43.84, 43.84, 0.0, 0.0, 1, -30.0, 30.0],
        [1105, 1103, 0.021621, 0.0635122, 0.00133832, 54.79, 54.79, 54.79, 0.0, 0.0, 1, -30.0, 30.0],
        [1106, 886, 0.00589581, 0.0224816, 0.00997078, 202.53, 202.53, 202.53, 0.0, 0.0, 1, -30.0, 30.0],
        [1106, 1108, 0.000259213, 0.00115678, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1106, 1347, 0.00414755, 0.0222513, 0.00685202, 220.27, 220.27, 220.27, 0.0, 0.0, 1, -30.0, 30.0],
        [1109, 1110, 0.0498866, 0.0981325, 0.00422932, 93.92, 93.92, 93.92, 0.0, 0.0, 1, -30.0, 30.0],
        [1109, 1119, 0.0820909, 0.158318, 0.00457502, 55.19, 55.19, 55.19, 0.0, 0.0, 1, -30.0, 30.0],
        [1110, 1158, 0.0129997, 0.0364564, 0.0017828, 65.86, 65.86, 65.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1111, 1113, 0.000206322, 0.00119514, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1111, 1114, 0.0140399, 0.0560249, 0.0148539, 236.73, 236.73, 236.73, 0.0, 0.0, 1, -30.0, 30.0],
        [1111, 1120, 0.00643314, 0.0315385, 0.0280208, 214.67, 214.67, 214.67, 0.0, 0.0, 1, -30.0, 30.0],
        [1112, 1109, 0.018382, 0.0503205, 0.000638131, 61.99, 61.99, 61.99, 0.0, 0.0, 1, -30.0, 30.0],
        [1115, 1117, 0.000249692, 0.00105109, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1116, 1118, 0.0402325, 0.0784115, 0.00440757, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1119, 779, 0.103584, 0.256695, 0.00589165, 100.88, 100.88, 100.88, 0.0, 0.0, 1, -30.0, 30.0],
        [1120, 1048, 0.00978236, 0.066883, 0.0549006, 181.49, 181.49, 181.49, 0.0, 0.0, 1, -30.0, 30.0],
        [1120, 1122, 0.000250486, 0.00100105, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1121, 1119, 0.0133846, 0.0398521, 0.00530145, 105.58, 105.58, 105.58, 0.0, 0.0, 1, -30.0, 30.0],
        [1121, 1813, 0.0710307, 0.149782, 0.00898974, 85.73, 85.73, 85.73, 0.0, 0.0, 1, -30.0, 30.0],
        [1123, 1124, 0.0172735, 0.0436234, 0.00281037, 40.51, 40.51, 40.51, 0.0, 0.0, 1, -30.0, 30.0],
        [1123, 1221, 0.0181516, 0.0453877, 0.00486894, 63.91, 63.91, 63.91, 0.0, 0.0, 1, -30.0, 30.0],
        [1124, 1126, 0.0175868, 0.0406567, 0.0010601, 86.37, 86.37, 86.37, 0.0, 0.0, 1, -30.0, 30.0],
        [1125, 1127, 0.00023124, 0.00114631, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1125, 1132, 0.00421149, 0.0258747, 0.0191247, 140.41, 140.41, 140.41, 0.0, 0.0, 1, -30.0, 30.0],
        [1126, 681, 0.0251425, 0.0597851, 0.00164687, 67.88, 67.88, 67.88, 0.0, 0.0, 1, -30.0, 30.0],
        [1126, 681, 0.0251425, 0.0597851, 0.00164687, 67.88, 67.88, 67.88, 0.0, 0.0, 1, -30.0, 30.0],
        [1128, 1305, 0.000750237, 0.0079125, 0.171683, 1052.19, 1052.19, 1052.19, 0.0, 0.0, 1, -30.0, 30.0],
        [1128, 1321, 0.000907124, 0.00987158, 0.121325, 1118.75, 1118.75, 1118.75, 0.0, 0.0, 1, -30.0, 30.0],
        [1129, 1131, 0.000275328, 0.00112981, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1132, 1131, 0.00547913, 0.029702, 0.0119595, 191.24, 191.24, 191.24, 0.0, 0.0, 1, -30.0, 30.0],
        [1133, 702, 0.031599, 0.083534, 0.003102, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1133, 1130, 0.0120902, 0.0298202, 0.00911791, 76.13, 76.13, 76.13, 0.0, 0.0, 1, -30.0, 30.0],
        [1133, 1130, 0.0120902, 0.0298202, 0.00911791, 76.13, 76.13, 76.13, 0.0, 0.0, 1, -30.0, 30.0],
        [1133, 1130, 0.0120902, 0.0298202, 0.00911791, 76.13, 76.13, 76.13, 0.0, 0.0, 1, -30.0, 30.0],
        [1133, 1136, 0.0237616, 0.0457047, 0.00700447, 59.3, 59.3, 59.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1134, 1123, 0.0142731, 0.0424435, 0.00203552, 58.41, 58.41, 58.41, 0.0, 0.0, 1, -30.0, 30.0],
        [1135, 1137, 0.000222515, 0.00117102, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1135, 1211, 0.00795184, 0.0456821, 0.0105338, 234.75, 234.75, 234.75, 0.0, 0.0, 1, -30.0, 30.0],
        [1136, 1134, 0.0104475, 0.026254, 0.0016754, 88.61, 88.61, 88.61, 0.0, 0.0, 1, -30.0, 30.0],
        [1138, 1221, 0.0184812, 0.0442748, 0.00169291, 61.71, 61.71, 61.71, 0.0, 0.0, 1, -30.0, 30.0],
        [1138, 1437, 0.0278113, 0.0658543, 0.00457232, 75.75, 75.75, 75.75, 0.0, 0.0, 1, -30.0, 30.0],
        [1138, 1437, 0.0278113, 0.0658543, 0.00457232, 75.75, 75.75, 75.75, 0.0, 0.0, 1, -30.0, 30.0],
        [1138, 1437, 0.0278113, 0.0658543, 0.00457232, 75.75, 75.75, 75.75, 0.0, 0.0, 1, -30.0, 30.0],
        [1139, 1136, 0.0237072, 0.0688616, 0.00286668, 41.89, 41.89, 41.89, 0.0, 0.0, 1, -30.0, 30.0],
        [1139, 1140, 0.0313226, 0.084203, 0.00341006, 62.48, 62.48, 62.48, 0.0, 0.0, 1, -30.0, 30.0],
        [1140, 924, 0.00984033, 0.0309634, 0.0071681, 53.92, 53.92, 53.92, 0.0, 0.0, 1, -30.0, 30.0],
        [1140, 1437, 0.0105536, 0.0239093, 0.00170812, 75.79, 75.79, 75.79, 0.0, 0.0, 1, -30.0, 30.0],
        [1142, 1135, 0.0118172, 0.0514987, 0.0124574, 178.46, 178.46, 178.46, 0.0, 0.0, 1, -30.0, 30.0],
        [1143, 1144, 0.0333413, 0.0771364, 0.00328102, 79.45, 79.45, 79.45, 0.0, 0.0, 1, -30.0, 30.0],
        [1143, 1144, 0.0333413, 0.0771364, 0.00328102, 79.45, 79.45, 79.45, 0.0, 0.0, 1, -30.0, 30.0],
        [1145, 1148, 0.0002839, 0.00109107, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1145, 1222, 0.00117407, 0.0145981, 0.267478, 1368.43, 1368.43, 1368.43, 0.0, 0.0, 1, -30.0, 30.0],
        [1147, 1144, 0.0150869, 0.0460163, 0.00181684, 80.15, 80.15, 80.15, 0.0, 0.0, 1, -30.0, 30.0],
        [1149, 655, 0.00745047, 0.0337646, 0.00676622, 232.85, 232.85, 232.85, 0.0, 0.0, 1, -30.0, 30.0],
        [1149, 1146, 0.005159, 0.0274333, 0.00574909, 189.26, 189.26, 189.26, 0.0, 0.0, 1, -30.0, 30.0],
        [1150, 1317, 0.0820694, 0.15254, 0.00480711, 89.0, 89.0, 89.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1151, 1141, 0.0450493, 0.116094, 0.00375462, 50.71, 50.71, 50.71, 0.0, 0.0, 1, -30.0, 30.0],
        [1151, 1150, 0.0645089, 0.15183, 0.00244045, 50.67, 50.67, 50.67, 0.0, 0.0, 1, -30.0, 30.0],
        [1152, 1133, 0.0179797, 0.0437131, 0.00320549, 67.17, 67.17, 67.17, 0.0, 0.0, 1, -30.0, 30.0],
        [1152, 1133, 0.0179797, 0.0437131, 0.00320549, 67.17, 67.17, 67.17, 0.0, 0.0, 1, -30.0, 30.0],
        [1152, 1151, 0.0278393, 0.0880607, 0.0020637, 72.06, 72.06, 72.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1154, 1156, 0.000277038, 0.00113713, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1154, 1222, 0.00062759, 0.00827101, 0.160637, 1113.28, 1113.28, 1113.28, 0.0, 0.0, 1, -30.0, 30.0],
        [1155, 1111, 0.00670658, 0.0429711, 0.0138404, 263.45, 263.45, 263.45, 0.0, 0.0, 1, -30.0, 30.0],
        [1155, 1111, 0.00670658, 0.0429711, 0.0138404, 263.45, 263.45, 263.45, 0.0, 0.0, 1, -30.0, 30.0],
        [1155, 1469, 0.00236134, 0.0142863, 0.00482526, 224.59, 224.59, 224.59, 0.0, 0.0, 1, -30.0, 30.0],
        [1157, 1153, 0.0312593, 0.085045, 0.00238509, 46.7, 46.7, 46.7, 0.0, 0.0, 1, -30.0, 30.0],
        [1157, 1158, 0.0208026, 0.0593244, 0.0072005, 64.94, 64.94, 64.94, 0.0, 0.0, 1, -30.0, 30.0],
        [1160, 1161, 0.000203358, 0.00112304, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1161, 1194, 0.0220178, 0.0723929, 0.0117052, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1161, 1194, 0.0220178, 0.0723929, 0.0117052, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1162, 1164, 0.000240712, 0.00106181, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1163, 1239, 0.00551901, 0.0312454, 0.00980949, 237.43, 237.43, 237.43, 0.0, 0.0, 1, -30.0, 30.0],
        [1164, 1167, 0.000771155, 0.0083278, 0.236204, 1089.13, 1089.13, 1089.13, 0.0, 0.0, 1, -30.0, 30.0],
        [1165, 1161, 0.030883, 0.076616, 0.002115, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1165, 1413, 0.030743, 0.0806334, 0.00231894, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1166, 1159, 0.0505333, 0.132691, 0.00807791, 50.54, 50.54, 50.54, 0.0, 0.0, 1, -30.0, 30.0],
        [1167, 553, 0.000390293, 0.00493056, 0.0886286, 1359.43, 1359.43, 1359.43, 0.0, 0.0, 1, -30.0, 30.0],
        [1167, 553, 0.000390293, 0.00493056, 0.0886286, 1359.43, 1359.43, 1359.43, 0.0, 0.0, 1, -30.0, 30.0],
        [1168, 1170, 0.000255201, 0.00117834, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1169, 1177, 0.0182049, 0.041866, 0.00184297, 70.44, 70.44, 70.44, 0.0, 0.0, 1, -30.0, 30.0],
        [1169, 1177, 0.0182049, 0.041866, 0.00184297, 77.56, 77.56, 77.56, 0.0, 0.0, 1, -30.0, 30.0],
        [1169, 1184, 0.034495, 0.0893192, 0.00210084, 54.05, 54.05, 54.05, 0.0, 0.0, 1, -30.0, 30.0],
        [1170, 770, 0.00768307, 0.0414936, 0.0166012, 225.81, 225.81, 225.81, 0.0, 0.0, 1, -30.0, 30.0],
        [1171, 1173, 0.000258748, 0.00113762, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1173, 1170, 0.00300361, 0.0151995, 0.00673153, 273.62, 273.62, 273.62, 0.0, 0.0, 1, -30.0, 30.0],
        [1173, 1170, 0.00300361, 0.0151995, 0.00673153, 317.32, 317.32, 317.32, 0.0, 0.0, 1, -30.0, 30.0],
        [1173, 1174, 0.00627011, 0.0335352, 0.0203131, 315.54, 315.54, 315.54, 0.0, 0.0, 1, -30.0, 30.0],
        [1173, 1174, 0.00627011, 0.0335352, 0.0203131, 315.54, 315.54, 315.54, 0.0, 0.0, 1, -30.0, 30.0],
        [1173, 1183, 0.00492186, 0.0247266, 0.00629295, 323.24, 323.24, 323.24, 0.0, 0.0, 1, -30.0, 30.0],
        [1174, 1176, 0.000263846, 0.00111106, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1174, 1239, 0.00265335, 0.0170558, 0.00902712, 239.05, 239.05, 239.05, 0.0, 0.0, 1, -30.0, 30.0],
        [1174, 1239, 0.00265335, 0.0170558, 0.00902712, 239.05, 239.05, 239.05, 0.0, 0.0, 1, -30.0, 30.0],
        [1175, 1193, 0.0147669, 0.0346597, 0.00125382, 70.67, 70.67, 70.67, 0.0, 0.0, 1, -30.0, 30.0],
        [1177, 1178, 0.0183221, 0.03967, 0.00155918, 75.21, 75.21, 75.21, 0.0, 0.0, 1, -30.0, 30.0],
        [1178, 1172, 0.0220624, 0.0501918, 0.00183498, 67.23, 67.23, 67.23, 0.0, 0.0, 1, -30.0, 30.0],
        [1178, 1180, 0.0460089, 0.137426, 0.00549554, 65.35, 65.35, 65.35, 0.0, 0.0, 1, -30.0, 30.0],
        [1178, 1182, 0.0220016, 0.0534287, 0.00195278, 90.87, 90.87, 90.87, 0.0, 0.0, 1, -30.0, 30.0],
        [1178, 1197, 0.0149199, 0.0408657, 0.00210721, 98.55, 98.55, 98.55, 0.0, 0.0, 1, -30.0, 30.0],
        [1180, 1193, 0.0630696, 0.163134, 0.00864979, 49.6, 49.6, 49.6, 0.0, 0.0, 1, -30.0, 30.0],
        [1181, 1183, 0.00020639, 0.00117948, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1183, 1195, 0.00596029, 0.0288694, 0.0176811, 272.6, 272.6, 272.6, 0.0, 0.0, 1, -30.0, 30.0],
        [1184, 1194, 0.0289589, 0.075354, 0.00383609, 55.75, 55.75, 55.75, 0.0, 0.0, 1, -30.0, 30.0],
        [1185, 1187, 0.100046, 0.23871, 0.0228687, 62.23, 62.23, 62.23, 0.0, 0.0, 1, -30.0, 30.0],
        [1186, 1189, 0.0145081, 0.103875, 0.0470328, 187.55, 187.55, 187.55, 0.0, 0.0, 1, -30.0, 30.0],
        [1186, 1239, 0.0281221, 0.1582, 0.0437334, 139.88, 139.88, 139.88, 0.0, 0.0, 1, -30.0, 30.0],
        [1187, 1188, 0.0421159, 0.0881778, 0.00363949, 48.89, 48.89, 48.89, 0.0, 0.0, 1, -30.0, 30.0],
        [1187, 1190, 0.0600747, 0.132326, 0.00587282, 58.3, 58.3, 58.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1188, 1190, 0.0370224, 0.0785921, 0.00296209, 60.22, 60.22, 60.22, 0.0, 0.0, 1, -30.0, 30.0],
        [1189, 936, 0.01463, 0.070975, 0.09917, 300.0, 300.0, 300.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1189, 1191, 0.000264322, 0.00115381, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1190, 1324, 0.115469, 0.313871, 0.00874852, 47.69, 47.69, 47.69, 0.0, 0.0, 1, -30.0, 30.0],
        [1192, 1190, 0.0399571, 0.105137, 0.00567576, 53.69, 53.69, 53.69, 0.0, 0.0, 1, -30.0, 30.0],
        [1194, 1175, 0.0204541, 0.0493676, 0.00158452, 68.74, 68.74, 68.74, 0.0, 0.0, 1, -30.0, 30.0],
        [1194, 1175, 0.0204541, 0.0493676, 0.00158452, 68.74, 68.74, 68.74, 0.0, 0.0, 1, -30.0, 30.0],
        [1194, 1236, 0.0338036, 0.0801428, 0.00515019, 91.57, 91.57, 91.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1195, 1173, 0.00471927, 0.0280266, 0.0122935, 244.82, 244.82, 244.82, 0.0, 0.0, 1, -30.0, 30.0],
        [1195, 1173, 0.00471927, 0.0280266, 0.0122935, 272.31, 272.31, 272.31, 0.0, 0.0, 1, -30.0, 30.0],
        [1197, 1198, 0.0171439, 0.0370752, 0.0033302, 65.17, 65.17, 65.17, 0.0, 0.0, 1, -30.0, 30.0],
        [1197, 1198, 0.0171439, 0.0370752, 0.0033302, 65.17, 65.17, 65.17, 0.0, 0.0, 1, -30.0, 30.0],
        [1198, 1159, 0.082738, 0.207695, 0.00363921, 56.96, 56.96, 56.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1198, 1236, 0.0321843, 0.0781017, 0.00254111, 74.76, 74.76, 74.76, 0.0, 0.0, 1, -30.0, 30.0],
        [1198, 1236, 0.0321843, 0.0781017, 0.00254111, 85.57, 85.57, 85.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1199, 1196, 0.02485, 0.0595034, 0.00204766, 68.53, 68.53, 68.53, 0.0, 0.0, 1, -30.0, 30.0],
        [1199, 1206, 0.0224258, 0.057804, 0.00526447, 68.86, 68.86, 68.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1200, 1169, 0.0143594, 0.0489158, 0.00208851, 99.06, 99.06, 99.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1200, 1169, 0.0143594, 0.0489158, 0.00208851, 99.06, 99.06, 99.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1201, 1203, 0.0196417, 0.0394421, 0.00191577, 51.55, 51.55, 51.55, 0.0, 0.0, 1, -30.0, 30.0],
        [1201, 1206, 0.0423138, 0.0855899, 0.00184059, 53.24, 53.24, 53.24, 0.0, 0.0, 1, -30.0, 30.0],
        [1202, 1204, 0.000212703, 0.00114237, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1202, 1205, 0.00487013, 0.0246653, 0.00852597, 212.54, 212.54, 212.54, 0.0, 0.0, 1, -30.0, 30.0],
        [1205, 1195, 0.00741528, 0.0484208, 0.0109804, 244.65, 244.65, 244.65, 0.0, 0.0, 1, -30.0, 30.0],
        [1205, 1195, 0.00741528, 0.0484208, 0.0109804, 272.53, 272.53, 272.53, 0.0, 0.0, 1, -30.0, 30.0],
        [1205, 1207, 0.000257343, 0.00108888, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1208, 1209, 0.000269535, 0.00110064, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1209, 1340, 0.00754125, 0.0160947, 0.000695357, 59.87, 59.87, 59.87, 0.0, 0.0, 1, -30.0, 30.0],
        [1209, 1355, 0.00802462, 0.0207587, 0.00174811, 56.68, 56.68, 56.68, 0.0, 0.0, 1, -30.0, 30.0],
        [1210, 1215, 0.000253544, 0.00110838, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1211, 696, 0.00505825, 0.0354224, 0.0139566, 368.23, 368.23, 368.23, 0.0, 0.0, 1, -30.0, 30.0],
        [1211, 1125, 0.00262276, 0.0150469, 0.0228491, 295.83, 295.83, 295.83, 0.0, 0.0, 1, -30.0, 30.0],
        [1211, 1125, 0.00262276, 0.0150469, 0.0228491, 295.83, 295.83, 295.83, 0.0, 0.0, 1, -30.0, 30.0],
        [1211, 1125, 0.00262276, 0.0150469, 0.0228491, 295.83, 295.83, 295.83, 0.0, 0.0, 1, -30.0, 30.0],
        [1211, 1444, 0.001945, 0.0136791, 0.023085, 292.05, 292.05, 292.05, 0.0, 0.0, 1, -30.0, 30.0],
        [1211, 1444, 0.001945, 0.0136791, 0.023085, 292.05, 292.05, 292.05, 0.0, 0.0, 1, -30.0, 30.0],
        [1211, 1444, 0.001945, 0.0136791, 0.023085, 292.05, 292.05, 292.05, 0.0, 0.0, 1, -30.0, 30.0],
        [1215, 1128, 0.00053399, 0.00710367, 0.241755, 1112.3, 1112.3, 1112.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1216, 1218, 0.000236926, 0.00105356, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1217, 1331, 0.00717668, 0.0248648, 0.00175059, 51.86, 51.86, 51.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1218, 1270, 0.00190537, 0.0117918, 0.0066086, 271.18, 271.18, 271.18, 0.0, 0.0, 1, -30.0, 30.0],
        [1219, 1222, 0.000237492, 0.0010782, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1221, 1247, 0.00933107, 0.0181781, 0.000947765, 71.57, 71.57, 71.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1221, 1247, 0.00933107, 0.0181781, 0.000947765, 71.57, 71.57, 71.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1222, 1215, 0.000123306, 0.00154277, 0.0651465, 1199.61, 1199.61, 1199.61, 0.0, 0.0, 1, -30.0, 30.0],
        [1222, 1292, 0.00106435, 0.0134176, 0.224693, 1238.37, 1238.37, 1238.37, 0.0, 0.0, 1, -30.0, 30.0],
        [1223, 1231, 0.000227339, 0.00104604, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1224, 751, 0.00644538, 0.0295547, 0.00620118, 246.77, 246.77, 246.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1225, 741, 0.0174818, 0.0549388, 0.00182458, 64.64, 64.64, 64.64, 0.0, 0.0, 1, -30.0, 30.0],
        [1225, 749, 0.02928, 0.0710792, 0.00260909, 68.89, 68.89, 68.89, 0.0, 0.0, 1, -30.0, 30.0],
        [1225, 749, 0.02928, 0.0710792, 0.00260909, 68.89, 68.89, 68.89, 0.0, 0.0, 1, -30.0, 30.0],
        [1225, 1351, 0.0427332, 0.0956365, 0.0051214, 50.5, 50.5, 50.5, 0.0, 0.0, 1, -30.0, 30.0],
        [1231, 1456, 0.000448829, 0.00455836, 0.150996, 1063.53, 1063.53, 1063.53, 0.0, 0.0, 1, -30.0, 30.0],
        [1232, 963, 0.00522552, 0.0338795, 0.0122537, 248.46, 248.46, 248.46, 0.0, 0.0, 1, -30.0, 30.0],
        [1232, 1234, 0.00026321, 0.00100311, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1233, 962, 0.0540906, 0.128551, 0.00399842, 80.97, 80.97, 80.97, 0.0, 0.0, 1, -30.0, 30.0],
        [1233, 962, 0.0540906, 0.128551, 0.00399842, 80.97, 80.97, 80.97, 0.0, 0.0, 1, -30.0, 30.0],
        [1235, 1239, 0.000208011, 0.00103227, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1236, 1175, 0.0157401, 0.0382098, 0.00337373, 110.42, 110.42, 110.42, 0.0, 0.0, 1, -30.0, 30.0],
        [1240, 1245, 0.000251611, 0.0011264, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1241, 1035, 0.00935898, 0.0615674, 0.0208915, 255.7, 255.7, 255.7, 0.0, 0.0, 1, -30.0, 30.0],
        [1241, 1035, 0.00935898, 0.0615674, 0.0208915, 255.7, 255.7, 255.7, 0.0, 0.0, 1, -30.0, 30.0],
        [1241, 1333, 0.00692943, 0.0347489, 0.0162097, 350.0, 350.0, 350.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1245, 437, 0.00133622, 0.0131631, 0.272038, 1165.7, 1165.7, 1165.7, 0.0, 0.0, 1, -30.0, 30.0],
        [1246, 1247, 0.000243101, 0.00110953, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1247, 670, 0.0145613, 0.0369488, 0.0053898, 91.4, 91.4, 91.4, 0.0, 0.0, 1, -30.0, 30.0],
        [1247, 1124, 0.0124819, 0.0305532, 0.00619661, 79.38, 79.38, 79.38, 0.0, 0.0, 1, -30.0, 30.0],
        [1248, 1254, 0.000215968, 0.00103938, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1249, 1055, 0.00820488, 0.0461124, 0.018331, 236.33, 236.33, 236.33, 0.0, 0.0, 1, -30.0, 30.0],
        [1250, 1079, 0.0747677, 0.153691, 0.00426066, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1254, 1089, 0.000696879, 0.00752614, 0.105753, 1114.66, 1114.66, 1114.66, 0.0, 0.0, 1, -30.0, 30.0],
        [1254, 1821, 0.0023243, 0.0247069, 0.373987, 1359.97, 1359.97, 1359.97, 0.0, 0.0, 1, -30.0, 30.0],
        [1254, 1821, 0.0023243, 0.0247069, 0.373987, 1359.97, 1359.97, 1359.97, 0.0, 0.0, 1, -30.0, 30.0],
        [1255, 1263, 0.000277712, 0.00115361, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1263, 1302, 0.000929674, 0.00437006, 0.00274227, 338.02, 338.02, 338.02, 0.0, 0.0, 1, -30.0, 30.0],
        [1263, 1302, 0.000929674, 0.00437006, 0.00274227, 362.77, 362.77, 362.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1263, 1302, 0.000929674, 0.00437006, 0.00274227, 362.77, 362.77, 362.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1263, 1302, 0.000929674, 0.00437006, 0.00274227, 362.77, 362.77, 362.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1264, 1268, 0.000271015, 0.00111135, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1268, 1304, 0.00297558, 0.0150919, 0.00671547, 245.26, 245.26, 245.26, 0.0, 0.0, 1, -30.0, 30.0],
        [1269, 1275, 0.000265647, 0.00100138, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1270, 949, 0.00654248, 0.0427545, 0.0175526, 267.88, 267.88, 267.88, 0.0, 0.0, 1, -30.0, 30.0],
        [1270, 949, 0.00654248, 0.0427545, 0.0175526, 267.88, 267.88, 267.88, 0.0, 0.0, 1, -30.0, 30.0],
        [1275, 1245, 0.0014687, 0.0168412, 0.250171, 1104.84, 1104.84, 1104.84, 0.0, 0.0, 1, -30.0, 30.0],
        [1275, 1312, 0.000527051, 0.00574906, 0.169639, 1151.33, 1151.33, 1151.33, 0.0, 0.0, 1, -30.0, 30.0],
        [1276, 1278, 0.000244691, 0.00104204, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1277, 921, 0.020741, 0.0483032, 0.00189175, 56.43, 56.43, 56.43, 0.0, 0.0, 1, -30.0, 30.0],
        [1278, 963, 0.00924893, 0.0503983, 0.014948, 209.06, 209.06, 209.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1279, 1286, 0.000200357, 0.00103121, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1280, 868, 0.0188316, 0.0442319, 0.00104658, 66.3, 66.3, 66.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1280, 1430, 0.0024125, 0.00641454, 0.00273471, 76.78, 76.78, 76.78, 0.0, 0.0, 1, -30.0, 30.0],
        [1280, 1430, 0.0024125, 0.00641454, 0.00273471, 76.78, 76.78, 76.78, 0.0, 0.0, 1, -30.0, 30.0],
        [1280, 1430, 0.0024125, 0.00641454, 0.00273471, 76.78, 76.78, 76.78, 0.0, 0.0, 1, -30.0, 30.0],
        [1286, 1409, 0.00152438, 0.00917417, 0.00955083, 268.86, 268.86, 268.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1286, 1409, 0.00152438, 0.00917417, 0.00955083, 268.86, 268.86, 268.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1287, 1292, 0.000298851, 0.00118524, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1288, 943, 0.00625888, 0.0405045, 0.0180222, 248.28, 248.28, 248.28, 0.0, 0.0, 1, -30.0, 30.0],
        [1288, 960, 0.00571326, 0.0410148, 0.00745528, 238.83, 238.83, 238.83, 0.0, 0.0, 1, -30.0, 30.0],
        [1292, 1435, 0.000837567, 0.00898808, 0.19308, 1198.22, 1198.22, 1198.22, 0.0, 0.0, 1, -30.0, 30.0],
        [1293, 1299, 0.000266549, 0.00119466, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1294, 641, 0.00527967, 0.0348418, 0.0162403, 248.57, 248.57, 248.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1299, 1305, 0.000763625, 0.00962974, 0.407818, 1255.96, 1255.96, 1255.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1300, 1302, 0.000225191, 0.00109439, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1303, 1305, 0.000254372, 0.00111164, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1304, 687, 0.00503036, 0.0248278, 0.00697327, 276.8, 276.8, 276.8, 0.0, 0.0, 1, -30.0, 30.0],
        [1304, 687, 0.00503036, 0.0248278, 0.00697327, 296.35, 296.35, 296.35, 0.0, 0.0, 1, -30.0, 30.0],
        [1305, 609, 0.000738931, 0.00898572, 0.16501, 1312.6, 1312.6, 1312.6, 0.0, 0.0, 1, -30.0, 30.0],
        [1306, 1312, 0.000210254, 0.00102473, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1307, 1338, 0.0031624, 0.0163127, 0.0155123, 272.0, 272.0, 272.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1307, 1338, 0.0031624, 0.0163127, 0.0155123, 272.0, 272.0, 272.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1307, 1397, 0.00340821, 0.0203199, 0.0123485, 238.8, 238.8, 238.8, 0.0, 0.0, 1, -30.0, 30.0],
        [1312, 808, 0.000880236, 0.0108152, 0.317659, 1370.89, 1370.89, 1370.89, 0.0, 0.0, 1, -30.0, 30.0],
        [1312, 808, 0.000880236, 0.0108152, 0.317659, 1370.89, 1370.89, 1370.89, 0.0, 0.0, 1, -30.0, 30.0],
        [1312, 1401, 0.000363332, 0.00433901, 0.0653368, 1143.03, 1143.03, 1143.03, 0.0, 0.0, 1, -30.0, 30.0],
        [1313, 1314, 0.000286784, 0.00104932, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1314, 1471, 0.0040831, 0.0261381, 0.0246748, 200.07, 200.07, 200.07, 0.0, 0.0, 1, -30.0, 30.0],
        [1315, 1321, 0.000268478, 0.0011184, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1316, 1131, 0.0094865, 0.0567671, 0.0227377, 226.14, 226.14, 226.14, 0.0, 0.0, 1, -30.0, 30.0],
        [1321, 708, 0.00133802, 0.0159246, 0.316489, 1051.73, 1051.73, 1051.73, 0.0, 0.0, 1, -30.0, 30.0],
        [1322, 1327, 0.000247785, 0.00118361, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1323, 1480, 0.00515121, 0.0265027, 0.00939274, 350.0, 350.0, 350.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1327, 1366, 0.000142044, 0.00140005, 0.0172363, 1894.65, 1894.65, 1894.65, 0.0, 0.0, 1, -30.0, 30.0],
        [1328, 1329, 0.000283192, 0.00119248, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1329, 1409, 0.00247391, 0.0144757, 0.0199245, 230.71, 230.71, 230.71, 0.0, 0.0, 1, -30.0, 30.0],
        [1330, 1331, 0.000217443, 0.00100618, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1331, 941, 0.0404221, 0.105602, 0.00572883, 79.06, 79.06, 79.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1331, 941, 0.0404221, 0.105602, 0.00572883, 79.06, 79.06, 79.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1331, 941, 0.0404221, 0.105602, 0.00572883, 79.06, 79.06, 79.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1332, 1333, 0.000256239, 0.00106145, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1333, 1462, 0.0109745, 0.0727243, 0.0407861, 350.0, 350.0, 350.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1334, 1338, 0.000256712, 0.00104121, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1335, 922, 0.0305554, 0.0696873, 0.00151885, 63.68, 63.68, 63.68, 0.0, 0.0, 1, -30.0, 30.0],
        [1338, 1376, 0.0010865, 0.00522343, 0.00145669, 267.9, 267.9, 267.9, 0.0, 0.0, 1, -30.0, 30.0],
        [1338, 1376, 0.0010865, 0.00522343, 0.00145669, 267.9, 267.9, 267.9, 0.0, 0.0, 1, -30.0, 30.0],
        [1338, 1428, 0.003431, 0.0215856, 0.00923494, 266.7, 266.7, 266.7, 0.0, 0.0, 1, -30.0, 30.0],
        [1338, 1428, 0.003431, 0.0215856, 0.00923494, 266.7, 266.7, 266.7, 0.0, 0.0, 1, -30.0, 30.0],
        [1339, 1342, 0.000277392, 0.00104264, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1342, 1471, 0.0010027, 0.00722934, 0.0034076, 229.77, 229.77, 229.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1343, 1344, 0.000230162, 0.00112156, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1345, 1347, 0.000282986, 0.00111773, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1346, 889, 0.00795427, 0.0216908, 0.000904376, 112.81, 112.81, 112.81, 0.0, 0.0, 1, -30.0, 30.0],
        [1348, 1349, 0.00027458, 0.00116961, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1349, 961, 0.0155233, 0.0442751, 0.00152485, 55.34, 55.34, 55.34, 0.0, 0.0, 1, -30.0, 30.0],
        [1349, 1448, 0.00595155, 0.0160521, 0.000444864, 88.96, 88.96, 88.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1350, 1351, 0.000200991, 0.00106114, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1351, 725, 0.0204217, 0.0426311, 0.00160606, 44.08, 44.08, 44.08, 0.0, 0.0, 1, -30.0, 30.0],
        [1351, 747, 0.0239133, 0.0624368, 0.00150552, 61.03, 61.03, 61.03, 0.0, 0.0, 1, -30.0, 30.0],
        [1352, 1353, 0.000282941, 0.00104829, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1354, 1355, 0.000240114, 0.00110496, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1355, 1415, 0.00613846, 0.0133247, 0.000328846, 56.76, 56.76, 56.76, 0.0, 0.0, 1, -30.0, 30.0],
        [1355, 1472, 0.00447067, 0.00939789, 0.000310653, 66.76, 66.76, 66.76, 0.0, 0.0, 1, -30.0, 30.0],
        [1356, 1357, 0.000243368, 0.00101908, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1357, 952, 0.0375894, 0.0873917, 0.0135871, 60.31, 60.31, 60.31, 0.0, 0.0, 1, -30.0, 30.0],
        [1357, 1482, 0.00739389, 0.0155033, 0.000695888, 100.08, 100.08, 100.08, 0.0, 0.0, 1, -30.0, 30.0],
        [1358, 1366, 0.000221097, 0.00118127, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1359, 1323, 0.00170572, 0.00593416, 0.00430915, 202.83, 202.83, 202.83, 0.0, 0.0, 1, -30.0, 30.0],
        [1367, 808, 0.00085465, 0.00950387, 0.154923, 1170.14, 1170.14, 1170.14, 0.0, 0.0, 1, -30.0, 30.0],
        [1368, 1374, 0.000287156, 0.00109132, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1369, 800, 0.020526, 0.0534932, 0.00130594, 81.86, 81.86, 81.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1375, 1383, 0.000275565, 0.00110499, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1376, 1428, 0.00324787, 0.0173615, 0.00958871, 260.81, 260.81, 260.81, 0.0, 0.0, 1, -30.0, 30.0],
        [1376, 1428, 0.00324787, 0.0173615, 0.00958871, 260.81, 260.81, 260.81, 0.0, 0.0, 1, -30.0, 30.0],
        [1383, 1312, 0.000371923, 0.00453986, 0.075615, 1045.72, 1045.72, 1045.72, 0.0, 0.0, 1, -30.0, 30.0],
        [1383, 1395, 0.000881201, 0.0104709, 0.481982, 1009.05, 1009.05, 1009.05, 0.0, 0.0, 1, -30.0, 30.0],
        [1383, 1475, 0.000987666, 0.011202, 0.278812, 1496.28, 1496.28, 1496.28, 0.0, 0.0, 1, -30.0, 30.0],
        [1384, 1385, 0.000242298, 0.00117692, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1385, 757, 0.00751514, 0.036859, 0.0149053, 211.34, 211.34, 211.34, 0.0, 0.0, 1, -30.0, 30.0],
        [1385, 759, 0.0023244, 0.013944, 0.00575113, 218.45, 218.45, 218.45, 0.0, 0.0, 1, -30.0, 30.0],
        [1386, 1387, 0.000280811, 0.00109936, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1387, 946, 0.0370795, 0.104984, 0.00174133, 59.62, 59.62, 59.62, 0.0, 0.0, 1, -30.0, 30.0],
        [1388, 1395, 0.000269246, 0.00106138, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1389, 997, 0.00586714, 0.0296838, 0.0255737, 252.93, 252.93, 252.93, 0.0, 0.0, 1, -30.0, 30.0],
        [1389, 1000, 0.00929538, 0.0457528, 0.0169985, 262.26, 262.26, 262.26, 0.0, 0.0, 1, -30.0, 30.0],
        [1389, 1000, 0.00929538, 0.0457528, 0.0169985, 262.26, 262.26, 262.26, 0.0, 0.0, 1, -30.0, 30.0],
        [1395, 1406, 0.00011726, 0.0013526, 0.0316443, 1041.1, 1041.1, 1041.1, 0.0, 0.0, 1, -30.0, 30.0],
        [1396, 1401, 0.000286839, 0.00103882, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1397, 1462, 0.0015546, 0.00776805, 0.00385405, 246.22, 246.22, 246.22, 0.0, 0.0, 1, -30.0, 30.0],
        [1402, 1406, 0.000202984, 0.00103045, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1406, 1367, 0.000496321, 0.00737696, 0.202547, 1203.63, 1203.63, 1203.63, 0.0, 0.0, 1, -30.0, 30.0],
        [1407, 1409, 0.000284536, 0.00114868, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1408, 893, 0.00878855, 0.0232463, 0.00125245, 67.94, 67.94, 67.94, 0.0, 0.0, 1, -30.0, 30.0],
        [1408, 893, 0.00878855, 0.0232463, 0.00125245, 67.94, 67.94, 67.94, 0.0, 0.0, 1, -30.0, 30.0],
        [1408, 1430, 0.0226845, 0.0646687, 0.0013536, 79.85, 79.85, 79.85, 0.0, 0.0, 1, -30.0, 30.0],
        [1409, 900, 0.00430102, 0.0241757, 0.00847342, 320.7, 320.7, 320.7, 0.0, 0.0, 1, -30.0, 30.0],
        [1410, 1411, 0.000233555, 0.00110689, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1411, 800, 0.0188213, 0.0533127, 0.000946535, 67.56, 67.56, 67.56, 0.0, 0.0, 1, -30.0, 30.0],
        [1411, 800, 0.0188213, 0.0533127, 0.000946535, 67.56, 67.56, 67.56, 0.0, 0.0, 1, -30.0, 30.0],
        [1411, 1369, 0.00714762, 0.0103152, 0.000638166, 67.3, 67.3, 67.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1412, 1413, 0.000214813, 0.0010431, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1413, 762, 0.0115902, 0.02904, 0.00210842, 110.0, 110.0, 110.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1414, 1415, 0.000216065, 0.0011029, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1415, 907, 0.0100064, 0.0284224, 0.00110334, 71.96, 71.96, 71.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1415, 907, 0.0100064, 0.0284224, 0.00110334, 71.96, 71.96, 71.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1416, 1419, 0.000268662, 0.00100801, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1419, 1307, 0.0011707, 0.00678111, 0.00337576, 351.45, 351.45, 351.45, 0.0, 0.0, 1, -30.0, 30.0],
        [1419, 1462, 0.00773033, 0.0359478, 0.013384, 208.06, 208.06, 208.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1420, 1422, 0.0002929, 0.00118706, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1423, 1425, 0.000250046, 0.00101167, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1426, 1428, 0.000249497, 0.00104938, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1427, 923, 0.0278908, 0.0843775, 0.00277489, 39.3, 39.3, 39.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1428, 1278, 0.00379166, 0.020389, 0.00610021, 224.25, 224.25, 224.25, 0.0, 0.0, 1, -30.0, 30.0],
        [1429, 1430, 0.000207494, 0.00118445, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1430, 868, 0.016386, 0.0339473, 0.000871681, 63.68, 63.68, 63.68, 0.0, 0.0, 1, -30.0, 30.0],
        [1430, 874, 0.0148065, 0.0317034, 0.00305876, 71.9, 71.9, 71.9, 0.0, 0.0, 1, -30.0, 30.0],
        [1430, 874, 0.0148065, 0.0317034, 0.00305876, 71.9, 71.9, 71.9, 0.0, 0.0, 1, -30.0, 30.0],
        [1431, 1434, 0.000212643, 0.00108278, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1434, 671, 0.020617, 0.0518004, 0.0012629, 83.52, 83.52, 83.52, 0.0, 0.0, 1, -30.0, 30.0],
        [1434, 671, 0.020617, 0.0518004, 0.0012629, 83.52, 83.52, 83.52, 0.0, 0.0, 1, -30.0, 30.0],
        [1434, 682, 0.00815233, 0.0203384, 0.000900862, 72.78, 72.78, 72.78, 0.0, 0.0, 1, -30.0, 30.0],
        [1434, 682, 0.00815233, 0.0203384, 0.000900862, 72.78, 72.78, 72.78, 0.0, 0.0, 1, -30.0, 30.0],
        [1434, 683, 0.0294637, 0.053735, 0.0022642, 73.44, 73.44, 73.44, 0.0, 0.0, 1, -30.0, 30.0],
        [1434, 683, 0.0294637, 0.053735, 0.0022642, 73.44, 73.44, 73.44, 0.0, 0.0, 1, -30.0, 30.0],
        [1435, 1215, 0.000379323, 0.00449073, 0.0797044, 1242.76, 1242.76, 1242.76, 0.0, 0.0, 1, -30.0, 30.0],
        [1436, 1444, 0.000291923, 0.00100505, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1444, 930, 0.00705076, 0.0356077, 0.0192346, 208.2, 208.2, 208.2, 0.0, 0.0, 1, -30.0, 30.0],
        [1445, 1446, 0.000258699, 0.00117136, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1446, 1294, 0.000635159, 0.0047891, 0.00376946, 196.5, 196.5, 196.5, 0.0, 0.0, 1, -30.0, 30.0],
        [1447, 1450, 0.000298805, 0.00111443, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1448, 961, 0.0111602, 0.0286757, 0.00237493, 61.22, 61.22, 61.22, 0.0, 0.0, 1, -30.0, 30.0],
        [1450, 1288, 0.00192923, 0.0155732, 0.00453624, 183.04, 183.04, 183.04, 0.0, 0.0, 1, -30.0, 30.0],
        [1451, 1456, 0.00024434, 0.00112093, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1452, 1446, 0.00171714, 0.00862256, 0.0022481, 274.88, 274.88, 274.88, 0.0, 0.0, 1, -30.0, 30.0],
        [1456, 1299, 0.000124772, 0.00155324, 0.0394401, 1051.3, 1051.3, 1051.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1456, 1305, 0.00124096, 0.0140177, 0.220533, 1173.26, 1173.26, 1173.26, 0.0, 0.0, 1, -30.0, 30.0],
        [1457, 1074, 0.000636486, 0.00824674, 0.122883, 1149.12, 1149.12, 1149.12, 0.0, 0.0, 1, -30.0, 30.0],
        [1458, 1460, 0.000222849, 0.00119896, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1459, 782, 0.0186349, 0.0489874, 0.00153472, 72.49, 72.49, 72.49, 0.0, 0.0, 1, -30.0, 30.0],
        [1460, 783, 0.00483774, 0.0354536, 0.0217524, 200.57, 200.57, 200.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1460, 1050, 0.00786927, 0.0398885, 0.0241334, 261.77, 261.77, 261.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1460, 1050, 0.00786927, 0.0398885, 0.0241334, 261.77, 261.77, 261.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1461, 1462, 0.00026323, 0.00117422, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1462, 1218, 0.00216567, 0.013441, 0.00437727, 197.89, 197.89, 197.89, 0.0, 0.0, 1, -30.0, 30.0],
        [1463, 1467, 0.000255199, 0.00108236, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1464, 909, 0.00513519, 0.0131824, 0.0020442, 73.0, 73.0, 73.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1464, 909, 0.00513519, 0.0131824, 0.0020442, 80.03, 80.03, 80.03, 0.0, 0.0, 1, -30.0, 30.0],
        [1467, 1288, 0.0046631, 0.0321374, 0.00712691, 323.77, 323.77, 323.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1467, 1471, 0.00296103, 0.0152833, 0.00326897, 233.67, 233.67, 233.67, 0.0, 0.0, 1, -30.0, 30.0],
        [1468, 1469, 0.000203959, 0.00111043, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1469, 943, 0.0157568, 0.0662015, 0.026778, 224.54, 224.54, 224.54, 0.0, 0.0, 1, -30.0, 30.0],
        [1470, 1475, 0.000218523, 0.00100281, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1472, 1415, 0.00406702, 0.0076667, 0.00052377, 49.31, 49.31, 49.31, 0.0, 0.0, 1, -30.0, 30.0],
        [1475, 1292, 0.000442514, 0.00546007, 0.0867058, 1550.57, 1550.57, 1550.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1476, 1167, 0.000845708, 0.00936491, 0.220919, 1400.0, 1400.0, 1400.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1476, 1366, 0.000370336, 0.00501971, 0.091035, 1890.72, 1890.72, 1890.72, 0.0, 0.0, 1, -30.0, 30.0],
        [1477, 1480, 0.000287792, 0.00107989, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1478, 1180, 0.0221802, 0.0589922, 0.00272605, 63.72, 63.72, 63.72, 0.0, 0.0, 1, -30.0, 30.0],
        [1480, 1179, 0.00288378, 0.0182892, 0.00665001, 194.82, 194.82, 194.82, 0.0, 0.0, 1, -30.0, 30.0],
        [1481, 1483, 0.000283638, 0.00112772, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1482, 927, 0.0287538, 0.0762042, 0.0037067, 61.24, 61.24, 61.24, 0.0, 0.0, 1, -30.0, 30.0],
        [1483, 926, 0.00339256, 0.0183167, 0.0108352, 278.2, 278.2, 278.2, 0.0, 0.0, 1, -30.0, 30.0],
        [1484, 1764, 0.0319879, 0.108604, 0.00770673, 119.53, 119.53, 119.53, 0.0, 0.0, 1, -30.0, 30.0],
        [1485, 1500, 0.0173305, 0.0626787, 0.0070064, 110.21, 110.21, 110.21, 0.0, 0.0, 1, -30.0, 30.0],
        [1485, 1593, 0.0141575, 0.0674639, 0.0105681, 120.32, 120.32, 120.32, 0.0, 0.0, 1, -30.0, 30.0],
        [1486, 1487, 0.000212281, 0.00117807, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1486, 1506, 0.0196546, 0.102768, 0.00857295, 123.66, 123.66, 123.66, 0.0, 0.0, 1, -30.0, 30.0],
        [1488, 1506, 0.0150567, 0.0703887, 0.00943182, 246.37, 246.37, 246.37, 0.0, 0.0, 1, -30.0, 30.0],
        [1489, 1491, 0.000229058, 0.00115393, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1489, 1974, 0.00130105, 0.0139331, 0.30435, 1281.09, 1281.09, 1281.09, 0.0, 0.0, 1, -30.0, 30.0],
        [1489, 1985, 0.00262623, 0.0279154, 0.307046, 1183.37, 1183.37, 1183.37, 0.0, 0.0, 1, -30.0, 30.0],
        [1490, 1488, 0.0111385, 0.048854, 0.00473942, 275.19, 275.19, 275.19, 0.0, 0.0, 1, -30.0, 30.0],
        [1492, 1535, 0.0116306, 0.0568617, 0.00644676, 131.29, 131.29, 131.29, 0.0, 0.0, 1, -30.0, 30.0],
        [1493, 1492, 0.0106792, 0.0411323, 0.00456388, 123.0, 123.0, 123.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1494, 1495, 0.000204804, 0.00100469, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1495, 1493, 0.00965023, 0.0401862, 0.00333381, 137.25, 137.25, 137.25, 0.0, 0.0, 1, -30.0, 30.0],
        [1496, 1504, 0.0282544, 0.116912, 0.00888644, 110.16, 110.16, 110.16, 0.0, 0.0, 1, -30.0, 30.0],
        [1498, 1497, 0.0113793, 0.0595503, 0.00657752, 136.78, 136.78, 136.78, 0.0, 0.0, 1, -30.0, 30.0],
        [1498, 1499, 0.0170123, 0.0521162, 0.00472975, 184.55, 184.55, 184.55, 0.0, 0.0, 1, -30.0, 30.0],
        [1499, 1514, 0.0209023, 0.0965686, 0.0108077, 200.0, 200.0, 200.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1499, 1617, 0.013108, 0.0505946, 0.00349668, 130.08, 130.08, 130.08, 0.0, 0.0, 1, -30.0, 30.0],
        [1501, 1502, 0.000241373, 0.00100654, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1501, 1503, 0.0364041, 0.191331, 0.00979169, 109.33, 109.33, 109.33, 0.0, 0.0, 1, -30.0, 30.0],
        [1501, 1509, 0.0212477, 0.0988911, 0.0102601, 110.68, 110.68, 110.68, 0.0, 0.0, 1, -30.0, 30.0],
        [1503, 1940, 0.0361598, 0.165477, 0.011131, 113.57, 113.57, 113.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1504, 1752, 0.0210667, 0.0954823, 0.00991286, 126.25, 126.25, 126.25, 0.0, 0.0, 1, -30.0, 30.0],
        [1505, 1501, 0.0272113, 0.105357, 0.0123165, 109.97, 109.97, 109.97, 0.0, 0.0, 1, -30.0, 30.0],
        [1506, 1505, 0.014262, 0.0631984, 0.00720554, 117.04, 117.04, 117.04, 0.0, 0.0, 1, -30.0, 30.0],
        [1507, 1512, 0.0558748, 0.133789, 0.0116348, 122.61, 122.61, 122.61, 0.0, 0.0, 1, -30.0, 30.0],
        [1508, 1507, 0.0118464, 0.0568177, 0.00580547, 104.15, 104.15, 104.15, 0.0, 0.0, 1, -30.0, 30.0],
        [1508, 1509, 0.0110374, 0.0439234, 0.00509819, 110.77, 110.77, 110.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1508, 1940, 0.0183587, 0.084431, 0.00800333, 113.66, 113.66, 113.66, 0.0, 0.0, 1, -30.0, 30.0],
        [1510, 1496, 0.0229532, 0.0931159, 0.00771324, 113.79, 113.79, 113.79, 0.0, 0.0, 1, -30.0, 30.0],
        [1510, 1526, 0.0317298, 0.149847, 0.0104852, 128.46, 128.46, 128.46, 0.0, 0.0, 1, -30.0, 30.0],
        [1511, 1517, 0.0101584, 0.0463968, 0.00522456, 167.0, 167.0, 167.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1511, 1608, 0.0130793, 0.0556886, 0.00621966, 221.91, 221.91, 221.91, 0.0, 0.0, 1, -30.0, 30.0],
        [1512, 1515, 0.0286193, 0.127717, 0.0120872, 113.96, 113.96, 113.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1512, 1759, 0.0416805, 0.203755, 0.0229945, 131.98, 131.98, 131.98, 0.0, 0.0, 1, -30.0, 30.0],
        [1513, 1514, 0.0111682, 0.0378505, 0.00557167, 149.97, 149.97, 149.97, 0.0, 0.0, 1, -30.0, 30.0],
        [1515, 1486, 0.03112, 0.124194, 0.0104372, 120.88, 120.88, 120.88, 0.0, 0.0, 1, -30.0, 30.0],
        [1515, 1772, 0.0603464, 0.212325, 0.0186925, 122.18, 122.18, 122.18, 0.0, 0.0, 1, -30.0, 30.0],
        [1516, 1517, 0.00746855, 0.0317623, 0.00329084, 127.38, 127.38, 127.38, 0.0, 0.0, 1, -30.0, 30.0],
        [1516, 1622, 0.0100255, 0.0400735, 0.00444625, 143.83, 143.83, 143.83, 0.0, 0.0, 1, -30.0, 30.0],
        [1516, 1622, 0.0100255, 0.0400735, 0.00444625, 143.83, 143.83, 143.83, 0.0, 0.0, 1, -30.0, 30.0],
        [1517, 1622, 0.0149881, 0.062401, 0.00421285, 169.76, 169.76, 169.76, 0.0, 0.0, 1, -30.0, 30.0],
        [1518, 1588, 0.007, 0.04, 0.0, 130.0, 130.0, 130.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1518, 1588, 0.007, 0.04, 0.0, 130.0, 130.0, 130.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1518, 1622, 0.008269, 0.032252, 0.002377, 250.0, 250.0, 250.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1519, 1522, 0.00950169, 0.0469516, 0.00495682, 158.85, 158.85, 158.85, 0.0, 0.0, 1, -30.0, 30.0],
        [1519, 1525, 0.0152605, 0.0781859, 0.00812912, 223.46, 223.46, 223.46, 0.0, 0.0, 1, -30.0, 30.0],
        [1520, 1601, 0.0484527, 0.156804, 0.0177264, 133.69, 133.69, 133.69, 0.0, 0.0, 1, -30.0, 30.0],
        [1520, 1620, 0.0183851, 0.0806146, 0.00995915, 122.28, 122.28, 122.28, 0.0, 0.0, 1, -30.0, 30.0],
        [1521, 1616, 0.0163331, 0.0647442, 0.00651924, 121.45, 121.45, 121.45, 0.0, 0.0, 1, -30.0, 30.0],
        [1523, 1522, 0.00868788, 0.0402683, 0.00402184, 128.44, 128.44, 128.44, 0.0, 0.0, 1, -30.0, 30.0],
        [1524, 1519, 0.010673, 0.0414962, 0.00526766, 121.37, 121.37, 121.37, 0.0, 0.0, 1, -30.0, 30.0],
        [1524, 1523, 0.0184167, 0.0790485, 0.00820263, 178.02, 178.02, 178.02, 0.0, 0.0, 1, -30.0, 30.0],
        [1525, 1524, 0.0112711, 0.0458461, 0.00528261, 150.5, 150.5, 150.5, 0.0, 0.0, 1, -30.0, 30.0],
        [1525, 1524, 0.0112711, 0.0458461, 0.00528261, 150.5, 150.5, 150.5, 0.0, 0.0, 1, -30.0, 30.0],
        [1525, 1565, 0.0325503, 0.112515, 0.0098213, 235.9, 235.9, 235.9, 0.0, 0.0, 1, -30.0, 30.0],
        [1525, 1566, 0.0209914, 0.100663, 0.00614559, 154.42, 154.42, 154.42, 0.0, 0.0, 1, -30.0, 30.0],
        [1525, 1566, 0.0209914, 0.100663, 0.00614559, 154.42, 154.42, 154.42, 0.0, 0.0, 1, -30.0, 30.0],
        [1526, 1533, 0.0393467, 0.143231, 0.0149763, 123.58, 123.58, 123.58, 0.0, 0.0, 1, -30.0, 30.0],
        [1527, 1753, 0.0160565, 0.0756449, 0.00737504, 154.35, 154.35, 154.35, 0.0, 0.0, 1, -30.0, 30.0],
        [1528, 1527, 0.0180609, 0.0762875, 0.0104042, 128.72, 128.72, 128.72, 0.0, 0.0, 1, -30.0, 30.0],
        [1529, 1530, 0.00942652, 0.0351675, 0.00363705, 115.2, 115.2, 115.2, 0.0, 0.0, 1, -30.0, 30.0],
        [1529, 1531, 0.0115392, 0.0497986, 0.00341891, 115.45, 115.45, 115.45, 0.0, 0.0, 1, -30.0, 30.0],
        [1530, 1498, 0.0218504, 0.078975, 0.0081451, 131.57, 131.57, 131.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1531, 1523, 0.0147834, 0.0666995, 0.00524724, 245.63, 245.63, 245.63, 0.0, 0.0, 1, -30.0, 30.0],
        [1531, 1532, 0.0121474, 0.0438864, 0.00321776, 151.74, 151.74, 151.74, 0.0, 0.0, 1, -30.0, 30.0],
        [1533, 1501, 0.0367343, 0.146981, 0.0146255, 120.73, 120.73, 120.73, 0.0, 0.0, 1, -30.0, 30.0],
        [1534, 1500, 0.0311502, 0.133802, 0.010886, 120.55, 120.55, 120.55, 0.0, 0.0, 1, -30.0, 30.0],
        [1534, 1535, 0.0141591, 0.0836598, 0.00985583, 124.95, 124.95, 124.95, 0.0, 0.0, 1, -30.0, 30.0],
        [1536, 1572, 0.0147469, 0.0571764, 0.00843953, 145.07, 145.07, 145.07, 0.0, 0.0, 1, -30.0, 30.0],
        [1538, 1537, 0.018577, 0.0834125, 0.00920011, 118.61, 118.61, 118.61, 0.0, 0.0, 1, -30.0, 30.0],
        [1539, 1543, 0.014195, 0.0630314, 0.00440385, 121.13, 121.13, 121.13, 0.0, 0.0, 1, -30.0, 30.0],
        [1541, 1539, 0.00809255, 0.0287273, 0.00364231, 153.43, 153.43, 153.43, 0.0, 0.0, 1, -30.0, 30.0],
        [1541, 1780, 0.00797675, 0.0342727, 0.00592205, 174.38, 174.38, 174.38, 0.0, 0.0, 1, -30.0, 30.0],
        [1542, 1544, 0.000248364, 0.00114012, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1542, 1562, 0.000993331, 0.0129632, 0.243057, 1153.31, 1153.31, 1153.31, 0.0, 0.0, 1, -30.0, 30.0],
        [1543, 1540, 0.00801493, 0.0365576, 0.00410979, 240.37, 240.37, 240.37, 0.0, 0.0, 1, -30.0, 30.0],
        [1543, 1546, 0.00902625, 0.0324259, 0.00291805, 198.48, 198.48, 198.48, 0.0, 0.0, 1, -30.0, 30.0],
        [1543, 1546, 0.00902625, 0.0324259, 0.00291805, 198.48, 198.48, 198.48, 0.0, 0.0, 1, -30.0, 30.0],
        [1545, 1540, 0.0194818, 0.0719401, 0.007165, 269.87, 269.87, 269.87, 0.0, 0.0, 1, -30.0, 30.0],
        [1545, 1546, 0.0148425, 0.0762464, 0.00507938, 289.34, 289.34, 289.34, 0.0, 0.0, 1, -30.0, 30.0],
        [1545, 1572, 0.0114916, 0.059502, 0.0109093, 201.97, 201.97, 201.97, 0.0, 0.0, 1, -30.0, 30.0],
        [1546, 1540, 0.0105785, 0.0337133, 0.00565928, 119.99, 119.99, 119.99, 0.0, 0.0, 1, -30.0, 30.0],
        [1547, 1549, 0.0123149, 0.0631455, 0.00905046, 134.5, 134.5, 134.5, 0.0, 0.0, 1, -30.0, 30.0],
        [1547, 1567, 0.0147739, 0.0642092, 0.00478607, 121.02, 121.02, 121.02, 0.0, 0.0, 1, -30.0, 30.0],
        [1548, 1570, 0.0206226, 0.0745889, 0.00842101, 125.0, 125.0, 125.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1549, 1541, 0.00848498, 0.0405326, 0.00726941, 109.81, 109.81, 109.81, 0.0, 0.0, 1, -30.0, 30.0],
        [1549, 1548, 0.00819898, 0.0332252, 0.00412498, 112.59, 112.59, 112.59, 0.0, 0.0, 1, -30.0, 30.0],
        [1550, 1537, 0.0225506, 0.125453, 0.013151, 126.11, 126.11, 126.11, 0.0, 0.0, 1, -30.0, 30.0],
        [1551, 1552, 0.0102534, 0.0484734, 0.00476485, 115.08, 115.08, 115.08, 0.0, 0.0, 1, -30.0, 30.0],
        [1552, 1563, 0.0068613, 0.0334551, 0.00506201, 170.48, 170.48, 170.48, 0.0, 0.0, 1, -30.0, 30.0],
        [1552, 1563, 0.0068613, 0.0334551, 0.00506201, 170.48, 170.48, 170.48, 0.0, 0.0, 1, -30.0, 30.0],
        [1552, 1565, 0.0056343, 0.0266395, 0.00238749, 115.98, 115.98, 115.98, 0.0, 0.0, 1, -30.0, 30.0],
        [1553, 1569, 0.0126316, 0.0518873, 0.00818973, 121.01, 121.01, 121.01, 0.0, 0.0, 1, -30.0, 30.0],
        [1555, 1852, 0.007528, 0.0339499, 0.00781868, 118.08, 118.08, 118.08, 0.0, 0.0, 1, -30.0, 30.0],
        [1556, 1934, 0.029212, 0.0900765, 0.00797595, 201.9, 201.9, 201.9, 0.0, 0.0, 1, -30.0, 30.0],
        [1556, 1934, 0.029212, 0.0900765, 0.00797595, 201.9, 201.9, 201.9, 0.0, 0.0, 1, -30.0, 30.0],
        [1557, 1559, 0.017835, 0.0721261, 0.00614993, 185.23, 185.23, 185.23, 0.0, 0.0, 1, -30.0, 30.0],
        [1557, 1856, 0.0077125, 0.0444563, 0.0062506, 113.94, 113.94, 113.94, 0.0, 0.0, 1, -30.0, 30.0],
        [1558, 1821, 0.00119977, 0.0142108, 0.326298, 1537.39, 1537.39, 1537.39, 0.0, 0.0, 1, -30.0, 30.0],
        [1558, 1835, 0.000568048, 0.00649813, 0.116184, 1323.32, 1323.32, 1323.32, 0.0, 0.0, 1, -30.0, 30.0],
        [1558, 1835, 0.000568048, 0.00649813, 0.116184, 1323.32, 1323.32, 1323.32, 0.0, 0.0, 1, -30.0, 30.0],
        [1560, 1852, 0.0118019, 0.0587902, 0.00645235, 112.23, 112.23, 112.23, 0.0, 0.0, 1, -30.0, 30.0],
        [1561, 1559, 0.0095966, 0.0314168, 0.00490819, 148.59, 148.59, 148.59, 0.0, 0.0, 1, -30.0, 30.0],
        [1561, 1560, 0.00893876, 0.0441709, 0.00461785, 127.75, 127.75, 127.75, 0.0, 0.0, 1, -30.0, 30.0],
        [1562, 1564, 0.000239505, 0.00103902, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1562, 1894, 0.00164507, 0.0198392, 0.44281, 1332.17, 1332.17, 1332.17, 0.0, 0.0, 1, -30.0, 30.0],
        [1563, 1551, 0.0160129, 0.0682274, 0.00647728, 125.91, 125.91, 125.91, 0.0, 0.0, 1, -30.0, 30.0],
        [1563, 1566, 0.0164688, 0.0739315, 0.00817846, 132.52, 132.52, 132.52, 0.0, 0.0, 1, -30.0, 30.0],
        [1565, 1536, 0.00840362, 0.0446153, 0.014459, 126.9, 126.9, 126.9, 0.0, 0.0, 1, -30.0, 30.0],
        [1565, 1563, 0.00826694, 0.038037, 0.00334981, 159.21, 159.21, 159.21, 0.0, 0.0, 1, -30.0, 30.0],
        [1565, 1563, 0.00826694, 0.038037, 0.00334981, 159.21, 159.21, 159.21, 0.0, 0.0, 1, -30.0, 30.0],
        [1565, 1571, 0.0184008, 0.0997132, 0.0129294, 141.64, 141.64, 141.64, 0.0, 0.0, 1, -30.0, 30.0],
        [1566, 1552, 0.00405608, 0.017468, 0.0032051, 143.57, 143.57, 143.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1566, 1552, 0.00405608, 0.017468, 0.0032051, 143.57, 143.57, 143.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1566, 1565, 0.00849066, 0.0362175, 0.00652285, 117.68, 117.68, 117.68, 0.0, 0.0, 1, -30.0, 30.0],
        [1567, 1553, 0.0223928, 0.0922695, 0.0122175, 105.32, 105.32, 105.32, 0.0, 0.0, 1, -30.0, 30.0],
        [1567, 1568, 0.000256236, 0.00105079, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1569, 1547, 0.00782623, 0.0323939, 0.00425786, 180.3, 180.3, 180.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1570, 1893, 0.0219977, 0.0995938, 0.00843369, 134.35, 134.35, 134.35, 0.0, 0.0, 1, -30.0, 30.0],
        [1571, 1545, 0.013532, 0.0509297, 0.00375968, 230.37, 230.37, 230.37, 0.0, 0.0, 1, -30.0, 30.0],
        [1572, 1571, 0.0142213, 0.0595124, 0.00531198, 101.52, 101.52, 101.52, 0.0, 0.0, 1, -30.0, 30.0],
        [1573, 1562, 0.00188991, 0.0217259, 0.394024, 1163.95, 1163.95, 1163.95, 0.0, 0.0, 1, -30.0, 30.0],
        [1574, 1576, 0.0100693, 0.0496337, 0.00638076, 131.83, 131.83, 131.83, 0.0, 0.0, 1, -30.0, 30.0],
        [1574, 1766, 0.00856084, 0.0473751, 0.00741483, 128.59, 128.59, 128.59, 0.0, 0.0, 1, -30.0, 30.0],
        [1575, 1554, 0.0220495, 0.0845115, 0.00522104, 102.64, 102.64, 102.64, 0.0, 0.0, 1, -30.0, 30.0],
        [1575, 1576, 0.0137111, 0.0456466, 0.00263664, 116.1, 116.1, 116.1, 0.0, 0.0, 1, -30.0, 30.0],
        [1576, 1577, 0.0127314, 0.0505808, 0.0065825, 120.86, 120.86, 120.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1577, 1538, 0.0228583, 0.0967425, 0.00981121, 111.08, 111.08, 111.08, 0.0, 0.0, 1, -30.0, 30.0],
        [1578, 1601, 0.014031, 0.0553819, 0.00523056, 133.76, 133.76, 133.76, 0.0, 0.0, 1, -30.0, 30.0],
        [1578, 1611, 0.00744318, 0.0309451, 0.00286564, 117.39, 117.39, 117.39, 0.0, 0.0, 1, -30.0, 30.0],
        [1579, 1860, 0.00499819, 0.0177834, 0.00205923, 152.42, 152.42, 152.42, 0.0, 0.0, 1, -30.0, 30.0],
        [1580, 1590, 0.00742368, 0.0291337, 0.00419048, 132.04, 132.04, 132.04, 0.0, 0.0, 1, -30.0, 30.0],
        [1580, 1591, 0.0155596, 0.0691747, 0.00724101, 131.74, 131.74, 131.74, 0.0, 0.0, 1, -30.0, 30.0],
        [1581, 1582, 0.009036, 0.044679, 0.003893, 220.0, 220.0, 220.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1581, 1585, 0.0101967, 0.0441583, 0.00425552, 153.86, 153.86, 153.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1581, 1585, 0.0101967, 0.0441583, 0.00425552, 153.86, 153.86, 153.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1582, 1583, 0.00854008, 0.0362846, 0.00337033, 147.4, 147.4, 147.4, 0.0, 0.0, 1, -30.0, 30.0],
        [1582, 1583, 0.00854008, 0.0362846, 0.00337033, 147.4, 147.4, 147.4, 0.0, 0.0, 1, -30.0, 30.0],
        [1582, 1584, 0.00958871, 0.0426328, 0.00751041, 164.47, 164.47, 164.47, 0.0, 0.0, 1, -30.0, 30.0],
        [1582, 1589, 0.00625791, 0.0276387, 0.00680793, 170.89, 170.89, 170.89, 0.0, 0.0, 1, -30.0, 30.0],
        [1582, 1891, 0.012092, 0.0429187, 0.00415395, 160.87, 160.87, 160.87, 0.0, 0.0, 1, -30.0, 30.0],
        [1582, 1891, 0.012092, 0.0429187, 0.00415395, 160.87, 160.87, 160.87, 0.0, 0.0, 1, -30.0, 30.0],
        [1583, 1584, 0.00931501, 0.0391331, 0.00285765, 110.66, 110.66, 110.66, 0.0, 0.0, 1, -30.0, 30.0],
        [1583, 1606, 0.00705939, 0.0309296, 0.00530276, 116.77, 116.77, 116.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1584, 1596, 0.00904153, 0.0320439, 0.00327847, 250.0, 250.0, 250.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1585, 1860, 0.00723893, 0.0299702, 0.0032947, 163.85, 163.85, 163.85, 0.0, 0.0, 1, -30.0, 30.0],
        [1585, 1860, 0.00723893, 0.0299702, 0.0032947, 163.85, 163.85, 163.85, 0.0, 0.0, 1, -30.0, 30.0],
        [1585, 1891, 0.00679276, 0.0272836, 0.00252659, 350.0, 350.0, 350.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1585, 1920, 0.00765025, 0.0307678, 0.00345137, 164.01, 164.01, 164.01, 0.0, 0.0, 1, -30.0, 30.0],
        [1585, 1920, 0.00765025, 0.0307678, 0.00345137, 164.01, 164.01, 164.01, 0.0, 0.0, 1, -30.0, 30.0],
        [1587, 1578, 0.00659517, 0.0291518, 0.00683364, 200.0, 200.0, 200.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1587, 1606, 0.00859397, 0.0454239, 0.00433505, 135.96, 135.96, 135.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1587, 1891, 0.0138055, 0.0531792, 0.00699655, 137.46, 137.46, 137.46, 0.0, 0.0, 1, -30.0, 30.0],
        [1588, 1618, 0.005583, 0.025576, 0.003523, 180.0, 180.0, 180.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1588, 1896, 0.007008, 0.04145, 0.005886, 180.0, 180.0, 180.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1589, 1587, 0.00728561, 0.0289751, 0.00309687, 127.73, 127.73, 127.73, 0.0, 0.0, 1, -30.0, 30.0],
        [1589, 1891, 0.00845505, 0.0356653, 0.00292041, 149.97, 149.97, 149.97, 0.0, 0.0, 1, -30.0, 30.0],
        [1589, 1891, 0.00845505, 0.0356653, 0.00292041, 149.97, 149.97, 149.97, 0.0, 0.0, 1, -30.0, 30.0],
        [1590, 1579, 0.00777896, 0.037797, 0.00375721, 115.96, 115.96, 115.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1590, 1591, 0.00683219, 0.0266355, 0.00319257, 147.57, 147.57, 147.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1590, 1876, 0.0134123, 0.0616665, 0.00619128, 153.58, 153.58, 153.58, 0.0, 0.0, 1, -30.0, 30.0],
        [1591, 1592, 0.00556629, 0.0268729, 0.00206014, 184.58, 184.58, 184.58, 0.0, 0.0, 1, -30.0, 30.0],
        [1592, 1594, 0.0190944, 0.0678028, 0.00664942, 128.75, 128.75, 128.75, 0.0, 0.0, 1, -30.0, 30.0],
        [1594, 1593, 0.00969676, 0.0451753, 0.00481316, 129.63, 129.63, 129.63, 0.0, 0.0, 1, -30.0, 30.0],
        [1595, 1596, 0.0174791, 0.08157, 0.00908789, 157.19, 157.19, 157.19, 0.0, 0.0, 1, -30.0, 30.0],
        [1595, 1607, 0.0110247, 0.0538828, 0.00405969, 173.22, 173.22, 173.22, 0.0, 0.0, 1, -30.0, 30.0],
        [1595, 1918, 0.0142942, 0.0550337, 0.0128695, 117.0, 117.0, 117.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1595, 1955, 0.0120768, 0.0451087, 0.005656, 126.8, 126.8, 126.8, 0.0, 0.0, 1, -30.0, 30.0],
        [1596, 1608, 0.012978, 0.0490425, 0.00442119, 160.55, 160.55, 160.55, 0.0, 0.0, 1, -30.0, 30.0],
        [1597, 1513, 0.0157628, 0.0722417, 0.00813196, 194.89, 194.89, 194.89, 0.0, 0.0, 1, -30.0, 30.0],
        [1597, 1955, 0.00958909, 0.0477402, 0.00726813, 205.62, 205.62, 205.62, 0.0, 0.0, 1, -30.0, 30.0],
        [1597, 1955, 0.00958909, 0.0477402, 0.00726813, 205.62, 205.62, 205.62, 0.0, 0.0, 1, -30.0, 30.0],
        [1598, 1618, 0.00727883, 0.0329213, 0.00236448, 110.06, 110.06, 110.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1599, 1601, 0.00519029, 0.0251301, 0.00335316, 158.38, 158.38, 158.38, 0.0, 0.0, 1, -30.0, 30.0],
        [1599, 1601, 0.00519029, 0.0251301, 0.00335316, 158.38, 158.38, 158.38, 0.0, 0.0, 1, -30.0, 30.0],
        [1599, 1944, 0.00874196, 0.0465317, 0.00356825, 166.3, 166.3, 166.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1599, 1944, 0.00874196, 0.0465317, 0.00356825, 166.3, 166.3, 166.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1599, 1944, 0.00874196, 0.0465317, 0.00356825, 166.3, 166.3, 166.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1600, 1601, 0.000283016, 0.0011091, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1601, 1612, 0.0133985, 0.0552521, 0.0123142, 134.93, 134.93, 134.93, 0.0, 0.0, 1, -30.0, 30.0],
        [1601, 1860, 0.0107084, 0.053569, 0.00865708, 202.12, 202.12, 202.12, 0.0, 0.0, 1, -30.0, 30.0],
        [1601, 1860, 0.0107084, 0.053569, 0.00865708, 202.12, 202.12, 202.12, 0.0, 0.0, 1, -30.0, 30.0],
        [1602, 1604, 0.000257079, 0.00107352, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1603, 1492, 0.0193925, 0.087366, 0.00688979, 141.07, 141.07, 141.07, 0.0, 0.0, 1, -30.0, 30.0],
        [1603, 1944, 0.0171235, 0.0560951, 0.0075692, 200.0, 200.0, 200.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1605, 1599, 0.0125638, 0.0531027, 0.00595173, 111.19, 111.19, 111.19, 0.0, 0.0, 1, -30.0, 30.0],
        [1605, 1624, 0.0280928, 0.0959085, 0.0054934, 127.85, 127.85, 127.85, 0.0, 0.0, 1, -30.0, 30.0],
        [1606, 1584, 0.00712606, 0.031816, 0.00268864, 109.71, 109.71, 109.71, 0.0, 0.0, 1, -30.0, 30.0],
        [1607, 1594, 0.0115073, 0.0550379, 0.00767495, 124.85, 124.85, 124.85, 0.0, 0.0, 1, -30.0, 30.0],
        [1608, 1597, 0.00831752, 0.042193, 0.00497562, 171.05, 171.05, 171.05, 0.0, 0.0, 1, -30.0, 30.0],
        [1609, 1612, 0.0107085, 0.0500674, 0.00444502, 118.74, 118.74, 118.74, 0.0, 0.0, 1, -30.0, 30.0],
        [1610, 1586, 0.00486364, 0.021017, 0.00328991, 98.07, 98.07, 98.07, 0.0, 0.0, 1, -30.0, 30.0],
        [1610, 1896, 0.0114158, 0.0530692, 0.0045511, 181.67, 181.67, 181.67, 0.0, 0.0, 1, -30.0, 30.0],
        [1611, 1601, 0.0124648, 0.0466359, 0.00301799, 145.11, 145.11, 145.11, 0.0, 0.0, 1, -30.0, 30.0],
        [1611, 1601, 0.0124648, 0.0466359, 0.00301799, 145.11, 145.11, 145.11, 0.0, 0.0, 1, -30.0, 30.0],
        [1611, 1609, 0.0105696, 0.0323431, 0.00438424, 133.04, 133.04, 133.04, 0.0, 0.0, 1, -30.0, 30.0],
        [1612, 1613, 0.0104883, 0.0418596, 0.00417814, 122.72, 122.72, 122.72, 0.0, 0.0, 1, -30.0, 30.0],
        [1614, 1521, 0.00573787, 0.0295188, 0.00250453, 131.5, 131.5, 131.5, 0.0, 0.0, 1, -30.0, 30.0],
        [1614, 1896, 0.0113317, 0.0574118, 0.00779985, 166.34, 166.34, 166.34, 0.0, 0.0, 1, -30.0, 30.0],
        [1615, 1613, 0.00716498, 0.0363638, 0.00595795, 118.68, 118.68, 118.68, 0.0, 0.0, 1, -30.0, 30.0],
        [1615, 1896, 0.00682267, 0.031676, 0.00494087, 127.83, 127.83, 127.83, 0.0, 0.0, 1, -30.0, 30.0],
        [1616, 1620, 0.0114528, 0.0474105, 0.00442852, 109.21, 109.21, 109.21, 0.0, 0.0, 1, -30.0, 30.0],
        [1617, 1518, 0.018642, 0.0590493, 0.00510224, 115.71, 115.71, 115.71, 0.0, 0.0, 1, -30.0, 30.0],
        [1617, 1622, 0.00854975, 0.0429969, 0.00395443, 136.23, 136.23, 136.23, 0.0, 0.0, 1, -30.0, 30.0],
        [1618, 1586, 0.00827902, 0.0295499, 0.0036862, 178.71, 178.71, 178.71, 0.0, 0.0, 1, -30.0, 30.0],
        [1618, 1619, 0.000286985, 0.00117964, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1618, 1896, 0.00397397, 0.0161931, 0.00203779, 157.54, 157.54, 157.54, 0.0, 0.0, 1, -30.0, 30.0],
        [1618, 1896, 0.00397397, 0.0161931, 0.00203779, 157.54, 157.54, 157.54, 0.0, 0.0, 1, -30.0, 30.0],
        [1620, 1532, 0.0137971, 0.067212, 0.00943756, 135.1, 135.1, 135.1, 0.0, 0.0, 1, -30.0, 30.0],
        [1621, 1573, 0.00125712, 0.0150498, 0.23231, 1128.83, 1128.83, 1128.83, 0.0, 0.0, 1, -30.0, 30.0],
        [1621, 1623, 0.00022492, 0.00111768, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1621, 1959, 0.00111826, 0.013569, 0.21682, 1125.51, 1125.51, 1125.51, 0.0, 0.0, 1, -30.0, 30.0],
        [1622, 1499, 0.0164763, 0.0596698, 0.00582901, 141.2, 141.2, 141.2, 0.0, 0.0, 1, -30.0, 30.0],
        [1624, 1876, 0.00588282, 0.0314411, 0.00326611, 123.04, 123.04, 123.04, 0.0, 0.0, 1, -30.0, 30.0],
        [1624, 1989, 0.00120172, 0.00519254, 0.000651029, 114.96, 114.96, 114.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1625, 1630, 0.0127066, 0.0574084, 0.0054635, 126.56, 126.56, 126.56, 0.0, 0.0, 1, -30.0, 30.0],
        [1625, 1638, 0.0176214, 0.0592742, 0.00478436, 131.06, 131.06, 131.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1625, 1646, 0.0237225, 0.086151, 0.00644256, 132.05, 132.05, 132.05, 0.0, 0.0, 1, -30.0, 30.0],
        [1626, 1627, 0.000284413, 0.00116461, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1628, 1640, 0.0106861, 0.0429559, 0.00627079, 165.06, 165.06, 165.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1628, 1930, 0.018978, 0.0658427, 0.00970525, 139.19, 139.19, 139.19, 0.0, 0.0, 1, -30.0, 30.0],
        [1628, 1949, 0.0124573, 0.0602235, 0.0127697, 147.79, 147.79, 147.79, 0.0, 0.0, 1, -30.0, 30.0],
        [1629, 1949, 0.00656948, 0.0303888, 0.00309009, 119.82, 119.82, 119.82, 0.0, 0.0, 1, -30.0, 30.0],
        [1630, 1864, 0.0245027, 0.100608, 0.0143545, 183.61, 183.61, 183.61, 0.0, 0.0, 1, -30.0, 30.0],
        [1631, 1630, 0.00950395, 0.0451807, 0.00534067, 128.19, 128.19, 128.19, 0.0, 0.0, 1, -30.0, 30.0],
        [1631, 1949, 0.00742465, 0.0340202, 0.00867736, 138.89, 138.89, 138.89, 0.0, 0.0, 1, -30.0, 30.0],
        [1632, 1930, 0.00223874, 0.00984926, 0.00151724, 135.65, 135.65, 135.65, 0.0, 0.0, 1, -30.0, 30.0],
        [1633, 1636, 0.0253427, 0.0775241, 0.0100286, 116.81, 116.81, 116.81, 0.0, 0.0, 1, -30.0, 30.0],
        [1634, 1654, 0.0151485, 0.0505163, 0.0056943, 100.78, 100.78, 100.78, 0.0, 0.0, 1, -30.0, 30.0],
        [1636, 1634, 0.00589589, 0.0285329, 0.00235294, 152.03, 152.03, 152.03, 0.0, 0.0, 1, -30.0, 30.0],
        [1636, 1634, 0.00589589, 0.0285329, 0.00235294, 152.03, 152.03, 152.03, 0.0, 0.0, 1, -30.0, 30.0],
        [1636, 1642, 0.0134564, 0.0669691, 0.00875464, 149.74, 149.74, 149.74, 0.0, 0.0, 1, -30.0, 30.0],
        [1637, 1660, 0.0158886, 0.0879712, 0.00821281, 151.77, 151.77, 151.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1637, 1949, 0.0198665, 0.0828071, 0.00728067, 156.06, 156.06, 156.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1637, 1949, 0.0198665, 0.0828071, 0.00728067, 156.06, 156.06, 156.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1638, 1636, 0.0120387, 0.0573974, 0.0082648, 157.47, 157.47, 157.47, 0.0, 0.0, 1, -30.0, 30.0],
        [1638, 1639, 0.000257937, 0.00113511, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1640, 1626, 0.0138175, 0.0421054, 0.00493277, 129.07, 129.07, 129.07, 0.0, 0.0, 1, -30.0, 30.0],
        [1641, 1634, 0.00893718, 0.0369292, 0.00950196, 147.08, 147.08, 147.08, 0.0, 0.0, 1, -30.0, 30.0],
        [1641, 1640, 0.017503, 0.0599763, 0.00467696, 131.52, 131.52, 131.52, 0.0, 0.0, 1, -30.0, 30.0],
        [1642, 1626, 0.00529542, 0.0257187, 0.00286519, 141.0, 141.0, 141.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1643, 1649, 0.0196645, 0.0927846, 0.0123742, 109.91, 109.91, 109.91, 0.0, 0.0, 1, -30.0, 30.0],
        [1643, 1683, 0.0623289, 0.238509, 0.0607817, 120.54, 120.54, 120.54, 0.0, 0.0, 1, -30.0, 30.0],
        [1644, 1670, 0.0204137, 0.0755132, 0.0127314, 136.07, 136.07, 136.07, 0.0, 0.0, 1, -30.0, 30.0],
        [1644, 1691, 0.0304247, 0.127294, 0.00854599, 118.58, 118.58, 118.58, 0.0, 0.0, 1, -30.0, 30.0],
        [1646, 1647, 0.018181, 0.0604666, 0.00757662, 142.87, 142.87, 142.87, 0.0, 0.0, 1, -30.0, 30.0],
        [1647, 1648, 0.0158762, 0.0637157, 0.00779886, 132.7, 132.7, 132.7, 0.0, 0.0, 1, -30.0, 30.0],
        [1647, 1967, 0.011197, 0.0521734, 0.0047422, 154.76, 154.76, 154.76, 0.0, 0.0, 1, -30.0, 30.0],
        [1647, 1967, 0.011197, 0.0521734, 0.0047422, 154.76, 154.76, 154.76, 0.0, 0.0, 1, -30.0, 30.0],
        [1648, 1645, 0.0408768, 0.15949, 0.0105632, 114.35, 114.35, 114.35, 0.0, 0.0, 1, -30.0, 30.0],
        [1650, 1651, 0.0798699, 0.318394, 0.0331989, 125.19, 125.19, 125.19, 0.0, 0.0, 1, -30.0, 30.0],
        [1650, 1654, 0.0353395, 0.146871, 0.0104792, 123.94, 123.94, 123.94, 0.0, 0.0, 1, -30.0, 30.0],
        [1651, 1628, 0.0129158, 0.0640143, 0.00640442, 119.27, 119.27, 119.27, 0.0, 0.0, 1, -30.0, 30.0],
        [1651, 1658, 0.0191338, 0.0956454, 0.0100164, 120.96, 120.96, 120.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1652, 1633, 0.0550665, 0.245792, 0.0359216, 124.64, 124.64, 124.64, 0.0, 0.0, 1, -30.0, 30.0],
        [1652, 1650, 0.0222326, 0.103243, 0.0171737, 136.73, 136.73, 136.73, 0.0, 0.0, 1, -30.0, 30.0],
        [1652, 1653, 0.0178739, 0.0833107, 0.0130256, 143.22, 143.22, 143.22, 0.0, 0.0, 1, -30.0, 30.0],
        [1652, 1653, 0.0178739, 0.0833107, 0.0130256, 143.22, 143.22, 143.22, 0.0, 0.0, 1, -30.0, 30.0],
        [1653, 1940, 0.0208825, 0.10821, 0.0131364, 187.88, 187.88, 187.88, 0.0, 0.0, 1, -30.0, 30.0],
        [1653, 1940, 0.0208825, 0.10821, 0.0131364, 178.16, 178.16, 178.16, 0.0, 0.0, 1, -30.0, 30.0],
        [1655, 1653, 0.0367609, 0.151377, 0.0281583, 133.93, 133.93, 133.93, 0.0, 0.0, 1, -30.0, 30.0],
        [1655, 1656, 0.0159522, 0.061439, 0.00930457, 129.73, 129.73, 129.73, 0.0, 0.0, 1, -30.0, 30.0],
        [1657, 1646, 0.0729814, 0.296622, 0.0218876, 112.42, 112.42, 112.42, 0.0, 0.0, 1, -30.0, 30.0],
        [1657, 1656, 0.0161243, 0.0649922, 0.00905557, 119.05, 119.05, 119.05, 0.0, 0.0, 1, -30.0, 30.0],
        [1658, 1659, 0.0125261, 0.062944, 0.00826122, 109.1, 109.1, 109.1, 0.0, 0.0, 1, -30.0, 30.0],
        [1660, 1644, 0.0255148, 0.141934, 0.021618, 149.8, 149.8, 149.8, 0.0, 0.0, 1, -30.0, 30.0],
        [1661, 1682, 0.0109378, 0.0576251, 0.00645777, 117.35, 117.35, 117.35, 0.0, 0.0, 1, -30.0, 30.0],
        [1661, 1683, 0.0116291, 0.0545121, 0.0222922, 117.14, 117.14, 117.14, 0.0, 0.0, 1, -30.0, 30.0],
        [1662, 1663, 0.00699911, 0.0252351, 0.00340686, 133.28, 133.28, 133.28, 0.0, 0.0, 1, -30.0, 30.0],
        [1664, 1662, 0.00756887, 0.0317132, 0.00413886, 120.59, 120.59, 120.59, 0.0, 0.0, 1, -30.0, 30.0],
        [1664, 1665, 0.0159972, 0.0611, 0.00726713, 134.96, 134.96, 134.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1665, 1666, 0.016241, 0.0703839, 0.00901994, 103.03, 103.03, 103.03, 0.0, 0.0, 1, -30.0, 30.0],
        [1665, 1683, 0.00815569, 0.0283978, 0.00271963, 133.81, 133.81, 133.81, 0.0, 0.0, 1, -30.0, 30.0],
        [1665, 1885, 0.00760998, 0.032528, 0.00396363, 154.98, 154.98, 154.98, 0.0, 0.0, 1, -30.0, 30.0],
        [1665, 1885, 0.00760998, 0.032528, 0.00396363, 154.98, 154.98, 154.98, 0.0, 0.0, 1, -30.0, 30.0],
        [1667, 1666, 0.00934588, 0.0485528, 0.00684737, 129.66, 129.66, 129.66, 0.0, 0.0, 1, -30.0, 30.0],
        [1667, 1669, 0.0231056, 0.0927096, 0.00940679, 158.46, 158.46, 158.46, 0.0, 0.0, 1, -30.0, 30.0],
        [1667, 1922, 0.00610858, 0.0335999, 0.00599503, 112.66, 112.66, 112.66, 0.0, 0.0, 1, -30.0, 30.0],
        [1668, 1676, 0.0326114, 0.132127, 0.00972662, 159.51, 159.51, 159.51, 0.0, 0.0, 1, -30.0, 30.0],
        [1669, 1682, 0.038292, 0.173393, 0.0126011, 121.57, 121.57, 121.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1669, 1961, 0.0229886, 0.107879, 0.00816337, 160.78, 160.78, 160.78, 0.0, 0.0, 1, -30.0, 30.0],
        [1670, 1671, 0.0138445, 0.0663444, 0.00569716, 131.67, 131.67, 131.67, 0.0, 0.0, 1, -30.0, 30.0],
        [1671, 1685, 0.0334187, 0.15768, 0.0142748, 124.19, 124.19, 124.19, 0.0, 0.0, 1, -30.0, 30.0],
        [1672, 1674, 0.0192838, 0.0845623, 0.00867404, 101.66, 101.66, 101.66, 0.0, 0.0, 1, -30.0, 30.0],
        [1673, 1672, 0.0186642, 0.0956396, 0.00883886, 120.9, 120.9, 120.9, 0.0, 0.0, 1, -30.0, 30.0],
        [1673, 1690, 0.019642, 0.101643, 0.0116426, 122.97, 122.97, 122.97, 0.0, 0.0, 1, -30.0, 30.0],
        [1675, 1676, 0.0187625, 0.0666922, 0.00616272, 120.66, 120.66, 120.66, 0.0, 0.0, 1, -30.0, 30.0],
        [1676, 1674, 0.0185564, 0.0844787, 0.0082828, 126.98, 126.98, 126.98, 0.0, 0.0, 1, -30.0, 30.0],
        [1678, 1677, 0.023593, 0.104039, 0.0185686, 121.19, 121.19, 121.19, 0.0, 0.0, 1, -30.0, 30.0],
        [1678, 1687, 0.0251914, 0.108263, 0.01329, 150.04, 150.04, 150.04, 0.0, 0.0, 1, -30.0, 30.0],
        [1679, 1673, 0.0298706, 0.114422, 0.0080246, 136.43, 136.43, 136.43, 0.0, 0.0, 1, -30.0, 30.0],
        [1680, 1679, 0.0201721, 0.101011, 0.00695598, 141.41, 141.41, 141.41, 0.0, 0.0, 1, -30.0, 30.0],
        [1681, 1684, 0.0230444, 0.104895, 0.0119813, 151.85, 151.85, 151.85, 0.0, 0.0, 1, -30.0, 30.0],
        [1681, 1684, 0.0230444, 0.104895, 0.0119813, 151.85, 151.85, 151.85, 0.0, 0.0, 1, -30.0, 30.0],
        [1682, 1885, 0.0122598, 0.0477646, 0.0059987, 145.62, 145.62, 145.62, 0.0, 0.0, 1, -30.0, 30.0],
        [1683, 1662, 0.00991921, 0.0426522, 0.00435716, 135.93, 135.93, 135.93, 0.0, 0.0, 1, -30.0, 30.0],
        [1683, 1664, 0.00800185, 0.0297803, 0.00441899, 139.17, 139.17, 139.17, 0.0, 0.0, 1, -30.0, 30.0],
        [1683, 1922, 0.00857961, 0.0416987, 0.00615997, 144.4, 144.4, 144.4, 0.0, 0.0, 1, -30.0, 30.0],
        [1683, 1961, 0.0116164, 0.062508, 0.0125268, 146.74, 146.74, 146.74, 0.0, 0.0, 1, -30.0, 30.0],
        [1684, 1680, 0.0161054, 0.0679149, 0.00901283, 148.05, 148.05, 148.05, 0.0, 0.0, 1, -30.0, 30.0],
        [1685, 1675, 0.030252, 0.0920784, 0.0130107, 100.92, 100.92, 100.92, 0.0, 0.0, 1, -30.0, 30.0],
        [1686, 1664, 0.0402807, 0.164571, 0.0194673, 131.12, 131.12, 131.12, 0.0, 0.0, 1, -30.0, 30.0],
        [1686, 1692, 0.0199335, 0.0945517, 0.00866741, 117.79, 117.79, 117.79, 0.0, 0.0, 1, -30.0, 30.0],
        [1687, 1669, 0.0288722, 0.109665, 0.0158221, 164.42, 164.42, 164.42, 0.0, 0.0, 1, -30.0, 30.0],
        [1687, 1669, 0.0288722, 0.109665, 0.0158221, 164.42, 164.42, 164.42, 0.0, 0.0, 1, -30.0, 30.0],
        [1687, 1715, 0.0331336, 0.116828, 0.0147, 256.21, 256.21, 256.21, 0.0, 0.0, 1, -30.0, 30.0],
        [1689, 1681, 0.0198135, 0.0814677, 0.0130237, 152.97, 152.97, 152.97, 0.0, 0.0, 1, -30.0, 30.0],
        [1689, 1681, 0.0198135, 0.0814677, 0.0130237, 152.97, 152.97, 152.97, 0.0, 0.0, 1, -30.0, 30.0],
        [1689, 1688, 0.0188614, 0.0683717, 0.00824425, 124.05, 124.05, 124.05, 0.0, 0.0, 1, -30.0, 30.0],
        [1689, 1873, 0.0215254, 0.0821643, 0.00792436, 139.11, 139.11, 139.11, 0.0, 0.0, 1, -30.0, 30.0],
        [1689, 1924, 0.0168382, 0.0672133, 0.011634, 134.89, 134.89, 134.89, 0.0, 0.0, 1, -30.0, 30.0],
        [1690, 1677, 0.0250332, 0.0868039, 0.0102099, 120.06, 120.06, 120.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1692, 1691, 0.0183896, 0.0771028, 0.00924486, 104.52, 104.52, 104.52, 0.0, 0.0, 1, -30.0, 30.0],
        [1693, 1663, 0.0115274, 0.0550608, 0.00693446, 118.76, 118.76, 118.76, 0.0, 0.0, 1, -30.0, 30.0],
        [1693, 1668, 0.0202863, 0.0842877, 0.00779197, 105.53, 105.53, 105.53, 0.0, 0.0, 1, -30.0, 30.0],
        [1695, 1694, 0.00840797, 0.0359718, 0.00736708, 238.5, 238.5, 238.5, 0.0, 0.0, 1, -30.0, 30.0],
        [1696, 1722, 0.00741411, 0.0371045, 0.00467098, 124.23, 124.23, 124.23, 0.0, 0.0, 1, -30.0, 30.0],
        [1696, 1723, 0.0136463, 0.0551309, 0.010086, 156.28, 156.28, 156.28, 0.0, 0.0, 1, -30.0, 30.0],
        [1696, 1723, 0.0136463, 0.0551309, 0.010086, 156.28, 156.28, 156.28, 0.0, 0.0, 1, -30.0, 30.0],
        [1696, 1911, 0.0144504, 0.0562188, 0.00572223, 153.25, 153.25, 153.25, 0.0, 0.0, 1, -30.0, 30.0],
        [1696, 1911, 0.0144504, 0.0562188, 0.00572223, 153.25, 153.25, 153.25, 0.0, 0.0, 1, -30.0, 30.0],
        [1697, 1695, 0.00474632, 0.0221773, 0.00333101, 113.58, 113.58, 113.58, 0.0, 0.0, 1, -30.0, 30.0],
        [1697, 1710, 0.0150141, 0.0583461, 0.010152, 138.21, 138.21, 138.21, 0.0, 0.0, 1, -30.0, 30.0],
        [1698, 1699, 0.0110279, 0.043675, 0.00515546, 114.86, 114.86, 114.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1699, 1695, 0.00818711, 0.039658, 0.00510176, 161.77, 161.77, 161.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1699, 1705, 0.0117055, 0.0615527, 0.0112213, 149.27, 149.27, 149.27, 0.0, 0.0, 1, -30.0, 30.0],
        [1700, 1698, 0.00902588, 0.0339398, 0.00372935, 127.69, 127.69, 127.69, 0.0, 0.0, 1, -30.0, 30.0],
        [1701, 1710, 0.012466, 0.0522278, 0.00474821, 229.1, 229.1, 229.1, 0.0, 0.0, 1, -30.0, 30.0],
        [1701, 1902, 0.0108987, 0.0539307, 0.00935317, 282.53, 282.53, 282.53, 0.0, 0.0, 1, -30.0, 30.0],
        [1702, 1696, 0.00939874, 0.0494985, 0.00589028, 118.07, 118.07, 118.07, 0.0, 0.0, 1, -30.0, 30.0],
        [1702, 1722, 0.0116552, 0.0492251, 0.00480749, 114.34, 114.34, 114.34, 0.0, 0.0, 1, -30.0, 30.0],
        [1702, 1730, 0.010027, 0.0433899, 0.00302462, 216.22, 216.22, 216.22, 0.0, 0.0, 1, -30.0, 30.0],
        [1702, 1911, 0.00930379, 0.0400368, 0.00338794, 182.9, 182.9, 182.9, 0.0, 0.0, 1, -30.0, 30.0],
        [1703, 1902, 0.00808373, 0.0413966, 0.00295185, 135.04, 135.04, 135.04, 0.0, 0.0, 1, -30.0, 30.0],
        [1703, 1909, 0.0072595, 0.0289305, 0.00220242, 132.18, 132.18, 132.18, 0.0, 0.0, 1, -30.0, 30.0],
        [1704, 1706, 0.000293894, 0.00114546, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1704, 1916, 0.000622443, 0.00746598, 0.181382, 1134.69, 1134.69, 1134.69, 0.0, 0.0, 1, -30.0, 30.0],
        [1705, 1700, 0.019507, 0.0616772, 0.00444026, 134.91, 134.91, 134.91, 0.0, 0.0, 1, -30.0, 30.0],
        [1705, 1710, 0.00819536, 0.0319146, 0.00512449, 169.15, 169.15, 169.15, 0.0, 0.0, 1, -30.0, 30.0],
        [1707, 1712, 0.0277107, 0.129948, 0.0107614, 163.69, 163.69, 163.69, 0.0, 0.0, 1, -30.0, 30.0],
        [1707, 1714, 1e-07, 0.13, 0.0, 160.0, 160.0, 160.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1708, 1709, 0.0105355, 0.0576975, 0.0039125, 136.29, 136.29, 136.29, 0.0, 0.0, 1, -30.0, 30.0],
        [1708, 1732, 0.0274547, 0.0960464, 0.00949152, 162.35, 162.35, 162.35, 0.0, 0.0, 1, -30.0, 30.0],
        [1711, 1728, 0.0215418, 0.100161, 0.0197932, 136.21, 136.21, 136.21, 0.0, 0.0, 1, -30.0, 30.0],
        [1712, 1718, 0.036328, 0.108324, 0.00929866, 126.52, 126.52, 126.52, 0.0, 0.0, 1, -30.0, 30.0],
        [1713, 1712, 0.0127422, 0.0495914, 0.00412852, 140.75, 140.75, 140.75, 0.0, 0.0, 1, -30.0, 30.0],
        [1713, 1714, 0.0142023, 0.0698265, 0.00731181, 134.88, 134.88, 134.88, 0.0, 0.0, 1, -30.0, 30.0],
        [1713, 1715, 0.031067, 0.152495, 0.0217503, 182.83, 182.83, 182.83, 0.0, 0.0, 1, -30.0, 30.0],
        [1714, 1735, 0.0350451, 0.147443, 0.012838, 152.96, 152.96, 152.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1714, 1735, 0.0350451, 0.147443, 0.012838, 152.96, 152.96, 152.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1716, 1719, 0.0149225, 0.0632084, 0.00647241, 135.04, 135.04, 135.04, 0.0, 0.0, 1, -30.0, 30.0],
        [1716, 1721, 0.0134162, 0.0574332, 0.00757866, 151.96, 151.96, 151.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1716, 1721, 0.0134162, 0.0574332, 0.00757866, 151.96, 151.96, 151.96, 0.0, 0.0, 1, -30.0, 30.0],
        [1716, 1735, 0.02264, 0.0837818, 0.00772503, 160.61, 160.61, 160.61, 0.0, 0.0, 1, -30.0, 30.0],
        [1716, 1735, 0.02264, 0.0837818, 0.00772503, 160.61, 160.61, 160.61, 0.0, 0.0, 1, -30.0, 30.0],
        [1717, 1726, 0.0149452, 0.0599967, 0.00975819, 111.81, 111.81, 111.81, 0.0, 0.0, 1, -30.0, 30.0],
        [1718, 1721, 0.0109624, 0.0514112, 0.0086946, 132.5, 132.5, 132.5, 0.0, 0.0, 1, -30.0, 30.0],
        [1719, 1717, 0.0113486, 0.0577544, 0.00524735, 136.53, 136.53, 136.53, 0.0, 0.0, 1, -30.0, 30.0],
        [1719, 1720, 0.0116199, 0.0453235, 0.00388383, 125.48, 125.48, 125.48, 0.0, 0.0, 1, -30.0, 30.0],
        [1721, 1719, 0.00614761, 0.0278, 0.00647183, 101.4, 101.4, 101.4, 0.0, 0.0, 1, -30.0, 30.0],
        [1721, 1726, 0.0157974, 0.0777954, 0.00710905, 131.88, 131.88, 131.88, 0.0, 0.0, 1, -30.0, 30.0],
        [1723, 1694, 0.00573787, 0.0284291, 0.00423994, 269.86, 269.86, 269.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1723, 1724, 0.0137155, 0.0694872, 0.0114697, 247.51, 247.51, 247.51, 0.0, 0.0, 1, -30.0, 30.0],
        [1725, 1724, 0.0104834, 0.0492436, 0.00835632, 212.55, 212.55, 212.55, 0.0, 0.0, 1, -30.0, 30.0],
        [1727, 1725, 0.00962875, 0.0413075, 0.00376635, 195.7, 195.7, 195.7, 0.0, 0.0, 1, -30.0, 30.0],
        [1727, 1726, 0.0148742, 0.0486764, 0.00515685, 358.85, 358.85, 358.85, 0.0, 0.0, 1, -30.0, 30.0],
        [1727, 1738, 0.0131485, 0.0616018, 0.00665839, 163.31, 163.31, 163.31, 0.0, 0.0, 1, -30.0, 30.0],
        [1728, 1729, 0.0140129, 0.0700478, 0.00705584, 120.56, 120.56, 120.56, 0.0, 0.0, 1, -30.0, 30.0],
        [1729, 1707, 0.0237615, 0.0772629, 0.0115473, 151.92, 151.92, 151.92, 0.0, 0.0, 1, -30.0, 30.0],
        [1730, 1731, 0.0148881, 0.0439463, 0.005952, 151.8, 151.8, 151.8, 0.0, 0.0, 1, -30.0, 30.0],
        [1730, 1737, 0.0189165, 0.0727288, 0.00955014, 228.45, 228.45, 228.45, 0.0, 0.0, 1, -30.0, 30.0],
        [1730, 1902, 0.0114894, 0.0482375, 0.00446046, 155.94, 155.94, 155.94, 0.0, 0.0, 1, -30.0, 30.0],
        [1730, 1902, 0.0114894, 0.0482375, 0.00446046, 155.94, 155.94, 155.94, 0.0, 0.0, 1, -30.0, 30.0],
        [1731, 1708, 0.0133752, 0.0612852, 0.00854748, 124.74, 124.74, 124.74, 0.0, 0.0, 1, -30.0, 30.0],
        [1732, 1711, 0.0240533, 0.104183, 0.00746802, 144.65, 144.65, 144.65, 0.0, 0.0, 1, -30.0, 30.0],
        [1733, 1716, 0.0171281, 0.0726239, 0.00972757, 130.74, 130.74, 130.74, 0.0, 0.0, 1, -30.0, 30.0],
        [1733, 1720, 0.0169465, 0.0860085, 0.00766473, 139.29, 139.29, 139.29, 0.0, 0.0, 1, -30.0, 30.0],
        [1733, 1735, 0.0121482, 0.0433523, 0.00593432, 156.49, 156.49, 156.49, 0.0, 0.0, 1, -30.0, 30.0],
        [1733, 1735, 0.0121482, 0.0433523, 0.00593432, 156.49, 156.49, 156.49, 0.0, 0.0, 1, -30.0, 30.0],
        [1734, 1736, 0.00021321, 0.00119728, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1737, 1738, 0.0182145, 0.0669575, 0.00527352, 204.27, 204.27, 204.27, 0.0, 0.0, 1, -30.0, 30.0],
        [1739, 1740, 0.000272585, 0.0011547, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1739, 1859, 0.00907844, 0.041245, 0.00309301, 122.79, 122.79, 122.79, 0.0, 0.0, 1, -30.0, 30.0],
        [1742, 1756, 0.0143493, 0.067561, 0.0185087, 119.29, 119.29, 119.29, 0.0, 0.0, 1, -30.0, 30.0],
        [1743, 1741, 0.00563925, 0.0271392, 0.00484725, 277.94, 277.94, 277.94, 0.0, 0.0, 1, -30.0, 30.0],
        [1743, 2000, 0.00669005, 0.0258281, 0.0021307, 340.43, 340.43, 340.43, 0.0, 0.0, 1, -30.0, 30.0],
        [1744, 1754, 0.00630129, 0.0294277, 0.010137, 130.0, 130.0, 130.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1744, 1928, 0.00368741, 0.0140598, 0.00253314, 131.78, 131.78, 131.78, 0.0, 0.0, 1, -30.0, 30.0],
        [1745, 1984, 0.0123412, 0.0615471, 0.00896961, 133.9, 133.9, 133.9, 0.0, 0.0, 1, -30.0, 30.0],
        [1746, 1742, 0.0151384, 0.0497009, 0.00458749, 134.53, 134.53, 134.53, 0.0, 0.0, 1, -30.0, 30.0],
        [1746, 1972, 0.0120438, 0.0462593, 0.00570623, 171.61, 171.61, 171.61, 0.0, 0.0, 1, -30.0, 30.0],
        [1747, 1750, 0.00927689, 0.0421179, 0.00340077, 186.62, 186.62, 186.62, 0.0, 0.0, 1, -30.0, 30.0],
        [1747, 1751, 0.00358706, 0.0183525, 0.00286048, 122.52, 122.52, 122.52, 0.0, 0.0, 1, -30.0, 30.0],
        [1747, 1984, 0.0122752, 0.0558627, 0.00694039, 151.51, 151.51, 151.51, 0.0, 0.0, 1, -30.0, 30.0],
        [1747, 1984, 0.0122752, 0.0558627, 0.00694039, 151.51, 151.51, 151.51, 0.0, 0.0, 1, -30.0, 30.0],
        [1748, 1741, 0.00381857, 0.0155296, 0.00268766, 169.63, 169.63, 169.63, 0.0, 0.0, 1, -30.0, 30.0],
        [1748, 1745, 0.0062131, 0.0246807, 0.00239381, 123.71, 123.71, 123.71, 0.0, 0.0, 1, -30.0, 30.0],
        [1749, 1750, 0.0072661, 0.0320505, 0.00421784, 128.58, 128.58, 128.58, 0.0, 0.0, 1, -30.0, 30.0],
        [1751, 1748, 0.00559162, 0.0259448, 0.00390003, 151.3, 151.3, 151.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1752, 2000, 0.0128818, 0.0621737, 0.00474304, 130.95, 130.95, 130.95, 0.0, 0.0, 1, -30.0, 30.0],
        [1753, 1739, 0.0172777, 0.0678644, 0.00697831, 130.77, 130.77, 130.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1753, 1928, 0.0174344, 0.0751393, 0.00953893, 140.15, 140.15, 140.15, 0.0, 0.0, 1, -30.0, 30.0],
        [1754, 1755, 0.000254938, 0.0011254, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1754, 1764, 0.0186689, 0.0867216, 0.0105875, 133.66, 133.66, 133.66, 0.0, 0.0, 1, -30.0, 30.0],
        [1754, 1928, 0.0119565, 0.0459689, 0.00547146, 129.99, 129.99, 129.99, 0.0, 0.0, 1, -30.0, 30.0],
        [1758, 1757, 0.027873, 0.112945, 0.0101302, 108.23, 108.23, 108.23, 0.0, 0.0, 1, -30.0, 30.0],
        [1759, 1769, 0.0269458, 0.0887136, 0.0126476, 134.03, 134.03, 134.03, 0.0, 0.0, 1, -30.0, 30.0],
        [1760, 1554, 0.0254581, 0.103447, 0.00994858, 122.61, 122.61, 122.61, 0.0, 0.0, 1, -30.0, 30.0],
        [1760, 1838, 0.0192022, 0.0677653, 0.019858, 178.27, 178.27, 178.27, 0.0, 0.0, 1, -30.0, 30.0],
        [1761, 1859, 0.00968476, 0.047728, 0.00609222, 175.14, 175.14, 175.14, 0.0, 0.0, 1, -30.0, 30.0],
        [1762, 1763, 0.000207934, 0.00112539, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1763, 1749, 0.0178196, 0.0763042, 0.00910543, 125.26, 125.26, 125.26, 0.0, 0.0, 1, -30.0, 30.0],
        [1763, 1761, 0.00940808, 0.0419172, 0.00436448, 145.25, 145.25, 145.25, 0.0, 0.0, 1, -30.0, 30.0],
        [1765, 1497, 0.0188732, 0.0906702, 0.0118018, 113.05, 113.05, 113.05, 0.0, 0.0, 1, -30.0, 30.0],
        [1765, 1528, 0.0241514, 0.092209, 0.00907673, 114.22, 114.22, 114.22, 0.0, 0.0, 1, -30.0, 30.0],
        [1766, 1554, 0.0162178, 0.0731825, 0.0115176, 116.07, 116.07, 116.07, 0.0, 0.0, 1, -30.0, 30.0],
        [1767, 1742, 0.0146779, 0.0584043, 0.00482464, 125.13, 125.13, 125.13, 0.0, 0.0, 1, -30.0, 30.0],
        [1767, 1771, 0.0200984, 0.086215, 0.00876593, 106.31, 106.31, 106.31, 0.0, 0.0, 1, -30.0, 30.0],
        [1768, 1770, 0.00020287, 0.00117933, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1768, 1985, 0.0025768, 0.0279553, 0.548623, 1408.82, 1408.82, 1408.82, 0.0, 0.0, 1, -30.0, 30.0],
        [1769, 1758, 0.018929, 0.103318, 0.0133779, 135.81, 135.81, 135.81, 0.0, 0.0, 1, -30.0, 30.0],
        [1771, 1484, 0.0192555, 0.0787138, 0.00909398, 111.5, 111.5, 111.5, 0.0, 0.0, 1, -30.0, 30.0],
        [1772, 1758, 0.0342634, 0.133679, 0.0110533, 129.38, 129.38, 129.38, 0.0, 0.0, 1, -30.0, 30.0],
        [1773, 1749, 0.0127253, 0.061946, 0.00602401, 122.75, 122.75, 122.75, 0.0, 0.0, 1, -30.0, 30.0],
        [1773, 1774, 0.0160892, 0.0678624, 0.0105902, 112.18, 112.18, 112.18, 0.0, 0.0, 1, -30.0, 30.0],
        [1774, 1756, 0.0126792, 0.065082, 0.00492821, 107.81, 107.81, 107.81, 0.0, 0.0, 1, -30.0, 30.0],
        [1775, 1776, 0.0142298, 0.0704285, 0.00671499, 138.59, 138.59, 138.59, 0.0, 0.0, 1, -30.0, 30.0],
        [1775, 1777, 0.0156541, 0.0524342, 0.00392301, 139.6, 139.6, 139.6, 0.0, 0.0, 1, -30.0, 30.0],
        [1775, 1790, 0.0112855, 0.0455985, 0.00374218, 160.66, 160.66, 160.66, 0.0, 0.0, 1, -30.0, 30.0],
        [1775, 1806, 0.017547, 0.0645544, 0.0104929, 135.24, 135.24, 135.24, 0.0, 0.0, 1, -30.0, 30.0],
        [1775, 1878, 0.0145258, 0.0637573, 0.00631038, 146.33, 146.33, 146.33, 0.0, 0.0, 1, -30.0, 30.0],
        [1776, 1779, 0.00988356, 0.04393, 0.00396882, 207.52, 207.52, 207.52, 0.0, 0.0, 1, -30.0, 30.0],
        [1777, 1776, 0.00560348, 0.0309123, 0.00587385, 126.56, 126.56, 126.56, 0.0, 0.0, 1, -30.0, 30.0],
        [1778, 1777, 0.00973506, 0.0455859, 0.00499663, 122.03, 122.03, 122.03, 0.0, 0.0, 1, -30.0, 30.0],
        [1778, 1811, 0.0181669, 0.0891987, 0.0076876, 111.14, 111.14, 111.14, 0.0, 0.0, 1, -30.0, 30.0],
        [1780, 1779, 0.00995316, 0.0404237, 0.00394349, 173.55, 173.55, 173.55, 0.0, 0.0, 1, -30.0, 30.0],
        [1780, 1787, 0.0128236, 0.0571838, 0.00935122, 154.59, 154.59, 154.59, 0.0, 0.0, 1, -30.0, 30.0],
        [1781, 1782, 0.000246122, 0.00112713, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1782, 1788, 0.00741469, 0.0377266, 0.00560927, 176.5, 176.5, 176.5, 0.0, 0.0, 1, -30.0, 30.0],
        [1782, 1788, 0.00741469, 0.0377266, 0.00560927, 176.5, 176.5, 176.5, 0.0, 0.0, 1, -30.0, 30.0],
        [1782, 1788, 0.00741469, 0.0377266, 0.00560927, 176.5, 176.5, 176.5, 0.0, 0.0, 1, -30.0, 30.0],
        [1782, 1953, 0.00779545, 0.0306832, 0.00255527, 168.36, 168.36, 168.36, 0.0, 0.0, 1, -30.0, 30.0],
        [1782, 1953, 0.00779545, 0.0306832, 0.00255527, 168.36, 168.36, 168.36, 0.0, 0.0, 1, -30.0, 30.0],
        [1782, 1991, 0.00800253, 0.0326855, 0.0048737, 178.33, 178.33, 178.33, 0.0, 0.0, 1, -30.0, 30.0],
        [1782, 1991, 0.00800253, 0.0326855, 0.0048737, 178.33, 178.33, 178.33, 0.0, 0.0, 1, -30.0, 30.0],
        [1783, 1789, 0.00439761, 0.0226763, 0.00244704, 212.24, 212.24, 212.24, 0.0, 0.0, 1, -30.0, 30.0],
        [1784, 1801, 0.00696938, 0.0246221, 0.00384599, 133.9, 133.9, 133.9, 0.0, 0.0, 1, -30.0, 30.0],
        [1784, 1806, 0.00704875, 0.030165, 0.0039488, 119.79, 119.79, 119.79, 0.0, 0.0, 1, -30.0, 30.0],
        [1785, 1788, 0.00876892, 0.0305521, 0.00473785, 155.26, 155.26, 155.26, 0.0, 0.0, 1, -30.0, 30.0],
        [1785, 1788, 0.00876892, 0.0305521, 0.00473785, 155.26, 155.26, 155.26, 0.0, 0.0, 1, -30.0, 30.0],
        [1786, 1934, 0.0168859, 0.0635738, 0.00890305, 224.54, 224.54, 224.54, 0.0, 0.0, 1, -30.0, 30.0],
        [1787, 1785, 0.00894304, 0.0336048, 0.00417979, 145.14, 145.14, 145.14, 0.0, 0.0, 1, -30.0, 30.0],
        [1787, 1785, 0.00894304, 0.0336048, 0.00417979, 145.14, 145.14, 145.14, 0.0, 0.0, 1, -30.0, 30.0],
        [1788, 1783, 0.00535501, 0.0216819, 0.00326013, 143.19, 143.19, 143.19, 0.0, 0.0, 1, -30.0, 30.0],
        [1788, 1783, 0.00535501, 0.0216819, 0.00326013, 143.19, 143.19, 143.19, 0.0, 0.0, 1, -30.0, 30.0],
        [1789, 1567, 0.0120173, 0.048009, 0.00372786, 168.41, 168.41, 168.41, 0.0, 0.0, 1, -30.0, 30.0],
        [1789, 1785, 0.0092196, 0.0485515, 0.00308913, 114.99, 114.99, 114.99, 0.0, 0.0, 1, -30.0, 30.0],
        [1790, 1953, 0.00636715, 0.0236518, 0.00232526, 131.57, 131.57, 131.57, 0.0, 0.0, 1, -30.0, 30.0],
        [1790, 1982, 0.00757811, 0.0298631, 0.00424269, 139.8, 139.8, 139.8, 0.0, 0.0, 1, -30.0, 30.0],
        [1791, 1793, 0.000220246, 0.00107565, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1791, 1794, 0.00505392, 0.0233957, 0.00369403, 113.11, 113.11, 113.11, 0.0, 0.0, 1, -30.0, 30.0],
        [1792, 638, 0.0137319, 0.0361308, 0.00239458, 51.0, 51.0, 51.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1794, 1796, 0.000276166, 0.00112292, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1794, 1982, 0.0123957, 0.0579287, 0.00512068, 191.64, 191.64, 191.64, 0.0, 0.0, 1, -30.0, 30.0],
        [1795, 625, 0.00351834, 0.00991989, 0.000376203, 48.44, 48.44, 48.44, 0.0, 0.0, 1, -30.0, 30.0],
        [1795, 1802, 0.0394551, 0.0841321, 0.00336814, 50.01, 50.01, 50.01, 0.0, 0.0, 1, -30.0, 30.0],
        [1797, 1814, 0.016873, 0.0606666, 0.0116172, 129.79, 129.79, 129.79, 0.0, 0.0, 1, -30.0, 30.0],
        [1798, 1786, 0.0182941, 0.0674432, 0.0073699, 125.85, 125.85, 125.85, 0.0, 0.0, 1, -30.0, 30.0],
        [1798, 1799, 0.031518, 0.121582, 0.00852541, 184.99, 184.99, 184.99, 0.0, 0.0, 1, -30.0, 30.0],
        [1799, 1800, 0.000225628, 0.00116495, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1802, 621, 0.0142522, 0.0417307, 0.00151142, 83.65, 83.65, 83.65, 0.0, 0.0, 1, -30.0, 30.0],
        [1803, 1805, 0.000224616, 0.00109381, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1803, 1806, 0.0295109, 0.0931232, 0.00764118, 124.7, 124.7, 124.7, 0.0, 0.0, 1, -30.0, 30.0],
        [1804, 628, 0.015526, 0.0430567, 0.00176621, 49.3, 49.3, 49.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1804, 629, 0.0114063, 0.0353268, 0.00214972, 53.94, 53.94, 53.94, 0.0, 0.0, 1, -30.0, 30.0],
        [1806, 1991, 0.00133605, 0.00531149, 0.000872163, 149.43, 149.43, 149.43, 0.0, 0.0, 1, -30.0, 30.0],
        [1806, 1991, 0.00133605, 0.00531149, 0.000872163, 171.08, 171.08, 171.08, 0.0, 0.0, 1, -30.0, 30.0],
        [1807, 1809, 0.000207548, 0.00116122, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1808, 646, 0.00922086, 0.0224742, 0.000776928, 99.52, 99.52, 99.52, 0.0, 0.0, 1, -30.0, 30.0],
        [1810, 1811, 0.000270943, 0.00111049, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1811, 1815, 0.0118666, 0.0560193, 0.00816134, 114.86, 114.86, 114.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1812, 1814, 0.000200106, 0.00119758, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1814, 1117, 0.00337401, 0.0128146, 0.00138727, 138.47, 138.47, 138.47, 0.0, 0.0, 1, -30.0, 30.0],
        [1814, 1854, 0.0192841, 0.0943143, 0.00636513, 147.37, 147.37, 147.37, 0.0, 0.0, 1, -30.0, 30.0],
        [1814, 1854, 0.0192841, 0.0943143, 0.00636513, 147.37, 147.37, 147.37, 0.0, 0.0, 1, -30.0, 30.0],
        [1816, 1829, 0.0231474, 0.0739516, 0.0059726, 176.82, 176.82, 176.82, 0.0, 0.0, 1, -30.0, 30.0],
        [1818, 1820, 0.0205056, 0.0826715, 0.00844094, 147.63, 147.63, 147.63, 0.0, 0.0, 1, -30.0, 30.0],
        [1819, 1824, 0.0110953, 0.0505524, 0.00666135, 143.35, 143.35, 143.35, 0.0, 0.0, 1, -30.0, 30.0],
        [1819, 1824, 0.0110953, 0.0505524, 0.00666135, 143.35, 143.35, 143.35, 0.0, 0.0, 1, -30.0, 30.0],
        [1819, 1840, 0.0168762, 0.069392, 0.0078149, 164.24, 164.24, 164.24, 0.0, 0.0, 1, -30.0, 30.0],
        [1820, 1817, 0.0177778, 0.081578, 0.016306, 125.11, 125.11, 125.11, 0.0, 0.0, 1, -30.0, 30.0],
        [1820, 1866, 0.0200739, 0.08561, 0.0115287, 157.67, 157.67, 157.67, 0.0, 0.0, 1, -30.0, 30.0],
        [1821, 1823, 0.00023354, 0.00106287, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1824, 1822, 0.00809205, 0.0369189, 0.00377881, 154.3, 154.3, 154.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1824, 1822, 0.00809205, 0.0369189, 0.00377881, 169.09, 169.09, 169.09, 0.0, 0.0, 1, -30.0, 30.0],
        [1824, 1825, 0.000205939, 0.00103488, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1824, 1826, 0.0310501, 0.132319, 0.0198637, 94.4, 94.4, 94.4, 0.0, 0.0, 1, -30.0, 30.0],
        [1826, 1816, 0.0185265, 0.0796652, 0.00661107, 121.14, 121.14, 121.14, 0.0, 0.0, 1, -30.0, 30.0],
        [1828, 1827, 0.0163315, 0.0630087, 0.0118286, 131.66, 131.66, 131.66, 0.0, 0.0, 1, -30.0, 30.0],
        [1829, 1822, 0.00669663, 0.034742, 0.00406749, 142.77, 142.77, 142.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1829, 1822, 0.00669663, 0.034742, 0.00406749, 142.77, 142.77, 142.77, 0.0, 0.0, 1, -30.0, 30.0],
        [1829, 1828, 0.00944894, 0.0495152, 0.00362819, 173.83, 173.83, 173.83, 0.0, 0.0, 1, -30.0, 30.0],
        [1830, 1833, 0.0180141, 0.0861355, 0.0080487, 112.82, 112.82, 112.82, 0.0, 0.0, 1, -30.0, 30.0],
        [1831, 1832, 0.0170934, 0.0579549, 0.00641509, 137.24, 137.24, 137.24, 0.0, 0.0, 1, -30.0, 30.0],
        [1831, 1846, 0.017362, 0.0732021, 0.00739522, 149.01, 149.01, 149.01, 0.0, 0.0, 1, -30.0, 30.0],
        [1833, 1832, 0.00738422, 0.0354828, 0.00278369, 126.83, 126.83, 126.83, 0.0, 0.0, 1, -30.0, 30.0],
        [1834, 1849, 0.00777806, 0.0355718, 0.00355714, 173.47, 173.47, 173.47, 0.0, 0.0, 1, -30.0, 30.0],
        [1835, 1847, 0.000967632, 0.0112904, 0.215665, 1911.83, 1911.83, 1911.83, 0.0, 0.0, 1, -30.0, 30.0],
        [1836, 1830, 0.00832254, 0.0440888, 0.00614822, 144.47, 144.47, 144.47, 0.0, 0.0, 1, -30.0, 30.0],
        [1836, 1830, 0.00832254, 0.0440888, 0.00614822, 144.47, 144.47, 144.47, 0.0, 0.0, 1, -30.0, 30.0],
        [1836, 1832, 0.00956898, 0.0354051, 0.00683712, 145.0, 145.0, 145.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1836, 1832, 0.00956898, 0.0354051, 0.00683712, 145.0, 145.0, 145.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1837, 1838, 0.0118821, 0.0589768, 0.00686743, 205.55, 205.55, 205.55, 0.0, 0.0, 1, -30.0, 30.0],
        [1837, 1851, 0.0204575, 0.097042, 0.0142469, 142.51, 142.51, 142.51, 0.0, 0.0, 1, -30.0, 30.0],
        [1837, 1851, 0.0204575, 0.097042, 0.0142469, 142.51, 142.51, 142.51, 0.0, 0.0, 1, -30.0, 30.0],
        [1839, 1827, 0.012963, 0.0602917, 0.00998991, 122.17, 122.17, 122.17, 0.0, 0.0, 1, -30.0, 30.0],
        [1840, 1839, 0.0153771, 0.0565846, 0.00453613, 134.06, 134.06, 134.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1841, 1842, 0.000262191, 0.00108853, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1842, 1849, 0.0087642, 0.0371905, 0.00408222, 144.76, 144.76, 144.76, 0.0, 0.0, 1, -30.0, 30.0],
        [1842, 1850, 0.00715303, 0.036067, 0.00578919, 104.61, 104.61, 104.61, 0.0, 0.0, 1, -30.0, 30.0],
        [1843, 1834, 0.0131663, 0.0573271, 0.00928784, 138.74, 138.74, 138.74, 0.0, 0.0, 1, -30.0, 30.0],
        [1843, 1840, 0.0154942, 0.0631155, 0.00868207, 160.08, 160.08, 160.08, 0.0, 0.0, 1, -30.0, 30.0],
        [1844, 1818, 0.029562, 0.109834, 0.00594516, 123.93, 123.93, 123.93, 0.0, 0.0, 1, -30.0, 30.0],
        [1845, 1847, 0.000282119, 0.00114429, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1846, 1844, 0.0215713, 0.0821517, 0.0100225, 111.87, 111.87, 111.87, 0.0, 0.0, 1, -30.0, 30.0],
        [1847, 1974, 0.00156587, 0.0217981, 0.336971, 1968.79, 1968.79, 1968.79, 0.0, 0.0, 1, -30.0, 30.0],
        [1847, 1985, 0.00112235, 0.0133759, 0.301317, 1355.91, 1355.91, 1355.91, 0.0, 0.0, 1, -30.0, 30.0],
        [1847, 1985, 0.00112235, 0.0133759, 0.301317, 1355.91, 1355.91, 1355.91, 0.0, 0.0, 1, -30.0, 30.0],
        [1848, 1550, 0.0257158, 0.0752943, 0.00563757, 131.84, 131.84, 131.84, 0.0, 0.0, 1, -30.0, 30.0],
        [1848, 1830, 0.0145413, 0.0678383, 0.00799494, 165.06, 165.06, 165.06, 0.0, 0.0, 1, -30.0, 30.0],
        [1849, 1833, 0.00830608, 0.0297417, 0.00434276, 120.15, 120.15, 120.15, 0.0, 0.0, 1, -30.0, 30.0],
        [1849, 1851, 0.00836311, 0.0359919, 0.0052185, 130.94, 130.94, 130.94, 0.0, 0.0, 1, -30.0, 30.0],
        [1850, 1557, 0.0111831, 0.0526115, 0.00665523, 137.92, 137.92, 137.92, 0.0, 0.0, 1, -30.0, 30.0],
        [1851, 1556, 0.0164307, 0.0739954, 0.0104461, 238.26, 238.26, 238.26, 0.0, 0.0, 1, -30.0, 30.0],
        [1851, 1836, 0.00585672, 0.0279428, 0.00590299, 158.34, 158.34, 158.34, 0.0, 0.0, 1, -30.0, 30.0],
        [1851, 1836, 0.00585672, 0.0279428, 0.00590299, 187.13, 187.13, 187.13, 0.0, 0.0, 1, -30.0, 30.0],
        [1852, 1853, 0.00762494, 0.0290551, 0.00807113, 126.91, 126.91, 126.91, 0.0, 0.0, 1, -30.0, 30.0],
        [1853, 1854, 0.00653226, 0.0331538, 0.00287093, 142.82, 142.82, 142.82, 0.0, 0.0, 1, -30.0, 30.0],
        [1853, 1854, 0.00653226, 0.0331538, 0.00287093, 142.82, 142.82, 142.82, 0.0, 0.0, 1, -30.0, 30.0],
        [1855, 1853, 0.0142048, 0.057154, 0.00779244, 123.21, 123.21, 123.21, 0.0, 0.0, 1, -30.0, 30.0],
        [1855, 1856, 0.0145131, 0.0687437, 0.00503079, 115.04, 115.04, 115.04, 0.0, 0.0, 1, -30.0, 30.0],
        [1857, 1555, 0.0137712, 0.055932, 0.0103068, 148.53, 148.53, 148.53, 0.0, 0.0, 1, -30.0, 30.0],
        [1857, 1556, 0.0104234, 0.0340638, 0.00597038, 161.56, 161.56, 161.56, 0.0, 0.0, 1, -30.0, 30.0],
        [1858, 1859, 0.000286506, 0.00109499, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1859, 1741, 0.0113267, 0.0448581, 0.00515321, 136.86, 136.86, 136.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1859, 1984, 0.00198256, 0.00889273, 0.000788506, 147.46, 147.46, 147.46, 0.0, 0.0, 1, -30.0, 30.0],
        [1859, 1984, 0.00198256, 0.00889273, 0.000788506, 147.46, 147.46, 147.46, 0.0, 0.0, 1, -30.0, 30.0],
        [1860, 1862, 0.000235011, 0.0010766, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1860, 1881, 0.0400995, 0.129189, 0.0140639, 125.24, 125.24, 125.24, 0.0, 0.0, 1, -30.0, 30.0],
        [1860, 1920, 0.000635095, 0.00297441, 0.000376491, 260.63, 260.63, 260.63, 0.0, 0.0, 1, -30.0, 30.0],
        [1860, 1944, 0.00480991, 0.0237952, 0.00294975, 179.32, 179.32, 179.32, 0.0, 0.0, 1, -30.0, 30.0],
        [1860, 1944, 0.00480991, 0.0237952, 0.00294975, 179.32, 179.32, 179.32, 0.0, 0.0, 1, -30.0, 30.0],
        [1863, 1864, 0.000237388, 0.00105774, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1864, 1967, 0.00275793, 0.0113707, 0.00244351, 184.91, 184.91, 184.91, 0.0, 0.0, 1, -30.0, 30.0],
        [1865, 1871, 0.00024416, 0.0011316, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1871, 1821, 0.00085334, 0.00952334, 0.223495, 1503.02, 1503.02, 1503.02, 0.0, 0.0, 1, -30.0, 30.0],
        [1871, 1847, 0.00173749, 0.0205038, 0.335264, 1333.37, 1333.37, 1333.37, 0.0, 0.0, 1, -30.0, 30.0],
        [1871, 1847, 0.00173749, 0.0205038, 0.335264, 1333.37, 1333.37, 1333.37, 0.0, 0.0, 1, -30.0, 30.0],
        [1872, 1874, 0.000230062, 0.00108057, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1873, 1659, 0.0212087, 0.0895415, 0.00791984, 127.44, 127.44, 127.44, 0.0, 0.0, 1, -30.0, 30.0],
        [1873, 1688, 0.0177883, 0.0793575, 0.00941717, 128.2, 128.2, 128.2, 0.0, 0.0, 1, -30.0, 30.0],
        [1874, 1951, 0.0012457, 0.0128933, 0.435948, 1173.62, 1173.62, 1173.62, 0.0, 0.0, 1, -30.0, 30.0],
        [1875, 1876, 0.000201478, 0.00116101, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1877, 1879, 0.000219009, 0.00111253, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1878, 1799, 0.00875562, 0.0328094, 0.00642261, 145.12, 145.12, 145.12, 0.0, 0.0, 1, -30.0, 30.0],
        [1878, 1799, 0.00875562, 0.0328094, 0.00642261, 145.12, 145.12, 145.12, 0.0, 0.0, 1, -30.0, 30.0],
        [1879, 1894, 0.00109627, 0.0137074, 0.204645, 1491.68, 1491.68, 1491.68, 0.0, 0.0, 1, -30.0, 30.0],
        [1879, 1998, 0.00021095, 0.00253395, 0.0412245, 1139.13, 1139.13, 1139.13, 0.0, 0.0, 1, -30.0, 30.0],
        [1880, 1881, 0.000280851, 0.001109, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1881, 1495, 0.0053529, 0.0234792, 0.00351444, 141.62, 141.62, 141.62, 0.0, 0.0, 1, -30.0, 30.0],
        [1882, 1885, 0.0002841, 0.00103901, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1885, 1922, 0.00392204, 0.0198194, 0.00188976, 127.84, 127.84, 127.84, 0.0, 0.0, 1, -30.0, 30.0],
        [1885, 1961, 0.00382053, 0.0185673, 0.00379065, 140.74, 140.74, 140.74, 0.0, 0.0, 1, -30.0, 30.0],
        [1886, 1891, 0.000254391, 0.00108703, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1892, 1894, 0.000234653, 0.00117025, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1893, 1569, 0.00841815, 0.0303351, 0.00494226, 160.36, 160.36, 160.36, 0.0, 0.0, 1, -30.0, 30.0],
        [1893, 1569, 0.00841815, 0.0303351, 0.00494226, 160.36, 160.36, 160.36, 0.0, 0.0, 1, -30.0, 30.0],
        [1894, 1542, 0.000693177, 0.0086873, 0.17099, 1407.41, 1407.41, 1407.41, 0.0, 0.0, 1, -30.0, 30.0],
        [1894, 1998, 0.00110399, 0.0129775, 0.199938, 1576.48, 1576.48, 1576.48, 0.0, 0.0, 1, -30.0, 30.0],
        [1895, 1900, 0.000241197, 0.00116609, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1896, 1598, 0.00347735, 0.015432, 0.002467, 173.27, 173.27, 173.27, 0.0, 0.0, 1, -30.0, 30.0],
        [1900, 1602, 0.00160243, 0.0161579, 0.215373, 996.55, 996.55, 996.55, 0.0, 0.0, 1, -30.0, 30.0],
        [1900, 1621, 0.000581777, 0.00724384, 0.150291, 1078.38, 1078.38, 1078.38, 0.0, 0.0, 1, -30.0, 30.0],
        [1901, 1907, 0.000297121, 0.0011741, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1902, 1909, 0.00461658, 0.0177276, 0.00183154, 200.0, 200.0, 200.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1908, 1909, 0.000219318, 0.00102665, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1909, 1709, 0.0128374, 0.0533187, 0.0106109, 145.31, 145.31, 145.31, 0.0, 0.0, 1, -30.0, 30.0],
        [1910, 1916, 0.000270699, 0.00116243, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1911, 1722, 0.00676312, 0.0321722, 0.0018414, 147.4, 147.4, 147.4, 0.0, 0.0, 1, -30.0, 30.0],
        [1916, 1734, 0.00188226, 0.0238945, 0.481628, 1010.33, 1010.33, 1010.33, 0.0, 0.0, 1, -30.0, 30.0],
        [1916, 1907, 0.000493968, 0.00576432, 0.14125, 1004.08, 1004.08, 1004.08, 0.0, 0.0, 1, -30.0, 30.0],
        [1917, 1918, 0.000291839, 0.00105355, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1918, 1510, 0.0146115, 0.0696109, 0.00475915, 199.63, 199.63, 199.63, 0.0, 0.0, 1, -30.0, 30.0],
        [1918, 1947, 0.00955096, 0.0401172, 0.00345216, 123.27, 123.27, 123.27, 0.0, 0.0, 1, -30.0, 30.0],
        [1918, 1955, 0.00239797, 0.0117494, 0.00139582, 250.0, 250.0, 250.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1919, 1920, 0.000298319, 0.00102217, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1920, 1944, 0.00619453, 0.0260755, 0.00286469, 148.22, 148.22, 148.22, 0.0, 0.0, 1, -30.0, 30.0],
        [1920, 1944, 0.00619453, 0.0260755, 0.00286469, 148.22, 148.22, 148.22, 0.0, 0.0, 1, -30.0, 30.0],
        [1920, 1977, 0.00680933, 0.0347283, 0.00272935, 176.63, 176.63, 176.63, 0.0, 0.0, 1, -30.0, 30.0],
        [1921, 1922, 0.000240225, 0.00111967, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1922, 1668, 0.0186539, 0.0919404, 0.00776597, 150.38, 150.38, 150.38, 0.0, 0.0, 1, -30.0, 30.0],
        [1922, 1961, 0.00449238, 0.0256612, 0.00357666, 144.73, 144.73, 144.73, 0.0, 0.0, 1, -30.0, 30.0],
        [1923, 1924, 0.000246671, 0.00105436, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1924, 1873, 0.00809366, 0.0380463, 0.00499127, 128.09, 128.09, 128.09, 0.0, 0.0, 1, -30.0, 30.0],
        [1925, 1926, 0.000252197, 0.00109504, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1926, 1937, 0.00314004, 0.014026, 0.000894594, 111.08, 111.08, 111.08, 0.0, 0.0, 1, -30.0, 30.0],
        [1927, 1928, 0.000298852, 0.00111313, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1929, 1930, 0.000246233, 0.00115184, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1931, 1932, 0.000291639, 0.00106819, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1932, 1629, 0.00952317, 0.0431336, 0.00477089, 128.3, 128.3, 128.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1932, 1930, 0.00177602, 0.00877754, 0.00151683, 131.81, 131.81, 131.81, 0.0, 0.0, 1, -30.0, 30.0],
        [1932, 1949, 0.00557577, 0.0175348, 0.00181953, 143.2, 143.2, 143.2, 0.0, 0.0, 1, -30.0, 30.0],
        [1933, 1935, 0.000277244, 0.00115225, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1934, 1815, 0.0121026, 0.0495993, 0.00625003, 115.61, 115.61, 115.61, 0.0, 0.0, 1, -30.0, 30.0],
        [1935, 1145, 0.00119498, 0.0145699, 0.235421, 1200.23, 1200.23, 1200.23, 0.0, 0.0, 1, -30.0, 30.0],
        [1935, 1558, 0.000706613, 0.00932278, 0.222839, 2074.69, 2074.69, 2074.69, 0.0, 0.0, 1, -30.0, 30.0],
        [1935, 1998, 0.0012208, 0.0140643, 0.29338, 1161.8, 1161.8, 1161.8, 0.0, 0.0, 1, -30.0, 30.0],
        [1936, 1938, 0.000215621, 0.00107214, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1937, 1508, 0.0200544, 0.0678407, 0.00807347, 123.39, 123.39, 123.39, 0.0, 0.0, 1, -30.0, 30.0],
        [1937, 1940, 0.00664623, 0.0310833, 0.00418796, 125.87, 125.87, 125.87, 0.0, 0.0, 1, -30.0, 30.0],
        [1938, 1489, 0.00170372, 0.020873, 0.571204, 1317.76, 1317.76, 1317.76, 0.0, 0.0, 1, -30.0, 30.0],
        [1938, 1489, 0.00170372, 0.020873, 0.571204, 1317.76, 1317.76, 1317.76, 0.0, 0.0, 1, -30.0, 30.0],
        [1938, 1635, 0.00288542, 0.0348191, 0.531924, 1249.75, 1249.75, 1249.75, 0.0, 0.0, 1, -30.0, 30.0],
        [1938, 1768, 0.00229222, 0.028473, 0.706576, 1164.67, 1164.67, 1164.67, 0.0, 0.0, 1, -30.0, 30.0],
        [1939, 1940, 0.000273721, 0.00102508, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1940, 1926, 0.00636535, 0.0244608, 0.00260146, 130.92, 130.92, 130.92, 0.0, 0.0, 1, -30.0, 30.0],
        [1941, 1944, 0.000254164, 0.00110189, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1944, 1876, 0.00293935, 0.0125401, 0.0010174, 200.0, 200.0, 200.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1944, 1876, 0.00293935, 0.0125401, 0.0010174, 200.0, 200.0, 200.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1945, 1947, 0.000261708, 0.0011819, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1947, 1595, 0.00715603, 0.0308346, 0.00520092, 145.94, 145.94, 145.94, 0.0, 0.0, 1, -30.0, 30.0],
        [1947, 1595, 0.00715603, 0.0308346, 0.00520092, 145.94, 145.94, 145.94, 0.0, 0.0, 1, -30.0, 30.0],
        [1948, 1951, 0.000260028, 0.00118234, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1949, 1632, 0.00179022, 0.00842256, 0.00101246, 123.47, 123.47, 123.47, 0.0, 0.0, 1, -30.0, 30.0],
        [1951, 1635, 0.000838413, 0.0103187, 0.285909, 1139.23, 1139.23, 1139.23, 0.0, 0.0, 1, -30.0, 30.0],
        [1951, 1965, 0.00479279, 0.0584752, 0.707287, 1140.01, 1140.01, 1140.01, 0.0, 0.0, 1, -30.0, 30.0],
        [1951, 1970, 0.00116622, 0.0154405, 0.272459, 1196.85, 1196.85, 1196.85, 0.0, 0.0, 1, -30.0, 30.0],
        [1952, 1953, 0.00022867, 0.00104454, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1953, 1982, 0.00359527, 0.0172021, 0.00148533, 164.86, 164.86, 164.86, 0.0, 0.0, 1, -30.0, 30.0],
        [1954, 1959, 0.000288305, 0.00118669, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1955, 1947, 0.00691432, 0.0227577, 0.00379953, 114.87, 114.87, 114.87, 0.0, 0.0, 1, -30.0, 30.0],
        [1960, 1965, 0.000207118, 0.00105236, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1961, 1667, 0.00500641, 0.0204519, 0.00259308, 160.49, 160.49, 160.49, 0.0, 0.0, 1, -30.0, 30.0],
        [1961, 1667, 0.00500641, 0.0204519, 0.00259308, 160.49, 160.49, 160.49, 0.0, 0.0, 1, -30.0, 30.0],
        [1965, 1734, 0.00256941, 0.0278208, 0.496554, 1208.87, 1208.87, 1208.87, 0.0, 0.0, 1, -30.0, 30.0],
        [1965, 1874, 0.00306201, 0.0371102, 0.574981, 1152.73, 1152.73, 1152.73, 0.0, 0.0, 1, -30.0, 30.0],
        [1965, 1916, 0.00381271, 0.0476006, 0.839451, 1137.59, 1137.59, 1137.59, 0.0, 0.0, 1, -30.0, 30.0],
        [1966, 1970, 0.000250308, 0.00115622, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1970, 1938, 0.00288492, 0.0361348, 0.869462, 1198.58, 1198.58, 1198.58, 0.0, 0.0, 1, -30.0, 30.0],
        [1971, 1974, 0.000271137, 0.00109771, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1972, 2000, 0.0017005, 0.00674614, 0.000704653, 401.79, 401.79, 401.79, 0.0, 0.0, 1, -30.0, 30.0],
        [1975, 1977, 0.000242399, 0.00105415, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1977, 1580, 0.0122312, 0.0426116, 0.00284926, 145.35, 145.35, 145.35, 0.0, 0.0, 1, -30.0, 30.0],
        [1977, 1580, 0.0122312, 0.0426116, 0.00284926, 145.35, 145.35, 145.35, 0.0, 0.0, 1, -30.0, 30.0],
        [1977, 1624, 0.0053131, 0.0230936, 0.00289926, 118.69, 118.69, 118.69, 0.0, 0.0, 1, -30.0, 30.0],
        [1977, 1989, 0.00604722, 0.026794, 0.00268773, 114.89, 114.89, 114.89, 0.0, 0.0, 1, -30.0, 30.0],
        [1978, 1982, 0.000268375, 0.00113383, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1982, 1784, 0.00864812, 0.0316744, 0.00356933, 187.19, 187.19, 187.19, 0.0, 0.0, 1, -30.0, 30.0],
        [1983, 1985, 0.000222422, 0.00103327, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1984, 1739, 0.00688222, 0.0309792, 0.00276842, 132.93, 132.93, 132.93, 0.0, 0.0, 1, -30.0, 30.0],
        [1985, 1974, 0.000581262, 0.0076133, 0.105103, 1131.7, 1131.7, 1131.7, 0.0, 0.0, 1, -30.0, 30.0],
        [1986, 1989, 0.000233086, 0.00113188, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1990, 1998, 0.000278169, 0.00111135, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [1991, 1784, 0.00481778, 0.0221413, 0.0036899, 156.3, 156.3, 156.3, 0.0, 0.0, 1, -30.0, 30.0],
        [1999, 2000, 0.000251475, 0.00105905, 0.0, 99999.0, 99999.0, 99999.0, 0.0, 0.0, 1, -30.0, 30.0],
        [2000, 1744, 0.00504988, 0.0144182, 0.00285928, 129.41, 129.41, 129.41, 0.0, 0.0, 1, -30.0, 30.0],
        [2, 1, 0.00379915, 0.12297, 0.0, 104.56, 104.56, 104.56, 1.0, 0.0, 1, -30.0, 30.0],
        [2, 1, 0.00379915, 0.12297, 0.0, 104.56, 104.56, 104.56, 1.0, 0.0, 1, -30.0, 30.0],
        [2, 1, 0.00379915, 0.12297, 0.0, 104.56, 104.56, 104.56, 1.0, 0.0, 1, -30.0, 30.0],
        [2, 1, 0.00379915, 0.12297, 0.0, 104.56, 104.56, 104.56, 1.0, 0.0, 1, -30.0, 30.0],
        [10, 9, 0.0051037, 0.163435, 0.0, 81.36, 81.36, 81.36, 1.05, 0.0, 1, -30.0, 30.0],
        [13, 12, 0.00649409, 0.199709, 0.0, 79.71, 79.71, 79.71, 1.0, 0.0, 1, -30.0, 30.0],
        [21, 20, 0.0041332, 0.131138, 0.0, 100.51, 100.51, 100.51, 1.05, 0.0, 1, -30.0, 30.0],
        [21, 20, 0.0041332, 0.131138, 0.0, 100.51, 100.51, 100.51, 1.05, 0.0, 1, -30.0, 30.0],
        [21, 20, 0.0041332, 0.131138, 0.0, 100.51, 100.51, 100.51, 1.05, 0.0, 1, -30.0, 30.0],
        [21, 20, 0.0041332, 0.131138, 0.0, 100.51, 100.51, 100.51, 1.05, 0.0, 1, -30.0, 30.0],
        [27, 26, 0.00584162, 0.170591, 0.0, 87.83, 87.83, 87.83, 1.0, 0.0, 1, -30.0, 30.0],
        [32, 31, 0.00336202, 0.097261, 0.0, 97.97, 97.97, 97.97, 1.0, 0.0, 1, -30.0, 30.0],
        [32, 31, 0.00336202, 0.097261, 0.0, 97.97, 97.97, 97.97, 1.0, 0.0, 1, -30.0, 30.0],
        [32, 31, 0.00336202, 0.097261, 0.0, 97.97, 97.97, 97.97, 1.0, 0.0, 1, -30.0, 30.0],
        [40, 39, 0.0032416, 0.107204, 0.0, 99.32, 99.32, 99.32, 1.025, 0.0, 1, -30.0, 30.0],
        [40, 39, 0.0032416, 0.107204, 0.0, 99.32, 99.32, 99.32, 1.025, 0.0, 1, -30.0, 30.0],
        [40, 39, 0.0032416, 0.107204, 0.0, 99.32, 99.32, 99.32, 1.025, 0.0, 1, -30.0, 30.0],
        [40, 39, 0.0032416, 0.107204, 0.0, 99.32, 99.32, 99.32, 1.025, 0.0, 1, -30.0, 30.0],
        [43, 42, 0.00383765, 0.116236, 0.0, 104.07, 104.07, 104.07, 1.0, 0.0, 1, -30.0, 30.0],
        [43, 42, 0.00383765, 0.116236, 0.0, 104.07, 104.07, 104.07, 1.0, 0.0, 1, -30.0, 30.0],
        [43, 42, 0.00383765, 0.116236, 0.0, 104.07, 104.07, 104.07, 1.0, 0.0, 1, -30.0, 30.0],
        [43, 42, 0.00383765, 0.116236, 0.0, 104.07, 104.07, 104.07, 1.0, 0.0, 1, -30.0, 30.0],
        [48, 47, 0.000741161, 0.0342695, 0.0, 366.59, 366.59, 366.59, 1.05, 0.0, 1, -30.0, 30.0],
        [49, 48, 0.00658169, 0.2034, 0.0, 75.08, 75.08, 75.08, 1.025, 0.0, 1, -30.0, 30.0],
        [53, 52, 0.000612391, 0.0349963, 0.0, 479.13, 479.13, 479.13, 1.05, 0.0, 1, -30.0, 30.0],
        [56, 55, 0.00716796, 0.21145, 0.0, 92.51, 92.51, 92.51, 1.0, 0.0, 1, -30.0, 30.0],
        [56, 55, 0.00716796, 0.21145, 0.0, 92.51, 92.51, 92.51, 1.0, 0.0, 1, -30.0, 30.0],
        [56, 55, 0.00716796, 0.21145, 0.0, 92.51, 92.51, 92.51, 1.0, 0.0, 1, -30.0, 30.0],
        [64, 63, 0.00344598, 0.0826713, 0.0, 67.49, 67.49, 67.49, 1.05, 0.0, 1, -30.0, 30.0],
        [68, 67, 0.00473999, 0.135563, 0.0, 79.87, 79.87, 79.87, 1.05, 0.0, 1, -30.0, 30.0],
        [72, 71, 0.00199206, 0.0627109, 0.0, 84.85, 84.85, 84.85, 1.025, 0.0, 1, -30.0, 30.0],
        [72, 71, 0.00199206, 0.0627109, 0.0, 84.85, 84.85, 84.85, 1.025, 0.0, 1, -30.0, 30.0],
        [72, 71, 0.00199206, 0.0627109, 0.0, 84.85, 84.85, 84.85, 1.025, 0.0, 1, -30.0, 30.0],
        [77, 76, 0.00371906, 0.106616, 0.0, 52.55, 52.55, 52.55, 1.0, 0.0, 1, -30.0, 30.0],
        [80, 79, 0.00426616, 0.129905, 0.0, 56.17, 56.17, 56.17, 1.025, 0.0, 1, -30.0, 30.0],
        [87, 86, 0.00401093, 0.122031, 0.0, 96.01, 96.01, 96.01, 1.05, 0.0, 1, -30.0, 30.0],
        [87, 86, 0.00401093, 0.122031, 0.0, 96.01, 96.01, 96.01, 1.05, 0.0, 1, -30.0, 30.0],
        [87, 86, 0.00401093, 0.122031, 0.0, 96.01, 96.01, 96.01, 1.05, 0.0, 1, -30.0, 30.0],
        [90, 89, 0.00364176, 0.117634, 0.0, 103.91, 103.91, 103.91, 1.0, 0.0, 1, -30.0, 30.0],
        [90, 89, 0.00364176, 0.117634, 0.0, 103.91, 103.91, 103.91, 1.0, 0.0, 1, -30.0, 30.0],
        [90, 89, 0.00364176, 0.117634, 0.0, 103.91, 103.91, 103.91, 1.0, 0.0, 1, -30.0, 30.0],
        [90, 89, 0.00364176, 0.117634, 0.0, 103.91, 103.91, 103.91, 1.0, 0.0, 1, -30.0, 30.0],
        [97, 96, 0.000367816, 0.0250303, 0.0, 563.84, 563.84, 563.84, 1.025, 0.0, 1, -30.0, 30.0],
        [97, 96, 0.000367816, 0.0250303, 0.0, 563.84, 563.84, 563.84, 1.025, 0.0, 1, -30.0, 30.0],
        [97, 96, 0.000367816, 0.0250303, 0.0, 563.84, 563.84, 563.84, 1.025, 0.0, 1, -30.0, 30.0],
        [98, 97, 0.0043109, 0.118588, 0.0, 106.49, 106.49, 106.49, 1.025, 0.0, 1, -30.0, 30.0],
        [98, 97, 0.0043109, 0.118588, 0.0, 106.49, 106.49, 106.49, 1.025, 0.0, 1, -30.0, 30.0],
        [98, 97, 0.0043109, 0.118588, 0.0, 106.49, 106.49, 106.49, 1.025, 0.0, 1, -30.0, 30.0],
        [98, 97, 0.0043109, 0.118588, 0.0, 106.49, 106.49, 106.49, 1.025, 0.0, 1, -30.0, 30.0],
        [98, 97, 0.0043109, 0.118588, 0.0, 106.49, 106.49, 106.49, 1.025, 0.0, 1, -30.0, 30.0],
        [101, 100, 0.00608926, 0.173075, 0.0, 74.48, 74.48, 74.48, 1.025, 0.0, 1, -30.0, 30.0],
        [106, 105, 0.00035521, 0.0221753, 0.0, 657.08, 657.08, 657.08, 1.0, 0.0, 1, -30.0, 30.0],
        [106, 105, 0.00035521, 0.0221753, 0.0, 657.08, 657.08, 657.08, 1.0, 0.0, 1, -30.0, 30.0],
        [106, 105, 0.00035521, 0.0221753, 0.0, 657.08, 657.08, 657.08, 1.0, 0.0, 1, -30.0, 30.0],
        [106, 105, 0.00035521, 0.0221753, 0.0, 657.08, 657.08, 657.08, 1.0, 0.0, 1, -30.0, 30.0],
        [107, 106, 0.00571663, 0.175469, 0.0, 93.09, 93.09, 93.09, 1.0, 0.0, 1, -30.0, 30.0],
        [107, 106, 0.00571663, 0.175469, 0.0, 93.09, 93.09, 93.09, 1.0, 0.0, 1, -30.0, 30.0],
        [107, 106, 0.00571663, 0.175469, 0.0, 93.09, 93.09, 93.09, 1.0, 0.0, 1, -30.0, 30.0],
        [111, 110, 0.00744712, 0.181268, 0.0, 59.69, 59.69, 59.69, 1.0, 0.0, 1, -30.0, 30.0],
        [122, 121, 0.00383106, 0.116111, 0.0, 64.03, 64.03, 64.03, 1.0, 0.0, 1, -30.0, 30.0],
        [125, 124, 0.00324687, 0.113445, 0.0, 84.03, 84.03, 84.03, 1.0, 0.0, 1, -30.0, 30.0],
        [133, 132, 0.00370939, 0.121073, 0.0, 91.49, 91.49, 91.49, 1.0, 0.0, 1, -30.0, 30.0],
        [133, 132, 0.00370939, 0.121073, 0.0, 91.49, 91.49, 91.49, 1.0, 0.0, 1, -30.0, 30.0],
        [133, 132, 0.00370939, 0.121073, 0.0, 91.49, 91.49, 91.49, 1.0, 0.0, 1, -30.0, 30.0],
        [136, 135, 0.00258486, 0.0763037, 0.0, 105.06, 105.06, 105.06, 1.05, 0.0, 1, -30.0, 30.0],
        [136, 135, 0.00258486, 0.0763037, 0.0, 105.06, 105.06, 105.06, 1.05, 0.0, 1, -30.0, 30.0],
        [136, 135, 0.00258486, 0.0763037, 0.0, 105.06, 105.06, 105.06, 1.05, 0.0, 1, -30.0, 30.0],
        [136, 135, 0.00258486, 0.0763037, 0.0, 105.06, 105.06, 105.06, 1.05, 0.0, 1, -30.0, 30.0],
        [140, 139, 0.00446464, 0.161135, 0.0, 113.96, 113.96, 113.96, 1.05, 0.0, 1, -30.0, 30.0],
        [143, 142, 0.0030816, 0.103129, 0.0, 75.63, 75.63, 75.63, 1.0, 0.0, 1, -30.0, 30.0],
        [148, 147, 0.00501266, 0.135225, 0.0, 74.45, 74.45, 74.45, 1.05, 0.0, 1, -30.0, 30.0],
        [152, 151, 0.00273447, 0.0840047, 0.0, 105.12, 105.12, 105.12, 1.05, 0.0, 1, -30.0, 30.0],
        [152, 151, 0.00273447, 0.0840047, 0.0, 105.12, 105.12, 105.12, 1.05, 0.0, 1, -30.0, 30.0],
        [152, 151, 0.00273447, 0.0840047, 0.0, 105.12, 105.12, 105.12, 1.05, 0.0, 1, -30.0, 30.0],
        [152, 151, 0.00273447, 0.0840047, 0.0, 105.12, 105.12, 105.12, 1.05, 0.0, 1, -30.0, 30.0],
        [160, 159, 0.000263425, 0.0163694, 0.0, 549.14, 549.14, 549.14, 1.0, 0.0, 1, -30.0, 30.0],
        [160, 159, 0.000263425, 0.0163694, 0.0, 549.14, 549.14, 549.14, 1.0, 0.0, 1, -30.0, 30.0],
        [160, 159, 0.000263425, 0.0163694, 0.0, 549.14, 549.14, 549.14, 1.0, 0.0, 1, -30.0, 30.0],
        [161, 160, 0.00448106, 0.13314, 0.0, 108.3, 108.3, 108.3, 1.0, 0.0, 1, -30.0, 30.0],
        [161, 160, 0.00448106, 0.13314, 0.0, 108.3, 108.3, 108.3, 1.0, 0.0, 1, -30.0, 30.0],
        [161, 160, 0.00448106, 0.13314, 0.0, 108.3, 108.3, 108.3, 1.0, 0.0, 1, -30.0, 30.0],
        [161, 160, 0.00448106, 0.13314, 0.0, 108.3, 108.3, 108.3, 1.0, 0.0, 1, -30.0, 30.0],
        [161, 160, 0.00448106, 0.13314, 0.0, 108.3, 108.3, 108.3, 1.0, 0.0, 1, -30.0, 30.0],
        [166, 165, 0.00609527, 0.174406, 0.0, 73.82, 73.82, 73.82, 1.05, 0.0, 1, -30.0, 30.0],
        [171, 170, 0.00611101, 0.178836, 0.0, 71.72, 71.72, 71.72, 1.05, 0.0, 1, -30.0, 30.0],
        [175, 174, 0.00487682, 0.129506, 0.0, 91.89, 91.89, 91.89, 1.05, 0.0, 1, -30.0, 30.0],
        [175, 174, 0.00487682, 0.129506, 0.0, 91.89, 91.89, 91.89, 1.05, 0.0, 1, -30.0, 30.0],
        [175, 174, 0.00487682, 0.129506, 0.0, 91.89, 91.89, 91.89, 1.05, 0.0, 1, -30.0, 30.0],
        [182, 181, 0.00632886, 0.157984, 0.0, 78.52, 78.52, 78.52, 1.05, 0.0, 1, -30.0, 30.0],
        [189, 188, 0.00352198, 0.0879053, 0.0, 96.74, 96.74, 96.74, 1.025, 0.0, 1, -30.0, 30.0],
        [189, 188, 0.00352198, 0.0879053, 0.0, 96.74, 96.74, 96.74, 1.025, 0.0, 1, -30.0, 30.0],
        [189, 188, 0.00352198, 0.0879053, 0.0, 96.74, 96.74, 96.74, 1.025, 0.0, 1, -30.0, 30.0],
        [192, 191, 0.003162, 0.0847761, 0.0, 112.18, 112.18, 112.18, 1.05, 0.0, 1, -30.0, 30.0],
        [192, 191, 0.003162, 0.0847761, 0.0, 112.18, 112.18, 112.18, 1.05, 0.0, 1, -30.0, 30.0],
        [192, 191, 0.003162, 0.0847761, 0.0, 112.18, 112.18, 112.18, 1.05, 0.0, 1, -30.0, 30.0],
        [192, 191, 0.003162, 0.0847761, 0.0, 112.18, 112.18, 112.18, 1.05, 0.0, 1, -30.0, 30.0],
        [192, 191, 0.003162, 0.0847761, 0.0, 112.18, 112.18, 112.18, 1.05, 0.0, 1, -30.0, 30.0],
        [195, 194, 0.00488653, 0.100254, 0.0, 98.77, 98.77, 98.77, 1.05, 0.0, 1, -30.0, 30.0],
        [195, 194, 0.00488653, 0.100254, 0.0, 98.77, 98.77, 98.77, 1.05, 0.0, 1, -30.0, 30.0],
        [195, 194, 0.00488653, 0.100254, 0.0, 98.77, 98.77, 98.77, 1.05, 0.0, 1, -30.0, 30.0],
        [195, 194, 0.00488653, 0.100254, 0.0, 98.77, 98.77, 98.77, 1.05, 0.0, 1, -30.0, 30.0],
        [203, 202, 0.000474719, 0.0287575, 0.0, 462.59, 462.59, 462.59, 1.0, 0.0, 1, -30.0, 30.0],
        [204, 203, 0.00620702, 0.173902, 0.0, 92.82, 92.82, 92.82, 1.0, 0.0, 1, -30.0, 30.0],
        [204, 203, 0.00620702, 0.173902, 0.0, 92.82, 92.82, 92.82, 1.0, 0.0, 1, -30.0, 30.0],
        [204, 203, 0.00620702, 0.173902, 0.0, 92.82, 92.82, 92.82, 1.0, 0.0, 1, -30.0, 30.0],
        [208, 207, 0.000485934, 0.0335187, 0.0, 547.19, 547.19, 547.19, 1.0, 0.0, 1, -30.0, 30.0],
        [208, 207, 0.000485934, 0.0335187, 0.0, 547.19, 547.19, 547.19, 1.0, 0.0, 1, -30.0, 30.0],
        [208, 207, 0.000485934, 0.0335187, 0.0, 547.19, 547.19, 547.19, 1.0, 0.0, 1, -30.0, 30.0],
        [209, 208, 0.00547522, 0.168939, 0.0, 103.76, 103.76, 103.76, 1.0, 0.0, 1, -30.0, 30.0],
        [209, 208, 0.00547522, 0.168939, 0.0, 103.76, 103.76, 103.76, 1.0, 0.0, 1, -30.0, 30.0],
        [209, 208, 0.00547522, 0.168939, 0.0, 103.76, 103.76, 103.76, 1.0, 0.0, 1, -30.0, 30.0],
        [209, 208, 0.00547522, 0.168939, 0.0, 103.76, 103.76, 103.76, 1.0, 0.0, 1, -30.0, 30.0],
        [212, 211, 0.00590415, 0.182112, 0.0, 76.05, 76.05, 76.05, 1.05, 0.0, 1, -30.0, 30.0],
        [216, 215, 0.00439306, 0.147597, 0.0, 80.28, 80.28, 80.28, 1.0, 0.0, 1, -30.0, 30.0],
        [223, 222, 0.00329633, 0.092158, 0.0, 108.93, 108.93, 108.93, 1.025, 0.0, 1, -30.0, 30.0],
        [223, 222, 0.00329633, 0.092158, 0.0, 108.93, 108.93, 108.93, 1.025, 0.0, 1, -30.0, 30.0],
        [223, 222, 0.00329633, 0.092158, 0.0, 108.93, 108.93, 108.93, 1.025, 0.0, 1, -30.0, 30.0],
        [223, 222, 0.00329633, 0.092158, 0.0, 108.93, 108.93, 108.93, 1.025, 0.0, 1, -30.0, 30.0],
        [223, 222, 0.00329633, 0.092158, 0.0, 108.93, 108.93, 108.93, 1.025, 0.0, 1, -30.0, 30.0],
        [229, 228, 0.007146, 0.192894, 0.0, 86.33, 86.33, 86.33, 1.05, 0.0, 1, -30.0, 30.0],
        [229, 228, 0.007146, 0.192894, 0.0, 86.33, 86.33, 86.33, 1.05, 0.0, 1, -30.0, 30.0],
        [229, 228, 0.007146, 0.192894, 0.0, 86.33, 86.33, 86.33, 1.05, 0.0, 1, -30.0, 30.0],
        [232, 231, 0.000431856, 0.0273372, 0.0, 532.26, 532.26, 532.26, 1.05, 0.0, 1, -30.0, 30.0],
        [232, 231, 0.000431856, 0.0273372, 0.0, 532.26, 532.26, 532.26, 1.05, 0.0, 1, -30.0, 30.0],
        [232, 231, 0.000431856, 0.0273372, 0.0, 532.26, 532.26, 532.26, 1.05, 0.0, 1, -30.0, 30.0],
        [233, 232, 0.00758432, 0.209341, 0.0, 86.5, 86.5, 86.5, 1.025, 0.0, 1, -30.0, 30.0],
        [233, 232, 0.00758432, 0.209341, 0.0, 86.5, 86.5, 86.5, 1.025, 0.0, 1, -30.0, 30.0],
        [233, 232, 0.00758432, 0.209341, 0.0, 86.5, 86.5, 86.5, 1.025, 0.0, 1, -30.0, 30.0],
        [236, 235, 0.00641065, 0.165008, 0.0, 82.37, 82.37, 82.37, 1.025, 0.0, 1, -30.0, 30.0],
        [236, 235, 0.00641065, 0.165008, 0.0, 82.37, 82.37, 82.37, 1.025, 0.0, 1, -30.0, 30.0],
        [241, 240, 0.00611709, 0.213585, 0.0, 68.58, 68.58, 68.58, 1.05, 0.0, 1, -30.0, 30.0],
        [244, 243, 0.00512975, 0.148551, 0.0, 87.16, 87.16, 87.16, 1.0, 0.0, 1, -30.0, 30.0],
        [244, 243, 0.00512975, 0.148551, 0.0, 87.16, 87.16, 87.16, 1.0, 0.0, 1, -30.0, 30.0],
        [244, 243, 0.00512975, 0.148551, 0.0, 87.16, 87.16, 87.16, 1.0, 0.0, 1, -30.0, 30.0],
        [249, 248, 0.00341943, 0.105492, 0.0, 104.41, 104.41, 104.41, 1.025, 0.0, 1, -30.0, 30.0],
        [249, 248, 0.00341943, 0.105492, 0.0, 104.41, 104.41, 104.41, 1.025, 0.0, 1, -30.0, 30.0],
        [249, 248, 0.00341943, 0.105492, 0.0, 104.41, 104.41, 104.41, 1.025, 0.0, 1, -30.0, 30.0],
        [249, 248, 0.00341943, 0.105492, 0.0, 104.41, 104.41, 104.41, 1.025, 0.0, 1, -30.0, 30.0],
        [252, 251, 0.00592868, 0.142904, 0.0, 75.18, 75.18, 75.18, 1.025, 0.0, 1, -30.0, 30.0],
        [255, 254, 0.00757038, 0.189759, 0.0, 71.45, 71.45, 71.45, 1.05, 0.0, 1, -30.0, 30.0],
        [258, 257, 0.00036117, 0.0243541, 0.0, 577.32, 577.32, 577.32, 1.05, 0.0, 1, -30.0, 30.0],
        [258, 257, 0.00036117, 0.0243541, 0.0, 577.32, 577.32, 577.32, 1.05, 0.0, 1, -30.0, 30.0],
        [258, 257, 0.00036117, 0.0243541, 0.0, 577.32, 577.32, 577.32, 1.05, 0.0, 1, -30.0, 30.0],
        [262, 261, 0.00623036, 0.21371, 0.0, 99.93, 99.93, 99.93, 1.05, 0.0, 1, -30.0, 30.0],
        [265, 264, 0.00304772, 0.083645, 0.0, 115.46, 115.46, 115.46, 1.025, 0.0, 1, -30.0, 30.0],
        [265, 264, 0.00304772, 0.083645, 0.0, 115.46, 115.46, 115.46, 1.025, 0.0, 1, -30.0, 30.0],
        [265, 264, 0.00304772, 0.083645, 0.0, 115.46, 115.46, 115.46, 1.025, 0.0, 1, -30.0, 30.0],
        [265, 264, 0.00304772, 0.083645, 0.0, 115.46, 115.46, 115.46, 1.025, 0.0, 1, -30.0, 30.0],
        [265, 264, 0.00304772, 0.083645, 0.0, 115.46, 115.46, 115.46, 1.025, 0.0, 1, -30.0, 30.0],
        [269, 268, 0.00510747, 0.163635, 0.0, 95.27, 95.27, 95.27, 1.0, 0.0, 1, -30.0, 30.0],
        [269, 268, 0.00510747, 0.163635, 0.0, 95.27, 95.27, 95.27, 1.0, 0.0, 1, -30.0, 30.0],
        [269, 268, 0.00510747, 0.163635, 0.0, 95.27, 95.27, 95.27, 1.0, 0.0, 1, -30.0, 30.0],
        [273, 272, 0.00472453, 0.168223, 0.0, 87.54, 87.54, 87.54, 1.05, 0.0, 1, -30.0, 30.0],
        [273, 272, 0.00472453, 0.168223, 0.0, 87.54, 87.54, 87.54, 1.05, 0.0, 1, -30.0, 30.0],
        [273, 272, 0.00472453, 0.168223, 0.0, 87.54, 87.54, 87.54, 1.05, 0.0, 1, -30.0, 30.0],
        [279, 278, 0.000279557, 0.0209921, 0.0, 541.62, 541.62, 541.62, 1.0, 0.0, 1, -30.0, 30.0],
        [279, 278, 0.000279557, 0.0209921, 0.0, 541.62, 541.62, 541.62, 1.0, 0.0, 1, -30.0, 30.0],
        [279, 278, 0.000279557, 0.0209921, 0.0, 541.62, 541.62, 541.62, 1.0, 0.0, 1, -30.0, 30.0],
        [280, 279, 0.0061476, 0.212034, 0.0, 88.56, 88.56, 88.56, 1.0, 0.0, 1, -30.0, 30.0],
        [280, 279, 0.0061476, 0.212034, 0.0, 88.56, 88.56, 88.56, 1.0, 0.0, 1, -30.0, 30.0],
        [280, 279, 0.0061476, 0.212034, 0.0, 88.56, 88.56, 88.56, 1.0, 0.0, 1, -30.0, 30.0],
        [290, 289, 0.00493721, 0.145289, 0.0, 86.21, 86.21, 86.21, 1.05, 0.0, 1, -30.0, 30.0],
        [290, 289, 0.00493721, 0.145289, 0.0, 86.21, 86.21, 86.21, 1.05, 0.0, 1, -30.0, 30.0],
        [290, 289, 0.00493721, 0.145289, 0.0, 86.21, 86.21, 86.21, 1.05, 0.0, 1, -30.0, 30.0],
        [293, 292, 0.00486311, 0.177245, 0.0, 73.46, 73.46, 73.46, 1.0, 0.0, 1, -30.0, 30.0],
        [297, 296, 0.00804152, 0.210577, 0.0, 87.22, 87.22, 87.22, 1.025, 0.0, 1, -30.0, 30.0],
        [297, 296, 0.00804152, 0.210577, 0.0, 87.22, 87.22, 87.22, 1.025, 0.0, 1, -30.0, 30.0],
        [297, 296, 0.00804152, 0.210577, 0.0, 87.22, 87.22, 87.22, 1.025, 0.0, 1, -30.0, 30.0],
        [305, 304, 0.00423138, 0.123212, 0.0, 96.15, 96.15, 96.15, 1.0, 0.0, 1, -30.0, 30.0],
        [305, 304, 0.00423138, 0.123212, 0.0, 96.15, 96.15, 96.15, 1.0, 0.0, 1, -30.0, 30.0],
        [305, 304, 0.00423138, 0.123212, 0.0, 96.15, 96.15, 96.15, 1.0, 0.0, 1, -30.0, 30.0],
        [310, 309, 0.00397496, 0.147482, 0.0, 92.78, 92.78, 92.78, 1.01875, 0.0, 1, -30.0, 30.0],
        [310, 309, 0.00397496, 0.147482, 0.0, 92.78, 92.78, 92.78, 1.01875, 0.0, 1, -30.0, 30.0],
        [310, 309, 0.00397496, 0.147482, 0.0, 92.78, 92.78, 92.78, 1.01875, 0.0, 1, -30.0, 30.0],
        [313, 312, 0.000374628, 0.0206814, 0.0, 621.25, 621.25, 621.25, 1.025, 0.0, 1, -30.0, 30.0],
        [313, 312, 0.000374628, 0.0206814, 0.0, 621.25, 621.25, 621.25, 1.025, 0.0, 1, -30.0, 30.0],
        [313, 312, 0.000374628, 0.0206814, 0.0, 621.25, 621.25, 621.25, 1.025, 0.0, 1, -30.0, 30.0],
        [314, 313, 0.00477271, 0.172569, 0.0, 97.95, 97.95, 97.95, 1.025, 0.0, 1, -30.0, 30.0],
        [314, 313, 0.00477271, 0.172569, 0.0, 97.95, 97.95, 97.95, 1.025, 0.0, 1, -30.0, 30.0],
        [314, 313, 0.00477271, 0.172569, 0.0, 97.95, 97.95, 97.95, 1.025, 0.0, 1, -30.0, 30.0],
        [317, 316, 0.000566901, 0.0324313, 0.0, 664.12, 664.12, 664.12, 1.05, 0.0, 1, -30.0, 30.0],
        [318, 317, 0.0031191, 0.0904938, 0.0, 103.52, 103.52, 103.52, 1.025, 0.0, 1, -30.0, 30.0],
        [318, 317, 0.0031191, 0.0904938, 0.0, 103.52, 103.52, 103.52, 1.025, 0.0, 1, -30.0, 30.0],
        [318, 317, 0.0031191, 0.0904938, 0.0, 103.52, 103.52, 103.52, 1.025, 0.0, 1, -30.0, 30.0],
        [318, 317, 0.0031191, 0.0904938, 0.0, 103.52, 103.52, 103.52, 1.025, 0.0, 1, -30.0, 30.0],
        [323, 322, 0.00368513, 0.123531, 0.0, 100.62, 100.62, 100.62, 1.025, 0.0, 1, -30.0, 30.0],
        [323, 322, 0.00368513, 0.123531, 0.0, 100.62, 100.62, 100.62, 1.025, 0.0, 1, -30.0, 30.0],
        [323, 322, 0.00368513, 0.123531, 0.0, 100.62, 100.62, 100.62, 1.025, 0.0, 1, -30.0, 30.0],
        [323, 322, 0.00368513, 0.123531, 0.0, 100.62, 100.62, 100.62, 1.025, 0.0, 1, -30.0, 30.0],
        [326, 325, 0.00535935, 0.171121, 0.0, 86.58, 86.58, 86.58, 1.025, 0.0, 1, -30.0, 30.0],
        [332, 331, 0.00336876, 0.122159, 0.0, 100.78, 100.78, 100.78, 1.0, 0.0, 1, -30.0, 30.0],
        [332, 331, 0.00336876, 0.122159, 0.0, 100.78, 100.78, 100.78, 1.0, 0.0, 1, -30.0, 30.0],
        [332, 331, 0.00336876, 0.122159, 0.0, 100.78, 100.78, 100.78, 1.0, 0.0, 1, -30.0, 30.0],
        [332, 331, 0.00336876, 0.122159, 0.0, 100.78, 100.78, 100.78, 1.0, 0.0, 1, -30.0, 30.0],
        [335, 334, 0.00547414, 0.182328, 0.0, 77.97, 77.97, 77.97, 1.05, 0.0, 1, -30.0, 30.0],
        [338, 337, 0.000520683, 0.0308017, 0.0, 533.07, 533.07, 533.07, 1.0, 0.0, 1, -30.0, 30.0],
        [343, 342, 0.00409104, 0.134256, 0.0, 87.29, 87.29, 87.29, 1.0, 0.0, 1, -30.0, 30.0],
        [343, 342, 0.00409104, 0.134256, 0.0, 87.29, 87.29, 87.29, 1.0, 0.0, 1, -30.0, 30.0],
        [343, 342, 0.00409104, 0.134256, 0.0, 87.29, 87.29, 87.29, 1.0, 0.0, 1, -30.0, 30.0],
        [349, 348, 0.00532781, 0.175477, 0.0, 72.23, 72.23, 72.23, 1.05, 0.0, 1, -30.0, 30.0],
        [362, 361, 0.00658926, 0.216386, 0.0, 81.65, 81.65, 81.65, 1.0, 0.0, 1, -30.0, 30.0],
        [362, 361, 0.00658926, 0.216386, 0.0, 81.65, 81.65, 81.65, 1.0, 0.0, 1, -30.0, 30.0],
        [364, 363, 0.00579857, 0.166774, 0.0, 94.42, 94.42, 94.42, 1.0, 0.0, 1, -30.0, 30.0],
        [364, 363, 0.00579857, 0.166774, 0.0, 94.42, 94.42, 94.42, 1.0, 0.0, 1, -30.0, 30.0],
        [364, 363, 0.00579857, 0.166774, 0.0, 94.42, 94.42, 94.42, 1.0, 0.0, 1, -30.0, 30.0],
        [368, 367, 0.000589989, 0.0336359, 0.0, 381.59, 381.59, 381.59, 1.01875, 0.0, 1, -30.0, 30.0],
        [371, 370, 0.00387152, 0.130503, 0.0, 87.48, 87.48, 87.48, 1.05, 0.0, 1, -30.0, 30.0],
        [383, 382, 0.00618558, 0.180353, 0.0, 72.94, 72.94, 72.94, 1.05, 0.0, 1, -30.0, 30.0],
        [387, 386, 0.00641241, 0.169875, 0.0, 69.9, 69.9, 69.9, 1.025, 0.0, 1, -30.0, 30.0],
        [396, 395, 0.000558024, 0.034469, 0.0, 327.99, 327.99, 327.99, 1.05, 0.0, 1, -30.0, 30.0],
        [400, 399, 0.000608468, 0.0296615, 0.0, 454.77, 454.77, 454.77, 1.025, 0.0, 1, -30.0, 30.0],
        [401, 400, 0.00484638, 0.144146, 0.0, 95.26, 95.26, 95.26, 1.025, 0.0, 1, -30.0, 30.0],
        [407, 406, 0.00753481, 0.211132, 0.0, 84.95, 84.95, 84.95, 1.025, 0.0, 1, -30.0, 30.0],
        [407, 406, 0.00753481, 0.211132, 0.0, 84.95, 84.95, 84.95, 1.025, 0.0, 1, -30.0, 30.0],
        [407, 406, 0.00753481, 0.211132, 0.0, 84.95, 84.95, 84.95, 1.025, 0.0, 1, -30.0, 30.0],
        [419, 418, 0.00391964, 0.121463, 0.0, 65.0, 65.0, 65.0, 1.0, 0.0, 1, -30.0, 30.0],
        [423, 422, 0.00415045, 0.136472, 0.0, 86.35, 86.35, 86.35, 1.025, 0.0, 1, -30.0, 30.0],
        [423, 422, 0.00415045, 0.136472, 0.0, 86.35, 86.35, 86.35, 1.025, 0.0, 1, -30.0, 30.0],
        [423, 422, 0.00415045, 0.136472, 0.0, 86.35, 86.35, 86.35, 1.025, 0.0, 1, -30.0, 30.0],
        [425, 424, 0.000422694, 0.0251061, 0.0, 385.66, 385.66, 385.66, 1.0125, 0.0, 1, -30.0, 30.0],
        [426, 425, 0.00379778, 0.125358, 0.0, 82.98, 82.98, 82.98, 1.0125, 0.0, 1, -30.0, 30.0],
        [426, 425, 0.00379778, 0.125358, 0.0, 82.98, 82.98, 82.98, 1.0125, 0.0, 1, -30.0, 30.0],
        [426, 425, 0.00379778, 0.125358, 0.0, 82.98, 82.98, 82.98, 1.0125, 0.0, 1, -30.0, 30.0],
        [429, 428, 0.00556216, 0.163857, 0.0, 68.51, 68.51, 68.51, 1.0, 0.0, 1, -30.0, 30.0],
        [432, 431, 0.000218409, 0.0116713, 0.0, 398.73, 398.73, 398.73, 1.0125, 0.0, 1, -30.0, 30.0],
        [436, 435, 0.000372743, 0.0230773, 0.0, 550.0, 550.0, 550.0, 1.025, 0.0, 1, -30.0, 30.0],
        [440, 439, 0.00541207, 0.154658, 0.0, 67.3, 67.3, 67.3, 1.025, 0.0, 1, -30.0, 30.0],
        [442, 441, 0.005748, 0.179259, 0.0, 86.17, 86.17, 86.17, 0.95, 0.0, 1, -30.0, 30.0],
        [442, 441, 0.005748, 0.179259, 0.0, 86.17, 86.17, 86.17, 0.95, 0.0, 1, -30.0, 30.0],
        [442, 441, 0.005748, 0.179259, 0.0, 86.17, 86.17, 86.17, 0.95, 0.0, 1, -30.0, 30.0],
        [448, 447, 0.00630533, 0.164397, 0.0, 89.21, 89.21, 89.21, 1.05, 0.0, 1, -30.0, 30.0],
        [453, 452, 0.00763568, 0.232242, 0.0, 80.02, 80.02, 80.02, 1.025, 0.0, 1, -30.0, 30.0],
        [457, 456, 0.00258531, 0.0996783, 0.0, 83.63, 83.63, 83.63, 1.025, 0.0, 1, -30.0, 30.0],
        [457, 456, 0.00258531, 0.0996783, 0.0, 83.63, 83.63, 83.63, 1.025, 0.0, 1, -30.0, 30.0],
        [457, 456, 0.00258531, 0.0996783, 0.0, 83.63, 83.63, 83.63, 1.025, 0.0, 1, -30.0, 30.0],
        [461, 460, 0.000291759, 0.0211319, 0.0, 430.07, 430.07, 430.07, 1.025, 0.0, 1, -30.0, 30.0],
        [462, 461, 0.00467071, 0.160266, 0.0, 87.96, 87.96, 87.96, 1.025, 0.0, 1, -30.0, 30.0],
        [462, 461, 0.00467071, 0.160266, 0.0, 87.96, 87.96, 87.96, 1.025, 0.0, 1, -30.0, 30.0],
        [462, 461, 0.00467071, 0.160266, 0.0, 87.96, 87.96, 87.96, 1.025, 0.0, 1, -30.0, 30.0],
        [467, 466, 0.00329932, 0.108119, 0.0, 82.88, 82.88, 82.88, 1.025, 0.0, 1, -30.0, 30.0],
        [467, 466, 0.00329932, 0.108119, 0.0, 82.88, 82.88, 82.88, 1.025, 0.0, 1, -30.0, 30.0],
        [467, 466, 0.00329932, 0.108119, 0.0, 82.88, 82.88, 82.88, 1.025, 0.0, 1, -30.0, 30.0],
        [475, 474, 0.000368674, 0.0179581, 0.0, 374.93, 374.93, 374.93, 1.025, 0.0, 1, -30.0, 30.0],
        [479, 478, 0.00453972, 0.126716, 0.0, 89.62, 89.62, 89.62, 1.0, 0.0, 1, -30.0, 30.0],
        [479, 478, 0.00453972, 0.126716, 0.0, 89.62, 89.62, 89.62, 1.0, 0.0, 1, -30.0, 30.0],
        [479, 478, 0.00453972, 0.126716, 0.0, 89.62, 89.62, 89.62, 1.0, 0.0, 1, -30.0, 30.0],
        [482, 481, 0.000218582, 0.0139091, 0.0, 396.66, 396.66, 396.66, 1.0, 0.0, 1, -30.0, 30.0],
        [483, 482, 0.00501157, 0.162453, 0.0, 77.26, 77.26, 77.26, 1.0, 0.0, 1, -30.0, 30.0],
        [488, 487, 0.00492906, 0.147588, 0.0, 88.37, 88.37, 88.37, 1.05, 0.0, 1, -30.0, 30.0],
        [488, 487, 0.00492906, 0.147588, 0.0, 88.37, 88.37, 88.37, 1.05, 0.0, 1, -30.0, 30.0],
        [488, 487, 0.00492906, 0.147588, 0.0, 88.37, 88.37, 88.37, 1.05, 0.0, 1, -30.0, 30.0],
        [494, 493, 0.000408465, 0.0230082, 0.0, 441.77, 441.77, 441.77, 1.0, 0.0, 1, -30.0, 30.0],
        [497, 496, 0.006773, 0.247424, 0.0, 75.82, 75.82, 75.82, 0.95, 0.0, 1, -30.0, 30.0],
        [500, 499, 0.000439526, 0.0263675, 0.0, 505.14, 505.14, 505.14, 1.00625, 0.0, 1, -30.0, 30.0],
        [500, 499, 0.000439526, 0.0263675, 0.0, 505.14, 505.14, 505.14, 1.00625, 0.0, 1, -30.0, 30.0],
        [500, 499, 0.000439526, 0.0263675, 0.0, 505.14, 505.14, 505.14, 1.00625, 0.0, 1, -30.0, 30.0],
        [508, 511, 0.000793027, 0.044555, 0.0, 434.69, 434.69, 434.69, 1.03125, 0.0, 1, -30.0, 30.0],
        [508, 512, 0.000501236, 0.0234684, 0.0, 432.53, 432.53, 432.53, 1.03125, 0.0, 1, -30.0, 30.0],
        [508, 513, 0.000391732, 0.0252422, 0.0, 430.46, 430.46, 430.46, 1.03125, 0.0, 1, -30.0, 30.0],
        [508, 514, 0.000413143, 0.0260406, 0.0, 430.03, 430.03, 430.03, 1.03125, 0.0, 1, -30.0, 30.0],
        [508, 515, 0.000363254, 0.0225924, 0.0, 428.72, 428.72, 428.72, 1.03125, 0.0, 1, -30.0, 30.0],
        [508, 516, 0.00084623, 0.0425764, 0.0, 427.14, 427.14, 427.14, 1.03125, 0.0, 1, -30.0, 30.0],
        [509, 508, 0.000713509, 0.036231, 0.0, 460.86, 460.86, 460.86, 1.025, 0.0, 1, -30.0, 30.0],
        [510, 509, 0.00403149, 0.144259, 0.0, 98.04, 98.04, 98.04, 1.025, 0.0, 1, -30.0, 30.0],
        [510, 509, 0.00403149, 0.144259, 0.0, 98.04, 98.04, 98.04, 1.025, 0.0, 1, -30.0, 30.0],
        [510, 509, 0.00403149, 0.144259, 0.0, 98.04, 98.04, 98.04, 1.025, 0.0, 1, -30.0, 30.0],
        [510, 509, 0.00403149, 0.144259, 0.0, 98.04, 98.04, 98.04, 1.025, 0.0, 1, -30.0, 30.0],
        [520, 522, 0.000242374, 0.0113283, 0.0, 1064.18, 1064.18, 1064.18, 1.0, 0.0, 1, -30.0, 30.0],
        [520, 523, 0.000204614, 0.0130045, 0.0, 1064.18, 1064.18, 1064.18, 1.0, 0.0, 1, -30.0, 30.0],
        [521, 520, 0.0004581, 0.0276269, 0.0, 389.02, 389.02, 389.02, 1.025, 0.0, 1, -30.0, 30.0],
        [527, 529, 0.000944315, 0.0278731, 0.0, 318.24, 318.24, 318.24, 1.0, 0.0, 1, -30.0, 30.0],
        [527, 530, 0.00206796, 0.0444986, 0.0, 318.24, 318.24, 318.24, 1.1, 0.0, 1, -30.0, 30.0],
        [527, 531, 0.000980349, 0.0315911, 0.0, 318.24, 318.24, 318.24, 1.09375, 0.0, 1, -30.0, 30.0],
        [527, 532, 0.00143178, 0.0425355, 0.0, 318.24, 318.24, 318.24, 1.1, 0.0, 1, -30.0, 30.0],
        [527, 533, 0.0016976, 0.0472972, 0.0, 318.24, 318.24, 318.24, 1.1, 0.0, 1, -30.0, 30.0],
        [528, 527, 0.00598016, 0.173981, 0.0, 87.01, 87.01, 87.01, 0.99375, 0.0, 1, -30.0, 30.0],
        [528, 527, 0.00598016, 0.173981, 0.0, 87.01, 87.01, 87.01, 0.99375, 0.0, 1, -30.0, 30.0],
        [528, 527, 0.00598016, 0.173981, 0.0, 87.01, 87.01, 87.01, 0.99375, 0.0, 1, -30.0, 30.0],
        [535, 536, 0.000549866, 0.0195539, 0.0, 522.6, 522.6, 522.6, 1.0, 0.0, 1, -30.0, 30.0],
        [535, 537, 0.000470304, 0.0154596, 0.0, 522.6, 522.6, 522.6, 1.0, 0.0, 1, -30.0, 30.0],
        [541, 542, 0.00222014, 0.0595547, 0.0, 225.85, 225.85, 225.85, 1.0625, 0.0, 1, -30.0, 30.0],
        [541, 543, 0.00125116, 0.0404651, 0.0, 225.85, 225.85, 225.85, 1.05, 0.0, 1, -30.0, 30.0],
        [541, 544, 0.00128457, 0.0415513, 0.0, 225.85, 225.85, 225.85, 1.05, 0.0, 1, -30.0, 30.0],
        [541, 545, 0.00172051, 0.0540267, 0.0, 225.85, 225.85, 225.85, 1.05625, 0.0, 1, -30.0, 30.0],
        [541, 546, 0.00108781, 0.0304733, 0.0, 225.85, 225.85, 225.85, 1.04375, 0.0, 1, -30.0, 30.0],
        [541, 547, 0.000852348, 0.0251471, 0.0, 225.85, 225.85, 225.85, 1.0375, 0.0, 1, -30.0, 30.0],
        [549, 551, 0.000123391, 0.00815117, 0.0, 1600.0, 1600.0, 1600.0, 1.0, 0.0, 1, -30.0, 30.0],
        [549, 552, 0.000124335, 0.00654867, 0.0, 1404.0, 1404.0, 1404.0, 1.0, 0.0, 1, -30.0, 30.0],
        [550, 549, 0.000725325, 0.0416935, 0.0, 405.05, 405.05, 405.05, 1.0125, 0.0, 1, -30.0, 30.0],
        [556, 558, 0.00235525, 0.0643899, 0.0, 177.84, 177.84, 177.84, 1.05625, 0.0, 1, -30.0, 30.0],
        [556, 559, 0.00134746, 0.0401504, 0.0, 177.84, 177.84, 177.84, 1.0375, 0.0, 1, -30.0, 30.0],
        [556, 560, 0.00330587, 0.0740108, 0.0, 177.84, 177.84, 177.84, 1.0625, 0.0, 1, -30.0, 30.0],
        [556, 561, 0.00211017, 0.0719344, 0.0, 177.84, 177.84, 177.84, 1.05625, 0.0, 1, -30.0, 30.0],
        [556, 562, 0.0015669, 0.0490229, 0.0, 177.84, 177.84, 177.84, 1.04375, 0.0, 1, -30.0, 30.0],
        [556, 563, 0.00328808, 0.0893608, 0.0, 177.84, 177.84, 177.84, 1.06875, 0.0, 1, -30.0, 30.0],
        [557, 556, 0.00532946, 0.137624, 0.0, 101.31, 101.31, 101.31, 1.05, 0.0, 1, -30.0, 30.0],
        [557, 556, 0.00532946, 0.137624, 0.0, 101.31, 101.31, 101.31, 1.05, 0.0, 1, -30.0, 30.0],
        [557, 556, 0.00532946, 0.137624, 0.0, 101.31, 101.31, 101.31, 1.05, 0.0, 1, -30.0, 30.0],
        [557, 556, 0.00532946, 0.137624, 0.0, 101.31, 101.31, 101.31, 1.05, 0.0, 1, -30.0, 30.0],
        [565, 567, 0.000199389, 0.0122183, 0.0, 923.65, 923.65, 923.65, 1.075, 0.0, 1, -30.0, 30.0],
        [565, 568, 0.00013803, 0.00788147, 0.0, 923.65, 923.65, 923.65, 1.0625, 0.0, 1, -30.0, 30.0],
        [565, 569, 0.000192452, 0.0126146, 0.0, 923.65, 923.65, 923.65, 1.075, 0.0, 1, -30.0, 30.0],
        [565, 570, 0.000247872, 0.0118621, 0.0, 923.65, 923.65, 923.65, 1.075, 0.0, 1, -30.0, 30.0],
        [565, 571, 0.000136819, 0.00924451, 0.0, 923.65, 923.65, 923.65, 1.0, 0.0, 1, -30.0, 30.0],
        [565, 572, 0.000149708, 0.00975562, 0.0, 923.65, 923.65, 923.65, 1.0, 0.0, 1, -30.0, 30.0],
        [566, 565, 0.000514241, 0.0253657, 0.0, 617.63, 617.63, 617.63, 1.05, 0.0, 1, -30.0, 30.0],
        [573, 574, 0.00280594, 0.0910405, 0.0, 161.2, 161.2, 161.2, 1.03125, 0.0, 1, -30.0, 30.0],
        [573, 575, 0.00304005, 0.0868273, 0.0, 161.2, 161.2, 161.2, 1.03125, 0.0, 1, -30.0, 30.0],
        [573, 576, 0.00249947, 0.0773702, 0.0, 161.2, 161.2, 161.2, 1.03125, 0.0, 1, -30.0, 30.0],
        [573, 577, 0.00202733, 0.051992, 0.0, 161.2, 161.2, 161.2, 1.03125, 0.0, 1, -30.0, 30.0],
        [573, 578, 0.00162818, 0.052609, 0.0, 161.2, 161.2, 161.2, 1.03125, 0.0, 1, -30.0, 30.0],
        [573, 579, 0.00158855, 0.0459158, 0.0, 161.2, 161.2, 161.2, 1.03125, 0.0, 1, -30.0, 30.0],
        [582, 581, 0.00506681, 0.166525, 0.0, 80.69, 80.69, 80.69, 1.0, 0.0, 1, -30.0, 30.0],
        [584, 587, 0.00111049, 0.0555738, 0.0, 350.65, 350.65, 350.65, 1.0625, 0.0, 1, -30.0, 30.0],
        [584, 588, 0.000563546, 0.0256456, 0.0, 342.22, 342.22, 342.22, 1.0375, 0.0, 1, -30.0, 30.0],
        [585, 584, 0.00037495, 0.0235948, 0.0, 484.12, 484.12, 484.12, 1.025, 0.0, 1, -30.0, 30.0],
        [586, 585, 0.00323131, 0.100155, 0.0, 111.82, 111.82, 111.82, 1.00625, 0.0, 1, -30.0, 30.0],
        [586, 585, 0.00323131, 0.100155, 0.0, 111.82, 111.82, 111.82, 1.00625, 0.0, 1, -30.0, 30.0],
        [586, 585, 0.00323131, 0.100155, 0.0, 111.82, 111.82, 111.82, 1.00625, 0.0, 1, -30.0, 30.0],
        [586, 585, 0.00323131, 0.100155, 0.0, 111.82, 111.82, 111.82, 1.00625, 0.0, 1, -30.0, 30.0],
        [592, 594, 0.000219446, 0.0161744, 0.0, 445.78, 445.78, 445.78, 1.0375, 0.0, 1, -30.0, 30.0],
        [592, 595, 0.000464557, 0.0295988, 0.0, 445.35, 445.35, 445.35, 1.0, 0.0, 1, -30.0, 30.0],
        [592, 596, 0.000375769, 0.0197958, 0.0, 444.45, 444.45, 444.45, 1.0375, 0.0, 1, -30.0, 30.0],
        [592, 597, 0.000498472, 0.0244839, 0.0, 441.03, 441.03, 441.03, 1.0375, 0.0, 1, -30.0, 30.0],
        [593, 592, 0.000470324, 0.0278701, 0.0, 511.7, 511.7, 511.7, 1.0, 0.0, 1, -30.0, 30.0],
        [593, 592, 0.000470324, 0.0278701, 0.0, 511.7, 511.7, 511.7, 1.0, 0.0, 1, -30.0, 30.0],
        [593, 592, 0.000470324, 0.0278701, 0.0, 511.7, 511.7, 511.7, 1.0, 0.0, 1, -30.0, 30.0],
        [605, 604, 0.0078066, 0.190564, 0.0, 92.34, 92.34, 92.34, 1.05, 0.0, 1, -30.0, 30.0],
        [606, 605, 0.0029805, 0.0720653, 0.0, 277.71, 277.71, 277.71, 1.05, 0.0, 1, -30.0, 30.0],
        [610, 609, 0.000182931, 0.011823, 0.0, 557.02, 557.02, 557.02, 1.025, 0.0, 1, -30.0, 30.0],
        [610, 609, 0.000182931, 0.011823, 0.0, 557.02, 557.02, 557.02, 1.025, 0.0, 1, -30.0, 30.0],
        [610, 609, 0.000182931, 0.011823, 0.0, 557.02, 557.02, 557.02, 1.025, 0.0, 1, -30.0, 30.0],
        [611, 610, 0.00366908, 0.128127, 0.0, 110.91, 110.91, 110.91, 1.025, 0.0, 1, -30.0, 30.0],
        [611, 610, 0.00366908, 0.128127, 0.0, 110.91, 110.91, 110.91, 1.025, 0.0, 1, -30.0, 30.0],
        [611, 610, 0.00366908, 0.128127, 0.0, 110.91, 110.91, 110.91, 1.025, 0.0, 1, -30.0, 30.0],
        [611, 610, 0.00366908, 0.128127, 0.0, 110.91, 110.91, 110.91, 1.025, 0.0, 1, -30.0, 30.0],
        [615, 614, 0.0060908, 0.163254, 0.0, 86.46, 86.46, 86.46, 1.05, 0.0, 1, -30.0, 30.0],
        [615, 614, 0.0060908, 0.163254, 0.0, 86.46, 86.46, 86.46, 1.05, 0.0, 1, -30.0, 30.0],
        [615, 614, 0.0060908, 0.163254, 0.0, 86.46, 86.46, 86.46, 1.05, 0.0, 1, -30.0, 30.0],
        [616, 615, 0.00232856, 0.0600332, 0.0, 164.12, 164.12, 164.12, 1.025, 0.0, 1, -30.0, 30.0],
        [620, 619, 0.00586055, 0.160518, 0.0, 80.06, 80.06, 80.06, 1.0, 0.0, 1, -30.0, 30.0],
        [621, 620, 0.00180346, 0.0526084, 0.0, 186.85, 186.85, 186.85, 1.0, 0.0, 1, -30.0, 30.0],
        [624, 623, 0.00465661, 0.132021, 0.0, 105.84, 105.84, 105.84, 1.025, 0.0, 1, -30.0, 30.0],
        [624, 623, 0.00465661, 0.132021, 0.0, 105.84, 105.84, 105.84, 1.025, 0.0, 1, -30.0, 30.0],
        [624, 623, 0.00465661, 0.132021, 0.0, 105.84, 105.84, 105.84, 1.025, 0.0, 1, -30.0, 30.0],
        [624, 623, 0.00465661, 0.132021, 0.0, 105.84, 105.84, 105.84, 1.025, 0.0, 1, -30.0, 30.0],
        [631, 630, 0.00395911, 0.133207, 0.0, 82.43, 82.43, 82.43, 1.0, 0.0, 1, -30.0, 30.0],
        [631, 630, 0.00395911, 0.133207, 0.0, 82.43, 82.43, 82.43, 1.0, 0.0, 1, -30.0, 30.0],
        [631, 630, 0.00395911, 0.133207, 0.0, 82.43, 82.43, 82.43, 1.0, 0.0, 1, -30.0, 30.0],
        [632, 631, 0.00198374, 0.0574628, 0.0, 280.52, 280.52, 280.52, 1.0, 0.0, 1, -30.0, 30.0],
        [642, 641, 0.00246607, 0.0779443, 0.0, 100.42, 100.42, 100.42, 1.01875, 0.0, 1, -30.0, 30.0],
        [642, 641, 0.00246607, 0.0779443, 0.0, 100.42, 100.42, 100.42, 1.01875, 0.0, 1, -30.0, 30.0],
        [642, 641, 0.00246607, 0.0779443, 0.0, 100.42, 100.42, 100.42, 1.01875, 0.0, 1, -30.0, 30.0],
        [642, 641, 0.00246607, 0.0779443, 0.0, 100.42, 100.42, 100.42, 1.01875, 0.0, 1, -30.0, 30.0],
        [651, 650, 0.00240903, 0.0809035, 0.0, 100.53, 100.53, 100.53, 1.0, 0.0, 1, -30.0, 30.0],
        [651, 650, 0.00240903, 0.0809035, 0.0, 100.53, 100.53, 100.53, 1.0, 0.0, 1, -30.0, 30.0],
        [651, 650, 0.00240903, 0.0809035, 0.0, 100.53, 100.53, 100.53, 1.0, 0.0, 1, -30.0, 30.0],
        [651, 650, 0.00240903, 0.0809035, 0.0, 100.53, 100.53, 100.53, 1.0, 0.0, 1, -30.0, 30.0],
        [656, 655, 0.00613796, 0.182688, 0.0, 69.7, 69.7, 69.7, 1.0, 0.0, 1, -30.0, 30.0],
        [659, 658, 0.00401388, 0.131486, 0.0, 84.26, 84.26, 84.26, 1.05, 0.0, 1, -30.0, 30.0],
        [659, 658, 0.00401388, 0.131486, 0.0, 84.26, 84.26, 84.26, 1.05, 0.0, 1, -30.0, 30.0],
        [659, 658, 0.00401388, 0.131486, 0.0, 84.26, 84.26, 84.26, 1.05, 0.0, 1, -30.0, 30.0],
        [662, 661, 0.00226705, 0.0723255, 0.0, 83.91, 83.91, 83.91, 1.05, 0.0, 1, -30.0, 30.0],
        [662, 661, 0.00226705, 0.0723255, 0.0, 83.91, 83.91, 83.91, 1.05, 0.0, 1, -30.0, 30.0],
        [662, 661, 0.00226705, 0.0723255, 0.0, 83.91, 83.91, 83.91, 1.05, 0.0, 1, -30.0, 30.0],
        [674, 673, 0.007297, 0.222089, 0.0, 56.41, 56.41, 56.41, 1.02, 0.0, 1, -30.0, 30.0],
        [679, 678, 0.00293628, 0.0895879, 0.0, 56.88, 56.88, 56.88, 1.025, 0.0, 1, -30.0, 30.0],
        [685, 684, 0.0069403, 0.231936, 0.0, 79.52, 79.52, 79.52, 1.0, 0.0, 1, -30.0, 30.0],
        [688, 687, 0.00418357, 0.140913, 0.0, 89.63, 89.63, 89.63, 1.025, 0.0, 1, -30.0, 30.0],
        [688, 687, 0.00418357, 0.140913, 0.0, 89.63, 89.63, 89.63, 1.025, 0.0, 1, -30.0, 30.0],
        [688, 687, 0.00418357, 0.140913, 0.0, 89.63, 89.63, 89.63, 1.025, 0.0, 1, -30.0, 30.0],
        [691, 690, 0.00389306, 0.126146, 0.0, 87.0, 87.0, 87.0, 1.025, 0.0, 1, -30.0, 30.0],
        [691, 690, 0.00389306, 0.126146, 0.0, 87.0, 87.0, 87.0, 1.025, 0.0, 1, -30.0, 30.0],
        [691, 690, 0.00389306, 0.126146, 0.0, 87.0, 87.0, 87.0, 1.025, 0.0, 1, -30.0, 30.0],
        [697, 696, 0.00462949, 0.144612, 0.0, 85.76, 85.76, 85.76, 1.0, 0.0, 1, -30.0, 30.0],
        [697, 696, 0.00462949, 0.144612, 0.0, 85.76, 85.76, 85.76, 1.0, 0.0, 1, -30.0, 30.0],
        [697, 696, 0.00462949, 0.144612, 0.0, 85.76, 85.76, 85.76, 1.0, 0.0, 1, -30.0, 30.0],
        [699, 698, 0.00240485, 0.0799237, 0.0, 122.5, 122.5, 122.5, 1.025, 0.0, 1, -30.0, 30.0],
        [699, 698, 0.00240485, 0.0799237, 0.0, 122.5, 122.5, 122.5, 1.025, 0.0, 1, -30.0, 30.0],
        [699, 698, 0.00240485, 0.0799237, 0.0, 122.5, 122.5, 122.5, 1.025, 0.0, 1, -30.0, 30.0],
        [699, 698, 0.00240485, 0.0799237, 0.0, 122.5, 122.5, 122.5, 1.025, 0.0, 1, -30.0, 30.0],
        [699, 698, 0.00240485, 0.0799237, 0.0, 122.5, 122.5, 122.5, 1.025, 0.0, 1, -30.0, 30.0],
        [704, 703, 0.00435811, 0.135458, 0.0, 78.34, 78.34, 78.34, 1.025, 0.0, 1, -30.0, 30.0],
        [704, 703, 0.00435811, 0.135458, 0.0, 78.34, 78.34, 78.34, 1.025, 0.0, 1, -30.0, 30.0],
        [706, 705, 0.000662637, 0.0383788, 0.0, 501.1, 501.1, 501.1, 1.05, 0.0, 1, -30.0, 30.0],
        [706, 705, 0.000662637, 0.0383788, 0.0, 501.1, 501.1, 501.1, 1.05, 0.0, 1, -30.0, 30.0],
        [706, 705, 0.000662637, 0.0383788, 0.0, 501.1, 501.1, 501.1, 1.05, 0.0, 1, -30.0, 30.0],
        [707, 706, 0.00586361, 0.151603, 0.0, 100.67, 100.67, 100.67, 1.025, 0.0, 1, -30.0, 30.0],
        [707, 706, 0.00586361, 0.151603, 0.0, 100.67, 100.67, 100.67, 1.025, 0.0, 1, -30.0, 30.0],
        [707, 706, 0.00586361, 0.151603, 0.0, 100.67, 100.67, 100.67, 1.025, 0.0, 1, -30.0, 30.0],
        [707, 706, 0.00586361, 0.151603, 0.0, 100.67, 100.67, 100.67, 1.025, 0.0, 1, -30.0, 30.0],
        [714, 713, 0.00440419, 0.155511, 0.0, 85.74, 85.74, 85.74, 1.025, 0.0, 1, -30.0, 30.0],
        [714, 713, 0.00440419, 0.155511, 0.0, 85.74, 85.74, 85.74, 1.025, 0.0, 1, -30.0, 30.0],
        [714, 713, 0.00440419, 0.155511, 0.0, 85.74, 85.74, 85.74, 1.025, 0.0, 1, -30.0, 30.0],
        [720, 719, 0.00484124, 0.176762, 0.0, 86.71, 86.71, 86.71, 1.0, 0.0, 1, -30.0, 30.0],
        [720, 719, 0.00484124, 0.176762, 0.0, 86.71, 86.71, 86.71, 1.0, 0.0, 1, -30.0, 30.0],
        [720, 719, 0.00484124, 0.176762, 0.0, 86.71, 86.71, 86.71, 1.0, 0.0, 1, -30.0, 30.0],
        [723, 722, 0.00470422, 0.134862, 0.0, 89.5, 89.5, 89.5, 1.0, 0.0, 1, -30.0, 30.0],
        [723, 722, 0.00470422, 0.134862, 0.0, 89.5, 89.5, 89.5, 1.0, 0.0, 1, -30.0, 30.0],
        [723, 722, 0.00470422, 0.134862, 0.0, 89.5, 89.5, 89.5, 1.0, 0.0, 1, -30.0, 30.0],
        [736, 735, 0.00391687, 0.126179, 0.0, 98.61, 98.61, 98.61, 1.025, 0.0, 1, -30.0, 30.0],
        [740, 739, 0.00726552, 0.191386, 0.0, 63.13, 63.13, 63.13, 1.0, 0.0, 1, -30.0, 30.0],
        [747, 746, 0.00177935, 0.0546496, 0.0, 99.5, 99.5, 99.5, 1.025, 0.0, 1, -30.0, 30.0],
        [747, 746, 0.00177935, 0.0546496, 0.0, 99.5, 99.5, 99.5, 1.025, 0.0, 1, -30.0, 30.0],
        [747, 746, 0.00177935, 0.0546496, 0.0, 99.5, 99.5, 99.5, 1.025, 0.0, 1, -30.0, 30.0],
        [747, 746, 0.00177935, 0.0546496, 0.0, 99.5, 99.5, 99.5, 1.025, 0.0, 1, -30.0, 30.0],
        [756, 755, 0.00832, 0.249904, 0.0, 86.67, 86.67, 86.67, 1.02, 0.0, 1, -30.0, 30.0],
        [756, 755, 0.00832, 0.249904, 0.0, 86.67, 86.67, 86.67, 1.02, 0.0, 1, -30.0, 30.0],
        [756, 755, 0.00832, 0.249904, 0.0, 86.67, 86.67, 86.67, 1.02, 0.0, 1, -30.0, 30.0],
        [759, 758, 0.00040287, 0.0248761, 0.0, 393.11, 393.11, 393.11, 1.025, 0.0, 1, -30.0, 30.0],
        [769, 768, 0.00570028, 0.138006, 0.0, 98.11, 98.11, 98.11, 1.025, 0.0, 1, -30.0, 30.0],
        [769, 768, 0.00570028, 0.138006, 0.0, 98.11, 98.11, 98.11, 1.025, 0.0, 1, -30.0, 30.0],
        [769, 768, 0.00570028, 0.138006, 0.0, 98.11, 98.11, 98.11, 1.025, 0.0, 1, -30.0, 30.0],
        [769, 768, 0.00570028, 0.138006, 0.0, 98.11, 98.11, 98.11, 1.025, 0.0, 1, -30.0, 30.0],
        [773, 772, 0.00508076, 0.163088, 0.0, 73.96, 73.96, 73.96, 1.05, 0.0, 1, -30.0, 30.0],
        [776, 775, 0.0038227, 0.118493, 0.0, 64.72, 64.72, 64.72, 1.05, 0.0, 1, -30.0, 30.0],
        [784, 783, 0.00489407, 0.1376, 0.0, 78.01, 78.01, 78.01, 1.025, 0.0, 1, -30.0, 30.0],
        [787, 786, 0.00424462, 0.156425, 0.0, 72.51, 72.51, 72.51, 1.025, 0.0, 1, -30.0, 30.0],
        [796, 795, 0.00248033, 0.0627566, 0.0, 94.32, 94.32, 94.32, 1.025, 0.0, 1, -30.0, 30.0],
        [796, 795, 0.00248033, 0.0627566, 0.0, 94.32, 94.32, 94.32, 1.025, 0.0, 1, -30.0, 30.0],
        [796, 795, 0.00248033, 0.0627566, 0.0, 94.32, 94.32, 94.32, 1.025, 0.0, 1, -30.0, 30.0],
        [802, 801, 0.00549287, 0.177787, 0.0, 97.18, 97.18, 97.18, 1.025, 0.0, 1, -30.0, 30.0],
        [802, 801, 0.00549287, 0.177787, 0.0, 97.18, 97.18, 97.18, 1.025, 0.0, 1, -30.0, 30.0],
        [802, 801, 0.00549287, 0.177787, 0.0, 97.18, 97.18, 97.18, 1.025, 0.0, 1, -30.0, 30.0],
        [802, 801, 0.00549287, 0.177787, 0.0, 97.18, 97.18, 97.18, 1.025, 0.0, 1, -30.0, 30.0],
        [807, 806, 0.00317281, 0.0989598, 0.0, 118.21, 118.21, 118.21, 1.0125, 0.0, 1, -30.0, 30.0],
        [807, 806, 0.00317281, 0.0989598, 0.0, 118.21, 118.21, 118.21, 1.0125, 0.0, 1, -30.0, 30.0],
        [807, 806, 0.00317281, 0.0989598, 0.0, 118.21, 118.21, 118.21, 1.0125, 0.0, 1, -30.0, 30.0],
        [807, 806, 0.00317281, 0.0989598, 0.0, 118.21, 118.21, 118.21, 1.0125, 0.0, 1, -30.0, 30.0],
        [809, 808, 0.000323561, 0.0202113, 0.0, 526.03, 526.03, 526.03, 1.0, 0.0, 1, -30.0, 30.0],
        [809, 808, 0.000323561, 0.0202113, 0.0, 526.03, 526.03, 526.03, 1.0, 0.0, 1, -30.0, 30.0],
        [809, 808, 0.000323561, 0.0202113, 0.0, 526.03, 526.03, 526.03, 1.0, 0.0, 1, -30.0, 30.0],
        [810, 809, 0.00313915, 0.0923103, 0.0, 92.89, 92.89, 92.89, 1.0, 0.0, 1, -30.0, 30.0],
        [810, 809, 0.00313915, 0.0923103, 0.0, 92.89, 92.89, 92.89, 1.0, 0.0, 1, -30.0, 30.0],
        [810, 809, 0.00313915, 0.0923103, 0.0, 92.89, 92.89, 92.89, 1.0, 0.0, 1, -30.0, 30.0],
        [813, 812, 0.00451803, 0.120813, 0.0, 85.49, 85.49, 85.49, 1.025, 0.0, 1, -30.0, 30.0],
        [813, 812, 0.00451803, 0.120813, 0.0, 85.49, 85.49, 85.49, 1.025, 0.0, 1, -30.0, 30.0],
        [813, 812, 0.00451803, 0.120813, 0.0, 85.49, 85.49, 85.49, 1.025, 0.0, 1, -30.0, 30.0],
        [819, 818, 0.00620342, 0.21355, 0.0, 57.84, 57.84, 57.84, 1.05, 0.0, 1, -30.0, 30.0],
        [824, 823, 0.00410731, 0.125752, 0.0, 86.62, 86.62, 86.62, 1.0, 0.0, 1, -30.0, 30.0],
        [824, 823, 0.00410731, 0.125752, 0.0, 86.62, 86.62, 86.62, 1.0, 0.0, 1, -30.0, 30.0],
        [824, 823, 0.00410731, 0.125752, 0.0, 86.62, 86.62, 86.62, 1.0, 0.0, 1, -30.0, 30.0],
        [826, 825, 0.00501609, 0.151018, 0.0, 88.22, 88.22, 88.22, 1.0, 0.0, 1, -30.0, 30.0],
        [826, 825, 0.00501609, 0.151018, 0.0, 88.22, 88.22, 88.22, 1.0, 0.0, 1, -30.0, 30.0],
        [826, 825, 0.00501609, 0.151018, 0.0, 88.22, 88.22, 88.22, 1.0, 0.0, 1, -30.0, 30.0],
        [837, 836, 0.00378831, 0.132034, 0.0, 86.92, 86.92, 86.92, 1.05, 0.0, 1, -30.0, 30.0],
        [837, 836, 0.00378831, 0.132034, 0.0, 86.92, 86.92, 86.92, 1.05, 0.0, 1, -30.0, 30.0],
        [837, 836, 0.00378831, 0.132034, 0.0, 86.92, 86.92, 86.92, 1.05, 0.0, 1, -30.0, 30.0],
        [840, 839, 0.0025344, 0.0635858, 0.0, 92.42, 92.42, 92.42, 1.05, 0.0, 1, -30.0, 30.0],
        [840, 839, 0.0025344, 0.0635858, 0.0, 92.42, 92.42, 92.42, 1.05, 0.0, 1, -30.0, 30.0],
        [840, 839, 0.0025344, 0.0635858, 0.0, 92.42, 92.42, 92.42, 1.05, 0.0, 1, -30.0, 30.0],
        [843, 842, 0.000679629, 0.0371829, 0.0, 428.14, 428.14, 428.14, 1.0, 0.0, 1, -30.0, 30.0],
        [844, 843, 0.00473007, 0.164319, 0.0, 89.75, 89.75, 89.75, 1.0, 0.0, 1, -30.0, 30.0],
        [844, 843, 0.00473007, 0.164319, 0.0, 89.75, 89.75, 89.75, 1.0, 0.0, 1, -30.0, 30.0],
        [844, 843, 0.00473007, 0.164319, 0.0, 89.75, 89.75, 89.75, 1.0, 0.0, 1, -30.0, 30.0],
        [848, 847, 0.00569445, 0.165357, 0.0, 90.42, 90.42, 90.42, 1.05, 0.0, 1, -30.0, 30.0],
        [848, 847, 0.00569445, 0.165357, 0.0, 90.42, 90.42, 90.42, 1.05, 0.0, 1, -30.0, 30.0],
        [848, 847, 0.00569445, 0.165357, 0.0, 90.42, 90.42, 90.42, 1.05, 0.0, 1, -30.0, 30.0],
        [850, 849, 0.00409836, 0.122152, 0.0, 91.43, 91.43, 91.43, 1.0, 0.0, 1, -30.0, 30.0],
        [850, 849, 0.00409836, 0.122152, 0.0, 91.43, 91.43, 91.43, 1.0, 0.0, 1, -30.0, 30.0],
        [850, 849, 0.00409836, 0.122152, 0.0, 91.43, 91.43, 91.43, 1.0, 0.0, 1, -30.0, 30.0],
        [864, 863, 0.000437275, 0.0267164, 0.0, 372.33, 372.33, 372.33, 1.0125, 0.0, 1, -30.0, 30.0],
        [879, 878, 0.00616796, 0.146795, 0.0, 99.53, 99.53, 99.53, 1.05, 0.0, 1, -30.0, 30.0],
        [879, 878, 0.00616796, 0.146795, 0.0, 99.53, 99.53, 99.53, 1.05, 0.0, 1, -30.0, 30.0],
        [879, 878, 0.00616796, 0.146795, 0.0, 99.53, 99.53, 99.53, 1.05, 0.0, 1, -30.0, 30.0],
        [879, 878, 0.00616796, 0.146795, 0.0, 99.53, 99.53, 99.53, 1.05, 0.0, 1, -30.0, 30.0],
        [882, 881, 0.0030849, 0.104709, 0.0, 82.06, 82.06, 82.06, 1.0, 0.0, 1, -30.0, 30.0],
        [882, 881, 0.0030849, 0.104709, 0.0, 82.06, 82.06, 82.06, 1.0, 0.0, 1, -30.0, 30.0],
        [882, 881, 0.0030849, 0.104709, 0.0, 82.06, 82.06, 82.06, 1.0, 0.0, 1, -30.0, 30.0],
        [886, 885, 0.000516692, 0.0253919, 0.0, 449.29, 449.29, 449.29, 1.0125, 0.0, 1, -30.0, 30.0],
        [897, 896, 0.00953202, 0.19545, 0.0, 86.79, 86.79, 86.79, 1.05, 0.0, 1, -30.0, 30.0],
        [901, 900, 0.00295193, 0.102274, 0.0, 96.27, 96.27, 96.27, 1.025, 0.0, 1, -30.0, 30.0],
        [901, 900, 0.00295193, 0.102274, 0.0, 96.27, 96.27, 96.27, 1.025, 0.0, 1, -30.0, 30.0],
        [901, 900, 0.00295193, 0.102274, 0.0, 96.27, 96.27, 96.27, 1.025, 0.0, 1, -30.0, 30.0],
        [905, 904, 0.00589739, 0.178431, 0.0, 100.64, 100.64, 100.64, 1.025, 0.0, 1, -30.0, 30.0],
        [905, 904, 0.00589739, 0.178431, 0.0, 100.64, 100.64, 100.64, 1.025, 0.0, 1, -30.0, 30.0],
        [905, 904, 0.00589739, 0.178431, 0.0, 100.64, 100.64, 100.64, 1.025, 0.0, 1, -30.0, 30.0],
        [905, 904, 0.00589739, 0.178431, 0.0, 100.64, 100.64, 100.64, 1.025, 0.0, 1, -30.0, 30.0],
        [914, 913, 0.00410954, 0.116124, 0.0, 82.56, 82.56, 82.56, 1.025, 0.0, 1, -30.0, 30.0],
        [914, 913, 0.00410954, 0.116124, 0.0, 82.56, 82.56, 82.56, 1.025, 0.0, 1, -30.0, 30.0],
        [914, 913, 0.00410954, 0.116124, 0.0, 82.56, 82.56, 82.56, 1.025, 0.0, 1, -30.0, 30.0],
        [926, 925, 0.000739235, 0.0378638, 0.0, 463.42, 463.42, 463.42, 1.025, 0.0, 1, -30.0, 30.0],
        [927, 926, 0.00595119, 0.176692, 0.0, 94.11, 94.11, 94.11, 1.025, 0.0, 1, -30.0, 30.0],
        [927, 926, 0.00595119, 0.176692, 0.0, 94.11, 94.11, 94.11, 1.025, 0.0, 1, -30.0, 30.0],
        [927, 926, 0.00595119, 0.176692, 0.0, 94.11, 94.11, 94.11, 1.025, 0.0, 1, -30.0, 30.0],
        [931, 930, 0.00380202, 0.116111, 0.0, 60.66, 60.66, 60.66, 1.0, 0.0, 1, -30.0, 30.0],
        [937, 936, 0.00341301, 0.120509, 0.0, 69.14, 69.14, 69.14, 1.025, 0.0, 1, -30.0, 30.0],
        [946, 945, 0.00363774, 0.11867, 0.0, 70.51, 70.51, 70.51, 1.025, 0.0, 1, -30.0, 30.0],
        [950, 949, 0.0069781, 0.198744, 0.0, 48.82, 48.82, 48.82, 1.0, 0.0, 1, -30.0, 30.0],
        [955, 954, 0.0062258, 0.186897, 0.0, 77.81, 77.81, 77.81, 1.05, 0.0, 1, -30.0, 30.0],
        [959, 958, 0.00545638, 0.162649, 0.0, 59.01, 59.01, 59.01, 1.025, 0.0, 1, -30.0, 30.0],
        [964, 963, 0.00435212, 0.143631, 0.0, 85.29, 85.29, 85.29, 1.0, 0.0, 1, -30.0, 30.0],
        [964, 963, 0.00435212, 0.143631, 0.0, 85.29, 85.29, 85.29, 1.0, 0.0, 1, -30.0, 30.0],
        [964, 963, 0.00435212, 0.143631, 0.0, 85.29, 85.29, 85.29, 1.0, 0.0, 1, -30.0, 30.0],
        [968, 967, 0.00446412, 0.138615, 0.0, 90.81, 90.81, 90.81, 1.05, 0.0, 1, -30.0, 30.0],
        [973, 972, 0.000475299, 0.027386, 0.0, 517.97, 517.97, 517.97, 1.025, 0.0, 1, -30.0, 30.0],
        [973, 972, 0.000475299, 0.027386, 0.0, 517.97, 517.97, 517.97, 1.025, 0.0, 1, -30.0, 30.0],
        [973, 972, 0.000475299, 0.027386, 0.0, 517.97, 517.97, 517.97, 1.025, 0.0, 1, -30.0, 30.0],
        [978, 977, 0.00547121, 0.1785, 0.0, 84.14, 84.14, 84.14, 1.0, 0.0, 1, -30.0, 30.0],
        [978, 977, 0.00547121, 0.1785, 0.0, 84.14, 84.14, 84.14, 1.0, 0.0, 1, -30.0, 30.0],
        [978, 977, 0.00547121, 0.1785, 0.0, 84.14, 84.14, 84.14, 1.0, 0.0, 1, -30.0, 30.0],
        [982, 981, 0.0048979, 0.118748, 0.0, 113.37, 113.37, 113.37, 1.025, 0.0, 1, -30.0, 30.0],
        [982, 981, 0.0048979, 0.118748, 0.0, 113.37, 113.37, 113.37, 1.025, 0.0, 1, -30.0, 30.0],
        [982, 981, 0.0048979, 0.118748, 0.0, 113.37, 113.37, 113.37, 1.025, 0.0, 1, -30.0, 30.0],
        [982, 981, 0.0048979, 0.118748, 0.0, 113.37, 113.37, 113.37, 1.025, 0.0, 1, -30.0, 30.0],
        [985, 984, 0.00647504, 0.183586, 0.0, 87.3, 87.3, 87.3, 1.05, 0.0, 1, -30.0, 30.0],
        [985, 984, 0.00647504, 0.183586, 0.0, 87.3, 87.3, 87.3, 1.05, 0.0, 1, -30.0, 30.0],
        [985, 984, 0.00647504, 0.183586, 0.0, 87.3, 87.3, 87.3, 1.05, 0.0, 1, -30.0, 30.0],
        [990, 989, 0.003891, 0.117341, 0.0, 61.58, 61.58, 61.58, 0.95, 0.0, 1, -30.0, 30.0],
        [996, 995, 0.00850359, 0.221875, 0.0, 82.79, 82.79, 82.79, 1.025, 0.0, 1, -30.0, 30.0],
        [996, 995, 0.00850359, 0.221875, 0.0, 82.79, 82.79, 82.79, 1.025, 0.0, 1, -30.0, 30.0],
        [996, 995, 0.00850359, 0.221875, 0.0, 82.79, 82.79, 82.79, 1.025, 0.0, 1, -30.0, 30.0],
        [1001, 1000, 0.00416239, 0.131895, 0.0, 84.92, 84.92, 84.92, 1.0, 0.0, 1, -30.0, 30.0],
        [1001, 1000, 0.00416239, 0.131895, 0.0, 84.92, 84.92, 84.92, 1.0, 0.0, 1, -30.0, 30.0],
        [1001, 1000, 0.00416239, 0.131895, 0.0, 84.92, 84.92, 84.92, 1.0, 0.0, 1, -30.0, 30.0],
        [1005, 1004, 0.007011, 0.2085, 0.0, 102.76, 102.76, 102.76, 0.95, 0.0, 1, -30.0, 30.0],
        [1008, 1007, 0.00629371, 0.209071, 0.0, 75.93, 75.93, 75.93, 1.025, 0.0, 1, -30.0, 30.0],
        [1011, 1010, 0.000561215, 0.0314549, 0.0, 428.81, 428.81, 428.81, 1.025, 0.0, 1, -30.0, 30.0],
        [1014, 1013, 0.008347, 0.217093, 0.0, 99.45, 99.45, 99.45, 1.0, 0.0, 1, -30.0, 30.0],
        [1018, 1017, 0.00695237, 0.166905, 0.0, 77.98, 77.98, 77.98, 1.0, 0.0, 1, -30.0, 30.0],
        [1018, 1017, 0.00695237, 0.166905, 0.0, 77.98, 77.98, 77.98, 1.0, 0.0, 1, -30.0, 30.0],
        [1021, 1020, 0.00451792, 0.12139, 0.0, 57.76, 57.76, 57.76, 1.025, 0.0, 1, -30.0, 30.0],
        [1028, 1027, 0.00514358, 0.17573, 0.0, 68.75, 68.75, 68.75, 1.025, 0.0, 1, -30.0, 30.0],
        [1033, 1032, 0.00462074, 0.179475, 0.0, 69.87, 69.87, 69.87, 1.05, 0.0, 1, -30.0, 30.0],
        [1036, 1035, 0.00368236, 0.0848926, 0.0, 91.5, 91.5, 91.5, 1.0, 0.0, 1, -30.0, 30.0],
        [1036, 1035, 0.00368236, 0.0848926, 0.0, 91.5, 91.5, 91.5, 1.0, 0.0, 1, -30.0, 30.0],
        [1036, 1035, 0.00368236, 0.0848926, 0.0, 91.5, 91.5, 91.5, 1.0, 0.0, 1, -30.0, 30.0],
        [1040, 1039, 0.00602886, 0.172111, 0.0, 76.96, 76.96, 76.96, 1.025, 0.0, 1, -30.0, 30.0],
        [1043, 1042, 0.000447232, 0.0301018, 0.0, 446.22, 446.22, 446.22, 1.025, 0.0, 1, -30.0, 30.0],
        [1044, 1043, 0.00205414, 0.068774, 0.0, 80.77, 80.77, 80.77, 1.01875, 0.0, 1, -30.0, 30.0],
        [1044, 1043, 0.00205414, 0.068774, 0.0, 80.77, 80.77, 80.77, 1.01875, 0.0, 1, -30.0, 30.0],
        [1047, 1046, 0.00545914, 0.176504, 0.0, 84.46, 84.46, 84.46, 1.025, 0.0, 1, -30.0, 30.0],
        [1047, 1046, 0.00545914, 0.176504, 0.0, 84.46, 84.46, 84.46, 1.025, 0.0, 1, -30.0, 30.0],
        [1047, 1046, 0.00545914, 0.176504, 0.0, 84.46, 84.46, 84.46, 1.025, 0.0, 1, -30.0, 30.0],
        [1051, 1050, 0.00377766, 0.102234, 0.0, 74.95, 74.95, 74.95, 1.025, 0.0, 1, -30.0, 30.0],
        [1056, 1055, 0.00314499, 0.0991278, 0.0, 85.78, 85.78, 85.78, 1.025, 0.0, 1, -30.0, 30.0],
        [1056, 1055, 0.00314499, 0.0991278, 0.0, 85.78, 85.78, 85.78, 1.025, 0.0, 1, -30.0, 30.0],
        [1056, 1055, 0.00314499, 0.0991278, 0.0, 85.78, 85.78, 85.78, 1.025, 0.0, 1, -30.0, 30.0],
        [1060, 1059, 0.000341631, 0.0246799, 0.0, 447.69, 447.69, 447.69, 1.025, 0.0, 1, -30.0, 30.0],
        [1061, 1060, 0.00427047, 0.123048, 0.0, 92.67, 92.67, 92.67, 1.025, 0.0, 1, -30.0, 30.0],
        [1061, 1060, 0.00427047, 0.123048, 0.0, 92.67, 92.67, 92.67, 1.025, 0.0, 1, -30.0, 30.0],
        [1061, 1060, 0.00427047, 0.123048, 0.0, 92.67, 92.67, 92.67, 1.025, 0.0, 1, -30.0, 30.0],
        [1067, 1066, 0.00719918, 0.172511, 0.0, 88.96, 88.96, 88.96, 1.05, 0.0, 1, -30.0, 30.0],
        [1067, 1066, 0.00719918, 0.172511, 0.0, 88.96, 88.96, 88.96, 1.05, 0.0, 1, -30.0, 30.0],
        [1067, 1066, 0.00719918, 0.172511, 0.0, 88.96, 88.96, 88.96, 1.05, 0.0, 1, -30.0, 30.0],
        [1068, 1067, 0.001201, 0.032029, 0.0, 224.26, 224.26, 224.26, 1.0, 0.0, 1, -30.0, 30.0],
        [1075, 1074, 0.000365765, 0.0300547, 0.0, 446.64, 446.64, 446.64, 1.05, 0.0, 1, -30.0, 30.0],
        [1076, 1075, 0.00625072, 0.20522, 0.0, 83.2, 83.2, 83.2, 1.025, 0.0, 1, -30.0, 30.0],
        [1076, 1075, 0.00625072, 0.20522, 0.0, 83.2, 83.2, 83.2, 1.025, 0.0, 1, -30.0, 30.0],
        [1076, 1075, 0.00625072, 0.20522, 0.0, 83.2, 83.2, 83.2, 1.025, 0.0, 1, -30.0, 30.0],
        [1082, 1081, 0.00642161, 0.176002, 0.0, 107.39, 107.39, 107.39, 1.0, 0.0, 1, -30.0, 30.0],
        [1087, 1086, 0.004951, 0.164107, 0.0, 81.16, 81.16, 81.16, 0.95, 0.0, 1, -30.0, 30.0],
        [1090, 1089, 0.000375312, 0.024465, 0.0, 446.24, 446.24, 446.24, 1.0, 0.0, 1, -30.0, 30.0],
        [1091, 1090, 0.00483218, 0.188826, 0.0, 110.6, 110.6, 110.6, 1.0, 0.0, 1, -30.0, 30.0],
        [1091, 1090, 0.00483218, 0.188826, 0.0, 110.6, 110.6, 110.6, 1.0, 0.0, 1, -30.0, 30.0],
        [1091, 1090, 0.00483218, 0.188826, 0.0, 110.6, 110.6, 110.6, 1.0, 0.0, 1, -30.0, 30.0],
        [1091, 1090, 0.00483218, 0.188826, 0.0, 110.6, 110.6, 110.6, 1.0, 0.0, 1, -30.0, 30.0],
        [1103, 1102, 0.00519484, 0.156492, 0.0, 50.3, 50.3, 50.3, 1.0, 0.0, 1, -30.0, 30.0],
        [1107, 1106, 0.007417, 0.201927, 0.0, 72.11, 72.11, 72.11, 1.0, 0.0, 1, -30.0, 30.0],
        [1112, 1111, 0.004757, 0.126197, 0.0, 71.65, 71.65, 71.65, 1.0, 0.0, 1, -30.0, 30.0],
        [1115, 1114, 0.00614133, 0.188009, 0.0, 87.54, 87.54, 87.54, 1.05, 0.0, 1, -30.0, 30.0],
        [1115, 1114, 0.00614133, 0.188009, 0.0, 87.54, 87.54, 87.54, 1.05, 0.0, 1, -30.0, 30.0],
        [1115, 1114, 0.00614133, 0.188009, 0.0, 87.54, 87.54, 87.54, 1.05, 0.0, 1, -30.0, 30.0],
        [1116, 1115, 0.001112, 0.028913, 0.0, 189.3, 189.3, 189.3, 1.0, 0.0, 1, -30.0, 30.0],
        [1121, 1120, 0.00286439, 0.106293, 0.0, 96.39, 96.39, 96.39, 1.05, 0.0, 1, -30.0, 30.0],
        [1126, 1125, 0.00444236, 0.135868, 0.0, 83.7, 83.7, 83.7, 1.025, 0.0, 1, -30.0, 30.0],
        [1126, 1125, 0.00444236, 0.135868, 0.0, 83.7, 83.7, 83.7, 1.025, 0.0, 1, -30.0, 30.0],
        [1126, 1125, 0.00444236, 0.135868, 0.0, 83.7, 83.7, 83.7, 1.025, 0.0, 1, -30.0, 30.0],
        [1129, 1128, 0.000386919, 0.0280642, 0.0, 414.52, 414.52, 414.52, 1.0, 0.0, 1, -30.0, 30.0],
        [1130, 1129, 0.00399342, 0.0857401, 0.0, 88.75, 88.75, 88.75, 1.0, 0.0, 1, -30.0, 30.0],
        [1130, 1129, 0.00399342, 0.0857401, 0.0, 88.75, 88.75, 88.75, 1.0, 0.0, 1, -30.0, 30.0],
        [1130, 1129, 0.00399342, 0.0857401, 0.0, 88.75, 88.75, 88.75, 1.0, 0.0, 1, -30.0, 30.0],
        [1133, 1132, 0.00597871, 0.145134, 0.0, 86.15, 86.15, 86.15, 1.05, 0.0, 1, -30.0, 30.0],
        [1136, 1135, 0.00419241, 0.145469, 0.0, 62.88, 62.88, 62.88, 1.05, 0.0, 1, -30.0, 30.0],
        [1146, 1145, 0.00054869, 0.0309134, 0.0, 405.28, 405.28, 405.28, 1.05, 0.0, 1, -30.0, 30.0],
        [1147, 1146, 0.00245169, 0.074866, 0.0, 88.97, 88.97, 88.97, 1.025, 0.0, 1, -30.0, 30.0],
        [1147, 1146, 0.00245169, 0.074866, 0.0, 88.97, 88.97, 88.97, 1.025, 0.0, 1, -30.0, 30.0],
        [1147, 1146, 0.00245169, 0.074866, 0.0, 88.97, 88.97, 88.97, 1.025, 0.0, 1, -30.0, 30.0],
        [1155, 1154, 0.000445391, 0.0298262, 0.0, 431.87, 431.87, 431.87, 1.0, 0.0, 1, -30.0, 30.0],
        [1163, 1162, 0.000525096, 0.0280552, 0.0, 347.38, 347.38, 347.38, 1.0, 0.0, 1, -30.0, 30.0],
        [1168, 1167, 0.000407544, 0.0225891, 0.0, 550.06, 550.06, 550.06, 1.025, 0.0, 1, -30.0, 30.0],
        [1168, 1167, 0.000407544, 0.0225891, 0.0, 550.06, 550.06, 550.06, 1.025, 0.0, 1, -30.0, 30.0],
        [1168, 1167, 0.000407544, 0.0225891, 0.0, 550.06, 550.06, 550.06, 1.025, 0.0, 1, -30.0, 30.0],
        [1169, 1168, 0.00339324, 0.11636, 0.0, 103.25, 103.25, 103.25, 1.01875, 0.0, 1, -30.0, 30.0],
        [1169, 1168, 0.00339324, 0.11636, 0.0, 103.25, 103.25, 103.25, 1.01875, 0.0, 1, -30.0, 30.0],
        [1169, 1168, 0.00339324, 0.11636, 0.0, 103.25, 103.25, 103.25, 1.01875, 0.0, 1, -30.0, 30.0],
        [1169, 1168, 0.00339324, 0.11636, 0.0, 103.25, 103.25, 103.25, 1.01875, 0.0, 1, -30.0, 30.0],
        [1172, 1171, 0.0037476, 0.118672, 0.0, 85.07, 85.07, 85.07, 1.025, 0.0, 1, -30.0, 30.0],
        [1172, 1171, 0.0037476, 0.118672, 0.0, 85.07, 85.07, 85.07, 1.025, 0.0, 1, -30.0, 30.0],
        [1172, 1171, 0.0037476, 0.118672, 0.0, 85.07, 85.07, 85.07, 1.025, 0.0, 1, -30.0, 30.0],
        [1175, 1174, 0.00639746, 0.204904, 0.0, 84.52, 84.52, 84.52, 1.0, 0.0, 1, -30.0, 30.0],
        [1175, 1174, 0.00639746, 0.204904, 0.0, 84.52, 84.52, 84.52, 1.0, 0.0, 1, -30.0, 30.0],
        [1175, 1174, 0.00639746, 0.204904, 0.0, 84.52, 84.52, 84.52, 1.0, 0.0, 1, -30.0, 30.0],
        [1180, 1179, 0.00358417, 0.124746, 0.0, 112.4, 112.4, 112.4, 1.05, 0.0, 1, -30.0, 30.0],
        [1182, 1181, 0.00287677, 0.093776, 0.0, 82.78, 82.78, 82.78, 1.025, 0.0, 1, -30.0, 30.0],
        [1182, 1181, 0.00287677, 0.093776, 0.0, 82.78, 82.78, 82.78, 1.025, 0.0, 1, -30.0, 30.0],
        [1182, 1181, 0.00287677, 0.093776, 0.0, 82.78, 82.78, 82.78, 1.025, 0.0, 1, -30.0, 30.0],
        [1190, 1189, 0.00743073, 0.214238, 0.0, 82.26, 82.26, 82.26, 1.025, 0.0, 1, -30.0, 30.0],
        [1190, 1189, 0.00743073, 0.214238, 0.0, 82.26, 82.26, 82.26, 1.025, 0.0, 1, -30.0, 30.0],
        [1196, 1195, 0.00619919, 0.159578, 0.0, 110.95, 110.95, 110.95, 1.0, 0.0, 1, -30.0, 30.0],
        [1203, 1202, 0.004278, 0.129058, 0.0, 63.58, 63.58, 63.58, 1.01, 0.0, 1, -30.0, 30.0],
        [1206, 1205, 0.00427, 0.137158, 0.0, 64.83, 64.83, 64.83, 1.02, 0.0, 1, -30.0, 30.0],
        [1210, 1212, 0.000439586, 0.0295958, 0.0, 303.58, 303.58, 303.58, 1.0, 0.0, 1, -30.0, 30.0],
        [1210, 1213, 0.000395241, 0.024685, 0.0, 293.92, 293.92, 293.92, 1.0, 0.0, 1, -30.0, 30.0],
        [1210, 1214, 0.00070798, 0.052461, 0.0, 291.95, 291.95, 291.95, 1.0, 0.0, 1, -30.0, 30.0],
        [1211, 1210, 0.000248124, 0.0164603, 0.0, 725.63, 725.63, 725.63, 1.05, 0.0, 1, -30.0, 30.0],
        [1217, 1216, 0.00555935, 0.172824, 0.0, 70.1, 70.1, 70.1, 1.00625, 0.0, 1, -30.0, 30.0],
        [1220, 1219, 0.000458933, 0.0209421, 0.0, 527.78, 527.78, 527.78, 1.0, 0.0, 1, -30.0, 30.0],
        [1220, 1219, 0.000458933, 0.0209421, 0.0, 527.78, 527.78, 527.78, 1.0, 0.0, 1, -30.0, 30.0],
        [1220, 1219, 0.000458933, 0.0209421, 0.0, 527.78, 527.78, 527.78, 1.0, 0.0, 1, -30.0, 30.0],
        [1221, 1220, 0.00457032, 0.139417, 0.0, 88.12, 88.12, 88.12, 1.0, 0.0, 1, -30.0, 30.0],
        [1221, 1220, 0.00457032, 0.139417, 0.0, 88.12, 88.12, 88.12, 1.0, 0.0, 1, -30.0, 30.0],
        [1221, 1220, 0.00457032, 0.139417, 0.0, 88.12, 88.12, 88.12, 1.0, 0.0, 1, -30.0, 30.0],
        [1223, 1226, 0.000287434, 0.016361, 0.0, 382.04, 382.04, 382.04, 1.04375, 0.0, 1, -30.0, 30.0],
        [1223, 1227, 0.000396411, 0.0242578, 0.0, 381.9, 381.9, 381.9, 1.05, 0.0, 1, -30.0, 30.0],
        [1223, 1228, 0.000411918, 0.0247476, 0.0, 380.47, 380.47, 380.47, 1.05, 0.0, 1, -30.0, 30.0],
        [1223, 1229, 0.00044113, 0.0265023, 0.0, 376.33, 376.33, 376.33, 1.05, 0.0, 1, -30.0, 30.0],
        [1223, 1230, 0.000618367, 0.0362494, 0.0, 371.53, 371.53, 371.53, 1.0625, 0.0, 1, -30.0, 30.0],
        [1224, 1223, 0.000370719, 0.0268468, 0.0, 517.96, 517.96, 517.96, 1.0, 0.0, 1, -30.0, 30.0],
        [1224, 1223, 0.000370719, 0.0268468, 0.0, 517.96, 517.96, 517.96, 1.0, 0.0, 1, -30.0, 30.0],
        [1224, 1223, 0.000370719, 0.0268468, 0.0, 517.96, 517.96, 517.96, 1.0, 0.0, 1, -30.0, 30.0],
        [1225, 1224, 0.0039661, 0.115058, 0.0, 106.7, 106.7, 106.7, 1.0, 0.0, 1, -30.0, 30.0],
        [1225, 1224, 0.0039661, 0.115058, 0.0, 106.7, 106.7, 106.7, 1.0, 0.0, 1, -30.0, 30.0],
        [1225, 1224, 0.0039661, 0.115058, 0.0, 106.7, 106.7, 106.7, 1.0, 0.0, 1, -30.0, 30.0],
        [1225, 1224, 0.0039661, 0.115058, 0.0, 106.7, 106.7, 106.7, 1.0, 0.0, 1, -30.0, 30.0],
        [1233, 1232, 0.0013863, 0.0409264, 0.0, 90.29, 90.29, 90.29, 1.01875, 0.0, 1, -30.0, 30.0],
        [1233, 1232, 0.0013863, 0.0409264, 0.0, 90.29, 90.29, 90.29, 1.01875, 0.0, 1, -30.0, 30.0],
        [1233, 1232, 0.0013863, 0.0409264, 0.0, 90.29, 90.29, 90.29, 1.01875, 0.0, 1, -30.0, 30.0],
        [1235, 1237, 0.000609043, 0.0205229, 0.0, 267.41, 267.41, 267.41, 1.0, 0.0, 1, -30.0, 30.0],
        [1235, 1238, 0.00154326, 0.0495428, 0.0, 267.41, 267.41, 267.41, 1.0, 0.0, 1, -30.0, 30.0],
        [1236, 1235, 0.00417237, 0.13308, 0.0, 100.68, 100.68, 100.68, 1.025, 0.0, 1, -30.0, 30.0],
        [1236, 1235, 0.00417237, 0.13308, 0.0, 100.68, 100.68, 100.68, 1.025, 0.0, 1, -30.0, 30.0],
        [1236, 1235, 0.00417237, 0.13308, 0.0, 100.68, 100.68, 100.68, 1.025, 0.0, 1, -30.0, 30.0],
        [1236, 1235, 0.00417237, 0.13308, 0.0, 100.68, 100.68, 100.68, 1.025, 0.0, 1, -30.0, 30.0],
        [1240, 1243, 0.000523176, 0.0300936, 0.0, 389.05, 389.05, 389.05, 1.05, 0.0, 1, -30.0, 30.0],
        [1240, 1244, 0.00051575, 0.0254358, 0.0, 388.14, 388.14, 388.14, 1.04375, 0.0, 1, -30.0, 30.0],
        [1241, 1240, 0.000460464, 0.024759, 0.0, 418.57, 418.57, 418.57, 1.0, 0.0, 1, -30.0, 30.0],
        [1242, 1241, 0.00285497, 0.0887566, 0.0, 79.55, 79.55, 79.55, 1.0, 0.0, 1, -30.0, 30.0],
        [1242, 1241, 0.00285497, 0.0887566, 0.0, 79.55, 79.55, 79.55, 1.0, 0.0, 1, -30.0, 30.0],
        [1248, 1251, 0.000209445, 0.015501, 0.0, 340.21, 340.21, 340.21, 1.00625, 0.0, 1, -30.0, 30.0],
        [1248, 1252, 0.000721695, 0.0393289, 0.0, 337.81, 337.81, 337.81, 1.025, 0.0, 1, -30.0, 30.0],
        [1248, 1253, 0.000782162, 0.0379598, 0.0, 334.09, 334.09, 334.09, 1.025, 0.0, 1, -30.0, 30.0],
        [1249, 1248, 0.000150855, 0.010652, 0.0, 460.18, 460.18, 460.18, 1.01875, 0.0, 1, -30.0, 30.0],
        [1250, 1249, 0.00560583, 0.181536, 0.0, 81.93, 81.93, 81.93, 1.0125, 0.0, 1, -30.0, 30.0],
        [1250, 1249, 0.00560583, 0.181536, 0.0, 81.93, 81.93, 81.93, 1.0125, 0.0, 1, -30.0, 30.0],
        [1255, 1256, 0.000369626, 0.0115713, 0.0, 436.45, 436.45, 436.45, 1.0, 0.0, 1, -30.0, 30.0],
        [1255, 1257, 0.00133862, 0.0361546, 0.0, 436.45, 436.45, 436.45, 1.0, 0.0, 1, -30.0, 30.0],
        [1255, 1258, 0.00124076, 0.038173, 0.0, 436.45, 436.45, 436.45, 1.0, 0.0, 1, -30.0, 30.0],
        [1255, 1259, 0.0013095, 0.0381141, 0.0, 436.45, 436.45, 436.45, 1.0, 0.0, 1, -30.0, 30.0],
        [1255, 1260, 0.000848761, 0.0214645, 0.0, 436.45, 436.45, 436.45, 1.0, 0.0, 1, -30.0, 30.0],
        [1255, 1261, 0.000845928, 0.0244161, 0.0, 436.45, 436.45, 436.45, 1.0, 0.0, 1, -30.0, 30.0],
        [1255, 1262, 0.138856, 4.34024, 0.0, 2.21, 2.21, 2.21, 1.0, 0.0, 1, -30.0, 30.0],
        [1264, 1266, 0.000568803, 0.0182665, 0.0, 603.85, 603.85, 603.85, 1.0, 0.0, 1, -30.0, 30.0],
        [1264, 1267, 0.000479159, 0.0147553, 0.0, 603.85, 603.85, 603.85, 1.0, 0.0, 1, -30.0, 30.0],
        [1265, 1264, 0.00486445, 0.113558, 0.0, 120.0, 120.0, 120.0, 1.025, 0.0, 1, -30.0, 30.0],
        [1269, 1271, 0.00070599, 0.0438287, 0.0, 359.22, 359.22, 359.22, 1.0625, 0.0, 1, -30.0, 30.0],
        [1269, 1272, 0.000298029, 0.0150527, 0.0, 353.55, 353.55, 353.55, 1.05, 0.0, 1, -30.0, 30.0],
        [1269, 1273, 0.000754788, 0.0470324, 0.0, 351.1, 351.1, 351.1, 1.0625, 0.0, 1, -30.0, 30.0],
        [1269, 1274, 0.000634379, 0.0320145, 0.0, 350.81, 350.81, 350.81, 1.0625, 0.0, 1, -30.0, 30.0],
        [1270, 1269, 0.000320024, 0.0193841, 0.0, 347.48, 347.48, 347.48, 1.00625, 0.0, 1, -30.0, 30.0],
        [1277, 1276, 0.00325919, 0.0919167, 0.0, 54.74, 54.74, 54.74, 1.025, 0.0, 1, -30.0, 30.0],
        [1279, 1281, 0.00138411, 0.0413246, 0.0, 325.78, 325.78, 325.78, 1.09375, 0.0, 1, -30.0, 30.0],
        [1279, 1282, 0.000756592, 0.0205126, 0.0, 325.78, 325.78, 325.78, 1.075, 0.0, 1, -30.0, 30.0],
        [1279, 1283, 0.00115149, 0.0359172, 0.0, 325.78, 325.78, 325.78, 1.09375, 0.0, 1, -30.0, 30.0],
        [1279, 1284, 0.000668062, 0.0217197, 0.0, 325.78, 325.78, 325.78, 1.075, 0.0, 1, -30.0, 30.0],
        [1279, 1285, 0.000623157, 0.020444, 0.0, 325.78, 325.78, 325.78, 1.075, 0.0, 1, -30.0, 30.0],
        [1280, 1279, 0.0077371, 0.195852, 0.0, 116.85, 116.85, 116.85, 1.0, 0.0, 1, -30.0, 30.0],
        [1280, 1279, 0.0077371, 0.195852, 0.0, 116.85, 116.85, 116.85, 1.0, 0.0, 1, -30.0, 30.0],
        [1280, 1279, 0.0077371, 0.195852, 0.0, 116.85, 116.85, 116.85, 1.0, 0.0, 1, -30.0, 30.0],
        [1280, 1279, 0.0077371, 0.195852, 0.0, 116.85, 116.85, 116.85, 1.0, 0.0, 1, -30.0, 30.0],
        [1287, 1289, 0.000669471, 0.0374293, 0.0, 404.57, 404.57, 404.57, 1.0, 0.0, 1, -30.0, 30.0],
        [1287, 1290, 0.000239238, 0.0131028, 0.0, 402.99, 402.99, 402.99, 1.0, 0.0, 1, -30.0, 30.0],
        [1287, 1291, 0.000319983, 0.0221799, 0.0, 401.82, 401.82, 401.82, 1.0, 0.0, 1, -30.0, 30.0],
        [1288, 1287, 0.000426836, 0.0288957, 0.0, 413.83, 413.83, 413.83, 1.025, 0.0, 1, -30.0, 30.0],
        [1293, 1295, 0.000312767, 0.0171889, 0.0, 440.64, 440.64, 440.64, 1.0375, 0.0, 1, -30.0, 30.0],
        [1293, 1296, 0.000386601, 0.0237745, 0.0, 439.58, 439.58, 439.58, 1.05, 0.0, 1, -30.0, 30.0],
        [1293, 1297, 0.000292704, 0.0181484, 0.0, 435.24, 435.24, 435.24, 1.0375, 0.0, 1, -30.0, 30.0],
        [1293, 1298, 0.000484994, 0.0270043, 0.0, 435.1, 435.1, 435.1, 1.05, 0.0, 1, -30.0, 30.0],
        [1294, 1293, 0.000532725, 0.0306357, 0.0, 372.66, 372.66, 372.66, 1.0, 0.0, 1, -30.0, 30.0],
        [1301, 1300, 0.00447345, 0.15633, 0.0, 95.65, 95.65, 95.65, 1.0, 0.0, 1, -30.0, 30.0],
        [1301, 1300, 0.00447345, 0.15633, 0.0, 95.65, 95.65, 95.65, 1.0, 0.0, 1, -30.0, 30.0],
        [1301, 1300, 0.00447345, 0.15633, 0.0, 95.65, 95.65, 95.65, 1.0, 0.0, 1, -30.0, 30.0],
        [1304, 1303, 0.000210868, 0.0129751, 0.0, 574.01, 574.01, 574.01, 1.0125, 0.0, 1, -30.0, 30.0],
        [1304, 1303, 0.000210868, 0.0129751, 0.0, 574.01, 574.01, 574.01, 1.0125, 0.0, 1, -30.0, 30.0],
        [1304, 1303, 0.000210868, 0.0129751, 0.0, 574.01, 574.01, 574.01, 1.0125, 0.0, 1, -30.0, 30.0],
        [1306, 1308, 0.000610989, 0.0313209, 0.0, 324.47, 324.47, 324.47, 1.0, 0.0, 1, -30.0, 30.0],
        [1306, 1309, 0.000448847, 0.0279348, 0.0, 321.21, 321.21, 321.21, 1.0, 0.0, 1, -30.0, 30.0],
        [1306, 1310, 0.00058653, 0.0323339, 0.0, 314.53, 314.53, 314.53, 1.0, 0.0, 1, -30.0, 30.0],
        [1306, 1311, 0.000653674, 0.0433285, 0.0, 310.04, 310.04, 310.04, 1.0, 0.0, 1, -30.0, 30.0],
        [1307, 1306, 0.000302662, 0.0182811, 0.0, 306.92, 306.92, 306.92, 1.00625, 0.0, 1, -30.0, 30.0],
        [1315, 1318, 0.000649212, 0.0346808, 0.0, 390.89, 390.89, 390.89, 1.0, 0.0, 1, -30.0, 30.0],
        [1315, 1319, 0.000534671, 0.0316431, 0.0, 390.48, 390.48, 390.48, 1.0, 0.0, 1, -30.0, 30.0],
        [1315, 1320, 0.00055555, 0.0358952, 0.0, 389.94, 389.94, 389.94, 1.0, 0.0, 1, -30.0, 30.0],
        [1316, 1315, 0.00046354, 0.0246602, 0.0, 387.12, 387.12, 387.12, 1.0, 0.0, 1, -30.0, 30.0],
        [1317, 1316, 0.00325591, 0.116644, 0.0, 89.19, 89.19, 89.19, 1.0, 0.0, 1, -30.0, 30.0],
        [1322, 1325, 0.000163161, 0.0112796, 0.0, 1214.85, 1214.85, 1214.85, 1.0, 0.0, 1, -30.0, 30.0],
        [1322, 1326, 0.00013235, 0.00823266, 0.0, 1214.85, 1214.85, 1214.85, 1.0, 0.0, 1, -30.0, 30.0],
        [1323, 1322, 0.000327338, 0.0202602, 0.0, 361.63, 361.63, 361.63, 1.0, 0.0, 1, -30.0, 30.0],
        [1324, 1323, 0.005376, 0.169639, 0.0, 150.0, 150.0, 150.0, 1.0, 0.0, 1, -30.0, 30.0],
        [1334, 1336, 0.00184783, 0.0566027, 0.0, 180.76, 180.76, 180.76, 0.98125, 0.0, 1, -30.0, 30.0],
        [1334, 1337, 0.00176878, 0.0556248, 0.0, 180.76, 180.76, 180.76, 0.98125, 0.0, 1, -30.0, 30.0],
        [1335, 1334, 0.00531102, 0.149587, 0.0, 75.19, 75.19, 75.19, 1.0, 0.0, 1, -30.0, 30.0],
        [1339, 1341, 0.000720114, 0.0229206, 0.0, 472.94, 472.94, 472.94, 1.0, 0.0, 1, -30.0, 30.0],
        [1340, 1339, 0.00557284, 0.17262, 0.0, 65.39, 65.39, 65.39, 1.0125, 0.0, 1, -30.0, 30.0],
        [1346, 1345, 0.00669846, 0.193678, 0.0, 81.96, 81.96, 81.96, 1.05, 0.0, 1, -30.0, 30.0],
        [1346, 1345, 0.00669846, 0.193678, 0.0, 81.96, 81.96, 81.96, 1.05, 0.0, 1, -30.0, 30.0],
        [1346, 1345, 0.00669846, 0.193678, 0.0, 81.96, 81.96, 81.96, 1.05, 0.0, 1, -30.0, 30.0],
        [1358, 1360, 0.000416634, 0.0247141, 0.0, 530.51, 530.51, 530.51, 1.0, 0.0, 1, -30.0, 30.0],
        [1358, 1361, 0.00018387, 0.0121597, 0.0, 530.51, 530.51, 530.51, 1.0, 0.0, 1, -30.0, 30.0],
        [1358, 1362, 0.000356104, 0.0248384, 0.0, 530.51, 530.51, 530.51, 1.0, 0.0, 1, -30.0, 30.0],
        [1358, 1363, 0.000475138, 0.0306649, 0.0, 530.51, 530.51, 530.51, 1.0, 0.0, 1, -30.0, 30.0],
        [1358, 1364, 0.000242145, 0.0144764, 0.0, 530.51, 530.51, 530.51, 1.0, 0.0, 1, -30.0, 30.0],
        [1358, 1365, 0.000430686, 0.0249461, 0.0, 530.51, 530.51, 530.51, 1.0, 0.0, 1, -30.0, 30.0],
        [1359, 1358, 0.000389034, 0.0212448, 0.0, 308.27, 308.27, 308.27, 1.00625, 0.0, 1, -30.0, 30.0],
        [1367, 1370, 0.000441395, 0.0300725, 0.0, 592.31, 592.31, 592.31, 1.0, 0.0, 1, -30.0, 30.0],
        [1367, 1371, 0.000227085, 0.0160471, 0.0, 592.31, 592.31, 592.31, 1.0, 0.0, 1, -30.0, 30.0],
        [1367, 1372, 0.000602761, 0.0297386, 0.0, 592.31, 592.31, 592.31, 1.0, 0.0, 1, -30.0, 30.0],
        [1367, 1373, 0.000376764, 0.023321, 0.0, 592.31, 592.31, 592.31, 1.0, 0.0, 1, -30.0, 30.0],
        [1368, 1367, 0.000605819, 0.0341366, 0.0, 322.55, 322.55, 322.55, 1.025, 0.0, 1, -30.0, 30.0],
        [1369, 1368, 0.00535161, 0.168312, 0.0, 75.92, 75.92, 75.92, 1.0125, 0.0, 1, -30.0, 30.0],
        [1375, 1377, 0.000214304, 0.0137379, 0.0, 490.21, 490.21, 490.21, 1.01875, 0.0, 1, -30.0, 30.0],
        [1375, 1378, 0.000410953, 0.0184473, 0.0, 490.21, 490.21, 490.21, 1.01875, 0.0, 1, -30.0, 30.0],
        [1375, 1379, 0.000286867, 0.0220216, 0.0, 490.21, 490.21, 490.21, 1.03125, 0.0, 1, -30.0, 30.0],
        [1375, 1380, 0.00035807, 0.0237028, 0.0, 490.21, 490.21, 490.21, 1.03125, 0.0, 1, -30.0, 30.0],
        [1375, 1381, 0.000572386, 0.0289535, 0.0, 490.21, 490.21, 490.21, 1.03125, 0.0, 1, -30.0, 30.0],
        [1375, 1382, 0.000379816, 0.023079, 0.0, 490.21, 490.21, 490.21, 1.03125, 0.0, 1, -30.0, 30.0],
        [1376, 1375, 0.000755561, 0.0363933, 0.0, 395.39, 395.39, 395.39, 1.01875, 0.0, 1, -30.0, 30.0],
        [1388, 1390, 0.00043046, 0.027225, 0.0, 414.15, 414.15, 414.15, 1.0, 0.0, 1, -30.0, 30.0],
        [1388, 1391, 0.000559195, 0.0366751, 0.0, 408.44, 408.44, 408.44, 1.0, 0.0, 1, -30.0, 30.0],
        [1388, 1392, 0.000715101, 0.0367522, 0.0, 407.59, 407.59, 407.59, 1.0, 0.0, 1, -30.0, 30.0],
        [1388, 1393, 0.00044067, 0.0320512, 0.0, 407.01, 407.01, 407.01, 1.0, 0.0, 1, -30.0, 30.0],
        [1388, 1394, 0.000409185, 0.0297471, 0.0, 404.63, 404.63, 404.63, 1.0, 0.0, 1, -30.0, 30.0],
        [1389, 1388, 0.000252717, 0.0194659, 0.0, 503.47, 503.47, 503.47, 1.0, 0.0, 1, -30.0, 30.0],
        [1389, 1388, 0.000252717, 0.0194659, 0.0, 503.47, 503.47, 503.47, 1.0, 0.0, 1, -30.0, 30.0],
        [1389, 1388, 0.000252717, 0.0194659, 0.0, 503.47, 503.47, 503.47, 1.0, 0.0, 1, -30.0, 30.0],
        [1396, 1398, 0.000765702, 0.0521757, 0.0, 371.08, 371.08, 371.08, 1.0875, 0.0, 1, -30.0, 30.0],
        [1396, 1399, 0.000465676, 0.0332952, 0.0, 367.51, 367.51, 367.51, 1.06875, 0.0, 1, -30.0, 30.0],
        [1396, 1400, 0.000301114, 0.0204812, 0.0, 364.36, 364.36, 364.36, 1.05625, 0.0, 1, -30.0, 30.0],
        [1397, 1396, 0.000836405, 0.0358005, 0.0, 299.68, 299.68, 299.68, 1.00625, 0.0, 1, -30.0, 30.0],
        [1402, 1404, 0.000147207, 0.0122103, 0.0, 1122.29, 1122.29, 1122.29, 1.0, 0.0, 1, -30.0, 30.0],
        [1402, 1405, 9.06137e-05, 0.00727964, 0.0, 1122.29, 1122.29, 1122.29, 1.0, 0.0, 1, -30.0, 30.0],
        [1403, 1402, 0.000303757, 0.0219457, 0.0, 505.54, 505.54, 505.54, 1.01875, 0.0, 1, -30.0, 30.0],
        [1403, 1402, 0.000303757, 0.0219457, 0.0, 505.54, 505.54, 505.54, 1.01875, 0.0, 1, -30.0, 30.0],
        [1403, 1402, 0.000303757, 0.0219457, 0.0, 505.54, 505.54, 505.54, 1.01875, 0.0, 1, -30.0, 30.0],
        [1408, 1407, 0.00493061, 0.127266, 0.0, 121.21, 121.21, 121.21, 1.025, 0.0, 1, -30.0, 30.0],
        [1408, 1407, 0.00493061, 0.127266, 0.0, 121.21, 121.21, 121.21, 1.025, 0.0, 1, -30.0, 30.0],
        [1408, 1407, 0.00493061, 0.127266, 0.0, 121.21, 121.21, 121.21, 1.025, 0.0, 1, -30.0, 30.0],
        [1408, 1407, 0.00493061, 0.127266, 0.0, 121.21, 121.21, 121.21, 1.025, 0.0, 1, -30.0, 30.0],
        [1416, 1417, 0.0037007, 0.0864387, 0.0, 212.09, 212.09, 212.09, 1.05, 0.0, 1, -30.0, 30.0],
        [1416, 1418, 0.00126548, 0.0427069, 0.0, 212.09, 212.09, 212.09, 1.05, 0.0, 1, -30.0, 30.0],
        [1420, 1421, 0.00165391, 0.0475702, 0.0, 159.12, 159.12, 159.12, 1.0375, 0.0, 1, -30.0, 30.0],
        [1424, 1423, 0.000477073, 0.0235593, 0.0, 393.03, 393.03, 393.03, 1.00625, 0.0, 1, -30.0, 30.0],
        [1427, 1426, 0.00521831, 0.141393, 0.0, 65.95, 65.95, 65.95, 1.025, 0.0, 1, -30.0, 30.0],
        [1431, 1432, 0.00352358, 0.0533121, 0.0, 216.45, 216.45, 216.45, 1.0, 0.0, 1, -30.0, 30.0],
        [1431, 1433, 0.00299241, 0.0597519, 0.0, 216.45, 216.45, 216.45, 1.0, 0.0, 1, -30.0, 30.0],
        [1435, 1438, 0.000807178, 0.0489689, 0.0, 282.69, 282.69, 282.69, 1.0, 0.0, 1, -30.0, 30.0],
        [1435, 1439, 0.000638045, 0.0536328, 0.0, 277.06, 277.06, 277.06, 1.0, 0.0, 1, -30.0, 30.0],
        [1435, 1440, 0.000749822, 0.0456448, 0.0, 272.79, 272.79, 272.79, 1.0, 0.0, 1, -30.0, 30.0],
        [1435, 1441, 0.00108577, 0.055487, 0.0, 264.65, 264.65, 264.65, 1.0, 0.0, 1, -30.0, 30.0],
        [1435, 1442, 0.000751797, 0.0393714, 0.0, 261.17, 261.17, 261.17, 1.0, 0.0, 1, -30.0, 30.0],
        [1435, 1443, 0.000574008, 0.041133, 0.0, 248.03, 248.03, 248.03, 1.0, 0.0, 1, -30.0, 30.0],
        [1436, 1435, 0.000379695, 0.0189188, 0.0, 530.43, 530.43, 530.43, 1.0, 0.0, 1, -30.0, 30.0],
        [1436, 1435, 0.000379695, 0.0189188, 0.0, 530.43, 530.43, 530.43, 1.0, 0.0, 1, -30.0, 30.0],
        [1436, 1435, 0.000379695, 0.0189188, 0.0, 530.43, 530.43, 530.43, 1.0, 0.0, 1, -30.0, 30.0],
        [1437, 1436, 0.0065692, 0.166151, 0.0, 94.26, 94.26, 94.26, 1.0, 0.0, 1, -30.0, 30.0],
        [1437, 1436, 0.0065692, 0.166151, 0.0, 94.26, 94.26, 94.26, 1.0, 0.0, 1, -30.0, 30.0],
        [1437, 1436, 0.0065692, 0.166151, 0.0, 94.26, 94.26, 94.26, 1.0, 0.0, 1, -30.0, 30.0],
        [1447, 1449, 0.00160434, 0.047762, 0.0, 169.13, 169.13, 169.13, 1.075, 0.0, 1, -30.0, 30.0],
        [1448, 1447, 0.00598162, 0.180514, 0.0, 86.56, 86.56, 86.56, 1.01875, 0.0, 1, -30.0, 30.0],
        [1448, 1447, 0.00598162, 0.180514, 0.0, 86.56, 86.56, 86.56, 1.01875, 0.0, 1, -30.0, 30.0],
        [1448, 1447, 0.00598162, 0.180514, 0.0, 86.56, 86.56, 86.56, 1.01875, 0.0, 1, -30.0, 30.0],
        [1451, 1453, 0.000481956, 0.0283016, 0.0, 394.99, 394.99, 394.99, 1.0625, 0.0, 1, -30.0, 30.0],
        [1451, 1454, 0.000434497, 0.0312239, 0.0, 392.15, 392.15, 392.15, 1.06875, 0.0, 1, -30.0, 30.0],
        [1451, 1455, 0.000530837, 0.0250677, 0.0, 391.48, 391.48, 391.48, 1.0625, 0.0, 1, -30.0, 30.0],
        [1452, 1451, 0.000276559, 0.0163949, 0.0, 350.46, 350.46, 350.46, 1.0125, 0.0, 1, -30.0, 30.0],
        [1458, 1457, 0.000614742, 0.0309945, 0.0, 488.74, 488.74, 488.74, 1.05, 0.0, 1, -30.0, 30.0],
        [1459, 1458, 0.00602683, 0.200568, 0.0, 83.03, 83.03, 83.03, 1.025, 0.0, 1, -30.0, 30.0],
        [1459, 1458, 0.00602683, 0.200568, 0.0, 83.03, 83.03, 83.03, 1.025, 0.0, 1, -30.0, 30.0],
        [1459, 1458, 0.00602683, 0.200568, 0.0, 83.03, 83.03, 83.03, 1.025, 0.0, 1, -30.0, 30.0],
        [1463, 1465, 0.00185842, 0.067418, 0.0, 149.18, 149.18, 149.18, 1.0625, 0.0, 1, -30.0, 30.0],
        [1463, 1466, 0.00262098, 0.0807659, 0.0, 149.18, 149.18, 149.18, 1.06875, 0.0, 1, -30.0, 30.0],
        [1464, 1463, 0.00625678, 0.153762, 0.0, 89.62, 89.62, 89.62, 1.0125, 0.0, 1, -30.0, 30.0],
        [1464, 1463, 0.00625678, 0.153762, 0.0, 89.62, 89.62, 89.62, 1.0125, 0.0, 1, -30.0, 30.0],
        [1464, 1463, 0.00625678, 0.153762, 0.0, 89.62, 89.62, 89.62, 1.0125, 0.0, 1, -30.0, 30.0],
        [1470, 1473, 0.000378113, 0.0233873, 0.0, 361.02, 361.02, 361.02, 1.0, 0.0, 1, -30.0, 30.0],
        [1470, 1474, 0.000631566, 0.030723, 0.0, 360.66, 360.66, 360.66, 1.0375, 0.0, 1, -30.0, 30.0],
        [1471, 1470, 0.000594159, 0.0381893, 0.0, 414.27, 414.27, 414.27, 1.0, 0.0, 1, -30.0, 30.0],
        [1472, 1471, 0.00475262, 0.130005, 0.0, 87.61, 87.61, 87.61, 1.0, 0.0, 1, -30.0, 30.0],
        [1472, 1471, 0.00475262, 0.130005, 0.0, 87.61, 87.61, 87.61, 1.0, 0.0, 1, -30.0, 30.0],
        [1472, 1471, 0.00475262, 0.130005, 0.0, 87.61, 87.61, 87.61, 1.0, 0.0, 1, -30.0, 30.0],
        [1476, 1479, 0.000434538, 0.0274846, 0.0, 514.02, 514.02, 514.02, 1.0, 0.0, 1, -30.0, 30.0],
        [1477, 1476, 0.000380475, 0.023634, 0.0, 319.63, 319.63, 319.63, 1.01875, 0.0, 1, -30.0, 30.0],
        [1478, 1477, 0.0065488, 0.160315, 0.0, 73.49, 73.49, 73.49, 1.025, 0.0, 1, -30.0, 30.0],
        [1482, 1481, 0.00455639, 0.169201, 0.0, 75.94, 75.94, 75.94, 1.025, 0.0, 1, -30.0, 30.0],
        [1490, 1489, 0.000492756, 0.0266389, 0.0, 352.42, 352.42, 352.42, 1.00625, 0.0, 1, -30.0, 30.0],
        [1543, 1542, 0.000515433, 0.0289168, 0.0, 580.88, 580.88, 580.88, 1.0, 0.0, 1, -30.0, 30.0],
        [1559, 1558, 0.000419743, 0.0248504, 0.0, 462.87, 462.87, 462.87, 1.0, 0.0, 1, -30.0, 30.0],
        [1563, 1562, 0.000316366, 0.0222741, 0.0, 502.94, 502.94, 502.94, 1.0, 0.0, 1, -30.0, 30.0],
        [1563, 1562, 0.000316366, 0.0222741, 0.0, 502.94, 502.94, 502.94, 1.0, 0.0, 1, -30.0, 30.0],
        [1563, 1562, 0.000316366, 0.0222741, 0.0, 502.94, 502.94, 502.94, 1.0, 0.0, 1, -30.0, 30.0],
        [1574, 1573, 0.000636752, 0.0318719, 0.0, 403.28, 403.28, 403.28, 1.0, 0.0, 1, -30.0, 30.0],
        [1603, 1602, 0.000432509, 0.0276677, 0.0, 264.57, 264.57, 264.57, 1.0125, 0.0, 1, -30.0, 30.0],
        [1622, 1621, 0.000510608, 0.0309302, 0.0, 493.79, 493.79, 493.79, 1.0, 0.0, 1, -30.0, 30.0],
        [1622, 1621, 0.000510608, 0.0309302, 0.0, 493.79, 493.79, 493.79, 1.0, 0.0, 1, -30.0, 30.0],
        [1622, 1621, 0.000510608, 0.0309302, 0.0, 493.79, 493.79, 493.79, 1.0, 0.0, 1, -30.0, 30.0],
        [1636, 1635, 0.000422552, 0.0283529, 0.0, 487.27, 487.27, 487.27, 1.025, 0.0, 1, -30.0, 30.0],
        [1636, 1635, 0.000422552, 0.0283529, 0.0, 487.27, 487.27, 487.27, 1.025, 0.0, 1, -30.0, 30.0],
        [1705, 1704, 0.000533, 0.027782, 0.0, 449.61, 449.61, 449.61, 1.0, 0.0, 1, -30.0, 30.0],
        [1735, 1734, 0.000333807, 0.0235814, 0.0, 499.65, 499.65, 499.65, 1.0125, 0.0, 1, -30.0, 30.0],
        [1735, 1734, 0.000333807, 0.0235814, 0.0, 499.65, 499.65, 499.65, 1.0125, 0.0, 1, -30.0, 30.0],
        [1735, 1734, 0.000333807, 0.0235814, 0.0, 499.65, 499.65, 499.65, 1.0125, 0.0, 1, -30.0, 30.0],
        [1769, 1768, 0.000350496, 0.0176872, 0.0, 397.85, 397.85, 397.85, 1.0125, 0.0, 1, -30.0, 30.0],
        [1792, 1791, 0.00184471, 0.055259, 0.0, 155.64, 155.64, 155.64, 1.05, 0.0, 1, -30.0, 30.0],
        [1795, 1794, 0.00136656, 0.0403767, 0.0, 199.62, 199.62, 199.62, 1.05, 0.0, 1, -30.0, 30.0],
        [1802, 1801, 0.00147735, 0.0384973, 0.0, 408.41, 408.41, 408.41, 1.025, 0.0, 1, -30.0, 30.0],
        [1804, 1803, 0.00110865, 0.0320628, 0.0, 182.01, 182.01, 182.01, 1.0, 0.0, 1, -30.0, 30.0],
        [1808, 1807, 0.00119019, 0.0303378, 0.0, 280.92, 280.92, 280.92, 1.05, 0.0, 1, -30.0, 30.0],
        [1813, 1812, 0.00143741, 0.0420235, 0.0, 265.15, 265.15, 265.15, 1.025, 0.0, 1, -30.0, 30.0],
        [1822, 1821, 0.00047096, 0.0247774, 0.0, 472.03, 472.03, 472.03, 1.0125, 0.0, 1, -30.0, 30.0],
        [1822, 1821, 0.00047096, 0.0247774, 0.0, 472.03, 472.03, 472.03, 1.0125, 0.0, 1, -30.0, 30.0],
        [1836, 1835, 0.000364613, 0.0242122, 0.0, 504.77, 504.77, 504.77, 1.025, 0.0, 1, -30.0, 30.0],
        [1836, 1835, 0.000364613, 0.0242122, 0.0, 504.77, 504.77, 504.77, 1.025, 0.0, 1, -30.0, 30.0],
        [1836, 1835, 0.000364613, 0.0242122, 0.0, 504.77, 504.77, 504.77, 1.025, 0.0, 1, -30.0, 30.0],
        [1846, 1845, 0.000691005, 0.0352925, 0.0, 310.66, 310.66, 310.66, 1.025, 0.0, 1, -30.0, 30.0],
        [1860, 1861, 0.00162475, 0.0419406, 0.0, 379.08, 379.08, 379.08, 1.0625, 0.0, 1, -30.0, 30.0],
        [1865, 1867, 0.000194433, 0.0129195, 0.0, 793.88, 793.88, 793.88, 1.0, 0.0, 1, -30.0, 30.0],
        [1865, 1868, 0.000273253, 0.0142651, 0.0, 793.88, 793.88, 793.88, 1.0, 0.0, 1, -30.0, 30.0],
        [1865, 1869, 0.00023872, 0.0156723, 0.0, 793.88, 793.88, 793.88, 1.0, 0.0, 1, -30.0, 30.0],
        [1865, 1870, 0.000427735, 0.0233479, 0.0, 793.88, 793.88, 793.88, 1.0, 0.0, 1, -30.0, 30.0],
        [1866, 1865, 0.000462011, 0.0313416, 0.0, 320.93, 320.93, 320.93, 1.0125, 0.0, 1, -30.0, 30.0],
        [1873, 1872, 0.000521452, 0.0349089, 0.0, 335.96, 335.96, 335.96, 1.00625, 0.0, 1, -30.0, 30.0],
        [1878, 1877, 0.000503095, 0.0278185, 0.0, 418.79, 418.79, 418.79, 1.0, 0.0, 1, -30.0, 30.0],
        [1882, 1883, 0.00165753, 0.0465107, 0.0, 262.95, 262.95, 262.95, 0.9875, 0.0, 1, -30.0, 30.0],
        [1882, 1884, 0.00190005, 0.0535015, 0.0, 259.88, 259.88, 259.88, 0.9875, 0.0, 1, -30.0, 30.0],
        [1886, 1887, 0.00181665, 0.0477125, 0.0, 306.17, 306.17, 306.17, 1.01875, 0.0, 1, -30.0, 30.0],
        [1886, 1888, 0.00151806, 0.0402758, 0.0, 302.63, 302.63, 302.63, 1.0125, 0.0, 1, -30.0, 30.0],
        [1886, 1889, 0.0186145, 0.56624, 0.0, 25.54, 25.54, 25.54, 1.0, 0.0, 1, -30.0, 30.0],
        [1886, 1890, 0.00476797, 0.130904, 0.0, 120.77, 120.77, 120.77, 1.0, 0.0, 1, -30.0, 30.0],
        [1893, 1892, 0.000315627, 0.0198888, 0.0, 416.81, 416.81, 416.81, 1.0125, 0.0, 1, -30.0, 30.0],
        [1895, 1897, 0.000452538, 0.0314991, 0.0, 361.5, 361.5, 361.5, 1.01875, 0.0, 1, -30.0, 30.0],
        [1895, 1898, 0.000315758, 0.02228, 0.0, 361.49, 361.49, 361.49, 1.0125, 0.0, 1, -30.0, 30.0],
        [1895, 1899, 0.000934461, 0.0658973, 0.0, 185.18, 185.18, 185.18, 1.0, 0.0, 1, -30.0, 30.0],
        [1896, 1895, 0.000633272, 0.0405052, 0.0, 511.57, 511.57, 511.57, 1.0, 0.0, 1, -30.0, 30.0],
        [1896, 1895, 0.000633272, 0.0405052, 0.0, 511.57, 511.57, 511.57, 1.0, 0.0, 1, -30.0, 30.0],
        [1896, 1895, 0.000633272, 0.0405052, 0.0, 511.57, 511.57, 511.57, 1.0, 0.0, 1, -30.0, 30.0],
        [1901, 1903, 0.000554941, 0.0315294, 0.0, 424.14, 424.14, 424.14, 1.0, 0.0, 1, -30.0, 30.0],
        [1901, 1904, 0.000564092, 0.0319121, 0.0, 421.24, 421.24, 421.24, 1.0, 0.0, 1, -30.0, 30.0],
        [1901, 1905, 0.000526245, 0.0305397, 0.0, 417.69, 417.69, 417.69, 1.0, 0.0, 1, -30.0, 30.0],
        [1901, 1906, 0.000595734, 0.0408934, 0.0, 417.66, 417.66, 417.66, 1.0, 0.0, 1, -30.0, 30.0],
        [1902, 1901, 0.000523025, 0.0267109, 0.0, 490.23, 490.23, 490.23, 1.0, 0.0, 1, -30.0, 30.0],
        [1902, 1901, 0.000523025, 0.0267109, 0.0, 490.23, 490.23, 490.23, 1.0, 0.0, 1, -30.0, 30.0],
        [1910, 1912, 0.000806667, 0.0465237, 0.0, 287.75, 287.75, 287.75, 1.03125, 0.0, 1, -30.0, 30.0],
        [1910, 1913, 0.00081102, 0.0546728, 0.0, 286.7, 286.7, 286.7, 1.0375, 0.0, 1, -30.0, 30.0],
        [1911, 1910, 0.00033763, 0.022652, 0.0, 482.45, 482.45, 482.45, 1.0125, 0.0, 1, -30.0, 30.0],
        [1911, 1910, 0.00033763, 0.022652, 0.0, 482.45, 482.45, 482.45, 1.0125, 0.0, 1, -30.0, 30.0],
        [1911, 1914, 0.00107441, 0.032384, 0.0, 194.47, 194.47, 194.47, 1.01875, 0.0, 1, -30.0, 30.0],
        [1911, 1915, 0.00367955, 0.0987562, 0.0, 99.9, 99.9, 99.9, 1.0, 0.0, 1, -30.0, 30.0],
        [1934, 1933, 0.000626566, 0.0352084, 0.0, 421.2, 421.2, 421.2, 1.0125, 0.0, 1, -30.0, 30.0],
        [1937, 1936, 0.000409907, 0.0253585, 0.0, 315.91, 315.91, 315.91, 1.0, 0.0, 1, -30.0, 30.0],
        [1941, 1942, 0.000897292, 0.0264097, 0.0, 386.75, 386.75, 386.75, 1.0, 0.0, 1, -30.0, 30.0],
        [1941, 1943, 0.00104162, 0.0278984, 0.0, 386.75, 386.75, 386.75, 1.0, 0.0, 1, -30.0, 30.0],
        [1945, 1946, 0.00167539, 0.0501291, 0.0, 290.13, 290.13, 290.13, 1.06875, 0.0, 1, -30.0, 30.0],
        [1948, 1950, 0.000567739, 0.0330324, 0.0, 383.33, 383.33, 383.33, 1.03125, 0.0, 1, -30.0, 30.0],
        [1949, 1948, 0.000609914, 0.0350336, 0.0, 437.91, 437.91, 437.91, 1.025, 0.0, 1, -30.0, 30.0],
        [1954, 1956, 0.000519862, 0.0358342, 0.0, 388.09, 388.09, 388.09, 1.0, 0.0, 1, -30.0, 30.0],
        [1954, 1957, 0.000685279, 0.0408862, 0.0, 384.87, 384.87, 384.87, 1.0, 0.0, 1, -30.0, 30.0],
        [1954, 1958, 0.000732376, 0.0408424, 0.0, 383.51, 383.51, 383.51, 1.0, 0.0, 1, -30.0, 30.0],
        [1955, 1954, 0.000455686, 0.0282318, 0.0, 629.16, 629.16, 629.16, 1.0, 0.0, 1, -30.0, 30.0],
        [1960, 1962, 0.000290708, 0.01882, 0.0, 399.18, 399.18, 399.18, 1.0375, 0.0, 1, -30.0, 30.0],
        [1960, 1963, 0.000454166, 0.0312431, 0.0, 397.54, 397.54, 397.54, 1.04375, 0.0, 1, -30.0, 30.0],
        [1960, 1964, 0.00054706, 0.0316451, 0.0, 395.31, 395.31, 395.31, 1.05, 0.0, 1, -30.0, 30.0],
        [1961, 1960, 0.000331342, 0.0181445, 0.0, 499.79, 499.79, 499.79, 1.0125, 0.0, 1, -30.0, 30.0],
        [1961, 1960, 0.000331342, 0.0181445, 0.0, 499.79, 499.79, 499.79, 1.0125, 0.0, 1, -30.0, 30.0],
        [1961, 1960, 0.000331342, 0.0181445, 0.0, 499.79, 499.79, 499.79, 1.0125, 0.0, 1, -30.0, 30.0],
        [1966, 1968, 0.000556982, 0.0397223, 0.0, 233.27, 233.27, 233.27, 1.0, 0.0, 1, -30.0, 30.0],
        [1966, 1969, 0.000406014, 0.028282, 0.0, 232.29, 232.29, 232.29, 1.0, 0.0, 1, -30.0, 30.0],
        [1967, 1966, 0.000371826, 0.0267792, 0.0, 405.4, 405.4, 405.4, 1.0, 0.0, 1, -30.0, 30.0],
        [1971, 1973, 0.000384662, 0.0216965, 0.0, 415.27, 415.27, 415.27, 1.0, 0.0, 1, -30.0, 30.0],
        [1972, 1971, 0.000796482, 0.0318587, 0.0, 584.42, 584.42, 584.42, 1.01875, 0.0, 1, -30.0, 30.0],
        [1975, 1976, 0.000590612, 0.0162989, 0.0, 732.81, 732.81, 732.81, 1.0, 0.0, 1, -30.0, 30.0],
        [1978, 1979, 0.00154278, 0.0433045, 0.0, 237.5, 237.5, 237.5, 1.00625, 0.0, 1, -30.0, 30.0],
        [1978, 1980, 0.00268462, 0.0698978, 0.0, 206.72, 206.72, 206.72, 1.00625, 0.0, 1, -30.0, 30.0],
        [1978, 1981, 0.00262636, 0.0648455, 0.0, 206.27, 206.27, 206.27, 1.00625, 0.0, 1, -30.0, 30.0],
        [1984, 1983, 0.000514187, 0.026485, 0.0, 498.38, 498.38, 498.38, 1.025, 0.0, 1, -30.0, 30.0],
        [1984, 1983, 0.000514187, 0.026485, 0.0, 498.38, 498.38, 498.38, 1.025, 0.0, 1, -30.0, 30.0],
        [1984, 1983, 0.000514187, 0.026485, 0.0, 498.38, 498.38, 498.38, 1.025, 0.0, 1, -30.0, 30.0],
        [1986, 1987, 0.000215645, 0.00651592, 0.0, 882.7, 882.7, 882.7, 1.0, 0.0, 1, -30.0, 30.0],
        [1986, 1988, 0.000354642, 0.0103789, 0.0, 882.7, 882.7, 882.7, 1.0, 0.0, 1, -30.0, 30.0],
        [1990, 1992, 0.000483841, 0.029371, 0.0, 515.19, 515.19, 515.19, 1.0, 0.0, 1, -30.0, 30.0],
        [1990, 1993, 0.00054628, 0.0305143, 0.0, 515.19, 515.19, 515.19, 1.0, 0.0, 1, -30.0, 30.0],
        [1990, 1994, 0.000486808, 0.0281122, 0.0, 515.19, 515.19, 515.19, 1.0, 0.0, 1, -30.0, 30.0],
        [1990, 1995, 0.000437113, 0.0288209, 0.0, 515.19, 515.19, 515.19, 1.0, 0.0, 1, -30.0, 30.0],
        [1990, 1996, 0.000204601, 0.0131521, 0.0, 515.19, 515.19, 515.19, 1.0, 0.0, 1, -30.0, 30.0],
        [1990, 1997, 0.00043835, 0.0253691, 0.0, 515.19, 515.19, 515.19, 1.0, 0.0, 1, -30.0, 30.0],
        [1991, 1990, 0.000717614, 0.020275, 0.0, 491.85, 491.85, 491.85, 1.0, 0.0, 1, -30.0, 30.0],
        [1991, 1990, 0.000717614, 0.020275, 0.0, 491.85, 491.85, 491.85, 1.0, 0.0, 1, -30.0, 30.0]    ])

    ## generator cost data
    # 2 startup shutdown n x1 y1 ... xn yn
    ppc["gencost"] = array([
        [2, 0.0, 0.0, 3, 0.016330, 21.370000, -2.678000],
        [2, 0.0, 0.0, 3, 0.012020, 21.100000, -2.186000],
        [2, 0.0, 0.0, 3, 0.016560, 22.010000, -2.770000],
        [2, 0.0, 0.0, 3, 0.012130, 19.750000, -2.049000],
        [2, 0.0, 0.0, 3, 0.014590, 24.090000, -2.724000],
        [2, 0.0, 0.0, 3, 0.019080, 19.760000, -2.386000],
        [2, 0.0, 0.0, 3, 0.000000, 17.000000, -1.619000],
        [2, 0.0, 0.0, 3, 0.001030, 9.129000, 0.000000],
        [2, 0.0, 0.0, 3, 0.001759, 8.167000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 17.390000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 14.990000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 14.550000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 14.170000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 16.790000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 17.210000, 0.000000],
        [2, 0.0, 0.0, 3, 0.026360, 20.610000, -2.442000],
        [2, 0.0, 0.0, 3, 0.019850, 17.370000, -2.014000],
        [2, 0.0, 0.0, 3, 0.014020, 21.620000, -2.032000],
        [2, 0.0, 0.0, 3, 0.015900, 19.400000, -2.187000],
        [2, 0.0, 0.0, 3, 0.019070, 19.250000, -2.470000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.018820, 19.240000, -1.694000],
        [2, 0.0, 0.0, 3, 0.013910, 16.010000, -1.180000],
        [2, 0.0, 0.0, 3, 0.010590, 18.900000, -1.149000],
        [2, 0.0, 0.0, 3, 0.016170, 21.530000, -1.659000],
        [2, 0.0, 0.0, 3, 0.013830, 17.440000, -1.276000],
        [2, 0.0, 0.0, 3, 0.013920, 15.920000, -1.169000],
        [2, 0.0, 0.0, 3, 0.001700, 8.322000, 0.000000],
        [2, 0.0, 0.0, 3, 0.001699, 8.325000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 17.950000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 15.700000, -13.460000],
        [2, 0.0, 0.0, 3, 0.000000, 17.590000, -15.850000],
        [2, 0.0, 0.0, 3, 0.000000, 16.800000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 18.720000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 15.600000, -12.390000],
        [2, 0.0, 0.0, 3, 0.014500, 14.870000, 0.000000],
        [2, 0.0, 0.0, 3, 0.011840, 18.040000, -1.020000],
        [2, 0.0, 0.0, 3, 0.014490, 16.990000, 0.000000],
        [2, 0.0, 0.0, 3, 0.020170, 17.960000, -1.156000],
        [2, 0.0, 0.0, 3, 0.017080, 16.480000, 0.000000],
        [2, 0.0, 0.0, 3, 0.013580, 14.240000, 0.000000],
        [2, 0.0, 0.0, 3, 0.020420, 25.400000, -7.217000],
        [2, 0.0, 0.0, 3, 0.020650, 22.280000, -5.772000],
        [2, 0.0, 0.0, 3, 0.011620, 29.890000, -5.213000],
        [2, 0.0, 0.0, 3, 0.026980, 23.340000, -6.146000],
        [2, 0.0, 0.0, 3, 0.020780, 17.190000, -4.678000],
        [2, 0.0, 0.0, 3, 0.019060, 26.830000, -6.793000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.018640, 19.460000, -1.724000],
        [2, 0.0, 0.0, 3, 0.020250, 21.280000, -2.006000],
        [2, 0.0, 0.0, 3, 0.000000, 15.850000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 14.680000, 0.000000],
        [2, 0.0, 0.0, 3, 0.012640, 21.190000, -2.482000],
        [2, 0.0, 0.0, 3, 0.023040, 18.720000, -2.847000],
        [2, 0.0, 0.0, 3, 0.012490, 20.530000, -2.495000],
        [2, 0.0, 0.0, 3, 0.019290, 17.330000, -2.237000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 24.770000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 23.890000, 0.000000],
        [2, 0.0, 0.0, 3, 0.023410, 27.190000, -1.626000],
        [2, 0.0, 0.0, 3, 0.019040, 27.540000, -1.546000],
        [2, 0.0, 0.0, 3, 0.026120, 28.970000, -1.581000],
        [2, 0.0, 0.0, 3, 0.000000, 27.490000, -54.620000],
        [2, 0.0, 0.0, 3, 0.000000, 28.490000, -40.200000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.027540, 26.150000, -2.426000],
        [2, 0.0, 0.0, 3, 0.033750, 29.900000, -3.238000],
        [2, 0.0, 0.0, 3, 0.030040, 32.670000, -3.029000],
        [2, 0.0, 0.0, 3, 0.028100, 29.570000, -3.073000],
        [2, 0.0, 0.0, 3, 0.029070, 33.100000, -3.287000],
        [2, 0.0, 0.0, 3, 0.000000, 26.420000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 23.670000, 0.000000],
        [2, 0.0, 0.0, 3, 0.027860, 27.390000, -2.660000],
        [2, 0.0, 0.0, 3, 0.034250, 26.960000, -2.562000],
        [2, 0.0, 0.0, 3, 0.025260, 34.170000, -3.145000],
        [2, 0.0, 0.0, 3, 0.029600, 27.690000, -2.616000],
        [2, 0.0, 0.0, 3, 0.000000, 27.640000, 0.000000],
        [2, 0.0, 0.0, 3, 0.030600, 27.070000, -1.764000],
        [2, 0.0, 0.0, 3, 0.034700, 31.910000, -2.326000],
        [2, 0.0, 0.0, 3, 0.026410, 28.690000, -2.552000],
        [2, 0.0, 0.0, 3, 0.026800, 30.990000, -4.106000],
        [2, 0.0, 0.0, 3, 0.024290, 32.580000, -4.626000],
        [2, 0.0, 0.0, 3, 0.031500, 30.790000, -4.019000],
        [2, 0.0, 0.0, 3, 0.030240, 30.230000, -4.252000],
        [2, 0.0, 0.0, 3, 0.033730, 29.460000, -4.014000],
        [2, 0.0, 0.0, 3, 0.027190, 29.530000, -4.077000],
        [2, 0.0, 0.0, 3, 0.000000, 24.590000, 0.000000],
        [2, 0.0, 0.0, 3, 0.064010, 39.890000, -13.580000],
        [2, 0.0, 0.0, 3, 0.075690, 39.520000, -13.630000],
        [2, 0.0, 0.0, 3, 0.018590, 30.360000, -2.086000],
        [2, 0.0, 0.0, 3, 0.019940, 29.900000, -2.177000],
        [2, 0.0, 0.0, 3, 0.026570, 25.400000, -2.084000],
        [2, 0.0, 0.0, 3, 0.026700, 30.430000, -2.712000],
        [2, 0.0, 0.0, 3, 0.000000, 27.950000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 24.810000, -9.402000],
        [2, 0.0, 0.0, 3, 0.000000, 26.840000, -9.579000],
        [2, 0.0, 0.0, 3, 0.029000, 26.400000, -2.688000],
        [2, 0.0, 0.0, 3, 0.023990, 29.870000, -3.309000],
        [2, 0.0, 0.0, 3, 0.021510, 32.620000, -3.169000],
        [2, 0.0, 0.0, 3, 0.018140, 33.130000, -2.925000],
        [2, 0.0, 0.0, 3, 0.029630, 28.730000, -3.319000],
        [2, 0.0, 0.0, 3, 0.019670, 35.420000, -2.741000],
        [2, 0.0, 0.0, 3, 0.019490, 29.910000, -2.624000],
        [2, 0.0, 0.0, 3, 0.028880, 34.360000, -3.224000],
        [2, 0.0, 0.0, 3, 0.025300, 36.570000, -4.649000],
        [2, 0.0, 0.0, 3, 0.021940, 39.920000, -4.583000],
        [2, 0.0, 0.0, 3, 0.022130, 31.190000, -3.989000],
        [2, 0.0, 0.0, 3, 0.021080, 33.810000, -4.054000],
        [2, 0.0, 0.0, 3, 0.000000, 24.640000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 27.900000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 28.820000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 28.220000, -20.920000],
        [2, 0.0, 0.0, 3, 0.000000, 29.390000, -33.230000],
        [2, 0.0, 0.0, 3, 0.000000, 22.690000, 0.000000],
        [2, 0.0, 0.0, 3, 0.035560, 30.220000, -3.324000],
        [2, 0.0, 0.0, 3, 0.034520, 29.800000, -3.435000],
        [2, 0.0, 0.0, 3, 0.022020, 28.880000, -2.864000],
        [2, 0.0, 0.0, 3, 0.022020, 28.750000, -2.089000],
        [2, 0.0, 0.0, 3, 0.028370, 27.650000, -2.337000],
        [2, 0.0, 0.0, 3, 0.020730, 30.250000, -2.185000],
        [2, 0.0, 0.0, 3, 0.030270, 26.810000, -1.859000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.034270, 27.540000, -2.959000],
        [2, 0.0, 0.0, 3, 0.022210, 30.390000, -2.577000],
        [2, 0.0, 0.0, 3, 0.025580, 29.290000, -2.630000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 28.390000, -33.640000],
        [2, 0.0, 0.0, 3, 0.000000, 28.910000, -49.180000],
        [2, 0.0, 0.0, 3, 0.000000, 29.590000, -53.360000],
        [2, 0.0, 0.0, 3, 0.000000, 0.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 0.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 0.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 0.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.020750, 26.750000, -1.370000],
        [2, 0.0, 0.0, 3, 0.016860, 30.820000, -1.447000],
        [2, 0.0, 0.0, 3, 0.057680, 46.130000, -11.660000],
        [2, 0.0, 0.0, 3, 0.000000, 25.330000, -12.060000],
        [2, 0.0, 0.0, 3, 0.000000, 25.660000, -4.680000],
        [2, 0.0, 0.0, 3, 0.000000, 24.700000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 26.630000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 27.190000, -6.785000],
        [2, 0.0, 0.0, 3, 0.000000, 24.980000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 26.850000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 0.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 0.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 24.290000, -3.684000],
        [2, 0.0, 0.0, 3, 0.000000, 27.130000, -6.071000],
        [2, 0.0, 0.0, 3, 0.026950, 39.130000, -6.398000],
        [2, 0.0, 0.0, 3, 0.039770, 30.070000, -5.243000],
        [2, 0.0, 0.0, 3, 0.028930, 34.570000, -6.352000],
        [2, 0.0, 0.0, 3, 0.023620, 40.790000, -6.121000],
        [2, 0.0, 0.0, 3, 0.027950, 37.180000, -6.334000],
        [2, 0.0, 0.0, 3, 0.031930, 29.680000, -5.362000],
        [2, 0.0, 0.0, 3, 0.076050, 51.290000, -17.350000],
        [2, 0.0, 0.0, 3, 0.082770, 40.290000, -15.230000],
        [2, 0.0, 0.0, 3, 0.071450, 38.330000, -14.300000],
        [2, 0.0, 0.0, 3, 0.067630, 41.080000, -13.860000],
        [2, 0.0, 0.0, 3, 0.025650, 26.950000, -3.765000],
        [2, 0.0, 0.0, 3, 0.032690, 35.340000, -5.969000],
        [2, 0.0, 0.0, 3, 0.023690, 38.060000, -5.211000],
        [2, 0.0, 0.0, 3, 0.030170, 29.840000, -5.257000],
        [2, 0.0, 0.0, 3, 0.031750, 36.530000, -6.418000],
        [2, 0.0, 0.0, 3, 0.030190, 29.900000, -4.161000],
        [2, 0.0, 0.0, 3, 0.000000, 25.840000, -6.588000],
        [2, 0.0, 0.0, 3, 0.000000, 24.610000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.017770, 33.220000, -2.811000],
        [2, 0.0, 0.0, 3, 0.018550, 32.790000, -2.878000],
        [2, 0.0, 0.0, 3, 0.030830, 29.760000, -3.390000],
        [2, 0.0, 0.0, 3, 0.030300, 30.920000, -3.063000],
        [2, 0.0, 0.0, 3, 0.026870, 27.250000, -3.079000],
        [2, 0.0, 0.0, 3, 0.035290, 26.840000, -2.686000],
        [2, 0.0, 0.0, 3, 0.024960, 29.200000, -2.467000],
        [2, 0.0, 0.0, 3, 0.036440, 28.870000, -2.854000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 28.520000, -18.400000],
        [2, 0.0, 0.0, 3, 0.000000, 25.620000, -3.884000],
        [2, 0.0, 0.0, 3, 0.000000, 23.310000, -3.982000],
        [2, 0.0, 0.0, 3, 0.000000, 30.130000, 0.000000],
        [2, 0.0, 0.0, 3, 0.047800, 35.250000, -2.658000],
        [2, 0.0, 0.0, 3, 0.042430, 34.620000, -2.848000],
        [2, 0.0, 0.0, 3, 0.027000, 26.830000, -1.056000],
        [2, 0.0, 0.0, 3, 0.029670, 36.330000, -7.979000],
        [2, 0.0, 0.0, 3, 0.029820, 32.190000, -6.679000],
        [2, 0.0, 0.0, 3, 0.000000, 26.110000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 23.870000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 26.750000, -11.630000],
        [2, 0.0, 0.0, 3, 0.000000, 27.230000, 0.000000],
        [2, 0.0, 0.0, 3, 0.017480, 30.130000, -1.799000],
        [2, 0.0, 0.0, 3, 0.027420, 30.740000, -2.511000],
        [2, 0.0, 0.0, 3, 0.025810, 27.470000, -1.610000],
        [2, 0.0, 0.0, 3, 0.018060, 26.620000, -1.373000],
        [2, 0.0, 0.0, 3, 0.015890, 27.630000, -1.274000],
        [2, 0.0, 0.0, 3, 0.021160, 24.820000, -1.303000],
        [2, 0.0, 0.0, 3, 0.026720, 27.570000, -1.831000],
        [2, 0.0, 0.0, 3, 0.026800, 26.200000, -1.183000],
        [2, 0.0, 0.0, 3, 0.000000, 26.690000, -33.490000],
        [2, 0.0, 0.0, 3, 0.000000, 29.090000, -39.450000],
        [2, 0.0, 0.0, 3, 0.000000, 28.020000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 27.600000, 0.000000],
        [2, 0.0, 0.0, 3, 0.030140, 28.090000, -1.545000],
        [2, 0.0, 0.0, 3, 0.022710, 30.520000, -2.755000],
        [2, 0.0, 0.0, 3, 0.026560, 28.540000, -2.911000],
        [2, 0.0, 0.0, 3, 0.034700, 28.170000, -2.694000],
        [2, 0.0, 0.0, 3, 0.000000, 28.390000, -12.290000],
        [2, 0.0, 0.0, 3, 0.000000, 26.530000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 27.010000, -11.700000],
        [2, 0.0, 0.0, 3, 0.000000, 27.970000, -25.120000],
        [2, 0.0, 0.0, 3, 0.000000, 28.320000, -24.590000],
        [2, 0.0, 0.0, 3, 0.000000, 24.890000, -16.720000],
        [2, 0.0, 0.0, 3, 0.000000, 29.480000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.530000, -27.320000],
        [2, 0.0, 0.0, 3, 0.022750, 28.760000, -1.499000],
        [2, 0.0, 0.0, 3, 0.017620, 28.180000, -1.267000],
        [2, 0.0, 0.0, 3, 0.000000, 24.110000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 27.860000, -5.433000],
        [2, 0.0, 0.0, 3, 0.023340, 31.330000, -2.633000],
        [2, 0.0, 0.0, 3, 0.032340, 27.940000, -2.118000],
        [2, 0.0, 0.0, 3, 0.049650, 62.470000, -12.660000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 24.220000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 26.700000, -10.140000],
        [2, 0.0, 0.0, 3, 0.068940, 36.430000, -6.560000],
        [2, 0.0, 0.0, 3, 0.000000, 26.880000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 25.490000, 0.000000],
        [2, 0.0, 0.0, 3, 0.087560, 46.560000, -21.500000],
        [2, 0.0, 0.0, 3, 0.052730, 74.480000, -20.090000],
        [2, 0.0, 0.0, 3, 0.084940, 68.780000, -27.580000],
        [2, 0.0, 0.0, 3, 0.096660, 44.480000, -19.550000],
        [2, 0.0, 0.0, 3, 0.000000, 35.260000, -23.850000],
        [2, 0.0, 0.0, 3, 0.000000, 36.720000, -18.640000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 34.050000, -26.490000],
        [2, 0.0, 0.0, 3, 0.000000, 37.740000, -32.880000],
        [2, 0.0, 0.0, 3, 0.051650, 44.600000, -4.878000],
        [2, 0.0, 0.0, 3, 0.026950, 39.750000, -2.886000],
        [2, 0.0, 0.0, 3, 0.023440, 35.050000, -2.790000],
        [2, 0.0, 0.0, 3, 0.029600, 26.180000, -1.993000],
        [2, 0.0, 0.0, 3, 0.000000, 24.550000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 27.520000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 25.340000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.027430, 31.010000, -2.787000],
        [2, 0.0, 0.0, 3, 0.037980, 27.220000, -2.450000],
        [2, 0.0, 0.0, 3, 0.000000, 27.460000, 0.000000],
        [2, 0.0, 0.0, 3, 0.041440, 47.290000, -7.598000],
        [2, 0.0, 0.0, 3, 0.072790, 40.500000, -7.724000],
        [2, 0.0, 0.0, 3, 0.057000, 41.110000, -8.072000],
        [2, 0.0, 0.0, 3, 0.059370, 49.020000, -9.042000],
        [2, 0.0, 0.0, 3, 0.000000, 26.200000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 31.910000, -47.910000],
        [2, 0.0, 0.0, 3, 0.000000, 26.290000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 25.850000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 25.600000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 26.850000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 28.320000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 26.690000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 27.370000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 24.980000, 0.000000],
        [2, 0.0, 0.0, 3, 0.026680, 29.730000, -2.025000],
        [2, 0.0, 0.0, 3, 0.026680, 27.770000, -1.526000],
        [2, 0.0, 0.0, 3, 0.000000, 24.410000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 27.070000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 25.720000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 0.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 0.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 0.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 0.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 26.620000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 28.830000, -3.836000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 28.460000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 26.160000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 26.110000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 31.790000, -42.120000],
        [2, 0.0, 0.0, 3, 0.000000, 27.410000, -6.762000],
        [2, 0.0, 0.0, 3, 0.000000, 28.560000, -9.464000],
        [2, 0.0, 0.0, 3, 0.000000, 28.680000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 25.470000, -6.823000],
        [2, 0.0, 0.0, 3, 0.000000, 27.080000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 26.110000, -8.847000],
        [2, 0.0, 0.0, 3, 0.000000, 28.190000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 29.640000, -9.633000],
        [2, 0.0, 0.0, 3, 0.000000, 26.720000, -14.910000],
        [2, 0.0, 0.0, 3, 0.000000, 29.180000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 27.140000, -14.200000],
        [2, 0.0, 0.0, 3, 0.000000, 28.260000, -14.610000],
        [2, 0.0, 0.0, 3, 0.000000, 28.170000, -9.208000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.038360, 32.160000, -2.940000],
        [2, 0.0, 0.0, 3, 0.025680, 37.790000, -3.317000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.000000, 30.000000, 0.000000],
        [2, 0.0, 0.0, 3, 0.038370, 28.430000, -2.564000],
        [2, 0.0, 0.0, 3, 0.024770, 31.400000, -2.842000],
        [2, 0.0, 0.0, 3, 0.033650, 26.610000, -2.174000],
        [2, 0.0, 0.0, 3, 0.032020, 29.200000, -2.244000],
        [2, 0.0, 0.0, 3, 0.028110, 32.580000, -3.395000],
        [2, 0.0, 0.0, 3, 0.024070, 31.180000, -2.922000],
        [2, 0.0, 0.0, 3, 0.022470, 27.330000, -1.046000],
        [2, 0.0, 0.0, 3, 0.032450, 32.160000, -1.745000],
        [2, 0.0, 0.0, 3, 0.036880, 43.320000, -5.610000],
        [2, 0.0, 0.0, 3, 0.032210, 32.980000, -6.626000],
        [2, 0.0, 0.0, 3, 0.017290, 31.760000, -1.292000],
        [2, 0.0, 0.0, 3, 0.025050, 31.700000, -1.593000],
        [2, 0.0, 0.0, 3, 0.018910, 31.000000, -1.358000],
        [2, 0.0, 0.0, 3, 0.000000, 30.380000, -40.860000],
        [2, 0.0, 0.0, 3, 0.000000, 30.920000, -35.490000],
        [2, 0.0, 0.0, 3, 0.050070, 81.060000, -21.940000],
        [2, 0.0, 0.0, 3, 0.047860, 77.650000, -21.070000],
        [2, 0.0, 0.0, 3, 0.026930, 43.010000, -6.466000],
        [2, 0.0, 0.0, 3, 0.023980, 39.200000, -5.566000],
        [2, 0.0, 0.0, 3, 0.025270, 35.750000, -5.396000],
        [2, 0.0, 0.0, 3, 0.035590, 31.010000, -5.591000],
        [2, 0.0, 0.0, 3, 0.023490, 38.840000, -5.717000],
        [2, 0.0, 0.0, 3, 0.029380, 32.000000, -4.708000],
        [2, 0.0, 0.0, 3, 0.000000, 28.010000, -27.440000]
    ])

    return ppc
